/*!
 * Lava Lamp
 * http://lavalamp.magicmediamuse.com/
 *
 * Author
 * Richard Hung
 * http://www.magicmediamuse.com/
 *
 * Version
 * 1.0.8
 * 
 * Copyright (c) 2014 Richard Hung.
 * 
 * License
 * Lava Lamp by Richard Hung is licensed under a Creative Commons Attribution-NonCommercial 3.0 Unported License.
 * http://creativecommons.org/licenses/by-nc/3.0/deed.en_US
 */


(function($){"use strict";var methods={init:function(settings){var defaultSettings={easing:"swing",duration:700,margins:false,setOnClick:false,activeObj:".current-menu-item, .current-menu-ancestor",autoUpdate:false,updateTime:100,enableHover:true,delayOn:0,delayOff:0,enableFocus:false,deepFocus:false};settings=$.extend({},defaultSettings,settings);return this.each(function(){var margins=settings.margins;var setOnClick=settings.setOnClick;var activeObj=settings.activeObj;var autoUpdate=settings.autoUpdate;var updateTime=settings.updateTime;var enableHover=settings.enableHover;var delayOn=settings.delayOn;var delayOff=settings.delayOff;var enableFocus=settings.enableFocus;var deepFocus=settings.deepFocus;var list=$(this);var items=list.children();var active=list.children(activeObj);if(active.length==0){active=items.eq(0)}list.data({lavalampActive:active,isAnim:false,settings:settings});list.addClass("lavalamp").css({position:"relative"});var obj=$('<div class="lavalamp-object" />').prependTo(list).css({position:"absolute"});items.addClass("lavalamp-item").css({zIndex:5,position:"relative"});var w=active.outerWidth(margins);var h=active.outerHeight(margins);var t=active.position().top;var l=active.position().left;var mt=active.css("marginTop");var ml=active.css("marginLeft");if(!margins){ml=parseInt(ml);mt=parseInt(mt);l=l+ml;t=t+mt}obj.css({width:w,height:h,top:t,left:l});var onHover=false;var enAnim=true;lavalampEnter=function(){var des=$(this);onHover=true;setTimeout(function(){if(onHover&&enAnim){list.lavalamp("anim",des)}},delayOn)};lavalampLeave=function(des){des=list.data("lavalampActive");onHover=false;setTimeout(function(){if(!onHover&&enAnim){list.lavalamp("anim",des)}},delayOff)};focusIn=function(){var des=$(this);if(!des.hasClass("lavalamp-item")){des=des.parents(".lavalamp-item")}enAnim=false;setTimeout(function(){list.lavalamp("anim",des)},delayOn);console.log("in")};focusOut=function(){enAnim=true;var des=list.data("lavalampActive");console.log(des);setTimeout(function(){list.lavalamp("anim",des)},delayOff);console.log("out")};if(enableHover){list.on("mouseenter",".lavalamp-item",lavalampEnter);list.on("mouseleave",".lavalamp-item",lavalampLeave)}if(enableFocus){list.on("focusin",".lavalamp-item",focusIn);list.on("focusout",".lavalamp-item",focusOut)}if(deepFocus){list.on("focusin",".lavalamp-item *",focusIn);list.on("focusout",".lavalamp-item *",focusOut)}if(setOnClick){items.click(function(){active=$(this);list.data("lavalampActive",active).lavalamp("update")})}if(autoUpdate){var updateInterval=setInterval(function(){var isAnim=list.data("isAnim");if(onHover==false&&isAnim==false){list.lavalamp("update")}},updateTime);list.data("updateInterval",updateInterval)}})},destroy:function(){return this.each(function(){var list=$(this);var settings=list.data("settings");var items=list.children(".lavalamp-item");var enableHover=settings.enableHover;var enableFocus=settings.enableFocus;var deepFocus=settings.deepFocus;var autoUpdate=settings.autoUpdate;if(enableHover){list.off("mouseenter",".lavalamp-item",lavalampEnter);list.off("mouseleave",".lavalamp-item",lavalampLeave)}if(enableFocus){list.off("focusin",".lavalamp-item",focusIn);list.off("focusout",".lavalamp-item",focusOut)}if(deepFocus){list.off("focusin",".lavalamp-item *",focusIn);list.off("focusout",".lavalamp-item *",focusOut)}list.removeClass("lavalamp");items.removeClass("lavalamp-item");if(autoUpdate){var updateInterval=list.data("updateInterval");clearInterval(updateInterval)}list.children(".lavalamp-object").remove();list.removeData()})},update:function(){return this.each(function(){var list=$(this);var items=list.children(":not(.lavalamp-object)");var active=list.data("lavalampActive");items.addClass("lavalamp-item").css({zIndex:5,position:"relative"});list.lavalamp("anim",active)})},anim:function(destination){var list=this;var settings=list.data("settings");var duration=settings.duration;var easing=settings.easing;var margins=settings.margins;var obj=list.children(".lavalamp-object");var w=destination.outerWidth(margins);var h=destination.outerHeight(margins);var t=destination.position().top;var l=destination.position().left;var mt=destination.css("marginTop");var ml=destination.css("marginLeft");if(!margins){ml=parseInt(ml);mt=parseInt(mt);l=l+ml;t=t+mt}list.data("isAnim",true);obj.stop(true,false).animate({width:w,height:h,top:t,left:l},duration,easing,function(){list.data("isAnim",false)})}};$.fn.lavalamp=function(method){if(methods[method]){return methods[method].apply(this,Array.prototype.slice.call(arguments,1))}else if(typeof method==="object"||!method){return methods.init.apply(this,arguments)}else{$.error("Method "+method+" does not exist on jQuery.lavalamp")}};var lavalampEnter,lavalampLeave,focusIn,focusOut})(jQuery);