<?php
	/**
	 * Ingenious Social Widget Class
	 */
class Ingenious_Social_Widget extends WP_Widget {

	public function init_fields() {
		$this->fields = array(
			'title' => array(
				'title' => esc_html__( 'Title', 'ingenious-shortcodes' ),
				'atts'	=> 'id="widget-title"',
				'type' => 'text',
			),
			'icon'	=> array(
				'title'			=> esc_html__( 'Icon', 'ingenious-shortcodes' ),
				'type'			=> 'select',
				'addrowclasses' => 'fai',
				'source' 		=> 'fa'
			),
			'add_custom_color'	=> array(
				'title'			=> esc_html__( 'Edit Color', 'ingenious-shortcodes' ),
				'type'			=> 'checkbox',
				'addrowclasses' => 'checkbox',
				'atts'			=> 'data-options="e:color;"'
			),
			'color'	=> array(
				'type'					=> 'text',
				'addrowclasses' 		=> 'disable',
				'atts'					=> 'data-default-color="' . INGENIOUS_THEME_COLOR . '"'
			),
			'bg_fill' => array(
				'title' => esc_html__( 'Add Background Fill', 'ingenious-shortcodes' ),
				'type' => 'radio',
				'value' => array(
					'none' => array( esc_html__( 'None', 'ingenious-shortcodes' ), 	true, 'd:bg_title_color;d:bg_font_color;d:bg_color;d:bg_overlay_gradient;d:bg_opacity;', '' ),
					'color' => array( esc_html__( 'Color', 'ingenious-shortcodes' ), 	false, 'e:bg_title_color;e:bg_font_color;e:bg_color;d:bg_overlay_gradient;e:bg_opacity;', '' ),
					'gradient' =>array( esc_html__( 'Gradient', 'ingenious-shortcodes' ), false, 'e:bg_title_color;e:bg_font_color;d:bg_color;e:bg_overlay_gradient;e:bg_opacity;', '' ),
				),
			),
			'bg_title_color' => array(
				'title' 			=> esc_html__( 'Title Color', 'ingenious-shortcodes' ),
				'atts' 				=> 'data-default-color="#ffffff"',
				'type' 				=> 'text',
				'addrowclasses' 	=> 'disable',
				'value'				=> 	'#ffffff'
			),
			'bg_font_color' => array(
				'title' 			=> esc_html__( 'Font Color', 'ingenious-shortcodes' ),
				'atts' 				=> 'data-default-color="#ffffff"',
				'type' 				=> 'text',
				'addrowclasses' 	=> 'disable',
				'value'				=> 	'#ffffff'
			),			
			'bg_color' => array(
				'title' 		=> esc_html__( 'Add Overlay Color', 'ingenious-shortcodes' ),
				'atts' 			=> 'data-default-color="' . INGENIOUS_THEME_COLOR . '"',
				'type' 			=> 'text',
				'addrowclasses' 	=> 'disable',
				'value'			=> INGENIOUS_THEME_COLOR
			),
			'bg_overlay_gradient' => array(
				'type' => 'fields',
				'addrowclasses' => 'disable box inside-box groups',
				'layout' => array(
					'c1' => array(
						'type' => 'text',
						'title' => esc_html__( 'From', 'ingenious-shortcodes' ),
						'atts' => 'data-default-color="#6b797f"',
						'value'	=> '#6b797f',
					),
					'op1' => array(
						'type' => 'number',
						'title' => esc_html__( 'From (Opacity %)', 'ingenious-shortcodes' ),
						'value' => '100',
					),				
					'c2' => array(
						'type' => 'text',
						'title' => esc_html__( 'To', 'ingenious-shortcodes' ),
						'atts' => 'data-default-color="#4ab769"',
						'value'	=> '#4ab769',
					),
					'op2' => array(
						'type' => 'number',
						'title' => esc_html__( 'To (Opacity %)', 'ingenious-shortcodes' ),
						'value' => '100',
					),
					'type' => array(
						'title' => esc_html__( 'Gradient type', 'ingenious-shortcodes' ),
						'type' => 'radio',
						'value' => array(
							'linear' => array( esc_html__( 'Linear', 'ingenious-shortcodes' ),  true, 'e:linear;d:radial' ),
							'radial' =>array( esc_html__( 'Radial', 'ingenious-shortcodes' ), false,  'd:linear;e:radial' ),
						),
					),
					'linear' => array(
						'title' => esc_html__( 'Linear settings', 'ingenious-shortcodes'  ),
						'type' => 'fields',
						'addrowclasses' => 'disable',
						'layout' => array(
							'angle' => array(
								'type' => 'number',
								'title' => esc_html__( 'Angle', 'ingenious-shortcodes' ),
								'value' => '45',
							),
						)
					),
					'radial' => array(
						'title' => esc_html__( 'Radial settings', 'ingenious-shortcodes'  ),
						'type' => 'fields',
						'addrowclasses' => 'disable',
						'layout' => array(
							'shape_type' => array(
								'title' => esc_html__( 'Shape', 'ingenious-shortcodes' ),
								'type' => 'radio',
								'value' => array(
									'simple' => array( esc_html__( 'Simple', 'ingenious-shortcodes' ),  true, 'e:shape;d:size;d:keyword' ),
									'extended' =>array( esc_html__( 'Extended', 'ingenious-shortcodes' ), false, 'd:shape;e:size;e:keyword' ),
								),
							),
							'shape' => array(
								'title' => esc_html__( 'Gradient type', 'ingenious-shortcodes' ),
								'type' => 'radio',
								'value' => array(
									'ellipse' => array( esc_html__( 'Ellipse', 'ingenious-shortcodes' ),  true ),
									'circle' =>array( esc_html__( 'Circle', 'ingenious-shortcodes' ), false ),
								),
							),
							'size' => array(
								'type' => 'text',
								'addrowclasses' => 'disable',
								'title' => esc_html__( 'Size', 'ingenious-shortcodes' ),
								'atts' => 'placeholder="'.esc_html__('Two space separated percent values, for example (60% 55%)', 'ingenious-shortcodes').'"',
							),
							'keyword' => array(
								'type' => 'select',
								'title' => esc_html__( 'Size keyword', 'ingenious-shortcodes' ),
								'addrowclasses' => 'disable',
								'source' => array(
									'closest-side' => array(esc_html__( 'Closest side', 'ingenious-shortcodes' ), false),
									'farthest-side' => array(esc_html__( 'Farthest side', 'ingenious-shortcodes' ), false),
									'closest-corner' => array(esc_html__( 'Closest corner', 'ingenious-shortcodes' ), false),
									'farthest-corner' => array(esc_html__( 'Farthest corner', 'ingenious-shortcodes' ), true),
								),
							),
						)
					),
					'custom_css' => array(
						'title' => esc_html__( 'Custom CSS rules', 'ingenious-shortcodes' ),
						'subtitle' => esc_html__( 'Enter styles', 'ingenious-shortcodes' ),
						'atts' => 'rows="10"',
						'type' => 'textarea',
						'addrowclasses' => 'full_row',
					),
				),
			),
			'bg_opacity' => array(
				'title' => esc_html__( 'Overlay Opacity', 'ingenious-shortcodes' ),
				'type' => 'number',
				'atts' => " min='0' max='100'",
				'value'	=> '100',
			),
		);
	}

	public function __construct() {
		$widget_ops = array( 'classname' => 'widget-ingenious-social', 'description' => esc_html__( 'Ingenious Social Widget', 'ingenious-shortcodes' ) );
		parent::__construct( 'ingenious-social', esc_html__( 'Ingenious Social', 'ingenious-shortcodes' ), $widget_ops );
	}

	public function widget( $args, $instance ) {
		extract( $args );
		extract(shortcode_atts(array(
			'title' => '',
			'icon'				=> '',
			'add_custom_color'	=> false,
			'color'				=> INGENIOUS_THEME_COLOR,
			'bg_fill' => '0',
			'bg_title_color' => '#ffffff',
			'bg_font_color' => '#ffffff',
			'bg_color' => INGENIOUS_THEME_COLOR,
			'bg_overlay_gradient' => array(),
			'bg_opacity' => '100',
		), $instance));
		$title = esc_html( $title );
		$icon = esc_attr( $icon );
		$add_custom_color = (bool)$add_custom_color;
		$color = esc_attr( $color );

		$title = apply_filters( 'widget_title', $title );

		$custom_color = $add_custom_color && !empty( $color );
		$widget_styles = "";
		if ( $custom_color ){
			$widget_styles .= "#$widget_id a:not(.ingenious_button):not(.ingenious_icon):hover,
								#$widget_id input[type='submit'],
								#$widget_id .widget_icon{
				color: $color;
			}
			#$widget_id input[type='submit'],
			#$widget_id .social_icon{
				border-color: $color;
			}
			#$widget_id .social_icon .figure_wrap svg{
				fill: $color;
			}
			#$widget_id input[type='submit']:hover,
			#footer_widgets #$widget_id .widgettitle{
				background-color: $color;
			}
			#$widget_id .social_icon:hover .figure_wrap svg,
			#$widget_id .social_icon .figure_wrap svg{
				stroke: $color;
			}";
		}
		$styles = '';
		//Widget background fill
		if ($bg_fill != 'none'){
			$bg_opacity = (int) $bg_opacity / 100;
			ob_start();
			echo "
				#".esc_attr($widget_id)." .widgettitle > span,
				#".esc_attr($widget_id).".widgettitle > a{
					color: ".esc_attr($bg_title_color).";
				}

				#".esc_attr($widget_id)." a,
				#".esc_attr($widget_id)."{
					color: ".esc_attr($bg_font_color).";
				}
			";
			if ($bg_fill == 'color') {
				echo "#".esc_attr($widget_id).":before{
					background: ".esc_attr($bg_color).";
				}";
			} elseif ($bg_fill == 'gradient') {
				$widget_gradient_css = ingenious_render_gradient_rules($bg_overlay_gradient);
				echo "#".esc_attr($widget_id).":before{
					".esc_attr($widget_gradient_css)."
				}";
			}
			echo "#".esc_attr($widget_id).":before{
				opacity: ".esc_attr($bg_opacity).";
			}";			
			$styles = ob_get_clean();
			$styles = json_encode($styles);
		}
		//Widget background fill

		if ($bg_fill != 'none' || $custom_color){
			if (!empty($styles)){
				$before_widget = preg_replace( "#class=\"(.+)\"#", "class=\"$1 render_styles\" data-style=\"".esc_attr($styles)."\"", $before_widget );
			} else {
				$before_widget = preg_replace( "#class=\"(.+)\"#", "class=\"$1 custom_color\"", $before_widget );
			}
		}

		echo sprintf("%s", $before_widget);
		if ( !empty( $widget_styles ) ){
			echo "<style type='text/css'>$widget_styles</style>";
		}

		if ( !empty( $title ) ){
			echo sprintf("%s", $before_title);
			if ( !empty( $icon ) ){
				echo "<i class='widget_icon $icon'></i>";
			}
			echo sprintf("%s", $title);
			echo sprintf("%s", $after_title);
		}
		$social_links = ingenious_render_social_links ();
		if ( !empty( $social_links ) ){
			echo "<div class='widget_social'>";
				echo sprintf("%s", $social_links);
			echo "</div>";
		}
		echo sprintf("%s", $after_widget);
	}

	public function update( $new_instance, $old_instance ) {
		$instance = (array)$new_instance;
		foreach ($new_instance as $key => $v) {
			switch ($this->fields[$key]['type']) {
				case 'text':
					$instance[$key] = strip_tags($v);
					break;
			}
		}
		return $instance;
	}

	public function form( $instance ) {
		$this->init_fields();
		if (function_exists('cws_core_build_layout') ) {
			echo cws_core_build_layout($instance, $this->fields, 'widget-' . $this->id_base . '[' . $this->number . '][');
		}
	}

}
?>