<?php
	/**
	 * Ingenious Latest Posts Widget Class
	 */
class Ingenious_Latest_Posts extends WP_Widget {

	public function init_fields() {
		$this->fields = array(
			'title' => array(
				'title' => esc_html__( 'Title', 'ingenious-shortcodes' ),
				'atts'	=> 'id="widget-title"',
				'type' => 'text',
			),
			'icon'	=> array(
				'title'			=> esc_html__( 'Icon', 'ingenious-shortcodes' ),
				'type'			=> 'select',
				'addrowclasses' => 'fai',
				'source' 		=> 'fa'
			),
			'add_custom_color'	=> array(
				'title'			=> esc_html__( 'Edit Color', 'ingenious-shortcodes' ),
				'type'			=> 'checkbox',
				'addrowclasses' => 'checkbox',
				'atts'			=> 'data-options="e:color;"'
			),
			'color'	=> array(
				'type'					=> 'text',
				'atts'					=> 'data-default-color="' . INGENIOUS_THEME_COLOR . '"'
			),
			'filter_by' => array(
				'title' => esc_html__( 'Filter By', 'ingenious-shortcodes' ),
				'type' => 'select',
				'source'	=> array(
					'none'		=> array( esc_html__( 'None', 'ingenious-shortcodes' ), true, 'd:cats;d:tags' ),
					'cat'		=> array( esc_html__( 'Categories', 'ingenious-shortcodes' ), false, 'e:cats;d:tags' ),
					'tag'		=> array( esc_html__( 'Tags', 'ingenious-shortcodes' ), false, 'd:cats;e:tags' ),
					'cat_tag'	=> array( esc_html__( 'Categories & Tags', 'ingenious-shortcodes' ), false, 'e:cats;e:tags' )
				)
			),
			'cats' => array(
				'title' => esc_html__( 'Categories', 'ingenious-shortcodes' ),
				'type' => 'taxonomy',
				'addrowclasses' => 'disable',
				'taxonomy' => 'category',
				'atts' => 'multiple',
				'source' => array(),
			),
			'tags' => array(
				'title' => esc_html__( 'Tags', 'ingenious-shortcodes' ),
				'type' => 'taxonomy',
				'addrowclasses' => 'disable',
				'taxonomy' => 'post_tag',
				'atts' => 'multiple',
				'source' => array(),
			),
			'visible_count' => array(
				'type' => 'number',
				'title' => esc_html__( 'Items per Slide', 'ingenious-shortcodes' ),
				'value' => '2',
			),
			'count' => array(
				'type' => 'number',
				'title' => esc_html__( 'Items to Show', 'ingenious-shortcodes' ),
				'value' => '4',
			),
			'hide_data' => array(
				'title' => esc_html__( 'Hide', 'ingenious-shortcodes' ),
				'type' => 'select',
				'atts' => 'multiple',
				'source' => array(
					'cats'	=> array( esc_html__( 'Categories', 'ingenious-shortcodes' ), false ),
					'tags'	=> array( esc_html__( 'Tags', 'ingenious-shortcodes' ), false ),
					'desc'	=> array( esc_html__( 'Description', 'ingenious-shortcodes' ), false )
				),
			),
			'chars_count' => array(
				'type' => 'number',
				'title' => esc_html__( 'Text Length', 'ingenious-shortcodes' ),
				'value' => '70',
			),
			'bg_fill' => array(
				'title' => esc_html__( 'Add Background Fill', 'ingenious-shortcodes' ),
				'type' => 'radio',
				'value' => array(
					'none' => array( esc_html__( 'None', 'ingenious-shortcodes' ), 	true, 'd:bg_title_color;d:bg_font_color;d:bg_color;d:bg_overlay_gradient;d:bg_opacity;', '' ),
					'color' => array( esc_html__( 'Color', 'ingenious-shortcodes' ), 	false, 'e:bg_title_color;e:bg_font_color;e:bg_color;d:bg_overlay_gradient;e:bg_opacity;', '' ),
					'gradient' =>array( esc_html__( 'Gradient', 'ingenious-shortcodes' ), false, 'e:bg_title_color;e:bg_font_color;d:bg_color;e:bg_overlay_gradient;e:bg_opacity;', '' ),
				),
			),
			'bg_title_color' => array(
				'title' 			=> esc_html__( 'Title Color', 'ingenious-shortcodes' ),
				'atts' 				=> 'data-default-color="#ffffff"',
				'type' 				=> 'text',
				'addrowclasses' 	=> 'disable',
				'value'				=> 	'#ffffff'
			),
			'bg_font_color' => array(
				'title' 			=> esc_html__( 'Font Color', 'ingenious-shortcodes' ),
				'atts' 				=> 'data-default-color="#ffffff"',
				'type' 				=> 'text',
				'addrowclasses' 	=> 'disable',
				'value'				=> 	'#ffffff'
			),			
			'bg_color' => array(
				'title' 		=> esc_html__( 'Add Overlay Color', 'ingenious-shortcodes' ),
				'atts' 			=> 'data-default-color="' . INGENIOUS_THEME_COLOR . '"',
				'type' 			=> 'text',
				'addrowclasses' 	=> 'disable',
				'value'			=> INGENIOUS_THEME_COLOR
			),
			'bg_overlay_gradient' => array(
				'type' => 'fields',
				'addrowclasses' => 'disable box inside-box groups',
				'layout' => array(
					'c1' => array(
						'type' => 'text',
						'title' => esc_html__( 'From', 'ingenious-shortcodes' ),
						'atts' => 'data-default-color="#6b797f"',
						'value'	=> '#6b797f',
					),
					'op1' => array(
						'type' => 'number',
						'title' => esc_html__( 'From (Opacity %)', 'ingenious-shortcodes' ),
						'value' => '100',
					),				
					'c2' => array(
						'type' => 'text',
						'title' => esc_html__( 'To', 'ingenious-shortcodes' ),
						'atts' => 'data-default-color="#4ab769"',
						'value'	=> '#4ab769',
					),
					'op2' => array(
						'type' => 'number',
						'title' => esc_html__( 'To (Opacity %)', 'ingenious-shortcodes' ),
						'value' => '100',
					),
					'type' => array(
						'title' => esc_html__( 'Gradient type', 'ingenious-shortcodes' ),
						'type' => 'radio',
						'value' => array(
							'linear' => array( esc_html__( 'Linear', 'ingenious-shortcodes' ),  true, 'e:linear;d:radial' ),
							'radial' =>array( esc_html__( 'Radial', 'ingenious-shortcodes' ), false,  'd:linear;e:radial' ),
						),
					),
					'linear' => array(
						'title' => esc_html__( 'Linear settings', 'ingenious-shortcodes'  ),
						'type' => 'fields',
						'addrowclasses' => 'disable',
						'layout' => array(
							'angle' => array(
								'type' => 'number',
								'title' => esc_html__( 'Angle', 'ingenious-shortcodes' ),
								'value' => '45',
							),
						)
					),
					'radial' => array(
						'title' => esc_html__( 'Radial settings', 'ingenious-shortcodes'  ),
						'type' => 'fields',
						'addrowclasses' => 'disable',
						'layout' => array(
							'shape_type' => array(
								'title' => esc_html__( 'Shape', 'ingenious-shortcodes' ),
								'type' => 'radio',
								'value' => array(
									'simple' => array( esc_html__( 'Simple', 'ingenious-shortcodes' ),  true, 'e:shape;d:size;d:keyword' ),
									'extended' =>array( esc_html__( 'Extended', 'ingenious-shortcodes' ), false, 'd:shape;e:size;e:keyword' ),
								),
							),
							'shape' => array(
								'title' => esc_html__( 'Gradient type', 'ingenious-shortcodes' ),
								'type' => 'radio',
								'value' => array(
									'ellipse' => array( esc_html__( 'Ellipse', 'ingenious-shortcodes' ),  true ),
									'circle' =>array( esc_html__( 'Circle', 'ingenious-shortcodes' ), false ),
								),
							),
							'size' => array(
								'type' => 'text',
								'addrowclasses' => 'disable',
								'title' => esc_html__( 'Size', 'ingenious-shortcodes' ),
								'atts' => 'placeholder="'.esc_html__('Two space separated percent values, for example (60% 55%)', 'ingenious-shortcodes').'"',
							),
							'keyword' => array(
								'type' => 'select',
								'title' => esc_html__( 'Size keyword', 'ingenious-shortcodes' ),
								'addrowclasses' => 'disable',
								'source' => array(
									'closest-side' => array(esc_html__( 'Closest side', 'ingenious-shortcodes' ), false),
									'farthest-side' => array(esc_html__( 'Farthest side', 'ingenious-shortcodes' ), false),
									'closest-corner' => array(esc_html__( 'Closest corner', 'ingenious-shortcodes' ), false),
									'farthest-corner' => array(esc_html__( 'Farthest corner', 'ingenious-shortcodes' ), true),
								),
							),
						)
					),
					'custom_css' => array(
						'title' => esc_html__( 'Custom CSS rules', 'ingenious-shortcodes' ),
						'subtitle' => esc_html__( 'Enter styles', 'ingenious-shortcodes' ),
						'atts' => 'rows="10"',
						'type' => 'textarea',
						'addrowclasses' => 'full_row',
					),
				),
			),
			'bg_opacity' => array(
				'title' => esc_html__( 'Overlay Opacity', 'ingenious-shortcodes' ),
				'type' => 'number',
				'atts' => " min='0' max='100'",
				'value'	=> '100',
			),
		);
	}

	public function __construct() {
		$widget_ops = array( 'classname' => 'widget-ingenious-latest-posts', 'description' => esc_html__( 'Ingenious Latest Posts Widget', 'ingenious-shortcodes' ) );
		parent::__construct( 'ingenious-latest-posts', esc_html__( 'Ingenious Latest Posts', 'ingenious-shortcodes' ), $widget_ops );
	}

	public function widget( $args, $instance ) {
		extract( $args );
		extract( shortcode_atts( array(
			'title'				=> '',
			'icon'				=> '',
			'add_custom_color'	=> false,
			'color'				=> INGENIOUS_THEME_COLOR,
			'filter_by'			=> '',
			'cats'				=> array(),
			'tags'				=> array(),
			'count'				=> '4',
			'visible_count'		=> '2',
			'hide_data'			=> array(),
			'chars_count'		=> '70',
			'bg_fill' => '0',
			'bg_title_color' => '#ffffff',
			'bg_font_color' => '#ffffff',
			'bg_color' => INGENIOUS_THEME_COLOR,
			'bg_overlay_gradient' => array(),
			'bg_opacity' => '100',
		), $instance));
		$title 				= esc_html( $title );
		$icon 				= esc_attr( $icon );
		$add_custom_color 	= (bool)$add_custom_color;
		$color 				= esc_attr( $color );
		$count 				= (int)$count;
		$visible_count 		= (int)$visible_count;
		$chars_count 		= (int)$chars_count;

		$title = apply_filters( 'widget_title', $title );

		$query_args = array(
			'post_type'			=> array( 'post' ),
			'post_status'		=> 'publish',
			'posts_per_page'	=> $count,
			'post__not_in'		=> get_option( 'sticky_posts' )
		);

		$tax_query = array();
		$cat_query_args = array();
		$tag_query_args = array();
		if ( in_array( $filter_by, array( 'cat', 'cat_tag' ) ) ){
			$cat_tax = 'category';
			$cat_terms = $cats;
			if ( !empty( $cat_terms ) ){
				array_push( $cat_query_args, array(
					'taxonomy'	=> $cat_tax,
					'field'			=> 'slug',
					'terms'			=> $cat_terms
				));
			}
		}
		if ( in_array( $filter_by, array( 'tag', 'cat_tag' ) ) ){
			$tag_tax = 'post_tag';
			$tag_terms = $tags;
			if ( !empty( $tag_terms ) ){
				array_push( $tag_query_args, array(
					'taxonomy'	=> $tag_tax,
					'field'			=> 'slug',
					'terms'			=> $tag_terms
				));
			}
		}
		if ( !empty( $cat_query_args ) && !empty( $tag_query_args ) ){
			$tax_query['relation'] = 'OR';
		}
		$tax_query = array_merge( $tax_query, $cat_query_args, $tag_query_args );
		if ( !empty( $tax_query ) ){
			$query_args['tax_query'] = $tax_query;
		}

		$q = new WP_Query( $query_args );
		$post_count = $q->post_count;
		$carousel_mode = $post_count > $visible_count;

		$custom_color = $add_custom_color && !empty( $color );
		$widget_styles = "";
		if ( $custom_color ){
			$widget_styles .= "#$widget_id a:not(.ingenious_button):not(.ingenious_icon),
								#$widget_id a:not(.ingenious_button):not(.ingenious_icon):hover,
								#$widget_id .widget_post_title > a:hover,
								#$widget_id input[type='submit'],
								#$widget_id .widget_icon{
				color: $color;
			}
			#$widget_id .widget_post_title > a{
				color: inherit;
			}
			#$widget_id input[type='submit'],
			#$widget_id .owl-pagination .owl-page{
				border-color: $color;
			}
			#$widget_id input[type='submit']:hover,
			#$widget_id .owl-pagination .owl-page.active{
				background-color: $color;
			}
			#footer_widgets #$widget_id .widget_header,
			#footer_widgets #$widget_id .widgettitle{
				background-color: $color;				
			}";
		}
		$styles = '';
		//Widget background fill
		if ($bg_fill != 'none'){
			$bg_opacity = (int) $bg_opacity / 100;
			ob_start();
			echo "
				#".esc_attr($widget_id)." .widgettitle > span,
				#".esc_attr($widget_id).".widgettitle > a{
					color: ".esc_attr($bg_title_color).";
				}

				#".esc_attr($widget_id)." a,
				#".esc_attr($widget_id)."{
					color: ".esc_attr($bg_font_color).";
				}
			";
			if ($bg_fill == 'color') {
				echo "#".esc_attr($widget_id).":before{
					background: ".esc_attr($bg_color).";
				}";
			} elseif ($bg_fill == 'gradient') {
				$widget_gradient_css = ingenious_render_gradient_rules($bg_overlay_gradient);
				echo "#".esc_attr($widget_id).":before{
					".esc_attr($widget_gradient_css)."
				}";
			}
			echo "#".esc_attr($widget_id).":before{
				opacity: ".esc_attr($bg_opacity).";
			}";			
			$styles = ob_get_clean();
			$styles = json_encode($styles);
		}
		//Widget background fill

		if ($bg_fill != 'none' || $custom_color){
			if (!empty($styles)){
				$before_widget = preg_replace( "#class=\"(.+)\"#", "class=\"$1 render_styles\" data-style=\"".esc_attr($styles)."\"", $before_widget );
			} else {
				$before_widget = preg_replace( "#class=\"(.+)\"#", "class=\"$1 custom_color\"", $before_widget );
			}
		}

		echo sprintf("%s", $before_widget);
		if ( !empty( $widget_styles ) ){
			echo "<style type='text/css'>$widget_styles</style>";
		}

		if ( !empty( $title ) ){
			if ( !empty( $icon ) ){
				echo sprintf("%s", $before_title) . "<i class='widget_icon $icon'></i>" . $title . $after_title;				
			}
			else{
				echo sprintf("%s", $before_title) . $title . $after_title;
			}
		}

		$post_list_classes = "post_list widget_post_list staff_post_list";
		$post_list_classes .= $carousel_mode ? " widget_carousel bullets_nav" : "";
		echo "<div class='$post_list_classes'>";
		$counter = 0;
		while ( $q->have_posts() ):
			$q->the_post();
			$pid = get_the_id();
			$cur_post = get_post( $pid );
			$permalink = esc_url(get_permalink());
			$post_format = get_post_format();
			$video_post = 'video' === $post_format;
			//Get post meta
			if (function_exists('cws_core_cwsfw_get_post_meta')) {
				$post_meta = cws_core_cwsfw_get_post_meta( $pid );
			}
			$post_meta = isset( $post_meta[0] ) ? $post_meta[0] : array();

			if ( $carousel_mode && $counter <= 0 ){ /* open carousel item tag */
				echo "<div class='item'>";
			}
			echo "<article class='post widget_post staff_post clearfix'>";
				$has_img = has_post_thumbnail( $pid );
				if ( $has_img || $video_post){
					if ($has_img){
						$thumb_props = wp_get_attachment_image_src( get_post_thumbnail_id( $pid ), 'full' );
						$thumb_id = get_post_thumbnail_id( $pid );
						$thumb = $thumb_props[0];
						$thumb_obj = ingenious_thumb( $thumb, array( 'width' => 80, 'height' => 80 , 'crop' => true), $thumb_id );
						$thumb_url = isset( $thumb_obj[0] ) ? esc_url($thumb_obj[0]) : "";	
						$thumb_url = esc_url( $thumb_url );														
					}
					echo "<div class='post_media widget_post_media staff_post_media'>";
					if ($video_post){
						$video_url = isset( $post_meta['video'] ) ? $post_meta['video'] : '';
						echo apply_filters( 'the_content',"[embed width='200']" .$video_url.'[/embed]' );	
					} else {
						echo "<a href='$permalink'>";
							echo "<img src='$thumb_url' data-at2x='" . $thumb_obj[3] . "' alt />";
						echo "</a>";
					}
					echo "</div>";
				}
				$post_data = "";
				ob_start();
				$post_title = esc_html( get_the_title() );
				if ( !empty( $post_title ) ){
					echo "<h4 class='post_title widget_post_title staff_post_title'>";
						echo "<a href='$permalink'>";
							echo sprintf("%s", $post_title);
						echo "</a>";
					echo "</h4>";
				}
				$terms = $cats = $tags = "";
				if ( !in_array( 'cats', $hide_data ) ){
					$cats = ingenious_get_post_term_links_str( 'category' );
				}
				if ( !in_array( 'tags', $hide_data ) ){
					$tags = ingenious_get_post_term_links_str( 'post_tag' );
				}
				$terms .= $cats;
				$terms .= !empty( $cats ) && !empty( $terms ) ? "<br />" : "";
				$terms .= $tags;
				echo !empty( $terms ) ? "<div class='post_terms widget_post_terms staff_post_terms'>$terms</div>" : "";
				if ( !in_array( 'desc', $hide_data ) ){
					$desc = !empty( $cur_post->post_excerpt ) ? $cur_post->post_excerpt : $cur_post->post_content;
					$desc = trim( preg_replace( "/[\s]{2,}/", " ", strip_shortcodes( strip_tags( $desc ) ) ) );
					$desc = substr( $desc, 0, $chars_count );
					$desc = wptexturize( $desc );
					echo !empty( $desc ) ? "<div class='post_desc widget_post_desc staff_post_desc'>$desc</div>" : ""; 
				}
				$post_data = ob_get_clean();
				echo !empty( $post_data ) ? "<div class='post_data widget_post_data staff_post_data'>$post_data</div>" : "";		
			echo "</article>";
			if ( $carousel_mode ){
				if ( $counter >= $visible_count-1 || $q->current_post >= $post_count-1 ){
					echo "</div>";
					$counter = 0;
				}
				else{
					$counter ++;
				}
			}
			endwhile;
			wp_reset_postdata();
			echo "</div>";
		echo sprintf("%s", $after_widget);
	}

	public function update( $new_instance, $old_instance ) {
		$instance = (array)$new_instance;
		foreach ($new_instance as $key => $v) {
			switch ($this->fields[$key]['type']) {
				case 'text':
					$instance[$key] = strip_tags($v);
					break;
			}
		}
		return $instance;
	}

	public function form( $instance ) {
		$this->init_fields();
		if (function_exists('cws_core_build_layout') ) {
			echo cws_core_build_layout($instance, $this->fields, 'widget-' . $this->id_base . '[' . $this->number . '][');
		}
	}

}
?>