<?php
new ingenious_Metaboxes();

class ingenious_Metaboxes {
	public $mb_page_layout = array();

	public function __construct() {
		if ( is_customize_preview() ) {
			$this->mb_page_layout = $this->getPageLayout();
		}
		$this->init();
	}

	private function getPageLayout() {
		return array(
			'sb_layout' => array(
				'title' => esc_html__('Sidebar Position', 'ingenious-shortcodes' ),
				'type' => 'radio',
				'subtype' => 'images',
				'value' => array(
					'default'=>	array( esc_html__('Default', 'ingenious-shortcodes' ), true, 'd:sidebar1;d:sidebar2', get_template_directory_uri() . '/img/fw_img/default.png' ),
					'left' => 	array( esc_html__('Left', 'ingenious-shortcodes' ), false, 'e:sidebar1;d:sidebar2',	get_template_directory_uri() . '/img/fw_img/left.png' ),
					'right' => 	array( esc_html__('Right', 'ingenious-shortcodes' ), false, 'e:sidebar1;d:sidebar2', get_template_directory_uri() . '/img/fw_img/right.png' ),
					'both' => 	array( esc_html__('Double', 'ingenious-shortcodes' ), false, 'e:sidebar1;e:sidebar2', get_template_directory_uri() . '/img/fw_img/both.png' ),
					'none' => 	array( esc_html__('None', 'ingenious-shortcodes' ), false, 'd:sidebar1;d:sidebar2', get_template_directory_uri() . '/img/fw_img/none.png' )
				),
				'addrowclasses' => 'grid-col-12',
			),
			'sidebar1' => array(
				'title' => esc_html__('Select a sidebar', 'ingenious-shortcodes' ),
				'type' => 'select',
				'addrowclasses' => 'disable grid-col-12',
				'source' => 'sidebars',
			),
			'sidebar2' => array(
				'required' => array( 'sb_layout', '=', 'both' ),
				'title' => esc_html__('Select right sidebar', 'ingenious-shortcodes' ),
				'type' => 'select',
				'addrowclasses' => 'disable grid-col-12',
				'source' => 'sidebars',
			),
			'page_color_override' => array(
				'type' => 'checkbox',
				'title' => esc_html__( 'Customize Page Color', 'ingenious-shortcodes' ),
				'addrowclasses' => 'checkbox grid-col-12',
				'atts' => 'data-options="e:page_color;"',
			),
			'page_color' => array(
				'title' => esc_html__( 'Page Color', 'ingenious-shortcodes' ),
				'atts' => 'data-default-color="' . INGENIOUS_THEME_COLOR . '"',
				'addrowclasses' => 'grid-col-4 box',
				'type' => 'text',
				'value'	=> INGENIOUS_THEME_COLOR
			),
			'header_override' => array(
				'type' => 'checkbox',
				'title' => esc_html__( 'Customize Header', 'ingenious-shortcodes' ),
				'addrowclasses' => 'checkbox grid-col-12',
				'atts' => 'data-options="e:header_covers_slider;e:menu_font_color;e:menu_opacity;e:header_logo_light;e:menu_bg_color;e:default_header_image;e:header_bg_opacity;e:header_overlay_type;e:add_pattern;e:page_title_spacings;e:hide_title;e:header_sep;"',
			),
			'header_covers_slider' => array(
				'title' => esc_html__( 'Header Overlays Slider', 'ingenious-shortcodes' ),
				'type' => 'checkbox',
				'addrowclasses' => 'checkbox disable grid-col-12 box'
			),
			'hide_title'	=> array(
				'title'	=> esc_html__( 'Hide Title Area', 'ingenious-shortcodes' ),
				'type'	=> 'checkbox',
				'addrowclasses' => 'checkbox grid-col-12 box'		
			),
			'header_logo_light' => array(
				'type' => 'select',
				'title' => esc_html__( 'Logo Variation', 'ingenious-shortcodes' ),
				'addrowclasses' => 'disable grid-col-12 box',
				'source' => array(
					'black' => array( esc_html__( 'Dark', 'ingenious-shortcodes' ), true),
					'white' => array( esc_html__( 'White', 'ingenious-shortcodes' ), false),
					'none' => array( esc_html__( 'None', 'ingenious-shortcodes' ), false),
				)
			),
			'menu_opacity' => array(
				'title' => esc_html__( 'Header Opacity', 'ingenious-shortcodes' ),
				'type' => 'number',
				'atts' => " min='0' max='100'",
				'addrowclasses' => 'disable grid-col-12 box',
				'value'	=> '100'
			),
			'menu_bg_color' => array(
				'title' 		=> esc_html__( 'Add Background Color', 'ingenious-shortcodes' ),						
				'type' 			=> 'text',
				'addrowclasses' => 'disable grid-col-12 box',
				'atts' 			=> 'data-default-color="#ffffff"',
				'value'			=> '#ffffff'
			),
			'menu_font_color' => array(
				'title' 		=> esc_html__( 'Override Menu Color', 'ingenious-shortcodes' ),
				'type' 			=> 'text',
				'addrowclasses' => 'disable grid-col-12 box',
				'atts' 			=> 'data-default-color="#1c3545;"',
				'value'			=> '#1c3545'
			),


			'add_pattern'	=> array(
				'title'	=> esc_html__( 'Add pattern', 'ingenious-shortcodes' ),
				'type'	=> 'checkbox',
				'atts'	=> 'checked data-options="e:default_pattern_image;"',
				'addrowclasses' => 'checkbox alt grid-col-3'		
			),
			'default_pattern_image' => array(
				'title'	=> esc_html__( 'Pattern Image', 'ingenious-shortcodes' ),
				'type' => 'fields',
				'addrowclasses' => 'disable grid-col-12 groups',
				'layout' => array(
					'image' => array(
						'title' => esc_html__( 'Background image', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-2',
						'type' => 'media',
					),
					'size' => array(
						'title' => esc_html__( 'Size', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-2',
						'type' => 'radio',
						'value' => array(
							'initial' =>array( esc_html__( 'Initial', 'ingenious-shortcodes' ), true,  '' ),
							'cover' => array( esc_html__( 'Cover', 'ingenious-shortcodes' ),  false, '' ),
							'contain' =>array( esc_html__( 'Contain', 'ingenious-shortcodes' ), false,  '' ),
						),
					),
					'repeat' => array(
						'title' => esc_html__( 'Repeat', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-2',
						'type' => 'radio',
						'value' => array(
							'no-repeat' => array( esc_html__( 'No repeat', 'ingenious-shortcodes' ),  false, '' ),
							'repeat' => array( esc_html__( 'Tile', 'ingenious-shortcodes' ),  true, '' ),
							'repeat-x' => array( esc_html__( 'Tile Horizontally', 'ingenious-shortcodes' ),  false, '' ),
							'repeat-y' =>array( esc_html__( 'Tile Vertically', 'ingenious-shortcodes' ), false,  '' ),
						),
					),
					'attachment' => array(
						'title' => esc_html__( 'Attachment', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-2',
						'type' => 'radio',
						'value' => array(
							'scroll' => array( esc_html__( 'Scroll', 'ingenious-shortcodes' ),  true, '' ),
							'fixed' =>array( esc_html__( 'Fixed', 'ingenious-shortcodes' ), false, '' ),
							'local' =>array( esc_html__( 'Local', 'ingenious-shortcodes' ), false, '' ),
						),
					),
					'position' => array(
						'title' => esc_html__( 'Position', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-2',
						'cols' => 3,
						'type' => 'radio',
						'value' => array(
							'tl'=>	array( '', false ),
							'tc'=>	array( '', false ),
							'tr'=>	array( '', false ),
							'cl'=>	array( '', false ),
							'cc'=>	array( '', true ),
							'cr'=>	array( '', false ),
							'bl'=>	array( '', false ),
							'bc'=>	array( '', false ),
							'br'=>	array( '', false ),
						),
					),
				),
			),	

			'header_overlay_type' => array(
				'title' => esc_html__( 'Overlay type', 'ingenious-shortcodes' ),
				'type' => 'radio',
				'addrowclasses' => 'grid-col-12 box',
				'value' => array(
					'color' => array( esc_html__( 'Color', 'ingenious-shortcodes' ), 	false, 'e:header_bg_color;d:header_bg_overlay_gradient;e:header_bg_opacity;', '' ),
					'gradient' =>array( esc_html__( 'Gradient', 'ingenious-shortcodes' ), true, 'd:header_bg_color;e:header_bg_overlay_gradient;e:header_bg_opacity;', '' ),
				),
			),
			'header_bg_color' => array(
				'title' 		=> esc_html__( 'Background Color', 'ingenious-shortcodes' ),
				'addrowclasses' => 'disable grid-col-12 box',
				'type' 			=> 'text',
				'atts' 			=> 'data-default-color="#1c3545;"',
				'value'			=> '#1c3545'
			),

			'header_bg_overlay_gradient' => array(
				'type' => 'fields',
				'addrowclasses' => 'grid-col-12 disable box inside-box groups',
				'layout' => array(
					'c1' => array(
						'type' => 'text',
						'title' => esc_html__( 'From', 'ingenious-shortcodes' ),
						'atts' => 'data-default-color="#6b797f"',
						'value'	=> '#6b797f',
						'addrowclasses' => 'grid-col-6',
					),
					'op1' => array(
						'type' => 'number',
						'title' => esc_html__( 'From (Opacity %)', 'ingenious-shortcodes' ),
						'value' => '100',
						'addrowclasses' => 'grid-col-6',
					),				
					'c2' => array(
						'type' => 'text',
						'title' => esc_html__( 'To', 'ingenious-shortcodes' ),
						'atts' => 'data-default-color="#4ab769"',
						'value'	=> '#4ab769',
						'addrowclasses' => 'grid-col-6',
					),
					'op2' => array(
						'type' => 'number',
						'title' => esc_html__( 'To (Opacity %)', 'ingenious-shortcodes' ),
						'value' => '100',
						'addrowclasses' => 'grid-col-6',
					),
					'type' => array(
						'title' => esc_html__( 'Gradient type', 'ingenious-shortcodes' ),
						'type' => 'radio',
						'addrowclasses' => 'grid-col-6',
						'value' => array(
							'linear' => array( esc_html__( 'Linear', 'ingenious-shortcodes' ),  true, 'e:linear;d:radial' ),
							'radial' =>array( esc_html__( 'Radial', 'ingenious-shortcodes' ), false,  'd:linear;e:radial' ),
						),
					),
					'linear' => array(
						'title' => esc_html__( 'Linear settings', 'ingenious-shortcodes'  ),
						'type' => 'fields',
						'addrowclasses' => 'disable grid-col-6',
						'layout' => array(
							'angle' => array(
								'type' => 'number',
								'title' => esc_html__( 'Angle', 'ingenious-shortcodes' ),
								'value' => '45',
							),
						)
					),
					'radial' => array(
						'title' => esc_html__( 'Radial settings', 'ingenious-shortcodes'  ),
						'type' => 'fields',
						'addrowclasses' => 'disable grid-col-12',
						'layout' => array(
							'shape_type' => array(
								'title' => esc_html__( 'Shape', 'ingenious-shortcodes' ),
								'type' => 'radio',
								'addrowclasses' => 'grid-col-4',
								'value' => array(
									'simple' => array( esc_html__( 'Simple', 'ingenious-shortcodes' ),  true, 'e:shape;d:size;d:keyword' ),
									'extended' =>array( esc_html__( 'Extended', 'ingenious-shortcodes' ), false, 'd:shape;e:size;e:keyword' ),
								),
							),
							'shape' => array(
								'title' => esc_html__( 'Gradient type', 'ingenious-shortcodes' ),
								'type' => 'radio',
								'addrowclasses' => 'grid-col-6',
								'value' => array(
									'ellipse' => array( esc_html__( 'Ellipse', 'ingenious-shortcodes' ),  true ),
									'circle' =>array( esc_html__( 'Circle', 'ingenious-shortcodes' ), false ),
								),
							),
							'size' => array(
								'type' => 'text',
								'addrowclasses' => 'disable grid-col-4',
								'title' => esc_html__( 'Size', 'ingenious-shortcodes' ),
								'atts' => 'placeholder="'.esc_html__('Two space separated percent values, for example (60% 55%)', 'ingenious-shortcodes').'"',
							),
							'keyword' => array(
								'type' => 'select',
								'title' => esc_html__( 'Size keyword', 'ingenious-shortcodes' ),
								'addrowclasses' => 'disable grid-col-4',
								'source' => array(
									'closest-side' => array(esc_html__( 'Closest side', 'ingenious-shortcodes' ), false),
									'farthest-side' => array(esc_html__( 'Farthest side', 'ingenious-shortcodes' ), false),
									'closest-corner' => array(esc_html__( 'Closest corner', 'ingenious-shortcodes' ), false),
									'farthest-corner' => array(esc_html__( 'Farthest corner', 'ingenious-shortcodes' ), true),
								),
							),
						)
					),
					'custom_css' => array(
						'title' => esc_html__( 'Custom CSS rules', 'ingenious-shortcodes' ),
						'subtitle' => esc_html__( 'Enter styles', 'ingenious-shortcodes' ),
						'atts' => 'rows="10"',
						'type' => 'textarea',
						'addrowclasses' => 'grid-col-12 full_row',
					),
				),
			),

			'header_bg_opacity' => array(
				'title' => esc_html__( 'Background Color/Gradient Opacity', 'ingenious-shortcodes' ),
				'type' => 'number',
				'atts' => " min='0' max='100'",
				'addrowclasses' => 'disable grid-col-12 box',
				'value'	=> '90',
			),

			'page_title_spacings' => array(
				'title' => esc_html__( 'Title Spacings (in px)', 'ingenious-shortcodes' ),
				'type' => 'margins',
				'addrowclasses' => 'grid-col-12 two-inputs box',
				'value' => array(
					'top' => array('placeholder' => esc_html__( 'Top', 'ingenious-shortcodes' ), 'value' => '60'),
					'bottom' => array('placeholder' => esc_html__( 'Bottom', 'ingenious-shortcodes' ), 'value' => '60'),
				),
			),
			'header_sep'	=> array(
				'title'	=> esc_html__( 'Header Separator', 'ingenious-shortcodes' ),
				'type'	=> 'checkbox',
				'atts'	=> 'checked data-options="e:header_crop;e:header_crossing;e:header_left_overlay;e:header_right_overlay;e:header_left_layer;e:header_right_layer"',
				'addrowclasses' => 'checkbox alt grid-col-12 box'		
			),
			'header_crop'	=> array(
				'title'		=> esc_html__( 'Crop Background', 'ingenious-shortcodes' ),
				'type'		=> 'select',
				'atts'		=> 'multiple',
				'addrowclasses' => 'grid-col-6 box_box',
				'source'		=> array(
						'left_crop'		=> array( esc_html__( 'Left Crop', 'ingenious-shortcodes' ), true ),
						'right_crop'	=> array( esc_html__( 'Right Crop', 'ingenious-shortcodes' ), true ),
						'center_crop'	=> array( esc_html__( 'Center Crop', 'ingenious-shortcodes' ), false ),
				)
			),	
			'header_crossing' => array(
				'title' => esc_html__( 'Crossing (in percentages)', 'ingenious-shortcodes' ),
				'type' => 'number',
				'atts' => " min='0' max='100'",
				'addrowclasses' => 'grid-col-6 box_box',
				'value'	=> '50',
			),	
			'header_left_overlay'	=> array(
				'title'	=> esc_html__( 'Left Triangle Overlay', 'ingenious-shortcodes' ),
				'type'	=> 'checkbox',
				'atts'	=> 'data-options="e:header_left_overlay_color;e:header_left_overlay_opacity"',
				'addrowclasses' => 'checkbox grid-col-12 box_box'		
			),		
			'header_left_overlay_color' => array(
				'title' => esc_html__( 'Overlay Color', 'ingenious-shortcodes' ),
				'atts' => 'data-default-color="' . INGENIOUS_THEME_COLOR . '"',
				'addrowclasses' => 'grid-col-6 box_box',
				'type' => 'text',
				'value'	=> INGENIOUS_THEME_COLOR
			),
			'header_left_overlay_opacity' => array(
				'title' => esc_html__( 'Overlay Opacity', 'ingenious-shortcodes' ),
				'type' => 'number',
				'atts' => " min='0' max='100'",
				'addrowclasses' => 'grid-col-6 box_box',
				'value'	=> '70',
			),	
			'header_right_overlay'	=> array(
				'title'	=> esc_html__( 'Right Triangle Overlay', 'ingenious-shortcodes' ),
				'type'	=> 'checkbox',
				'atts'	=> 'data-options="e:header_right_overlay_color;e:header_right_overlay_opacity"',
				'addrowclasses' => 'checkbox grid-col-12 box_box'		
			),		
			'header_right_overlay_color' => array(
				'title' => esc_html__( 'Overlay Color', 'ingenious-shortcodes' ),
				'atts' => 'data-default-color="' . INGENIOUS_THEME_COLOR . '"',
				'addrowclasses' => 'grid-col-6 box_box',
				'type' => 'text',
				'value'	=> INGENIOUS_THEME_COLOR
			),
			'header_right_overlay_opacity' => array(
				'title' => esc_html__( 'Overlay Opacity', 'ingenious-shortcodes' ),
				'type' => 'number',
				'atts' => " min='0' max='100'",
				'addrowclasses' => 'grid-col-6 box_box',
				'value'	=> '70',
			),	
			'header_left_layer'	=> array(
				'title'	=> esc_html__( 'Left Background Layer', 'ingenious-shortcodes' ),
				'type'	=> 'checkbox',
				'atts'	=> 'data-options="e:header_left_layer_box;"',
				'addrowclasses' => 'checkbox grid-col-12 box_box'		
			),	
			'header_left_layer_box' => array(
				'type' => 'fields',
				'addrowclasses' => 'grid-col-12 box_box box_inside',
				'layout' => array(
					'bg'	=> array(
						'title'		=> esc_html__( 'Background Type Color', 'ingenious-shortcodes' ),
						'type'		=> 'select',
						'addrowclasses' => 'grid-col-12',
						'source'		=> array(
								'color'		=> array( esc_html__( 'Color', 'ingenious-shortcodes' ), true, 'e:color;e:color_opacity;d:gradient_from;d:from_opacity;d:gradient_to;d:to_opacity;d:gradient_angle' ),
								'gradient'	=> array( esc_html__( 'Gradient', 'ingenious-shortcodes' ), false, 'd:color;d:color_opacity;e:gradient_from;e:from_opacity;e:gradient_to;e:to_opacity;e:gradient_angle' ),
						)
					),	
					'color' => array(
						'title' => esc_html__( 'Color', 'ingenious-shortcodes' ),
						'atts' => 'data-default-color="' . INGENIOUS_THEME_COLOR . '"',
						'addrowclasses' => 'grid-col-6',
						'type' => 'text',
						'value'	=> INGENIOUS_THEME_COLOR
					),	
					'color_opacity' => array(
						'title' => esc_html__( 'Color Opacity', 'ingenious-shortcodes' ),
						'type' => 'number',
						'atts' => " min='0' max='100'",
						'addrowclasses' => 'grid-col-6',
						'value'	=> '70',
					),
					'gradient_from' => array(
						'title' => esc_html__( 'From', 'ingenious-shortcodes' ),
						'atts' => 'data-default-color="' . INGENIOUS_THEME_COLOR . '"',
						'addrowclasses' => 'grid-col-6',
						'type' => 'text',
						'value'	=> INGENIOUS_THEME_COLOR
					),	
					'from_opacity' => array(
						'title' => esc_html__( 'Gradient From Color Opacity', 'ingenious-shortcodes' ),
						'type' => 'number',
						'atts' => " min='0' max='100'",
						'addrowclasses' => 'grid-col-6',
						'value'	=> '70',
					),
					'gradient_to' => array(
						'title' => esc_html__( 'To', 'ingenious-shortcodes' ),
						'atts' => 'data-default-color="' . INGENIOUS_THEME_COLOR . '"',
						'addrowclasses' => 'grid-col-6',
						'type' => 'text',
						'value'	=> INGENIOUS_THEME_COLOR
					),
					'to_opacity' => array(
						'title' => esc_html__( 'Gradient To Color Opacity', 'ingenious-shortcodes' ),
						'type' => 'number',
						'atts' => " min='0' max='100'",
						'addrowclasses' => 'grid-col-6',
						'value'	=> '70',
					),
					'gradient_angle' => array(
						'title' => esc_html__( 'Angle', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-12',
						'type' => 'number',
						'atts' => " min='-360' max='360'",
						'value'	=> '45',
					),	
					'points'	=> array(
						'title'	=> esc_html__( 'Custom Points', 'ingenious-shortcodes' ),
						'type'	=> 'checkbox',
						'atts'	=> 'data-options="e:top_point;e:bot_point"',
						'addrowclasses' => 'checkbox grid-col-12'		
					),
					'top_point' => array(
						'title' => esc_html__( 'Top Point (in percentages)', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-6',
						'type' => 'number',
						'atts' => " min='0' max='100'",
						'value'	=> '50',
					),
					'bot_point' => array(
						'title' => esc_html__( 'Bottom Point (in percentages)', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-6',
						'type' => 'number',
						'atts' => " min='0' max='100'",
						'value'	=> '50',
					),
				)
			),
			'header_right_layer'	=> array(
				'title'	=> esc_html__( 'Right Background Layer', 'ingenious-shortcodes' ),
				'type'	=> 'checkbox',
				'atts'	=> 'data-options="e:header_right_layer_box"',
				'addrowclasses' => 'checkbox grid-col-12 box_box'		
			),
			'header_right_layer_box' => array(
				'type' => 'fields',
				'addrowclasses' => 'grid-col-12 box_box box_inside',
				'layout' => array(
					'bg'	=> array(
						'title'		=> esc_html__( 'Background Type Color', 'ingenious-shortcodes' ),
						'type'		=> 'select',
						'addrowclasses' => 'grid-col-12',
						'source'		=> array(
								'color'		=> array( esc_html__( 'Color', 'ingenious-shortcodes' ), true, 'e:color;e:color_opacity;d:gradient_from;d:from_opacity;d:gradient_to;d:to_opacity;d:gradient_angle' ),
								'gradient'	=> array( esc_html__( 'Gradient', 'ingenious-shortcodes' ), false, 'd:color;d:color_opacity;e:gradient_from;e:from_opacity;e:gradient_to;e:to_opacity;e:gradient_angle' ),
						)
					),	
					'color' => array(
						'title' => esc_html__( 'Color', 'ingenious-shortcodes' ),
						'atts' => 'data-default-color="' . INGENIOUS_THEME_COLOR . '"',
						'addrowclasses' => 'grid-col-6',
						'type' => 'text',
						'value'	=> INGENIOUS_THEME_COLOR
					),	
					'color_opacity' => array(
						'title' => esc_html__( 'Color Opacity', 'ingenious-shortcodes' ),
						'type' => 'number',
						'atts' => " min='0' max='100'",
						'addrowclasses' => 'grid-col-6',
						'value'	=> '70',
					),
					'gradient_from' => array(
						'title' => esc_html__( 'From', 'ingenious-shortcodes' ),
						'atts' => 'data-default-color="' . INGENIOUS_THEME_COLOR . '"',
						'addrowclasses' => 'grid-col-6',
						'type' => 'text',
						'value'	=> INGENIOUS_THEME_COLOR
					),	
					'from_opacity' => array(
						'title' => esc_html__( 'Gradient From Color Opacity', 'ingenious-shortcodes' ),
						'type' => 'number',
						'atts' => " min='0' max='100'",
						'addrowclasses' => 'grid-col-6',
						'value'	=> '70',
					),
					'gradient_to' => array(
						'title' => esc_html__( 'To', 'ingenious-shortcodes' ),
						'atts' => 'data-default-color="' . INGENIOUS_THEME_COLOR . '"',
						'addrowclasses' => 'grid-col-6',
						'type' => 'text',
						'value'	=> INGENIOUS_THEME_COLOR
					),
					'to_opacity' => array(
						'title' => esc_html__( 'Gradient To Color Opacity', 'ingenious-shortcodes' ),
						'type' => 'number',
						'atts' => " min='0' max='100'",
						'addrowclasses' => 'grid-col-6',
						'value'	=> '70',
					),
					'gradient_angle' => array(
						'title' => esc_html__( 'Angle', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-12',
						'type' => 'number',
						'atts' => " min='-360' max='360'",
						'value'	=> '45',
					),		
					'points'	=> array(
						'title'	=> esc_html__( 'Custom Points', 'ingenious-shortcodes' ),
						'type'	=> 'checkbox',
						'atts'	=> 'data-options="e:top_point;e:bot_point"',
						'addrowclasses' => 'checkbox grid-col-12'		
					),
					'top_point' => array(
						'title' => esc_html__( 'Top Point (in percentages)', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-6',
						'type' => 'number',
						'atts' => " min='0' max='100'",
						'value'	=> '50',
					),
					'bot_point' => array(
						'title' => esc_html__( 'Bottom Point (in percentages)', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-6',
						'type' => 'number',
						'atts' => " min='0' max='100'",
						'value'	=> '50',
					),	
				)
			),
			'sb_foot_override' => array(
				'type' => 'checkbox',
				'title' => esc_html__( 'Customize Footer', 'ingenious-shortcodes' ),
				'atts' => 'data-options="e:footer-sidebar-top;e:hide_footer;"',
				'addrowclasses' => 'checkbox grid-col-12',
			),
			'hide_footer'	=> array(
				'title'	=> esc_html__( 'Hide Footer', 'ingenious-shortcodes' ),
				'type'	=> 'checkbox',
				'addrowclasses' => 'checkbox grid-col-12 box'		
			),
			'footer-sidebar-top' => array(
				'type' => 'select',
				'addrowclasses' => 'disable grid-col-12 box',
				'source' => 'sidebars',
			),
			'sb_slider_override' => array(
				'type' => 'checkbox',
				'title' => esc_html__( 'Add Image Slider', 'ingenious-shortcodes' ),
				'atts' => 'data-options="e:slider_shortcode"',
				'addrowclasses' => 'checkbox grid-col-12',
			),
			'slider_shortcode' => array(
				'addrowclasses' => 'disable grid-col-12 box',
				'type' => 'text',
				'default' => ''
			),
		);
	}

	private function init() {
		add_action( 'add_meta_boxes', array($this, 'post_addmb') );
		add_action( 'add_meta_boxes_cwsportfolio', array($this, 'portfolio_addmb') );
		add_action( 'add_meta_boxes_cwsstaff', array($this, 'staff_addmb') );
		add_action( 'add_meta_boxes_megamenu_item', array($this, 'mgmenu_addmb') );

		add_action( 'admin_enqueue_scripts', array($this, 'mb_script_enqueue') );
		add_action( 'save_post', array($this, 'post_metabox_save'), 11, 2 );
	}

	public function portfolio_addmb() {
		add_meta_box( 'cws-post-metabox-id', 'CWS Portfolio Options', array($this, 'mb_portfolio_callback'), 'cwsportfolio', 'normal', 'high' );
	}

	public function staff_addmb() {
		add_meta_box( 'cws-post-metabox-id', 'CWS Staff Options', array($this, 'mb_staff_callback'), 'cwsstaff', 'normal', 'high' );
	}

	public function mgmenu_addmb() {
		add_meta_box( 'cws-post-metabox-id', 'CWS Megamenu Options', array($this, 'mb_mgmenu_callback'), 'megamenu_item', 'normal', 'high' );
	}

	public function post_addmb() {
		add_meta_box( 'cws-post-metabox-id', 'CWS Post Options', array($this, 'mb_post_callback'), 'post', 'normal', 'high' );
		add_meta_box( 'cws-post-metabox-id-1', 'Background Image', array($this, 'mb_post_side_callback'), 'post', 'side', 'low' );
		add_meta_box( 'cws-post-metabox-id', 'CWS Page Options', array($this, 'mb_page_callback'), 'page', 'normal', 'high' );
		add_meta_box( 'cws-post-metabox-id-1', 'Header Image', array($this, 'mb_page_side_callback'), 'page', 'side', 'low' );
	}

	public function mb_post_side_callback( $post ) {
		wp_nonce_field( 'cws_mb_nonce', 'mb_nonce' );

		$cws_stored_meta = get_post_meta( $post->ID, 'cws_mb_post' );
		$mb_attr_all = array(
			'post_back_image' => array(
				'title' => esc_html__( 'Image', 'ingenious-shortcodes' ),
				'addrowclasses' => 'hide_label grid-col-12 wide_picture wide_btn',
				'type' => 'media',
			),
		);

		if (function_exists('cws_core_build_layout') ) {
			echo cws_core_build_layout((!empty($cws_stored_meta) ? $cws_stored_meta[0] : ''), $mb_attr_all, 'cws_mb_');
		}			
	}

	public function mb_page_side_callback( $post ) {
		wp_nonce_field( 'cws_mb_nonce', 'mb_nonce' );

		$cws_stored_meta = get_post_meta( $post->ID, 'cws_mb_post' );
		$mb_attr_all = array(
			'page_back_image' => array(
				'title' => esc_html__( 'Image', 'ingenious-shortcodes' ),
				'addrowclasses' => 'hide_label grid-col-12 wide_picture wide_btn',
				'type' => 'media',
			),
		);

		if (function_exists('cws_core_build_layout') ) {
			echo cws_core_build_layout((!empty($cws_stored_meta) ? $cws_stored_meta[0] : ''), $mb_attr_all, 'cws_mb_');
		}	
	}	

	public function mb_staff_callback( $post ) {
		wp_nonce_field( 'cws_mb_nonce', 'mb_nonce' );

		$mb_attr = array(
			'is_clickable' => array(
				'type' => 'checkbox',
				'addrowclasses' => 'grid-col-12',
				'title' => esc_html__('Clickable link', 'ingenious-shortcodes' ),
			),
			'social_group' => array(
				'type' => 'group',
				'addrowclasses' => 'group grid-col-12',
				'title' => esc_html__('Social networks', 'ingenious-shortcodes' ),
				'button_title' => esc_html__('Add new social network', 'ingenious-shortcodes' ),
				'layout' => array(
					'title' => array(
						'type' => 'text',
						'atts' => 'data-role="title"',
						'title' => esc_html__('Social account title', 'ingenious-shortcodes' ),
					),
					'icon' => array(
						'type' => 'select',
						'addrowclasses' => 'fai',
						'source' => 'fa',
						'title' => esc_html__('Select the icon for this social contact', 'ingenious-shortcodes' )
					),
					'url' => array(
						'type' => 'text',
						'title' => esc_html__('Url to your account', 'ingenious-shortcodes' ),
					),
				),
			)
		);

		$cws_stored_meta = get_post_meta( $post->ID, 'cws_mb_post' );
		if (function_exists('cws_core_build_layout') ) {
			echo cws_core_build_layout((!empty($cws_stored_meta) ? $cws_stored_meta[0] : ''), $mb_attr, 'cws_mb_');
		}	
	}

	public function mb_mgmenu_callback( $post ) {
		wp_nonce_field( 'cws_mb_nonce', 'mb_nonce' );

		$mb_attr = array(
			'fw_mgmenu' => array(
				'type' => 'checkbox',
				'title' => esc_html__('Disable Full Width Megamenu', 'ingenious-shortcodes' ),
				'atts' => 'data-options="e:mgmenu_width;e:mgmenu_pos"',
				'addrowclasses' => 'grid-col-12',
			),
			'mgmenu_width' => array(
				'title' 		=> esc_html__( 'Set Fixed Width (in px)', 'ingenious-shortcodes' ),
				'type' 			=> 'text',
				'addrowclasses' => 'disable grid-col-12',
				'value'			=> '1170',
			),
			'mgmenu_pos' => array(
				'title' 		=> esc_html__( 'Dropdown Position', 'ingenious-shortcodes' ),
				'type' 			=> 'select',
				'addrowclasses' => 'disable grid-col-12',
				'source' => array(
					'center' => array(esc_html__( 'Center', 'ingenious-shortcodes' ), true),
					'left' => array(esc_html__( 'Left', 'ingenious-shortcodes' ), false),
					'right' => array(esc_html__( 'Right', 'ingenious-shortcodes' ), false),
				),
			),
		);
		$cws_stored_meta = get_post_meta( $post->ID, 'cws_mb_post' );
		if (function_exists('cws_core_build_layout') ) {
			echo cws_core_build_layout((!empty($cws_stored_meta) ? $cws_stored_meta[0] : ''), $mb_attr, 'cws_mb_');
		}	
	}

	public function mb_page_callback( $post ) {
		wp_nonce_field( 'cws_mb_nonce', 'mb_nonce' );

		$mb_attr = $this->getPageLayout();

		$cws_stored_meta = get_post_meta( $post->ID, 'cws_mb_post' );
		if (function_exists('cws_core_build_layout') ) {
			echo cws_core_build_layout((!empty($cws_stored_meta) ? $cws_stored_meta[0] : ''), $mb_attr, 'cws_mb_');
		}	
	}

	public function mb_portfolio_callback( $post ) {
		wp_nonce_field( 'cws_mb_nonce', 'mb_nonce' );

		$mb_attr = array(
			'tab0' => array(
				'type' => 'tab',
				'init' => 'open grid-col-12',
				'title' => esc_html__( 'General', 'ingenious-shortcodes' ),
				'layout' => array(
					'full_width' => array(
						'type' => 'checkbox',
						'title' => esc_html__( 'Full Width', 'ingenious-shortcodes' ),
						'atts' => 'data-options="d:decr_pos;"',
					),
					'title_align' => array(
						'type' => 'select',
						'title' => esc_html__( 'Title Alignment', 'ingenious-shortcodes' ),
						'source' => array(
							'left' => array(esc_html__( 'Left', 'ingenious-shortcodes' ), true ),
							'center' => array(esc_html__( 'Center', 'ingenious-shortcodes' ), false ),
							'right' => array(esc_html__( 'Right', 'ingenious-shortcodes' ), false ),
						),
					),
					'decr_pos' => array(
						'type' => 'select',
						'title' => esc_html__( 'Project Description', 'ingenious-shortcodes' ),
						'source' => array(
							'bot' => array(esc_html__( 'Bottom', 'ingenious-shortcodes' ), true, 'd:cont_width;'),
							'left' => array(esc_html__( 'Left', 'ingenious-shortcodes' ), false, 'e:cont_width;'),
							'left_s' => array(esc_html__( 'Left + Sticky', 'ingenious-shortcodes' ), false, 'e:cont_width;'),
							'right' => array(esc_html__( 'Right', 'ingenious-shortcodes' ), false, 'e:cont_width;'),
							'right_s' => array(esc_html__( 'Right + Sticky', 'ingenious-shortcodes' ), false, 'e:cont_width;'),
						),
					),
					'cont_width' => array(
						'type' => 'select',
						'title' => esc_html__( 'Content Width', 'ingenious-shortcodes' ),
						'source' => array(
							'25' => array(esc_html__( '1/4', 'ingenious-shortcodes' ), false),
							'33' => array(esc_html__( '1/3', 'ingenious-shortcodes' ), true),
							'50' => array(esc_html__( '1/2', 'ingenious-shortcodes' ), false),
							'66' => array(esc_html__( '2/3', 'ingenious-shortcodes' ), false),
						),
					),
					'p_type' => array(
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Single\'s Format', 'ingenious-shortcodes' ),
						'source' => array(
							'image' => array(esc_html__( 'Featured Image', 'ingenious-shortcodes' ), true, 'd:gall_type;d:video_type;d:slider_type;d:rev_slider_type;'),
							'gallery' => array(esc_html__( 'Gallery', 'ingenious-shortcodes' ), false, 'e:gall_type;d:video_type;d:slider_type;d:rev_slider_type;'),
							'slider' => array(esc_html__( 'Slider', 'ingenious-shortcodes' ), false, 'd:gall_type;d:video_type;e:slider_type;d:rev_slider_type;'),
							'rev_slider' => array(esc_html__( 'External Slider', 'ingenious-shortcodes' ), false, 'd:gall_type;d:video_type;d:slider_type;e:rev_slider_type;'),
							'video' => array(esc_html__( 'Video', 'ingenious-shortcodes' ), false, 'd:gall_type;e:video_type;d:slider_type;d:rev_slider_type;'),
							'none' => array(esc_html__( 'None', 'ingenious-shortcodes' ), false, 'd:gall_type;d:video_type;d:slider_type;d:rev_slider_type;'),
						),
					),
					'gall_type' => array(
						'type' => 'fields',
						'addrowclasses' => 'box inside-box groups',
						'layout' => array(
							'gall' => array(
								'title' => esc_html__( 'Add Media', 'ingenious-shortcodes' ),
								'type' => 'gallery'
							),
						),
					),
					'slider_type' => array(
						'type' => 'fields',
						'addrowclasses' => 'box inside-box groups',
						'layout' => array(
							'slider_gall' => array(
								'title' => esc_html__( 'Add Media', 'ingenious-shortcodes' ),
								'type' => 'gallery',
								'addrowclasses' => 'grid-col-3',
							),
							'on_grid' => array(
								'title' => esc_html__( 'Show on Portfolio Grid', 'ingenious-shortcodes' ),
								'type' => 'checkbox',
								'addrowclasses' => 'grid-col-3',
							),
						),
					),
					'rev_slider_type' => array(
						'type' => 'fields',
						'addrowclasses' => 'box inside-box groups',
						'layout' => array(
							'rev_url' => array(
								'title' => esc_html__( 'Add Shortcode', 'ingenious-shortcodes' ),
								'type' => 'text',
							),
						)
					),
					'video_type' => array(
						'type' => 'fields',
						'addrowclasses' => 'box inside-box groups',
						'layout' => array(
							'video_t' => array(
								'type' => 'select',
								'source' => array(
									'youtube' => array(esc_html__( 'YouTube', 'ingenious-shortcodes' ), true, 'e:youtube_t;d:vimeo_t;d:other_t;'),
									'vimeo' => array(esc_html__( 'Vimeo', 'ingenious-shortcodes' ), false, 'd:youtube_t;e:vimeo_t;d:other_t;'),
									'other' => array(esc_html__( 'Other', 'ingenious-shortcodes' ), false, 'd:youtube_t;d:vimeo_t;e:other_t;'),
								),
							),
							'youtube_t' => array(
								'type' => 'fields',
								'addrowclasses' => 'box inside-box groups grid-col-12',
								'layout' => array(
									'url' => array(
										'title' => esc_html__( 'Video ID', 'ingenious-shortcodes' ),
										'type' => 'text',
									),
								),
							),
							'vimeo_t' => array(
								'type' => 'fields',
								'addrowclasses' => 'box inside-box groups grid-col-12',
								'layout' => array(
									'url' => array(
										'title' => esc_html__( 'Video ID', 'ingenious-shortcodes' ),
										'type' => 'text',
									),
								),
							),
							'other_t' => array(
								'type' => 'fields',
								'addrowclasses' => 'box inside-box groups grid-col-12',
								'layout' => array(
									'url' => array(
										'title' => esc_html__( 'Video URL', 'ingenious-shortcodes' ),
										'type' => 'text',
									),
								),
							),
							'popup' => array(
								'title' => esc_html__( 'Show Video in a Popup on Single', 'ingenious-shortcodes' ),
								'type' => 'checkbox',
								'addrowclasses' => 'grid-col-12',
								'atts' => 'data-options="e:img;"',
							),
							'on_grid' => array(
								'title' => esc_html__( 'Show on Portfolio Grid', 'ingenious-shortcodes' ),
								'type' => 'checkbox',
								'addrowclasses' => 'grid-col-12',
								'atts' => 'data-options="e:popup_grid;"',
							),
							'popup_grid' => array(
								'title' => esc_html__( 'Show Video in a Popup on Grid', 'ingenious-shortcodes' ),
								'type' => 'checkbox',
								'addrowclasses' => 'grid-col-12',
							),
						)
					),
					'sb_layout' => array(
						'title' => esc_html__('Sidebar Position', 'ingenious-shortcodes' ),
						'type' => 'radio',
						'subtype' => 'images',
						'value' => array(
							'left' => 	array( esc_html__('Left', 'ingenious-shortcodes' ), false, 'e:sidebar1;d:sidebar2',	get_template_directory_uri() . '/img/fw_img/left.png' ),
							'right' => 	array( esc_html__('Right', 'ingenious-shortcodes' ), false, 'e:sidebar1;d:sidebar2', get_template_directory_uri() . '/img/fw_img/right.png' ),
							'both' => 	array( esc_html__('Double', 'ingenious-shortcodes' ), false, 'e:sidebar1;e:sidebar2', get_template_directory_uri() . '/img/fw_img/both.png' ),
							'none' => 	array( esc_html__('None', 'ingenious-shortcodes' ), true, 'd:sidebar1;d:sidebar2', get_template_directory_uri() . '/img/fw_img/none.png' )
						),
					),
					'sidebar1' => array(
						'title' => esc_html__('Select a sidebar', 'ingenious-shortcodes' ),
						'type' => 'select',
						'addrowclasses' => 'disable',
						'source' => 'sidebars',
					),
					'sidebar2' => array(
						'required' => array( 'sb_layout', '=', 'both' ),
						'title' => esc_html__('Select right sidebar', 'ingenious-shortcodes' ),
						'type' => 'select',
						'addrowclasses' => 'disable',
						'source' => 'sidebars',
					),
				),
			),
			'tab1' => array(
				'type' => 'tab',
				'init' => 'closed',
				'title' => esc_html__( 'Isotope Layout', 'ingenious-shortcodes' ),
				'layout' => array(
					'isotope_col_count' => array(
						'type' => 'select',
						'title' => esc_html__( 'Columns', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-12',
						'source' => array(
							'1' => array(esc_html__( 'One', 'ingenious-shortcodes' ), true),
							'2' => array(esc_html__( 'Two', 'ingenious-shortcodes' ), false),
							'3' => array(esc_html__( 'Three', 'ingenious-shortcodes' ), false),
							'4' => array(esc_html__( 'Four', 'ingenious-shortcodes' ), false),
						),
					),
					'isotope_line_count' => array(
						'type' => 'select',
						'title' => esc_html__( 'Lines', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-12',
						'source' => array(
							'1' => array(esc_html__( 'One', 'ingenious-shortcodes' ), true),
							'2' => array(esc_html__( 'Two', 'ingenious-shortcodes' ), false),
							'3' => array(esc_html__( 'Three', 'ingenious-shortcodes' ), false),
							'4' => array(esc_html__( 'Four', 'ingenious-shortcodes' ), false),
						),
					),
					'desc' => array(
						'type' => 'lable',
						'addrowclasses' => 'grid-col-12',
						'title' => esc_html__( 'This option is used in the Isotope Portfolio Layout only. The image will take the selected number of Columns/Lines and will be displayed accordingly.', 'ingenious-shortcodes' ),
					),
				),
			),
			'tab2' => array(
				'type' => 'tab',
				'init' => 'closed',
				'title' => esc_html__( 'Related Items', 'ingenious-shortcodes' ),
				'layout' => array(
					'carousel' => array(
						'title' => esc_html__( 'Display items carousel for this portfolio post', 'ingenious-shortcodes' ),
						'type' => 'checkbox',
						'atts' => 'checked',
						'addrowclasses' => 'checkbox grid-col-12',
					),
					'show_related' => array(
						'title' => esc_html__( 'Show related Items', 'ingenious-shortcodes' ),
						'type' => 'checkbox',
						'atts' => 'checked data-options="e:related_projects_options;e:rpo_title;e:rpo_cols;e:rpo_items_count;e:rpo_categories;"',
						'addrowclasses' => 'alt checkbox grid-col-12',
					),
					'rpo_title' => array(
						'type' => 'text',
						'title' => esc_html__( 'Title', 'ingenious-shortcodes' ),
						'value' => esc_html__( 'پروژه های مرتبط', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-12',
					),
					'rpo_categories' => array(
						'title' => esc_html__( 'Categories', 'ingenious-shortcodes' ),
						'type' => 'taxonomy',
						'atts' => 'multiple',
						'addrowclasses' => 'grid-col-12',
						'taxonomy' => 'cwsportfolio-cat',
						'source' => array(),
					),
					'rpo_cols' => array(
						'type' => 'select',
						'title' => esc_html__( 'Columns', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-12',
						'source' => array(
							'1' => array(esc_html__( 'One', 'ingenious-shortcodes' ), false),
							'2' => array(esc_html__( 'Two', 'ingenious-shortcodes' ), false),
							'3' => array(esc_html__( 'Three', 'ingenious-shortcodes' ), false),
							'4' => array(esc_html__( 'Four', 'ingenious-shortcodes' ), true),
							),
					),
					'rpo_show' => array(
						'type' => 'select',
						'title' => esc_html__( 'Show Title and Description', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-12',
						'source' => array(
							'inside_img' => array(esc_html__( 'On Image', 'ingenious-shortcodes' ), true),
							'under_img' => array(esc_html__( 'Under Image', 'ingenious-shortcodes' ), false),
						),
					),
					'rpo_meta' => array(
						'type' => 'select',
						'title' => esc_html__( 'Show Meta', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-12',
						'atts' => 'multiple',
						'source' => array(
							'title' => array(esc_html__( 'Title', 'ingenious-shortcodes' ), true),
							'excerpt' => array(esc_html__( 'Excerpt', 'ingenious-shortcodes' ), false),
							'cats' => array(esc_html__( 'Categories', 'ingenious-shortcodes' ), false),
						),
					),
					'rpo_items_count' => array(
						'type' => 'number',
						'title' => esc_html__( 'Number of Related Items', 'ingenious-shortcodes' ),
						'value' => '4',
						'addrowclasses' => 'grid-col-12',
					),
				),

			),
			'tab3' => array(
				'type' => 'tab',
				'init' => 'closed',
				'title' => esc_html__( 'Hover', 'ingenious-shortcodes' ),
				'layout' => array(
					'enable_hover' => array(
						'title' => esc_html__( 'Enable Hover', 'ingenious-shortcodes' ),
						'type' => 'checkbox',
						'atts' => 'checked data-options="e:link_options;e:link_options_single;e:link_options_fancybox"',
						'addrowclasses' => 'alt checkbox grid-col-12',
					),
					'link_options_fancybox' => array(
						'type' => 'checkbox',
						'title' => esc_html__( 'Open in a popup', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-12',
					),
					'link_options_single' => array(
						'type' => 'checkbox',
						'title' => esc_html__( 'Single Link', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-12',
						'atts' => 'data-options="e:link_options_url;"',
					),
					'link_options_url' => array(
						'type' => 'text',
						'title' => esc_html__( 'Add Custom URL', 'ingenious-shortcodes' ),
						'addrowclasses' => 'grid-col-12',
						'default' => ''
					),
				),
			),	
		);

		$cws_stored_meta = get_post_meta( $post->ID, 'cws_mb_post' );
		if (function_exists('cws_core_build_layout') ) {
			echo cws_core_build_layout((!empty($cws_stored_meta) ? $cws_stored_meta[0] : ''), $mb_attr, 'cws_mb_');
		}	
	}

	public function mb_post_callback( $post ) {
		wp_nonce_field( 'cws_mb_nonce', 'mb_nonce' );

		$mb_attr = array(
			'gallery' => array(
				'type' => 'tab',
				'init' => 'closed',
				'title' => esc_html__( 'Gallery options', 'ingenious-shortcodes' ),
				'layout' => array(
					'gallery' => array(
						'title' => esc_html__( 'Gallery', 'ingenious-shortcodes' ),
						'type' => 'gallery',
						'addrowclasses' => 'grid-col-12',
					)
				),
			),
			'video' => array(
				'type' => 'tab',
				'init' => 'closed',
				'title' => esc_html__( 'Video options', 'ingenious-shortcodes' ),
				'layout' => array(
					'video' => array(
						'title' => esc_html__( 'Url to video file', 'ingenious-shortcodes' ),
						'type' => 'text',
						'addrowclasses' => 'grid-col-12',
					)
				)
			),
			'audio' => array(
				'type' => 'tab',
				'init' => 'closed',
				'title' => esc_html__( 'Audio options', 'ingenious-shortcodes' ),
				'layout' => array(
					'audio' => array(
						'title' => esc_html__( 'Self-hosted/soundclod audio url.', 'ingenious-shortcodes' ),
						'subtitle' => esc_html__( 'Ex.: /wp-content/uploads/audio.mp3 or http://soundcloud.com/...', 'ingenious-shortcodes' ),
						'type' => 'text',
						'addrowclasses' => 'grid-col-12',
					)
				)
			),
			'link' => array(
				'type' => 'tab',
				'init' => 'closed',
				'title' => esc_html__( 'Link options', 'ingenious-shortcodes' ),
				'layout' => array(
					'link' => array(
						'title' => esc_html__( 'Url', 'ingenious-shortcodes' ),
						'type' => 'text',
						'addrowclasses' => 'grid-col-12',
					)
				)
			),
			'quote' => array(
				'type' => 'tab',
				'init' => 'closed',
				'title' => esc_html__( 'Quote options', 'ingenious-shortcodes' ),
				'layout' => array(
					'quote_text' => array(
						'title' => esc_html__( 'Quote', 'ingenious-shortcodes' ),
						'subtitle' => esc_html__( 'Enter the quote', 'ingenious-shortcodes' ),
						'atts' => 'rows="5"',
						'type' => 'textarea',
						'addrowclasses' => 'grid-col-12',
					),
					'author_name' => array(
						'title' => esc_html__( 'Author Name', 'ingenious-shortcodes' ),
						'type' => 'text',
						'addrowclasses' => 'grid-col-12',
					),
					'author_status' => array(
						'title' => esc_html__( 'Author Status', 'ingenious-shortcodes' ),
						'type' => 'text',
						'addrowclasses' => 'grid-col-12',
					)
				)
			)
		);

		$cws_stored_meta = get_post_meta( $post->ID, 'cws_mb_post' );
		if (function_exists('cws_core_build_layout') ) {
			echo cws_core_build_layout((!empty($cws_stored_meta) ? $cws_stored_meta[0] : ''), $mb_attr, 'cws_mb_');
		}	

		$mb_attr_all = array(
			'single_img' => array(
				'title' => esc_html__( 'Show Featured Image on Post Details Page', 'ingenious-shortcodes' ),
				'type' => 'checkbox',
				'addrowclasses' => 'checkbox grid-col-12',
				'atts' => 'checked data-options="e:full_width;"',
			),
			'full_width' => array(
				'type' => 'checkbox',
				'title' => esc_html__( 'Full-Width Featured Image', 'ingenious-shortcodes' ),
				'addrowclasses' => 'checkbox grid-col-12',
			),
			'post_custom_color' => array(
				'type' => 'checkbox',
				'addrowclasses' => 'checkbox grid-col-12',
				'title' => esc_html__( 'Edit Colors', 'ingenious-shortcodes' ),
				'atts' => 'data-options="e:post_title_color;e:post_font_color;e:post_font_sec_color;e:apply_color;"',
			),
			'apply_color' => array(
				'type' => 'select',
				'title' => esc_html__( 'Apply to', 'ingenious-shortcodes' ),
				'addrowclasses' => 'grid-col-12',
				'source' => array(
					'list_color' => array(esc_html__( 'Blog List', 'ingenious-shortcodes' ), true),
					'single_color' => array(esc_html__( 'Blog Single', 'ingenious-shortcodes' ), false),
					'both_color' => array(esc_html__( 'Both', 'ingenious-shortcodes' ), false),
				),
			),
			'post_title_color' => array(
				'title' 		=> esc_html__( 'Title Color', 'ingenious-shortcodes' ),
				'tooltip' => array(
					'title' => esc_html__( 'Override Title Color', 'ingenious-shortcodes' ),
					'content' => esc_html__( 'Override Title Color', 'ingenious-shortcodes' ),
				),
				'type' 			=> 'text',
				'addrowclasses' => 'disable grid-col-12',
				'atts' 			=> 'data-default-color="#59ab66"',
				'value'			=> '#59ab66'
			),
			'post_font_color' => array(
				'title' 		=> esc_html__( 'Text Color', 'ingenious-shortcodes' ),
				'type' 			=> 'text',
				'addrowclasses' => 'disable grid-col-12',
				'atts' 			=> 'data-default-color="#808c95;"',
				'value'			=> '#808c95'
			),
			'post_font_sec_color' => array(
				'title' 		=> esc_html__( 'Helper Color', 'ingenious-shortcodes' ),
				'type' 			=> 'text',
				'addrowclasses' => 'disable grid-col-12',
				'atts' 			=> 'data-default-color="#e9e7de;"',
				'value'			=> '#e9e7de'
			),
			'custom_title_overlay' => array(
				'type' => 'checkbox',
				'addrowclasses' => 'checkbox grid-col-12',
				'title' => esc_html__( 'Add Background Overlay', 'ingenious-shortcodes' ),
				'atts' => 'data-options="e:title_overlay;e:title_bg_opacity;e:apply_bg_color;"',
			),
			'apply_bg_color' => array(
				'type' => 'select',
				'title' => esc_html__( 'Apply to', 'ingenious-shortcodes' ),
				'addrowclasses' => 'grid-col-12',
				'source' => array(
					'list_color' => array(esc_html__( 'Blog List', 'ingenious-shortcodes' ), true),
					'single_color' => array(esc_html__( 'Blog Single', 'ingenious-shortcodes' ), false),
					'both_color' => array(esc_html__( 'Both', 'ingenious-shortcodes' ), false),
				),
			),
			'title_overlay' => array(
				'title' => esc_html__( 'Overlay Color', 'ingenious-shortcodes' ),
				'type' => 'text',
				'addrowclasses' => 'grid-col-12 disable',
				'atts' 			=> 'data-default-color="#000000"',
				'value'			=> '#000000'
			),
			'title_bg_opacity' => array(
				'title' 		=> esc_html__( 'Opacity', 'ingenious-shortcodes' ),								
				'type' 			=> 'number',
				'addrowclasses' => 'grid-col-12',
				'atts' 			=> " min='0' max='100'",
				'value'			=> '40'
			),
			'custom_title_spacings' => array(
				'type' => 'checkbox',
				'addrowclasses' => 'checkbox grid-col-12',
				'title' => esc_html__( 'Add Title Spacings', 'ingenious-shortcodes' ),
				'atts' => 'data-options="e:page_title_spacings;"',
			),
			'page_title_spacings' => array(
				'type' => 'margins',
				'addrowclasses' => 'grid-col-4 two-inputs',
				'value' => array(
					'top' => array('placeholder' => esc_html__( 'Top (in px)', 'ingenious-shortcodes' ), 'value' => '60px'),
					'bottom' => array('placeholder' => esc_html__( 'Bottom (in px)', 'ingenious-shortcodes' ), 'value' => '60px'),
				),
			),
		);

		if (function_exists('cws_core_build_layout') ) {
			echo cws_core_build_layout((!empty($cws_stored_meta) ? $cws_stored_meta[0] : ''), $mb_attr_all, 'cws_mb_');
		}	
	}		

	public function mb_script_enqueue($a) {
		global $pagenow;
		global $typenow;
		if( ($a == 'widgets.php' || $a == 'post-new.php' || $a == 'post.php' || $a == 'edit-tags.php') && ('customize.php' !== $pagenow) ) {
			if($typenow != 'product'){		
				wp_enqueue_script('select2-js', get_template_directory_uri() . '/includes/core/assets/js/select2/select2.js', array('jquery') );
				wp_enqueue_style('select2-css', get_template_directory_uri() . '/includes/core/assets/js/select2/select2.css', false, '2.0.0' );
			}
			wp_enqueue_media();
			wp_enqueue_style( 'wp-color-picker');
			wp_enqueue_script( 'wp-color-picker');
			wp_enqueue_style( 'mb_post_css' );
			wp_enqueue_script('custom-user-js', get_template_directory_uri() . '/includes/core/assets/js/user.js', array('jquery') );
		}
	}

	public function post_metabox_save( $post_id, $post )
	{
		if ( in_array($post->post_type, array('post', 'page', 'cwsportfolio', 'cwsstaff', 'megamenu_item')) ) {
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )
				return;

			if ( !isset( $_POST['mb_nonce']) || !wp_verify_nonce($_POST['mb_nonce'], 'cws_mb_nonce') )
				return;

			if ( !current_user_can( 'edit_post', $post->ID ) )
				return;

			$save_array = array();

			foreach($_POST as $key => $value) {
				if (0 === strpos($key, 'cws_mb_')) {
					if ('on' === $value) {
						$value = '1';
					}
					if (is_array($value)) {
						foreach ($value as $k => $val) {
							if (is_array($val)) {
								$save_array[substr($key, 7)][$k] = $val;
							} else {
								$save_array[substr($key, 7)][$k] = esc_html($val);
							}
						}
					} else {
						$save_array[substr($key, 7)] = esc_html($value);
					}
				}
			}
			if (!empty($save_array)) {
				update_post_meta($post_id, 'cws_mb_post', $save_array);
			}
		}
	}
}
?>