<?php
/*
Plugin Name: CWS Portfolio & Staff
Plugin URI:  http://creaws.com
Description: Internal use for creaws/cwsthemes themes only.
Text Domain: cws-portfolio-staff
Version: 1.1.1
*/

/*------------------------------------
-------------- PORTFOLIO -------------
------------------------------------*/

$theme = wp_get_theme();
define('CWS_THEME_SLUG', $theme->get( 'TextDomain' ));

add_action( "init", "register_cwsportfolio_cat" );
add_action( "init", "register_cwsportfolio" );

function register_cwsportfolio_cat(){

 $portfolio_slug = get_slug('portfolio_slug');
 $portfolio_slug = empty( $portfolio_slug ) ? 'portfolio' : $portfolio_slug;
 register_taxonomy( 'cwsportfolio-cat', 'cwsportfolio', array(
  'hierarchical' => true,
  'show_admin_column' => true,
  'rewrite' => array( 'slug' => sanitize_title($portfolio_slug . '-cat') )
  ));
}

function get_slug($taxonomy) {
 return call_user_func_array(CWS_THEME_SLUG . '_get_option', array($taxonomy));
}

function register_cwsportfolio (){
 $labels = array(
  'name' => esc_html__( 'Portfolio', 'cws-portfolio-staff' ),
  'singular_name' => esc_html__( 'Portfolio', 'cws-portfolio-staff' ),
  'menu_name' => esc_html__( 'Portfolio', 'cws-portfolio-staff' ),
  'add_new' => esc_html__( 'Add New', 'cws-portfolio-staff' ),
  'add_new_item' => esc_html__( 'Add New Portfolio', 'cws-portfolio-staff' ),
  'edit_item' => esc_html__('Edit Portfolio', 'cws-portfolio-staff' ),
  'new_item' => esc_html__( 'New Portfolio', 'cws-portfolio-staff' ),
  'view_item' => esc_html__( 'View Portfolio', 'cws-portfolio-staff' ),
  'search_items' => esc_html__( 'Search Portfolio', 'cws-portfolio-staff' ),
  'not_found' => esc_html__( 'No Portfolio Items found', 'cws-portfolio-staff' ),
  'not_found_in_trash' => esc_html__( 'No Portfolio Items found in Trash', 'cws-portfolio-staff' ),
  'parent_item_colon' => '',
  );
 $portfolio_slug = get_slug( 'portfolio_slug' );
 $portfolio_slug = empty( $portfolio_slug ) ? 'portfolio' : $portfolio_slug;
 register_post_type( 'cwsportfolio', array(
  'label' => esc_html__( 'Portfolio items', 'cws-portfolio-staff' ),
  'labels' => $labels,
  'public' => true,
  'rewrite' => array( 'slug' => $portfolio_slug ),
  'capability_type' => 'post',
  'supports' => array(
   'title',
   'editor',
   'excerpt',
   'page-attributes',
   'thumbnail'
   ),
  'menu_position' => 23,
  'menu_icon' => 'dashicons-format-gallery',
  'taxonomies' => array( 'cwsportfolio-cat' ),
  'has_archive' => true
 ));
}

/*------------------------------------
---------------- STAFF ---------------
------------------------------------*/

add_action( "init", "register_cwsstaff_department" );
add_action( "init", "register_cwsstaff_position" );
add_action( "init", "register_cwsstaff" );

function register_cwsstaff (){
 $labels = array(
  'name' => esc_html__( 'Staff', 'cws-portfolio-staff' ),
  'singular_name' => esc_html__( 'Staff', 'cws-portfolio-staff' ),
  'menu_name' => esc_html__( 'Our team', 'cws-portfolio-staff' ),
  'all_items' => esc_html__( 'All', 'cws-portfolio-staff' ),
  'add_new' => esc_html__( 'Add New', 'cws-portfolio-staff' ),
  'add_new_item' => esc_html__( 'Add New Staff', 'cws-portfolio-staff' ),
  'edit_item' => esc_html__('Edit Staff', 'cws-portfolio-staff' ),
  'new_item' => esc_html__( 'New Staff', 'cws-portfolio-staff' ),
  'view_item' => esc_html__( 'View Staff', 'cws-portfolio-staff' ),
  'search_items' => esc_html__( 'Find Staff', 'cws-portfolio-staff' ),
  'not_found' => esc_html__( 'No Staff found', 'cws-portfolio-staff' ),
  'not_found_in_trash' => esc_html__( 'No Staff found in Trash', 'cws-portfolio-staff' ),
  'parent_item_colon' => '',
  );
 $staff_slug = get_slug( 'staff_slug' );
 $staff_slug = empty( $staff_slug ) ? 'staff' : $staff_slug;
 register_post_type( 'cwsstaff', array(
  'label' => esc_html__( 'Staff members', 'cws-portfolio-staff' ),
  'labels' => $labels,
  'public' => true,
  'rewrite' => array( 'slug' => sanitize_title($staff_slug) ),
  'capability_type' => 'post',
  'supports' => array(
   'title',
   'editor',
   'excerpt',
   'page-attributes',
   'thumbnail'
   ),
  'menu_position' => 24,
  'menu_icon' => 'dashicons-groups',
  'taxonomies' => array( 'cwsstaff_member_position' ),
  'has_archive' => true
 ));
}

function register_cwsstaff_department(){
 $staff_slug = get_slug( 'staff_slug' );
 $staff_slug = empty( $staff_slug ) ? 'staff' : $staff_slug;
 $labels = array(
  'name' => esc_html__( 'Departments', 'cws-portfolio-staff' ),
  'singular_name' => esc_html__( 'Staff Department', 'cws-portfolio-staff' ),
  'all_items' => esc_html__( 'All Departments', 'cws-portfolio-staff' ),
  'edit_item' => esc_html__( 'Edit Department', 'cws-portfolio-staff' ),
  'view_item' => esc_html__( 'View Department', 'cws-portfolio-staff' ),
  'update_item' => esc_html__( 'Update Department', 'cws-portfolio-staff' ),
  'add_new_item' => esc_html__( 'Add New Department', 'cws-portfolio-staff' ),
  'new_item_name' => esc_html__( 'New Department\'s Title', 'cws-portfolio-staff' ),
  'parent_item' => esc_html__( 'Parent Department', 'cws-portfolio-staff' ),
  'parent_item_colon' => esc_html__( 'Parent Department:', 'cws-portfolio-staff' ),
  'search_items' => esc_html__( 'Search Departments', 'cws-portfolio-staff' ),
  'popular_items' => esc_html__( 'Popular Departments', 'cws-portfolio-staff' ),
  'separate_items_width_commas' => esc_html__( 'Separate with commas', 'cws-portfolio-staff' ),
  'add_or_remove_items' => esc_html__( 'Add or Remove Departments', 'cws-portfolio-staff' ),
  'choose_from_most_used' => esc_html__( 'Choose from the most used Departments', 'cws-portfolio-staff' ),
  'not_found' => esc_html__( 'No Staff departments found', 'cws-portfolio-staff' )
 );
 register_taxonomy( 'cwsstaff_member_department', 'cwsstaff', array(
  'labels' => $labels,
  'hierarchical' => true,
  'show_admin_column' => true,
  'rewrite' => array( 'slug' => sanitize_title($staff_slug . '-cat') )
 ));
}

function register_cwsstaff_position(){
 $staff_slug = get_slug( 'staff_slug' );
 $staff_slug = empty( $staff_slug ) ? 'staff' : $staff_slug;
 $labels = array(
  'name' => esc_html__( 'Positions', 'cws-portfolio-staff' ),
  'singular_name' => esc_html__( 'Staff Member position', 'cws-portfolio-staff' ),
  'all_items' => esc_html__( 'All Positions', 'cws-portfolio-staff' ),
  'edit_item' => esc_html__( 'Edit Position', 'cws-portfolio-staff' ),
  'view_item' => esc_html__( 'View Position', 'cws-portfolio-staff' ),
  'update_item' => esc_html__( 'Update Position', 'cws-portfolio-staff' ),
  'add_new_item' => esc_html__( 'Add New Position', 'cws-portfolio-staff' ),
  'new_item_name' => esc_html__( 'New Position\'s Title', 'cws-portfolio-staff' ),
  'search_items' => esc_html__( 'Search Positions', 'cws-portfolio-staff' ),
  'popular_items' => esc_html__( 'Popular Positions', 'cws-portfolio-staff' ),
  'separate_items_width_commas' => esc_html__( 'Separate with commas', 'cws-portfolio-staff' ),
  'add_or_remove_items' => esc_html__( 'Add or Remove Positions', 'cws-portfolio-staff' ),
  'choose_from_most_used' => esc_html__( 'Choose from the most used Positions', 'cws-portfolio-staff' ),
  'not_found' => esc_html__( 'No Staff Member positions found', 'cws-portfolio-staff' )
 );
 register_taxonomy( 'cwsstaff_member_position', 'cwsstaff', array(
  'labels' => $labels,
  'show_admin_column' => true,
  'rewrite' => array( 'slug' => sanitize_title($staff_slug . '-tag') ),
  'show_tagcloud' => false
 ));
}

function add_order_column( $columns ) {
  $columns['menu_order'] = /*esc_html__( */"Order"/*, "cws-portfolio-staff" )*/;
  return $columns;
}
add_action('manage_edit-cwsstaff_columns', 'add_order_column');
add_action('manage_edit-cwsportfolio_columns', 'add_order_column');

/**
* show custom order column values
*/
function show_order_column($name){
  global $post;
  switch ($name) {
    case 'menu_order':
      $order = $post->menu_order;
      echo $order;
      break;
   default:
      break;
   }
}
add_action('manage_cwsstaff_posts_custom_column','show_order_column');
add_action('manage_cwsportfolio_posts_custom_column','show_order_column');

/**
* make column sortable
*/
function order_column_register_sortable( $columns ){
	$new_columns = array(
		"menu_order" 	=> "menu_order",
		"date"			=> "date",
		"title"			=> "title"
	);
	return $new_columns;
}
add_filter('manage_edit-cwsstaff_sortable_columns','order_column_register_sortable');
add_filter('manage_edit-cwsportfolio_sortable_columns','order_column_register_sortable');
 
/**
 * Load plugin textdomain.
 */
function cws_load_textdomain() {
  load_plugin_textdomain( 'cws-portfolio-staff', false, false ); 
}
add_action( 'plugins_loaded', 'cws_load_textdomain' );

?>