/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-07-06 11:15:41 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=108 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schedule` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=5488 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=26454 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=2836 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=174 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=114 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_cwssvgi` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `atts` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`(128))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_pro_entities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `data` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_duplicator_pro_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=138573 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_post_views` (
  `id` bigint unsigned NOT NULL,
  `type` tinyint unsigned NOT NULL,
  `period` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `count` bigint unsigned NOT NULL,
  PRIMARY KEY (`type`,`period`,`id`),
  UNIQUE KEY `id_type_period_count` (`id`,`type`,`period`,`count`) USING BTREE,
  KEY `type_period_count` (`type`,`period`,`count`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3817 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=4872 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_css` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_css_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_layer_animations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_layer_animations_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_navigations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_navigations_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_sliders` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_sliders_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_slides_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_static_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_revslider_static_slides_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `query` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `actioned_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonce_action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nonce_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=47699 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `locale` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `image` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'info',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=192 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `address_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `last_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `company` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_1` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_2` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `city` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `state` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `postcode` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `country` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_operational_data` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_via` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_orders` (
  `id` bigint unsigned NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `billing_email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint unsigned DEFAULT NULL,
  `payment_method` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_orders_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permissions` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_key` char(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_secret` char(43) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonces` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `truncated_key` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_label` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attribute_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_orderby` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_email` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(191),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_ir` (
  `id` int NOT NULL AUTO_INCREMENT,
  `text1` text CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci NOT NULL,
  `text2` text CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_item_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=2112 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type` (`location_type`),
  KEY `location_type_code` (`location_type`,`location_code`(90)),
  KEY `zone_id` (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type` (`location_type`),
  KEY `location_type_code` (`location_type`,`location_code`(90))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(191)),
  KEY `tax_rate_class` (`tax_rate_class`(191)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wpgmza` (
  `id` int NOT NULL AUTO_INCREMENT,
  `map_id` int NOT NULL,
  `address` varchar(700) NOT NULL,
  `description` mediumtext NOT NULL,
  `pic` varchar(700) NOT NULL,
  `link` varchar(2083) NOT NULL,
  `icon` varchar(700) NOT NULL,
  `lat` varchar(100) NOT NULL,
  `lng` varchar(100) NOT NULL,
  `anim` varchar(3) NOT NULL,
  `title` varchar(700) NOT NULL,
  `infoopen` varchar(3) NOT NULL,
  `category` varchar(500) NOT NULL,
  `approved` tinyint(1) DEFAULT '1',
  `retina` tinyint(1) DEFAULT '0',
  `type` tinyint(1) DEFAULT '0',
  `did` varchar(500) NOT NULL,
  `other_data` longtext NOT NULL,
  `latlng` point DEFAULT NULL,
  `sticky` tinyint(1) DEFAULT '0',
  `layergroup` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wpgmza_admin_notices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci,
  `active_date` datetime DEFAULT NULL,
  `options` longtext COLLATE utf8mb4_unicode_520_ci,
  `dismissed` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpgmza_categories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL,
  `category_name` varchar(50) NOT NULL,
  `category_icon` varchar(700) NOT NULL,
  `retina` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wpgmza_category_maps` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cat_id` int NOT NULL,
  `map_id` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wpgmza_circles` (
  `id` int NOT NULL AUTO_INCREMENT,
  `map_id` int NOT NULL,
  `name` text,
  `center` point DEFAULT NULL,
  `radius` float DEFAULT NULL,
  `color` varchar(16) DEFAULT NULL,
  `opacity` float DEFAULT NULL,
  `lineColor` varchar(16) DEFAULT NULL,
  `lineOpacity` float DEFAULT '0',
  `description` text,
  `hoverEnabled` tinyint(1) DEFAULT '0',
  `ohFillColor` varchar(16) DEFAULT NULL,
  `ohLineColor` varchar(16) DEFAULT NULL,
  `ohFillOpacity` float DEFAULT NULL,
  `ohLineOpacity` float DEFAULT NULL,
  `link` varchar(700) NOT NULL,
  `layergroup` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wpgmza_image_overlays` (
  `id` int NOT NULL AUTO_INCREMENT,
  `map_id` int NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci,
  `cornerA` point DEFAULT NULL,
  `cornerB` point DEFAULT NULL,
  `image` varchar(700) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `opacity` float DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpgmza_maps` (
  `id` int NOT NULL AUTO_INCREMENT,
  `map_title` varchar(256) NOT NULL,
  `map_width` varchar(6) NOT NULL,
  `map_height` varchar(6) NOT NULL,
  `map_start_lat` varchar(700) NOT NULL,
  `map_start_lng` varchar(700) NOT NULL,
  `map_start_location` varchar(700) NOT NULL,
  `map_start_zoom` int NOT NULL,
  `default_marker` varchar(700) NOT NULL,
  `type` int NOT NULL,
  `alignment` int NOT NULL,
  `directions_enabled` int NOT NULL,
  `styling_enabled` int NOT NULL,
  `styling_json` mediumtext NOT NULL,
  `active` int NOT NULL,
  `kml` varchar(700) NOT NULL,
  `bicycle` int NOT NULL,
  `traffic` int NOT NULL,
  `dbox` int NOT NULL,
  `dbox_width` varchar(10) NOT NULL,
  `listmarkers` int NOT NULL,
  `listmarkers_advanced` int NOT NULL,
  `filterbycat` tinyint(1) NOT NULL,
  `ugm_enabled` int NOT NULL,
  `ugm_category_enabled` tinyint(1) NOT NULL,
  `fusion` varchar(100) NOT NULL,
  `map_width_type` varchar(3) NOT NULL,
  `map_height_type` varchar(3) NOT NULL,
  `mass_marker_support` int NOT NULL,
  `ugm_access` int NOT NULL,
  `order_markers_by` int NOT NULL,
  `order_markers_choice` int NOT NULL,
  `show_user_location` int NOT NULL,
  `default_to` varchar(700) NOT NULL,
  `other_settings` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wpgmza_point_labels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `map_id` int NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci,
  `center` point DEFAULT NULL,
  `fillColor` varchar(16) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lineColor` varchar(16) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `opacity` float DEFAULT NULL,
  `fontSize` varchar(3) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpgmza_polygon` (
  `id` int NOT NULL AUTO_INCREMENT,
  `map_id` int NOT NULL,
  `polydata` longtext NOT NULL,
  `innerpolydata` longtext NOT NULL,
  `linecolor` varchar(7) NOT NULL,
  `lineopacity` varchar(7) NOT NULL,
  `fillcolor` varchar(7) NOT NULL,
  `opacity` varchar(3) NOT NULL,
  `title` varchar(250) NOT NULL,
  `link` varchar(700) NOT NULL,
  `ohfillcolor` varchar(7) NOT NULL,
  `ohlinecolor` varchar(7) NOT NULL,
  `ohopacity` varchar(3) NOT NULL,
  `polyname` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `linethickness` varchar(3) NOT NULL,
  `layergroup` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wpgmza_polylines` (
  `id` int NOT NULL AUTO_INCREMENT,
  `map_id` int NOT NULL,
  `polydata` longtext NOT NULL,
  `linecolor` varchar(7) NOT NULL,
  `linethickness` varchar(3) NOT NULL,
  `opacity` varchar(3) NOT NULL,
  `polyname` varchar(100) NOT NULL,
  `layergroup` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wpgmza_rectangles` (
  `id` int NOT NULL AUTO_INCREMENT,
  `map_id` int NOT NULL,
  `name` text,
  `cornerA` point DEFAULT NULL,
  `cornerB` point DEFAULT NULL,
  `color` varchar(16) DEFAULT NULL,
  `opacity` float DEFAULT NULL,
  `lineColor` varchar(16) DEFAULT NULL,
  `lineOpacity` float DEFAULT '0',
  `description` text,
  `hoverEnabled` tinyint(1) DEFAULT '0',
  `ohFillColor` varchar(16) DEFAULT NULL,
  `ohLineColor` varchar(16) DEFAULT NULL,
  `ohFillOpacity` float DEFAULT NULL,
  `ohLineOpacity` float DEFAULT NULL,
  `link` varchar(700) NOT NULL,
  `layergroup` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wp_users` VALUES 
("1","admin","$P$B9J5MXIXgsNzNAvxGeap/eiPR7owIT.","admin","info@designertheme.ir","","2017-08-09 19:54:22","","0","مدیر");

INSERT IGNORE INTO `wp_usermeta` VALUES 
("1","1","nickname","مدیر"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","comment_shortcuts","false"),
("7","1","admin_color","fresh"),
("8","1","use_ssl","0"),
("9","1","show_admin_bar_front","true"),
("10","1","locale",""),
("11","1","wp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("12","1","wp_user_level","10"),
("13","1","dismissed_wp_pointers","wp496_privacy,vc_pointers_backend_editor,theme_editor_notice,text_widget_custom_html"),
("14","1","show_welcome_panel","0"),
("16","1","wp_dashboard_quick_press_last_post_id","4871"),
("17","1","community-events-location","a:1:{s:2:\"ip\";s:12:\"185.140.59.0\";}"),
("18","1","manageedit-shop_ordercolumnshidden","a:1:{i:0;s:15:\"billing_address\";}"),
("19","1","wp_user-settings","libraryContent=browse&editor=html&hidetb=1&urlbutton=custom&imgsize=full&post_dfw=off&edit_element_vcUIPanelWidth=803&edit_element_vcUIPanelLeft=370px&edit_element_vcUIPanelTop=124px&posts_list_mode=list&editor_plain_text_paste_warning=2"),
("20","1","wp_user-settings-time","1710768147"),
("21","1","nav_menu_recently_edited","35"),
("22","1","managenav-menuscolumnshidden","a:1:{i:0;s:15:\"title-attribute\";}"),
("23","1","metaboxhidden_nav-menus","a:7:{i:0;s:21:\"add-post-type-product\";i:1;s:12:\"add-post_tag\";i:2;s:15:\"add-post_format\";i:3;s:15:\"add-product_cat\";i:4;s:15:\"add-product_tag\";i:5;s:20:\"add-cwsportfolio-cat\";i:6;s:30:\"woocommerce_endpoints_nav_link\";}"),
("24","1","_woocommerce_persistent_cart_1","a:1:{s:4:\"cart\";a:1:{s:32:\"043c3d7e489c69b48737cc0c92d0f3a2\";a:11:{s:3:\"key\";s:32:\"043c3d7e489c69b48737cc0c92d0f3a2\";s:10:\"product_id\";i:933;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";i:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:324;s:17:\"line_subtotal_tax\";d:0;s:10:\"line_total\";d:324;s:8:\"line_tax\";d:0;}}}"),
("25","1","closedpostboxes_nav-menus","a:0:{}"),
("26","1","billing_first_name",""),
("27","1","billing_last_name",""),
("28","1","billing_company",""),
("29","1","billing_address_1",""),
("30","1","billing_address_2",""),
("31","1","billing_city",""),
("32","1","billing_postcode",""),
("33","1","billing_country",""),
("34","1","billing_state",""),
("35","1","billing_phone",""),
("36","1","billing_email","info@designertheme.ir"),
("37","1","shipping_first_name",""),
("38","1","shipping_last_name",""),
("39","1","shipping_company",""),
("40","1","shipping_address_1",""),
("41","1","shipping_address_2",""),
("42","1","shipping_city",""),
("43","1","shipping_postcode",""),
("44","1","shipping_country",""),
("45","1","shipping_state",""),
("46","1","syntax_highlighting","true"),
("47","1","last_update","1529508473"),
("48","1","wp__user_like_count","0"),
("49","1","wc_last_active","1720224000"),
("50","1","dismissed_template_files_notice","1"),
("51","1","dismissed_no_secure_connection_notice","1"),
("52","1","dismissed_store_notice_setting_moved_notice","1"),
("53","1","dismissed_update_notice","1"),
("55","1","duplicator_pro_created_format","1"),
("56","1","show_try_gutenberg_panel","0"),
("57","1","_woocommerce_tracks_anon_id","woo:LN4bwdz8RLZ4CnhIKbtoEvx4"),
("63","1","dismissed_maxmind_license_key_notice","1"),
("64","1","rocketcdn_dismiss_notice","1"),
("65","1","_order_count","0"),
("66","1","wp_media_library_mode","list"),
("67","1","_imagify_ignore_ads","a:1:{i:0;s:9:\"wp-rocket\";}"),
("68","1","wp_mediafromftp_add_on_wpcron_events","a:0:{}"),
("80","1","session_tokens","a:1:{s:64:\"c7070563133f94b8b919f63f35b8a09292b308c715bd881310d357f2fbe57e4b\";a:4:{s:10:\"expiration\";i:1721471076;s:2:\"ip\";s:14:\"185.140.59.165\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36\";s:5:\"login\";i:1720261476;}}"),
("84","1","tgmpa_dismissed_notice_ingenious","1"),
("85","1","dismissed_download_directories_sync_complete_notice","1"),
("86","1","meta-box-order_product","a:3:{s:4:\"side\";s:84:\"submitdiv,postimagediv,woocommerce-product-images,product_catdiv,tagsdiv-product_tag\";s:6:\"normal\";s:55:\"woocommerce-product-data,postcustom,slugdiv,postexcerpt\";s:8:\"advanced\";s:0:\"\";}"),
("103","1","closedpostboxes_page","a:1:{i:0;s:25:\"slider_revolution_metabox\";}"),
("104","1","metaboxhidden_page","a:6:{i:0;s:12:\"revisionsdiv\";i:1;s:10:\"postcustom\";i:2;s:16:\"commentstatusdiv\";i:3;s:11:\"commentsdiv\";i:4;s:7:\"slugdiv\";i:5;s:9:\"authordiv\";}");

INSERT IGNORE INTO `wp_actionscheduler_actions` VALUES 
("4879","woocommerce_run_on_woocommerce_admin_updated","failed","2023-03-09 12:30:00","2023-03-09 16:00:00","[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1678365000;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1678365000;}","5","1","2023-03-09 12:30:01","2023-03-09 16:00:01","0",NULL,"10"),
("4881","woocommerce_run_on_woocommerce_admin_updated","failed","2023-03-09 12:30:09","2023-03-09 16:00:09","[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1678365009;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1678365009;}","5","1","2023-03-09 12:30:15","2023-03-09 16:00:15","0",NULL,"10"),
("4912","action_scheduler/migration_hook","failed","2023-03-10 17:42:01","2023-03-10 21:12:01","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1678470121;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1678470121;}","1","1","2023-03-10 17:42:21","2023-03-10 21:12:21","0",NULL,"10"),
("4961","action_scheduler/migration_hook","failed","2023-03-10 22:04:40","2023-03-11 01:34:40","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1678485880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1678485880;}","1","1","2023-03-10 22:05:40","2023-03-11 01:35:40","0",NULL,"10"),
("5057","action_scheduler/migration_hook","failed","2023-05-27 09:26:41","2023-05-27 12:56:41","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1685179601;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1685179601;}","1","1","2023-05-27 09:27:01","2023-05-27 12:57:01","0",NULL,"10"),
("5147","rocket_preload_job_check_finished","failed","2023-08-07 08:17:27","2023-08-07 11:47:27","[1691396187]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1691396247;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1691396247;}","6","1","2023-08-07 08:17:42","2023-08-07 11:47:42","0",NULL,"10"),
("5149","action_scheduler/migration_hook","failed","2023-08-07 08:18:42","2023-08-07 11:48:42","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1691396322;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1691396322;}","1","1","2023-08-07 08:18:43","2023-08-07 11:48:43","0",NULL,"10"),
("5156","action_scheduler/migration_hook","failed","2023-08-07 13:04:46","2023-08-07 16:34:46","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1691413486;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1691413486;}","1","1","2023-08-07 13:04:46","2023-08-07 16:34:46","0",NULL,"10"),
("5158","action_scheduler/migration_hook","failed","2023-08-07 13:23:57","2023-08-07 16:53:57","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1691414637;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1691414637;}","1","1","2023-08-07 13:23:58","2023-08-07 16:53:58","0",NULL,"10"),
("5451","woocommerce_cleanup_draft_orders","complete","2024-06-04 19:48:33","2024-06-04 23:18:33","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717530513;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717530513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-05 23:57:26","2024-06-06 03:27:26","0",NULL,"10"),
("5452","woocommerce_cleanup_draft_orders","complete","2024-06-06 23:57:26","2024-06-07 03:27:26","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717718246;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717718246;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-07 09:39:23","2024-06-07 13:09:23","0",NULL,"10"),
("5453","woocommerce_cleanup_draft_orders","complete","2024-06-08 09:39:23","2024-06-08 13:09:23","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717839563;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717839563;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-08 12:36:01","2024-06-08 16:06:01","0",NULL,"10"),
("5454","woocommerce_cleanup_draft_orders","complete","2024-06-09 12:36:01","2024-06-09 16:06:01","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717936561;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717936561;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-09 14:43:08","2024-06-09 18:13:08","0",NULL,"10"),
("5455","woocommerce_cleanup_draft_orders","complete","2024-06-10 14:43:08","2024-06-10 18:13:08","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1718030588;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1718030588;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-10 17:08:08","2024-06-10 20:38:08","0",NULL,"10"),
("5456","woocommerce_cleanup_draft_orders","complete","2024-06-11 17:08:08","2024-06-11 20:38:08","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1718125688;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1718125688;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-12 07:18:03","2024-06-12 10:48:03","0",NULL,"10"),
("5457","woocommerce_cleanup_draft_orders","complete","2024-06-13 07:18:03","2024-06-13 10:48:03","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1718263083;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1718263083;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-13 12:43:19","2024-06-13 16:13:19","0",NULL,"10"),
("5458","woocommerce_cleanup_draft_orders","complete","2024-06-14 12:43:19","2024-06-14 16:13:19","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1718368999;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1718368999;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-14 15:13:03","2024-06-14 18:43:03","0",NULL,"10"),
("5459","woocommerce_cleanup_draft_orders","complete","2024-06-15 15:13:03","2024-06-15 18:43:03","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1718464383;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1718464383;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-15 16:39:28","2024-06-15 20:09:28","0",NULL,"10"),
("5460","woocommerce_cleanup_draft_orders","complete","2024-06-16 16:39:28","2024-06-16 20:09:28","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1718555968;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1718555968;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-17 07:07:16","2024-06-17 10:37:16","0",NULL,"10"),
("5461","woocommerce_cleanup_draft_orders","complete","2024-06-18 07:07:16","2024-06-18 10:37:16","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1718694436;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1718694436;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-18 11:04:47","2024-06-18 14:34:47","0",NULL,"10"),
("5462","woocommerce_cleanup_draft_orders","complete","2024-06-19 11:04:47","2024-06-19 14:34:47","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1718795087;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1718795087;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-19 13:13:30","2024-06-19 16:43:30","0",NULL,"10"),
("5463","woocommerce_cleanup_draft_orders","complete","2024-06-20 13:13:30","2024-06-20 16:43:30","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1718889210;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1718889210;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-20 21:10:21","2024-06-21 00:40:21","0",NULL,"10"),
("5464","woocommerce_cleanup_draft_orders","complete","2024-06-21 21:10:21","2024-06-22 00:40:21","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1719004221;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1719004221;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-22 05:25:11","2024-06-22 08:55:11","0",NULL,"10"),
("5465","woocommerce_cleanup_draft_orders","complete","2024-06-23 05:25:11","2024-06-23 08:55:11","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1719120311;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1719120311;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-23 06:28:11","2024-06-23 09:58:11","0",NULL,"10"),
("5466","woocommerce_cleanup_draft_orders","complete","2024-06-24 06:28:11","2024-06-24 09:58:11","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1719210491;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1719210491;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-24 06:36:05","2024-06-24 10:06:05","0",NULL,"10"),
("5467","woocommerce_cleanup_draft_orders","complete","2024-06-25 06:36:05","2024-06-25 10:06:05","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1719297365;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1719297365;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-25 09:25:18","2024-06-25 12:55:18","0",NULL,"10"),
("5468","woocommerce_cleanup_draft_orders","complete","2024-06-26 09:25:18","2024-06-26 12:55:18","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1719393918;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1719393918;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-27 09:08:55","2024-06-27 12:38:55","0",NULL,"10"),
("5469","woocommerce_cleanup_draft_orders","complete","2024-06-28 09:08:55","2024-06-28 12:38:55","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1719565735;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1719565735;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-29 13:29:08","2024-06-29 16:59:08","0",NULL,"10"),
("5470","woocommerce_cleanup_draft_orders","complete","2024-06-30 13:29:08","2024-06-30 16:59:08","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1719754148;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1719754148;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-06-30 17:00:42","2024-06-30 20:30:42","0",NULL,"10"),
("5471","woocommerce_cleanup_draft_orders","complete","2024-07-01 17:00:42","2024-07-01 20:30:42","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1719853242;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1719853242;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-07-02 06:53:53","2024-07-02 10:23:53","0",NULL,"10"),
("5472","woocommerce_cleanup_draft_orders","complete","2024-07-03 06:53:53","2024-07-03 10:23:53","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1719989633;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1719989633;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-07-03 08:47:52","2024-07-03 12:17:52","0",NULL,"10"),
("5473","woocommerce_cleanup_draft_orders","complete","2024-07-04 08:47:52","2024-07-04 12:17:52","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1720082872;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1720082872;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-07-04 08:59:09","2024-07-04 12:29:09","0",NULL,"10"),
("5474","woocommerce_cleanup_draft_orders","complete","2024-07-05 08:59:09","2024-07-05 12:29:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1720169949;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1720169949;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-07-05 11:08:01","2024-07-05 14:38:01","0",NULL,"10"),
("5475","woocommerce_cleanup_draft_orders","complete","2024-07-06 11:08:01","2024-07-06 14:38:01","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1720264081;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1720264081;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","1","2024-07-06 11:08:58","2024-07-06 14:38:58","0",NULL,"10"),
("5476","woocommerce_run_update_callback","complete","2024-07-06 10:24:56","2024-07-06 13:54:56","{\"update_callback\":\"wc_update_860_remove_recommended_marketing_plugins_transient\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1720261496;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1720261496;}","2","1","2024-07-06 10:25:28","2024-07-06 13:55:28","0",NULL,"10"),
("5477","woocommerce_update_db_to_current_version","complete","2024-07-06 10:24:57","2024-07-06 13:54:57","{\"version\":\"8.6.1\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1720261497;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1720261497;}","2","1","2024-07-06 10:25:28","2024-07-06 13:55:28","0",NULL,"10"),
("5478","action_scheduler/migration_hook","complete","2024-07-06 10:26:58","2024-07-06 13:56:58","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1720261618;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1720261618;}","1","1","2024-07-06 10:27:17","2024-07-06 13:57:17","0",NULL,"10"),
("5479","woocommerce_run_product_attribute_lookup_regeneration_callback","complete","2024-07-06 10:56:22","2024-07-06 14:26:22","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1720263382;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1720263382;}","2","1","2024-07-06 10:56:22","2024-07-06 14:26:22","0",NULL,"10"),
("5480","woocommerce_run_product_attribute_lookup_regeneration_callback","complete","2024-07-06 10:56:23","2024-07-06 14:26:23","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1720263383;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1720263383;}","2","1","2024-07-06 10:56:44","2024-07-06 14:26:44","0",NULL,"10"),
("5481","woocommerce_run_update_callback","complete","2024-07-06 11:02:03","2024-07-06 14:32:03","{\"update_callback\":\"wc_update_870_prevent_listing_of_transient_files_directory\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1720263723;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1720263723;}","2","1","2024-07-06 11:02:31","2024-07-06 14:32:31","0",NULL,"10"),
("5482","woocommerce_run_update_callback","complete","2024-07-06 11:02:04","2024-07-06 14:32:04","{\"update_callback\":\"wc_update_890_update_connect_to_woocommerce_note\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1720263724;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1720263724;}","2","1","2024-07-06 11:02:31","2024-07-06 14:32:31","0",NULL,"10"),
("5483","woocommerce_run_update_callback","complete","2024-07-06 11:02:05","2024-07-06 14:32:05","{\"update_callback\":\"wc_update_890_update_paypal_standard_load_eligibility\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1720263725;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1720263725;}","2","1","2024-07-06 11:02:31","2024-07-06 14:32:31","0",NULL,"10"),
("5484","woocommerce_run_update_callback","complete","2024-07-06 11:02:06","2024-07-06 14:32:06","{\"update_callback\":\"wc_update_891_create_plugin_autoinstall_history_option\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1720263726;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1720263726;}","2","1","2024-07-06 11:02:31","2024-07-06 14:32:31","0",NULL,"10"),
("5485","woocommerce_run_update_callback","complete","2024-07-06 11:02:07","2024-07-06 14:32:07","{\"update_callback\":\"wc_update_900_add_launch_your_store_tour_option\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1720263727;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1720263727;}","2","1","2024-07-06 11:02:31","2024-07-06 14:32:31","0",NULL,"10"),
("5486","woocommerce_update_db_to_current_version","complete","2024-07-06 11:02:08","2024-07-06 14:32:08","{\"version\":\"9.0.2\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1720263728;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1720263728;}","2","1","2024-07-06 11:02:31","2024-07-06 14:32:31","0",NULL,"10"),
("5487","woocommerce_cleanup_draft_orders","pending","2024-07-07 11:08:58","2024-07-07 14:38:58","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1720350538;s:18:\"\0*\0first_timestamp\";i:1664306591;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1720350538;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","7","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10");

INSERT IGNORE INTO `wp_actionscheduler_groups` VALUES 
("1","action-scheduler-migration"),
("2","woocommerce-db-updates"),
("3","wc_update_product_lookup_tables"),
("4","wc-admin-data"),
("5","woocommerce-remote-inbox-engine"),
("6","rocket-preload"),
("7","");

INSERT IGNORE INTO `wp_actionscheduler_logs` VALUES 
("1008","4879","ایجاد فعالیت","2023-03-09 12:30:00","2023-03-09 16:00:00"),
("1012","4879","عملیات توسط WP Cron شروع شد","2023-03-09 12:30:01","2023-03-09 16:00:01"),
("1013","4879","اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.","2023-03-09 12:30:01","2023-03-09 16:00:01"),
("1014","4881","ایجاد فعالیت","2023-03-09 12:30:09","2023-03-09 16:00:09"),
("1017","4881","عملیات توسط WP Cron شروع شد","2023-03-09 12:30:15","2023-03-09 16:00:15"),
("1018","4881","اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.","2023-03-09 12:30:15","2023-03-09 16:00:15"),
("1107","4912","ایجاد فعالیت","2023-03-10 17:41:01","2023-03-10 21:11:01"),
("1110","4912","عملیات توسط WP Cron شروع شد","2023-03-10 17:42:21","2023-03-10 21:12:21"),
("1111","4912","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2023-03-10 17:42:21","2023-03-10 21:12:21"),
("1255","4961","ایجاد فعالیت","2023-03-10 22:03:40","2023-03-11 01:33:40"),
("1256","4961","عملیات توسط WP Cron شروع شد","2023-03-10 22:05:40","2023-03-11 01:35:40"),
("1257","4961","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2023-03-10 22:05:40","2023-03-11 01:35:40"),
("1543","5057","ایجاد فعالیت","2023-05-27 09:25:41","2023-05-27 12:55:41"),
("1544","5057","عملیات توسط WP Cron شروع شد","2023-05-27 09:27:01","2023-05-27 12:57:01"),
("1545","5057","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2023-05-27 09:27:01","2023-05-27 12:57:01"),
("1813","5147","ایجاد فعالیت","2023-08-07 08:16:27","2023-08-07 11:46:27"),
("1815","5147","عملیات توسط WP Cron شروع شد","2023-08-07 08:17:42","2023-08-07 11:47:42"),
("1816","5147","اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_check_finished will not be executed as no callbacks are registered.","2023-08-07 08:17:42","2023-08-07 11:47:42"),
("1819","5149","ایجاد فعالیت","2023-08-07 08:17:42","2023-08-07 11:47:42"),
("1820","5149","عملیات توسط Async Request شروع شد","2023-08-07 08:18:43","2023-08-07 11:48:43"),
("1821","5149","اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2023-08-07 08:18:43","2023-08-07 11:48:43"),
("1840","5156","ایجاد فعالیت","2023-08-07 13:03:46","2023-08-07 16:33:46"),
("1841","5156","عملیات توسط WP Cron شروع شد","2023-08-07 13:04:46","2023-08-07 16:34:46"),
("1842","5156","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2023-08-07 13:04:46","2023-08-07 16:34:46"),
("1846","5158","ایجاد فعالیت","2023-08-07 13:22:57","2023-08-07 16:52:57"),
("1847","5158","عملیات توسط WP Cron شروع شد","2023-08-07 13:23:58","2023-08-07 16:53:58"),
("1848","5158","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2023-08-07 13:23:58","2023-08-07 16:53:58"),
("2727","5451","ایجاد فعالیت","2024-06-03 19:48:33","2024-06-03 23:18:33"),
("2728","5451","عملیات توسط WP Cron شروع شد","2024-06-05 23:57:25","2024-06-06 03:27:25"),
("2729","5451","عملیات توسط WP Cron کامل شد","2024-06-05 23:57:26","2024-06-06 03:27:26"),
("2730","5452","ایجاد فعالیت","2024-06-05 23:57:26","2024-06-06 03:27:26"),
("2731","5452","عملیات توسط WP Cron شروع شد","2024-06-07 09:39:23","2024-06-07 13:09:23"),
("2732","5452","عملیات توسط WP Cron کامل شد","2024-06-07 09:39:23","2024-06-07 13:09:23"),
("2733","5453","ایجاد فعالیت","2024-06-07 09:39:23","2024-06-07 13:09:23"),
("2734","5453","عملیات توسط WP Cron شروع شد","2024-06-08 12:36:01","2024-06-08 16:06:01"),
("2735","5453","عملیات توسط WP Cron کامل شد","2024-06-08 12:36:01","2024-06-08 16:06:01"),
("2736","5454","ایجاد فعالیت","2024-06-08 12:36:01","2024-06-08 16:06:01"),
("2737","5454","عملیات توسط WP Cron شروع شد","2024-06-09 14:43:08","2024-06-09 18:13:08"),
("2738","5454","عملیات توسط WP Cron کامل شد","2024-06-09 14:43:08","2024-06-09 18:13:08"),
("2739","5455","ایجاد فعالیت","2024-06-09 14:43:08","2024-06-09 18:13:08"),
("2740","5455","عملیات توسط WP Cron شروع شد","2024-06-10 17:08:08","2024-06-10 20:38:08"),
("2741","5455","عملیات توسط WP Cron کامل شد","2024-06-10 17:08:08","2024-06-10 20:38:08"),
("2742","5456","ایجاد فعالیت","2024-06-10 17:08:08","2024-06-10 20:38:08"),
("2743","5456","عملیات توسط WP Cron شروع شد","2024-06-12 07:18:03","2024-06-12 10:48:03"),
("2744","5456","عملیات توسط WP Cron کامل شد","2024-06-12 07:18:03","2024-06-12 10:48:03"),
("2745","5457","ایجاد فعالیت","2024-06-12 07:18:03","2024-06-12 10:48:03"),
("2746","5457","عملیات توسط WP Cron شروع شد","2024-06-13 12:43:19","2024-06-13 16:13:19"),
("2747","5457","عملیات توسط WP Cron کامل شد","2024-06-13 12:43:19","2024-06-13 16:13:19"),
("2748","5458","ایجاد فعالیت","2024-06-13 12:43:20","2024-06-13 16:13:20"),
("2749","5458","عملیات توسط WP Cron شروع شد","2024-06-14 15:13:03","2024-06-14 18:43:03"),
("2750","5458","عملیات توسط WP Cron کامل شد","2024-06-14 15:13:03","2024-06-14 18:43:03"),
("2751","5459","ایجاد فعالیت","2024-06-14 15:13:03","2024-06-14 18:43:03"),
("2752","5459","عملیات توسط WP Cron شروع شد","2024-06-15 16:39:28","2024-06-15 20:09:28"),
("2753","5459","عملیات توسط WP Cron کامل شد","2024-06-15 16:39:28","2024-06-15 20:09:28"),
("2754","5460","ایجاد فعالیت","2024-06-15 16:39:28","2024-06-15 20:09:28"),
("2755","5460","عملیات توسط WP Cron شروع شد","2024-06-17 07:07:16","2024-06-17 10:37:16"),
("2756","5460","عملیات توسط WP Cron کامل شد","2024-06-17 07:07:16","2024-06-17 10:37:16"),
("2757","5461","ایجاد فعالیت","2024-06-17 07:07:16","2024-06-17 10:37:16"),
("2758","5461","عملیات توسط WP Cron شروع شد","2024-06-18 11:04:46","2024-06-18 14:34:46"),
("2759","5461","عملیات توسط WP Cron کامل شد","2024-06-18 11:04:47","2024-06-18 14:34:47"),
("2760","5462","ایجاد فعالیت","2024-06-18 11:04:47","2024-06-18 14:34:47"),
("2761","5462","عملیات توسط WP Cron شروع شد","2024-06-19 13:13:30","2024-06-19 16:43:30"),
("2762","5462","عملیات توسط WP Cron کامل شد","2024-06-19 13:13:30","2024-06-19 16:43:30"),
("2763","5463","ایجاد فعالیت","2024-06-19 13:13:30","2024-06-19 16:43:30"),
("2764","5463","عملیات توسط WP Cron شروع شد","2024-06-20 21:10:21","2024-06-21 00:40:21"),
("2765","5463","عملیات توسط WP Cron کامل شد","2024-06-20 21:10:21","2024-06-21 00:40:21"),
("2766","5464","ایجاد فعالیت","2024-06-20 21:10:21","2024-06-21 00:40:21"),
("2767","5464","عملیات توسط WP Cron شروع شد","2024-06-22 05:25:11","2024-06-22 08:55:11"),
("2768","5464","عملیات توسط WP Cron کامل شد","2024-06-22 05:25:11","2024-06-22 08:55:11"),
("2769","5465","ایجاد فعالیت","2024-06-22 05:25:11","2024-06-22 08:55:11"),
("2770","5465","عملیات توسط WP Cron شروع شد","2024-06-23 06:28:11","2024-06-23 09:58:11"),
("2771","5465","عملیات توسط WP Cron کامل شد","2024-06-23 06:28:11","2024-06-23 09:58:11"),
("2772","5466","ایجاد فعالیت","2024-06-23 06:28:11","2024-06-23 09:58:11"),
("2773","5466","عملیات توسط WP Cron شروع شد","2024-06-24 06:36:05","2024-06-24 10:06:05"),
("2774","5466","عملیات توسط WP Cron کامل شد","2024-06-24 06:36:05","2024-06-24 10:06:05"),
("2775","5467","ایجاد فعالیت","2024-06-24 06:36:05","2024-06-24 10:06:05"),
("2776","5467","عملیات توسط WP Cron شروع شد","2024-06-25 09:25:18","2024-06-25 12:55:18"),
("2777","5467","عملیات توسط WP Cron کامل شد","2024-06-25 09:25:18","2024-06-25 12:55:18"),
("2778","5468","ایجاد فعالیت","2024-06-25 09:25:18","2024-06-25 12:55:18"),
("2779","5468","عملیات توسط WP Cron شروع شد","2024-06-27 09:08:55","2024-06-27 12:38:55"),
("2780","5468","عملیات توسط WP Cron کامل شد","2024-06-27 09:08:55","2024-06-27 12:38:55"),
("2781","5469","ایجاد فعالیت","2024-06-27 09:08:55","2024-06-27 12:38:55"),
("2782","5469","عملیات توسط WP Cron شروع شد","2024-06-29 13:29:08","2024-06-29 16:59:08"),
("2783","5469","عملیات توسط WP Cron کامل شد","2024-06-29 13:29:08","2024-06-29 16:59:08"),
("2784","5470","ایجاد فعالیت","2024-06-29 13:29:08","2024-06-29 16:59:08"),
("2785","5470","عملیات توسط WP Cron شروع شد","2024-06-30 17:00:42","2024-06-30 20:30:42"),
("2786","5470","عملیات توسط WP Cron کامل شد","2024-06-30 17:00:42","2024-06-30 20:30:42"),
("2787","5471","ایجاد فعالیت","2024-06-30 17:00:42","2024-06-30 20:30:42"),
("2788","5471","عملیات توسط WP Cron شروع شد","2024-07-02 06:53:53","2024-07-02 10:23:53"),
("2789","5471","عملیات توسط WP Cron کامل شد","2024-07-02 06:53:53","2024-07-02 10:23:53"),
("2790","5472","ایجاد فعالیت","2024-07-02 06:53:53","2024-07-02 10:23:53"),
("2791","5472","عملیات توسط WP Cron شروع شد","2024-07-03 08:47:52","2024-07-03 12:17:52"),
("2792","5472","عملیات توسط WP Cron کامل شد","2024-07-03 08:47:52","2024-07-03 12:17:52"),
("2793","5473","ایجاد فعالیت","2024-07-03 08:47:52","2024-07-03 12:17:52"),
("2794","5473","عملیات توسط WP Cron شروع شد","2024-07-04 08:59:09","2024-07-04 12:29:09"),
("2795","5473","عملیات توسط WP Cron کامل شد","2024-07-04 08:59:09","2024-07-04 12:29:09"),
("2796","5474","ایجاد فعالیت","2024-07-04 08:59:09","2024-07-04 12:29:09"),
("2797","5474","عملیات توسط WP Cron شروع شد","2024-07-05 11:08:01","2024-07-05 14:38:01"),
("2798","5474","عملیات توسط WP Cron کامل شد","2024-07-05 11:08:01","2024-07-05 14:38:01"),
("2799","5475","ایجاد فعالیت","2024-07-05 11:08:01","2024-07-05 14:38:01"),
("2800","5476","ایجاد فعالیت","2024-07-06 10:24:56","2024-07-06 13:54:56"),
("2801","5477","ایجاد فعالیت","2024-07-06 10:24:56","2024-07-06 13:54:56"),
("2802","5476","عملیات توسط Async Request شروع شد","2024-07-06 10:25:28","2024-07-06 13:55:28"),
("2803","5476","عملیات توسط Async Request کامل شد","2024-07-06 10:25:28","2024-07-06 13:55:28"),
("2804","5477","عملیات توسط Async Request شروع شد","2024-07-06 10:25:28","2024-07-06 13:55:28"),
("2805","5477","عملیات توسط Async Request کامل شد","2024-07-06 10:25:28","2024-07-06 13:55:28"),
("2806","5478","ایجاد فعالیت","2024-07-06 10:25:58","2024-07-06 13:55:58"),
("2807","5478","عملیات توسط Async Request شروع شد","2024-07-06 10:27:17","2024-07-06 13:57:17"),
("2808","5478","عملیات توسط Async Request کامل شد","2024-07-06 10:27:17","2024-07-06 13:57:17"),
("2809","5479","ایجاد فعالیت","2024-07-06 10:56:21","2024-07-06 14:26:21"),
("2810","5479","عملیات توسط WP Cron شروع شد","2024-07-06 10:56:22","2024-07-06 14:26:22"),
("2811","5480","ایجاد فعالیت","2024-07-06 10:56:22","2024-07-06 14:26:22"),
("2812","5479","عملیات توسط WP Cron کامل شد","2024-07-06 10:56:22","2024-07-06 14:26:22"),
("2813","5480","عملیات توسط Async Request شروع شد","2024-07-06 10:56:44","2024-07-06 14:26:44"),
("2814","5480","عملیات توسط Async Request کامل شد","2024-07-06 10:56:44","2024-07-06 14:26:44"),
("2815","5481","ایجاد فعالیت","2024-07-06 11:02:03","2024-07-06 14:32:03"),
("2816","5482","ایجاد فعالیت","2024-07-06 11:02:03","2024-07-06 14:32:03"),
("2817","5483","ایجاد فعالیت","2024-07-06 11:02:03","2024-07-06 14:32:03"),
("2818","5484","ایجاد فعالیت","2024-07-06 11:02:03","2024-07-06 14:32:03"),
("2819","5485","ایجاد فعالیت","2024-07-06 11:02:03","2024-07-06 14:32:03"),
("2820","5486","ایجاد فعالیت","2024-07-06 11:02:03","2024-07-06 14:32:03"),
("2821","5481","عملیات توسط WP Cron شروع شد","2024-07-06 11:02:30","2024-07-06 14:32:30"),
("2822","5481","عملیات توسط WP Cron کامل شد","2024-07-06 11:02:31","2024-07-06 14:32:31"),
("2823","5482","عملیات توسط WP Cron شروع شد","2024-07-06 11:02:31","2024-07-06 14:32:31"),
("2824","5482","عملیات توسط WP Cron کامل شد","2024-07-06 11:02:31","2024-07-06 14:32:31"),
("2825","5483","عملیات توسط WP Cron شروع شد","2024-07-06 11:02:31","2024-07-06 14:32:31"),
("2826","5483","عملیات توسط WP Cron کامل شد","2024-07-06 11:02:31","2024-07-06 14:32:31"),
("2827","5484","عملیات توسط WP Cron شروع شد","2024-07-06 11:02:31","2024-07-06 14:32:31"),
("2828","5484","عملیات توسط WP Cron کامل شد","2024-07-06 11:02:31","2024-07-06 14:32:31"),
("2829","5485","عملیات توسط WP Cron شروع شد","2024-07-06 11:02:31","2024-07-06 14:32:31"),
("2830","5485","عملیات توسط WP Cron کامل شد","2024-07-06 11:02:31","2024-07-06 14:32:31"),
("2831","5486","عملیات توسط WP Cron شروع شد","2024-07-06 11:02:31","2024-07-06 14:32:31"),
("2832","5486","عملیات توسط WP Cron کامل شد","2024-07-06 11:02:31","2024-07-06 14:32:31"),
("2833","5475","عملیات توسط WP Cron شروع شد","2024-07-06 11:08:58","2024-07-06 14:38:58"),
("2834","5475","عملیات توسط WP Cron کامل شد","2024-07-06 11:08:58","2024-07-06 14:38:58"),
("2835","5487","ایجاد فعالیت","2024-07-06 11:08:58","2024-07-06 14:38:58");

INSERT IGNORE INTO `wp_commentmeta` VALUES 
("1","7","akismet_error","1370606029"),
("2","7","akismet_history","a:4:{s:4:\"time\";d:1370606029.1820490360260009765625;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("4","7","rating","4"),
("5","7","akismet_history","a:4:{s:4:\"time\";d:1370607930.6214559078216552734375;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("6","8","akismet_error","1370606265"),
("7","8","akismet_history","a:4:{s:4:\"time\";d:1370606265.92131900787353515625;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("9","8","rating","5"),
("10","8","akismet_history","a:4:{s:4:\"time\";d:1370607942.4681990146636962890625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("11","9","akismet_error","1370605393"),
("12","9","akismet_history","a:4:{s:4:\"time\";d:1370605393.68045711517333984375;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("14","9","rating","4"),
("15","9","akismet_history","a:4:{s:4:\"time\";d:1370605641.8064620494842529296875;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("16","9","verified",""),
("17","10","akismet_error","1370606115"),
("18","10","akismet_history","a:4:{s:4:\"time\";d:1370606115.2617321014404296875;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("20","10","rating","4"),
("21","10","akismet_history","a:4:{s:4:\"time\";d:1370607935.6320250034332275390625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("22","10","verified",""),
("23","11","akismet_error","1370610134"),
("24","11","akismet_history","a:4:{s:4:\"time\";d:1370610134.2017900943756103515625;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("26","11","rating","5"),
("27","11","akismet_history","a:4:{s:4:\"time\";d:1370611526.547483921051025390625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("28","11","verified",""),
("29","12","akismet_error","1370606072"),
("30","12","akismet_history","a:4:{s:4:\"time\";d:1370606072.7117550373077392578125;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("32","12","rating","5"),
("33","12","akismet_history","a:4:{s:4:\"time\";d:1370607931.63070201873779296875;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("34","13","akismet_error","1370610085"),
("35","13","akismet_history","a:4:{s:4:\"time\";d:1370610085.324596881866455078125;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("37","13","rating","5"),
("38","13","akismet_history","a:4:{s:4:\"time\";d:1370611525.10484409332275390625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("39","13","verified",""),
("40","14","akismet_error","1370620193"),
("41","14","akismet_history","a:4:{s:4:\"time\";d:1370620193.9864521026611328125;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("43","14","rating","5"),
("44","14","akismet_history","a:4:{s:4:\"time\";d:1370620633.9563140869140625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("45","14","verified",""),
("46","15","akismet_error","1370610209"),
("47","15","akismet_history","a:4:{s:4:\"time\";d:1370610209.978949069976806640625;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("49","15","rating","4"),
("50","15","akismet_history","a:4:{s:4:\"time\";d:1370611527.7993829250335693359375;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("51","16","akismet_error","1370611492"),
("52","16","akismet_history","a:4:{s:4:\"time\";d:1370611492.6543419361114501953125;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("54","16","rating","5"),
("55","16","akismet_history","a:4:{s:4:\"time\";d:1370611529.7720489501953125;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("56","17","akismet_error","1370620411"),
("57","17","akismet_history","a:4:{s:4:\"time\";d:1370620411.1445829868316650390625;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("59","17","rating","3"),
("60","17","akismet_history","a:4:{s:4:\"time\";d:1370620633.9381520748138427734375;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("61","18","akismet_error","1370605612"),
("62","18","akismet_history","a:4:{s:4:\"time\";d:1370605612.873900890350341796875;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("64","18","rating","4"),
("65","18","akismet_history","a:4:{s:4:\"time\";d:1370605643.71494293212890625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("66","19","akismet_error","1370605993"),
("67","19","akismet_history","a:4:{s:4:\"time\";d:1370605993.45998096466064453125;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("69","19","rating","5"),
("70","19","akismet_history","a:4:{s:4:\"time\";d:1370607929.392714977264404296875;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("71","20","akismet_error","1370606643"),
("72","20","akismet_history","a:4:{s:4:\"time\";d:1370606643.435740947723388671875;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("74","20","rating","5"),
("75","20","akismet_history","a:4:{s:4:\"time\";d:1370607947.308474063873291015625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("76","21","akismet_error","1370606091"),
("77","21","akismet_history","a:4:{s:4:\"time\";d:1370606091.7579820156097412109375;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("79","21","rating","1"),
("80","21","akismet_history","a:4:{s:4:\"time\";d:1370607932.6080811023712158203125;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("81","21","verified",""),
("82","22","akismet_error","1370620222"),
("83","22","akismet_history","a:4:{s:4:\"time\";d:1370620222.19242095947265625;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("85","22","rating","5"),
("86","22","akismet_history","a:4:{s:4:\"time\";d:1370620633.951541900634765625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("87","22","verified",""),
("88","23","akismet_error","1370607293"),
("89","23","akismet_history","a:4:{s:4:\"time\";d:1370607293.9348719120025634765625;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:7:\"student\";}"),
("91","23","rating","5"),
("92","23","akismet_history","a:4:{s:4:\"time\";d:1370607950.2842080593109130859375;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("93","24","akismet_error","1370607656"),
("94","24","akismet_history","a:4:{s:4:\"time\";d:1370607656.262073040008544921875;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("96","24","rating","5"),
("97","24","akismet_history","a:4:{s:4:\"time\";d:1370607953.4172599315643310546875;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("98","25","akismet_error","1370608902"),
("99","25","akismet_history","a:4:{s:4:\"time\";d:1370608902.768413066864013671875;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("101","25","rating","4"),
("102","25","akismet_history","a:4:{s:4:\"time\";d:1370609037.499927043914794921875;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("103","26","akismet_error","1370611600"),
("104","26","akismet_history","a:4:{s:4:\"time\";d:1370611600.5786969661712646484375;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("106","26","rating","5"),
("107","26","akismet_history","a:4:{s:4:\"time\";d:1370612306.3991410732269287109375;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("108","27","akismet_error","1370620436"),
("109","27","akismet_history","a:4:{s:4:\"time\";d:1370620436.97305393218994140625;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("111","27","rating","1"),
("112","27","akismet_history","a:4:{s:4:\"time\";d:1370620633.932437896728515625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("113","28","akismet_error","1370684262"),
("114","28","akismet_history","a:4:{s:4:\"time\";d:1370684262.2404038906097412109375;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("116","28","rating","5"),
("117","29","akismet_error","1370605945"),
("118","29","akismet_history","a:4:{s:4:\"time\";d:1370605945.8927509784698486328125;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("120","29","rating","4"),
("121","29","akismet_history","a:4:{s:4:\"time\";d:1370607928.4240779876708984375;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("122","29","verified",""),
("123","30","akismet_error","1370606196"),
("124","30","akismet_history","a:4:{s:4:\"time\";d:1370606196.096724987030029296875;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("126","30","rating","3"),
("127","30","akismet_history","a:4:{s:4:\"time\";d:1370607938.78227710723876953125;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("128","30","verified",""),
("129","31","akismet_error","1370607565"),
("130","31","akismet_history","a:4:{s:4:\"time\";d:1370607565.8578360080718994140625;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("132","31","rating","5"),
("133","31","akismet_history","a:4:{s:4:\"time\";d:1370607952.2542870044708251953125;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("134","31","verified",""),
("135","32","akismet_error","1370609989"),
("136","32","akismet_history","a:4:{s:4:\"time\";d:1370609989.9351150989532470703125;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("138","32","rating","4"),
("139","32","akismet_history","a:4:{s:4:\"time\";d:1370611523.6167409420013427734375;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("140","32","verified",""),
("141","33","akismet_error","1370608744"),
("142","33","akismet_history","a:4:{s:4:\"time\";d:1370608744.324286937713623046875;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("144","33","rating","3"),
("145","33","akismet_history","a:4:{s:4:\"time\";d:1370609036.19725894927978515625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("146","33","verified",""),
("147","34","akismet_error","1370620529"),
("148","34","akismet_history","a:4:{s:4:\"time\";d:1370620529.737782001495361328125;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}"),
("150","34","rating","1"),
("151","34","akismet_history","a:4:{s:4:\"time\";d:1370620633.7349870204925537109375;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}"),
("152","34","verified",""),
("153","7","verified","0"),
("154","8","verified","0"),
("155","12","verified","0"),
("160","15","verified","0"),
("161","16","verified","0"),
("162","17","verified","0"),
("163","23","verified","0"),
("164","24","verified","0"),
("165","25","verified","0"),
("166","26","verified","0"),
("167","27","verified","0"),
("168","18","verified","0"),
("169","19","verified","0"),
("170","20","verified","0");

INSERT IGNORE INTO `wp_comments` VALUES 
("2","105","admin","cws@cws.cws","","141.101.31.31","2017-09-04 07:07:40","2017-09-04 03:37:40","ممنون.","0","1","","comment","0","0"),
("3","111","admin","cws@cws.cws","","141.101.31.31","2017-09-08 13:02:56","2017-09-08 09:32:56","حتما.","0","1","","comment","0","0"),
("4","111","admin","cws@cws.cws","","141.101.31.31","2017-09-08 13:03:10","2017-09-08 09:33:10","بله مناسبه","0","1","","comment","3","0"),
("5","111","admin","cws@cws.cws","","141.101.31.31","2017-09-08 13:03:23","2017-09-08 09:33:23","شما لطف دارین","0","1","","comment","4","0"),
("6","111","admin","cws@cws.cws","","141.101.31.31","2017-09-08 13:03:34","2017-09-08 09:33:34","خیلی ممنون","0","1","","comment","0","0"),
("7","931","کیوان","bester.c@gmail.com","","196.215.9.147","2013-06-07 11:53:49","2013-06-07 08:23:49","بی نظیره!","0","1","","review","0","0"),
("8","931","مسعود","andrew@chromeorange.co.uk","","86.19.152.140","2013-06-07 11:57:45","2013-06-07 08:27:45","قیمتش بالاست","0","1","","review","0","0"),
("9","932","جواد","james@jameskoster.co.uk","","86.146.141.82","2013-06-07 11:43:13","2013-06-07 08:13:13","کیفیتش عالیه","0","1","","review","0","0"),
("10","932","حمید","bester.c@gmail.com","","196.215.9.147","2013-06-07 11:55:15","2013-06-07 08:25:15","خوب نیست!","0","1","","review","0","0"),
("11","932","لیلا","stuart@woothemes.com","","82.32.109.140","2013-06-07 13:02:14","2013-06-07 09:32:14","ممنون.","0","1","","review","0","0"),
("12","933","سالار","bester.c@gmail.com","","196.215.9.147","2013-06-07 11:54:32","2013-06-07 08:24:32","قیمتش مناسبه","0","1","","review","0","0"),
("13","935","نیما","stuart@woothemes.com","","82.32.109.140","2013-06-07 13:01:25","2013-06-07 09:31:25","مطالب مشابه بیشتر بزارید.","0","1","","review","0","0"),
("14","935","میلاد","maria@woothemes.com","","24.225.103.32","2013-06-07 15:49:53","2013-06-07 12:19:53","لطفا موجود کنید.","0","1","","review","0","0"),
("15","936","اصغر","stuart@woothemes.com","","82.32.109.140","2013-06-07 13:03:29","2013-06-07 09:33:29","خیلی عالیه.","0","1","","review","0","0"),
("16","936","آرمان","ryan@woothemes.com","","99.153.225.252","2013-06-07 13:24:52","2013-06-07 09:54:52","خوبه اما گرونه","0","1","","review","0","0"),
("17","936","سینا","maria@woothemes.com","","24.225.103.32","2013-06-07 15:53:31","2013-06-07 12:23:31","بی نظیره!","0","1","","review","0","0"),
("18","937","جعفر","james@jameskoster.co.uk","","86.146.141.82","2013-06-07 11:46:52","2013-06-07 08:16:52","جرف نداره","0","1","","review","0","0"),
("19","937","رضا","bester.c@gmail.com","","196.215.9.147","2013-06-07 11:53:13","2013-06-07 08:23:13","عالیه!","0","1","","review","0","0"),
("20","937","فرهاد","magnus@woothemes.com","","79.161.106.35","2013-06-07 12:04:03","2013-06-07 08:34:03","خیلی خوبه!","0","1","","review","0","0"),
("21","938","آرش","andrew@chromeorange.co.uk","","86.19.152.140","2013-06-07 11:54:51","2013-06-07 08:24:51","راضی نبودم","0","1","","review","0","0"),
("22","938","وحید","maria@woothemes.com","","24.225.103.32","2013-06-07 15:50:22","2013-06-07 12:20:22","کیفیتش عالیع","0","1","","review","0","0"),
("23","939","میهمان","student@woothemes.com","","196.215.9.147","2013-06-07 12:14:53","2013-06-07 08:44:53","عالیه!","0","1","","review","0","0"),
("24","939","کیا","coen@woothemes.com","","84.39.28.254","2013-06-07 12:20:56","2013-06-07 08:50:56","عالی!","0","1","","review","0","0"),
("25","939","نوید","dan@woothemes.com","","188.221.1.167","2013-06-07 12:41:42","2013-06-07 09:11:42","دمتون گرم.","0","1","","review","0","0"),
("26","939","محسن","ryan@woothemes.com","","99.153.225.252","2013-06-07 13:26:40","2013-06-07 09:56:40","ارزش قیمتش رو نداره","0","1","","review","0","0"),
("27","939","بهنام","maria@woothemes.com","","24.225.103.32","2013-06-07 15:53:56","2013-06-07 12:23:56","خوب نبود","0","1","","review","0","0"),
("28","939","Gerhard","gerhard@woothemes.com","","72.251.244.9","2013-06-08 09:37:42","2013-06-08 09:37:42","The best hoodie ever!","0","","","review","0","0"),
("29","942","مجید","bester.c@gmail.com","","196.215.9.147","2013-06-07 11:52:25","2013-06-07 08:22:25","راضی کننده نبود","0","1","","review","0","0"),
("30","942","احمد","andrew@chromeorange.co.uk","","86.19.152.140","2013-06-07 11:56:36","2013-06-07 08:26:36","خوب نیست","0","1","","review","0","0"),
("31","942","سپهر","coen@woothemes.com","","84.39.28.254","2013-06-07 12:19:25","2013-06-07 08:49:25","فوق العاده بود.","0","1","","review","0","0"),
("32","942","سامان","stuart@woothemes.com","","82.32.109.140","2013-06-07 12:59:49","2013-06-07 09:29:49","مطلب خوبی بود.","0","1","","review","0","0"),
("33","943","داوود","dan@woothemes.com","","188.221.1.167","2013-06-07 12:39:04","2013-06-07 09:09:04","خیلی خوب بود ممنون","0","1","","review","0","0"),
("34","943","شایان","maria@woothemes.com","","24.225.103.32","2013-06-07 15:55:29","2013-06-07 12:25:29","نمی ارزه!","0","1","","review","0","0"),
("36","4502","ووکامرس","","","","2019-03-11 15:53:46","2019-03-11 12:23:46","در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>ارسال api الزامی می باشد","0","1","WooCommerce","order_note","0","0"),
("37","4502","ووکامرس","","","","2019-03-11 18:25:53","2019-03-11 14:55:53","سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.","0","1","WooCommerce","order_note","0","0");

INSERT IGNORE INTO `wp_duplicator_pro_entities` VALUES 
("1","DUP_PRO_Global_Entity","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": null,\n    \"crypt\": true,\n    \"wpfront_integrate\": 0,\n    \"package_ui_created\": 1,\n    \"package_mysqldump\": 0,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": null,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 6,\n    \"homepath_as_abspath\": false,\n    \"archive_build_mode_schedule\": -1,\n    \"archive_compression_schedule\": true,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 180,\n    \"php_max_worker_time_in_sec\": \"9999999\",\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"json_mode\": 0,\n    \"ajax_protocol\": \"admin\",\n    \"custom_ajax_url\": \"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": 0,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": \"2048\",\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": null,\n    \"dropbox_upload_chunksize_in_kb\": 2000,\n    \"dropbox_transfer_mode\": 1,\n    \"gdrive_upload_chunksize_in_kb\": 2000,\n    \"gdrive_transfer_mode\": 0,\n    \"s3_upload_part_size_in_kb\": 6000,\n    \"onedrive_upload_chunksize_in_kb\": 3200,\n    \"local_upload_chunksize_in_MB\": 16,\n    \"manual_mode_storage_ids\": [\n        \"-2\"\n    ],\n    \"license_status\": 0,\n    \"license_expiration_time\": 1692623307,\n    \"license_no_activations_left\": false,\n    \"license_key_visible\": 1,\n    \"lkp\": \"\",\n    \"license_limit\": -1,\n    \"last_edd_api_response\": null,\n    \"last_edd_api_timestamp\": 0,\n    \"last_system_check_timestamp\": 1720263752,\n    \"initial_activation_timestamp\": 1502310360,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": null,\n    \"debug_on\": 1,\n    \"unhook_third_party_js\": null,\n    \"unhook_third_party_css\": null,\n    \"profile_idea\": null,\n    \"profile_beta\": null,\n    \"dupHidePackagesGiftFeatures\": true,\n    \"id\": 1\n}"),
("2","DUP_PRO_Secure_Global_Entity","{\n    \"basic_auth_password\": \"\",\n    \"lkp\": \"\",\n    \"id\": 2\n}"),
("3","DUP_PRO_System_Global_Entity","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1720264537,\n    \"id\": 3\n}"),
("4","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"Default\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": [],\n    \"installer_opts_secure_on\": null,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"fEZbRpn4KnsxEn0lYqwkaNtiSAJyGGh5AsH2v7U5oJhF6S9IG3uTrfXzL3LE3RZBsbagnKJPXyLGg\\/3WBX76kA==\",\n    \"installer_opts_skip_scan\": null,\n    \"installer_opts_db_host\": null,\n    \"installer_opts_db_name\": null,\n    \"installer_opts_db_user\": null,\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"type\": \"DUP_PRO_Package_Template_Entity\",\n    \"installer_opts_cache_wp\": null,\n    \"installer_opts_cache_path\": null\n}"),
("5","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 1,\n    \"archive_filter_dirs\": \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/cache;\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/maintenance;\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/.wp-cli;\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/perfmatters\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/maintenance.php;\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/error_log\",\n    \"archive_filter_names\": true,\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"C1S69iwb1jGveRggNmFYNLkXA094uq\\/EkesUyAkix1oDk+fn2br1tSrHs85DvAsWqi0qu7EKv3Oq3VwSFNnPdw==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"id\": 5\n}");

INSERT IGNORE INTO `wp_duplicator_pro_packages` VALUES 
("25","20240706_ingenious","b802e2b5201829135345_20240706111316","20","2024-07-06 14:45:24","admin","{\n    \"ID\": 25,\n    \"Created\": \"2024-07-06 11:13:16\",\n    \"Version\": \"4.5.9\",\n    \"VersionWP\": \"6.5.5\",\n    \"VersionDB\": \"8.0.33\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240706_ingenious\",\n    \"Hash\": \"b802e2b5201829135345_20240706111316\",\n    \"NameHash\": \"20240706_ingenious_b802e2b5201829135345_20240706111316\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240706_ingenious_b802e2b5201829135345_20240706111316_scan.json\",\n    \"timer_start\": 1720264538.5409319400787353515625,\n    \"Runtime\": 0,\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/cache;\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/maintenance;\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/.wp-cli;\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/perfmatters\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/maintenance.php;\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/error_log\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/.opcache\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/.tmb\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/.wp-cli\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/bps-backup\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/cache\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/cache\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/maintenance\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/old-cache\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/perfmatters\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/updraft\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/wfcache\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/.htaccess\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/.user.ini\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/error_log\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/php.ini\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/web.config\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-config.php\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/maintenance.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 1,\n        \"FilterNames\": true,\n        \"File\": \"20240706_ingenious_b802e2b5201829135345_20240706111316_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\",\n        \"Size\": 415595536,\n        \"Dirs\": null,\n        \"DirCount\": 2340,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 17894,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"Warning\": [],\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [\n                    \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/.wp-cli\",\n                    \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/cache\",\n                    \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/maintenance\",\n                    \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/perfmatters\"\n                ],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Warning\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [\n                    \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/error_log\",\n                    \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/maintenance.php\"\n                ],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null,\n            \"TreeWarning\": null\n        },\n        \"ListDelimiter\": \"\\n\",\n        \"throttleDelayInUs\": 0\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240706_ingenious_b802e2b5201829135345_20240706111316_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"vgbUWzGaSRwoJKwEb3TP7PzmCR7tj6nr67NGaE1Sbi+wSfRAwaCSl7j5aU1IfMiYEQ1zmIQWZzgXTQeqlZJ6DA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb3_persian_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\",\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"parsthem_ingenious2\",\n            \"tablesBaseCount\": 78,\n            \"tablesFinalCount\": 78,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 5607,\n            \"tablesSizeOnDisk\": 10190160,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": 34,\n                    \"insertedRows\": false,\n                    \"size\": 35840\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 3086\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": false,\n                    \"size\": 9456\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": 100,\n                    \"insertedRows\": false,\n                    \"size\": 24040\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": 138,\n                    \"insertedRows\": false,\n                    \"size\": 30936\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": 35,\n                    \"insertedRows\": false,\n                    \"size\": 12236\n                },\n                \"wp_cwssvgi\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": false,\n                    \"size\": 12316\n                },\n                \"wp_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": 709,\n                    \"insertedRows\": false,\n                    \"size\": 1206208\n                },\n                \"wp_post_views\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": 3152,\n                    \"insertedRows\": false,\n                    \"size\": 1093552\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": 546,\n                    \"insertedRows\": false,\n                    \"size\": 1338744\n                },\n                \"wp_revslider_css\": {\n                    \"inaccurateRows\": 109,\n                    \"insertedRows\": false,\n                    \"size\": 100400\n                },\n                \"wp_revslider_css_bkp\": {\n                    \"inaccurateRows\": 109,\n                    \"insertedRows\": false,\n                    \"size\": 95280\n                },\n                \"wp_revslider_layer_animations\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_revslider_layer_animations_bkp\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_revslider_navigations\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_revslider_navigations_bkp\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_revslider_sliders\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": false,\n                    \"size\": 63288\n                },\n                \"wp_revslider_sliders_bkp\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": false,\n                    \"size\": 81716\n                },\n                \"wp_revslider_slides\": {\n                    \"inaccurateRows\": 18,\n                    \"insertedRows\": false,\n                    \"size\": 2430032\n                },\n                \"wp_revslider_slides_bkp\": {\n                    \"inaccurateRows\": 19,\n                    \"insertedRows\": false,\n                    \"size\": 2732104\n                },\n                \"wp_revslider_static_slides\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": false,\n                    \"size\": 3856\n                },\n                \"wp_revslider_static_slides_bkp\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 2168\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": 172,\n                    \"insertedRows\": false,\n                    \"size\": 13852\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": 63,\n                    \"insertedRows\": false,\n                    \"size\": 8808\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": false,\n                    \"size\": 10460\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": 63,\n                    \"insertedRows\": false,\n                    \"size\": 17048\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": 67,\n                    \"insertedRows\": false,\n                    \"size\": 15360\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 8292\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": 118,\n                    \"insertedRows\": false,\n                    \"size\": 26192\n                },\n                \"wp_wc_admin_notes\": {\n                    \"inaccurateRows\": 75,\n                    \"insertedRows\": false,\n                    \"size\": 35988\n                },\n                \"wp_wc_category_lookup\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 2082\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 2048\n                },\n                \"wp_wc_download_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_wc_order_addresses\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_wc_order_stats\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_wc_orders\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 131072\n                },\n                \"wp_wc_orders_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": 16,\n                    \"insertedRows\": false,\n                    \"size\": 11064\n                },\n                \"wp_wc_rate_limits\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": false,\n                    \"size\": 9424\n                },\n                \"wp_wc_webhooks\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 2048\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_woocommerce_ir\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_woocommerce_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": false,\n                    \"size\": 10640\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 3128\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 82084\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_wpgmza\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_admin_notices\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_categories\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_category_maps\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_circles\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_image_overlays\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_maps\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_point_labels\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_polygon\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_polylines\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_rectangles\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                }\n            },\n            \"varLowerCaseTables\": \"0\",\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.33\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20240706_ingenious_b802e2b5201829135345_20240706111316_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/backups-dup-pro\\/tmp\\/20240706_ingenious_b802e2b5201829135345_20240706111316_database.sql\"\n    },\n    \"Status\": \"20.0\",\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 1720264542,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wp_users\",\n            \"wp_usermeta\",\n            \"wp_actionscheduler_actions\",\n            \"wp_actionscheduler_claims\",\n            \"wp_actionscheduler_groups\",\n            \"wp_actionscheduler_logs\",\n            \"wp_commentmeta\",\n            \"wp_comments\",\n            \"wp_cwssvgi\",\n            \"wp_duplicator_pro_entities\",\n            \"wp_duplicator_pro_packages\",\n            \"wp_links\",\n            \"wp_options\",\n            \"wp_post_views\",\n            \"wp_postmeta\",\n            \"wp_posts\",\n            \"wp_revslider_css\",\n            \"wp_revslider_css_bkp\",\n            \"wp_revslider_layer_animations\",\n            \"wp_revslider_layer_animations_bkp\",\n            \"wp_revslider_navigations\",\n            \"wp_revslider_navigations_bkp\",\n            \"wp_revslider_sliders\",\n            \"wp_revslider_sliders_bkp\",\n            \"wp_revslider_slides\",\n            \"wp_revslider_slides_bkp\",\n            \"wp_revslider_static_slides\",\n            \"wp_revslider_static_slides_bkp\",\n            \"wp_term_relationships\",\n            \"wp_term_taxonomy\",\n            \"wp_termmeta\",\n            \"wp_terms\",\n            \"wp_wc_admin_note_actions\",\n            \"wp_wc_admin_notes\",\n            \"wp_wc_category_lookup\",\n            \"wp_wc_customer_lookup\",\n            \"wp_wc_download_log\",\n            \"wp_wc_order_addresses\",\n            \"wp_wc_order_coupon_lookup\",\n            \"wp_wc_order_operational_data\",\n            \"wp_wc_order_product_lookup\",\n            \"wp_wc_order_stats\",\n            \"wp_wc_order_tax_lookup\",\n            \"wp_wc_orders\",\n            \"wp_wc_orders_meta\",\n            \"wp_wc_product_attributes_lookup\",\n            \"wp_wc_product_download_directories\",\n            \"wp_wc_product_meta_lookup\",\n            \"wp_wc_rate_limits\",\n            \"wp_wc_reserved_stock\",\n            \"wp_wc_tax_rate_classes\",\n            \"wp_wc_webhooks\",\n            \"wp_woocommerce_api_keys\",\n            \"wp_woocommerce_attribute_taxonomies\",\n            \"wp_woocommerce_downloadable_product_permissions\",\n            \"wp_woocommerce_ir\",\n            \"wp_woocommerce_log\",\n            \"wp_woocommerce_order_itemmeta\",\n            \"wp_woocommerce_order_items\",\n            \"wp_woocommerce_payment_tokenmeta\",\n            \"wp_woocommerce_payment_tokens\",\n            \"wp_woocommerce_sessions\",\n            \"wp_woocommerce_shipping_zone_locations\",\n            \"wp_woocommerce_shipping_zone_methods\",\n            \"wp_woocommerce_shipping_zones\",\n            \"wp_woocommerce_tax_rate_locations\",\n            \"wp_woocommerce_tax_rates\",\n            \"wp_wpgmza\",\n            \"wp_wpgmza_admin_notices\",\n            \"wp_wpgmza_categories\",\n            \"wp_wpgmza_category_maps\",\n            \"wp_wpgmza_circles\",\n            \"wp_wpgmza_image_overlays\",\n            \"wp_wpgmza_maps\",\n            \"wp_wpgmza_point_labels\",\n            \"wp_wpgmza_polygon\",\n            \"wp_wpgmza_polylines\",\n            \"wp_wpgmza_rectangles\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1720264538.5647599697113037109375,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 5607,\n            \"tables\": {\n                \"wp_users\": {\n                    \"start\": \"1\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_cwssvgi\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_pro_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_pro_packages\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_post_views\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_css\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_css_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_layer_animations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_layer_animations_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_navigations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_navigations_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_sliders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_sliders_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_slides\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_slides_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_static_slides\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_static_slides_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_admin_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_category_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_download_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_addresses\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_stats\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_orders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_orders_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_rate_limits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_webhooks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_ir\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza_admin_notices\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza_categories\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza_category_maps\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza_circles\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza_image_overlays\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza_maps\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza_point_labels\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza_polygon\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza_polylines\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza_rectangles\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"-2\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 5\n}");

INSERT IGNORE INTO `wp_options` VALUES 
("1","siteurl","https://rtl.pars-themes.com/ingenious","yes"),
("2","home","https://rtl.pars-themes.com/ingenious","yes"),
("3","blogname","سایت","yes"),
("4","blogdescription","یک سایت دیگر با وردپرس فارسی","yes"),
("5","users_can_register","0","yes"),
("6","admin_email","sup@pars-themes.com","yes"),
("7","start_of_week","6","yes"),
("8","use_balanceTags","0","yes"),
("9","use_smilies","1","yes"),
("10","require_name_email","1","yes"),
("11","comments_notify","","yes"),
("12","posts_per_rss","10","yes"),
("13","rss_use_excerpt","0","yes"),
("14","mailserver_url","mail.example.com","yes"),
("15","mailserver_login","login@example.com","yes"),
("16","mailserver_pass","password","yes"),
("17","mailserver_port","110","yes"),
("18","default_category","1","yes"),
("19","default_comment_status","open","yes"),
("20","default_ping_status","","yes"),
("21","default_pingback_flag","","yes"),
("22","posts_per_page","10","yes"),
("23","date_format","F j, Y","yes"),
("24","time_format","g:i a","yes"),
("25","links_updated_date_format","F j, Y g:i a","yes"),
("26","comment_moderation","1","yes"),
("27","moderation_notify","","yes"),
("28","permalink_structure","/%postname%/","yes"),
("29","rewrite_rules","a:298:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:12:\"portfolio/?$\";s:32:\"index.php?post_type=cwsportfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=cwsportfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=cwsportfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=cwsportfolio&paged=$matches[1]\";s:8:\"staff/?$\";s:28:\"index.php?post_type=cwsstaff\";s:38:\"staff/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=cwsstaff&feed=$matches[1]\";s:33:\"staff/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=cwsstaff&feed=$matches[1]\";s:25:\"staff/page/([0-9]{1,})/?$\";s:46:\"index.php?post_type=cwsstaff&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"megamenu_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"megamenu_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"megamenu_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"megamenu_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"megamenu_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"megamenu_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"megamenu_item/([^/]+)/embed/?$\";s:46:\"index.php?megamenu_item=$matches[1]&embed=true\";s:34:\"megamenu_item/([^/]+)/trackback/?$\";s:40:\"index.php?megamenu_item=$matches[1]&tb=1\";s:42:\"megamenu_item/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?megamenu_item=$matches[1]&paged=$matches[2]\";s:49:\"megamenu_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?megamenu_item=$matches[1]&cpage=$matches[2]\";s:39:\"megamenu_item/([^/]+)/wc-api(/(.*))?/?$\";s:54:\"index.php?megamenu_item=$matches[1]&wc-api=$matches[3]\";s:50:\"megamenu_item/([^/]+)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?megamenu_item=$matches[1]&wc/file/transient=$matches[3]\";s:45:\"megamenu_item/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:56:\"megamenu_item/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:56:\"megamenu_item/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:67:\"megamenu_item/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"megamenu_item/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?megamenu_item=$matches[1]&page=$matches[2]\";s:30:\"megamenu_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"megamenu_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"megamenu_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"megamenu_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"megamenu_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"megamenu_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"portfolio-cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?cwsportfolio-cat=$matches[1]&feed=$matches[2]\";s:49:\"portfolio-cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?cwsportfolio-cat=$matches[1]&feed=$matches[2]\";s:30:\"portfolio-cat/([^/]+)/embed/?$\";s:49:\"index.php?cwsportfolio-cat=$matches[1]&embed=true\";s:42:\"portfolio-cat/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?cwsportfolio-cat=$matches[1]&paged=$matches[2]\";s:24:\"portfolio-cat/([^/]+)/?$\";s:38:\"index.php?cwsportfolio-cat=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:45:\"index.php?cwsportfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:39:\"index.php?cwsportfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?cwsportfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?cwsportfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?cwsportfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?cwsportfolio=$matches[1]&cpage=$matches[2]\";s:35:\"portfolio/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?cwsportfolio=$matches[1]&wc-api=$matches[3]\";s:46:\"portfolio/([^/]+)/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?cwsportfolio=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"portfolio/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?cwsportfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:50:\"staff-cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?cwsstaff_member_department=$matches[1]&feed=$matches[2]\";s:45:\"staff-cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?cwsstaff_member_department=$matches[1]&feed=$matches[2]\";s:26:\"staff-cat/([^/]+)/embed/?$\";s:59:\"index.php?cwsstaff_member_department=$matches[1]&embed=true\";s:38:\"staff-cat/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?cwsstaff_member_department=$matches[1]&paged=$matches[2]\";s:20:\"staff-cat/([^/]+)/?$\";s:48:\"index.php?cwsstaff_member_department=$matches[1]\";s:50:\"staff-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?cwsstaff_member_position=$matches[1]&feed=$matches[2]\";s:45:\"staff-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?cwsstaff_member_position=$matches[1]&feed=$matches[2]\";s:26:\"staff-tag/([^/]+)/embed/?$\";s:57:\"index.php?cwsstaff_member_position=$matches[1]&embed=true\";s:38:\"staff-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:64:\"index.php?cwsstaff_member_position=$matches[1]&paged=$matches[2]\";s:20:\"staff-tag/([^/]+)/?$\";s:46:\"index.php?cwsstaff_member_position=$matches[1]\";s:33:\"staff/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"staff/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"staff/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"staff/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"staff/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"staff/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"staff/([^/]+)/embed/?$\";s:41:\"index.php?cwsstaff=$matches[1]&embed=true\";s:26:\"staff/([^/]+)/trackback/?$\";s:35:\"index.php?cwsstaff=$matches[1]&tb=1\";s:46:\"staff/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?cwsstaff=$matches[1]&feed=$matches[2]\";s:41:\"staff/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?cwsstaff=$matches[1]&feed=$matches[2]\";s:34:\"staff/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?cwsstaff=$matches[1]&paged=$matches[2]\";s:41:\"staff/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?cwsstaff=$matches[1]&cpage=$matches[2]\";s:31:\"staff/([^/]+)/wc-api(/(.*))?/?$\";s:49:\"index.php?cwsstaff=$matches[1]&wc-api=$matches[3]\";s:42:\"staff/([^/]+)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?cwsstaff=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"staff/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:48:\"staff/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:48:\"staff/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:59:\"staff/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:30:\"staff/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?cwsstaff=$matches[1]&page=$matches[2]\";s:22:\"staff/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"staff/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"staff/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"staff/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"staff/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"staff/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:38:\"vc_grid_item/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?vc_grid_item=$matches[1]&wc-api=$matches[3]\";s:49:\"vc_grid_item/([^/]+)/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?vc_grid_item=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"vc_grid_item/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"vc_grid_item/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"vc_grid_item/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:66:\"vc_grid_item/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=178&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes"),
("30","hack_file","0","yes"),
("31","blog_charset","UTF-8","yes"),
("32","moderation_keys","","no"),
("33","active_plugins","a:16:{i:0;s:19:\"akismet/akismet.php\";i:1;s:35:\"classic-widgets/classic-widgets.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";i:3;s:31:\"cws-flaticons/cws-flaticons.php\";i:4;s:29:\"cws-megamenu/cws-megamenu.php\";i:5;s:43:\"cws-portfolio-staff/cws-portfolio-staff.php\";i:6;s:29:\"cws-svgicons/cws-svgicons.php\";i:7;s:17:\"cws-to/cws-to.php\";i:8;s:33:\"duplicator-pro/duplicator-pro.php\";i:9;s:45:\"ingenious-shortcodes/ingenious-shortcodes.php\";i:10;s:27:\"js_composer/js_composer.php\";i:11;s:43:\"persian-woocommerce/woocommerce-persian.php\";i:12;s:23:\"revslider/revslider.php\";i:13;s:27:\"woocommerce/woocommerce.php\";i:14;s:31:\"wp-google-maps/wpGoogleMaps.php\";i:15;s:29:\"wp-parsidate/wp-parsidate.php\";}","yes"),
("34","category_base","","yes"),
("35","ping_sites","http://rpc.pingomatic.com/","yes"),
("36","comment_max_links","2","yes"),
("37","gmt_offset","","yes"),
("38","default_email_category","1","yes"),
("39","recently_edited","a:5:{i:0;s:86:\"/home/parsthem/rtl.pars-themes.com/ingenious/wp-content/themes/ingenious/functions.php\";i:1;s:82:\"/home/parsthem/rtl.pars-themes.com/ingenious/wp-content/themes/ingenious/style.css\";i:3;s:86:\"/home/demodsco/rtl.pars-themes.com/ingenious/wp-content/themes/ingenious/functions.php\";i:4;s:82:\"/home/demodsco/rtl.pars-themes.com/ingenious/wp-content/themes/ingenious/style.css\";i:5;s:80:\"/home/demodsco/rtl.pars-themes.com/ingenious/wp-content/themes/ingenious/rtl.css\";}","no"),
("40","template","ingenious","yes"),
("41","stylesheet","ingenious","yes"),
("44","comment_registration","","yes"),
("45","html_type","text/html","yes"),
("46","use_trackback","0","yes"),
("47","default_role","subscriber","yes"),
("48","db_version","57155","yes"),
("49","uploads_use_yearmonth_folders","1","yes"),
("50","upload_path","","yes"),
("51","blog_public","1","yes"),
("52","default_link_category","2","yes"),
("53","show_on_front","page","yes"),
("54","tag_base","","yes"),
("55","show_avatars","1","yes"),
("56","avatar_rating","G","yes"),
("57","upload_url_path","","yes"),
("58","thumbnail_size_w","150","yes"),
("59","thumbnail_size_h","150","yes"),
("60","thumbnail_crop","1","yes"),
("61","medium_size_w","300","yes"),
("62","medium_size_h","300","yes"),
("63","avatar_default","mystery","yes"),
("64","large_size_w","1024","yes"),
("65","large_size_h","1024","yes"),
("66","image_default_link_type","none","yes"),
("67","image_default_size","","yes"),
("68","image_default_align","","yes"),
("69","close_comments_for_old_posts","","yes"),
("70","close_comments_days_old","14","yes"),
("71","thread_comments","1","yes"),
("72","thread_comments_depth","5","yes"),
("73","page_comments","","yes"),
("74","comments_per_page","50","yes"),
("75","default_comments_page","newest","yes"),
("76","comment_order","asc","yes"),
("77","sticky_posts","a:0:{}","yes"),
("81","uninstall_plugins","a:3:{s:33:\"duplicator-pro/duplicator-pro.php\";a:2:{i:0;s:24:\"Duplicator\\Core\\Unistall\";i:1;s:8:\"unistall\";}s:27:\"perfmatters/perfmatters.php\";s:21:\"perfmatters_uninstall\";s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";}","no"),
("82","timezone_string","Asia/Tehran","yes"),
("83","page_for_posts","0","yes"),
("85","default_post_format","0","yes"),
("86","link_manager_enabled","0","yes"),
("87","finished_splitting_shared_terms","1","yes"),
("88","site_icon","0","yes"),
("89","medium_large_size_w","768","yes"),
("90","medium_large_size_h","0","yes"),
("91","initial_db_version","38590","yes"),
("92","wp_user_roles","a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:146:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;s:10:\"loco_admin\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:40:\"vc_access_rules_post_types/megamenu_item\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:31:\"vc_access_rules_unfiltered_html\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:24:\"vc_access_rules_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:44:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:31:\"vc_access_rules_unfiltered_html\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:20:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:31:\"vc_access_rules_unfiltered_html\";b:0;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:15:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:0;s:31:\"vc_access_rules_frontend_editor\";b:0;s:31:\"vc_access_rules_unfiltered_html\";b:0;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:0;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:10:\"translator\";a:2:{s:4:\"name\";s:10:\"Translator\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:10:\"loco_admin\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:102:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:0;s:31:\"vc_access_rules_frontend_editor\";b:0;s:31:\"vc_access_rules_unfiltered_html\";b:0;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:0;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}}","yes"),
("93","fresh_site","0","yes"),
("94","WPLANG","fa_IR","yes"),
("108","cron","a:26:{i:1720264587;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1720265400;a:1:{s:20:\"imagify_rating_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1720266741;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1720266981;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1720267214;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1720267329;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1720267357;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1720267989;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1720270164;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1720270825;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1720274181;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1720284981;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1720291704;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1720292527;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1720295664;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1720296117;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1720296416;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1720299600;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1720305000;a:1:{s:18:\"imagify_sync_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1720339202;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1720349152;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1720349791;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1720485000;a:1:{s:46:\"imagify_update_library_size_calculations_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1720611173;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1721559441;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}","yes"),
("109","theme_mods_twentyseventeen","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1520686721;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}","no"),
("128","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:19:\"sup@pars-themes.com\";s:7:\"version\";s:5:\"6.4.5\";s:9:\"timestamp\";i:1719307573;}","no"),
("145","recently_activated","a:1:{s:35:\"litespeed-cache/litespeed-cache.php\";i:1720261557;}","yes"),
("151","ztjalali_options","{\"force_timezone\":false,\"change_date_to_jalali\":true,\"change_jdate_number_to_persian\":true,\"change_url_date_to_jalali\":false,\"afghan_month_name\":false,\"disallow_month_short_name\":true,\"change_title_number_to_persian\":true,\"change_content_number_to_persian\":true,\"change_excerpt_number_to_persian\":true,\"change_comment_number_to_persian\":true,\"change_commentcount_number_to_persian\":true,\"change_category_number_to_persian\":true,\"change_point_to_persian\":true,\"change_arabic_to_persian\":true,\"change_archive_title\":true,\"save_changes_in_db\":true,\"ztjalali_admin_style\":false,\"persian_planet\":false}","yes"),
("152","ztjalali_version","5.0.1","yes"),
("154","widget_ztjalali_archive","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("155","widget_ztjalali_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("156","wpcf7","a:2:{s:7:\"version\";s:5:\"5.9.6\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";d:1502322384;s:7:\"version\";s:3:\"4.8\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}","yes"),
("157","post_views_counter_settings_general","a:12:{s:16:\"post_types_count\";a:1:{i:0;s:4:\"post\";}s:12:\"counter_mode\";s:3:\"php\";s:17:\"post_views_column\";b:1;s:19:\"time_between_counts\";a:2:{s:6:\"number\";i:24;s:4:\"type\";s:5:\"hours\";}s:12:\"reset_counts\";a:2:{s:6:\"number\";i:30;s:4:\"type\";s:4:\"days\";}s:14:\"flush_interval\";a:2:{s:6:\"number\";i:0;s:4:\"type\";s:7:\"minutes\";}s:7:\"exclude\";a:2:{s:6:\"groups\";a:0:{}s:5:\"roles\";a:0:{}}s:11:\"exclude_ips\";a:0:{}s:19:\"restrict_edit_views\";b:0;s:19:\"deactivation_delete\";b:0;s:8:\"cron_run\";b:1;s:11:\"cron_update\";b:0;}","no"),
("158","post_views_counter_settings_display","a:8:{s:5:\"label\";s:11:\"Post Views:\";s:18:\"post_types_display\";a:1:{i:0;s:4:\"post\";}s:18:\"page_types_display\";a:1:{i:0;s:8:\"singular\";}s:16:\"restrict_display\";a:2:{s:6:\"groups\";a:0:{}s:5:\"roles\";a:0:{}}s:8:\"position\";s:5:\"after\";s:13:\"display_style\";a:2:{s:4:\"icon\";b:1;s:4:\"text\";b:1;}s:12:\"link_to_post\";b:1;s:10:\"icon_class\";s:19:\"dashicons-chart-bar\";}","no"),
("159","post_views_counter_version","1.2.7","no"),
("160","woocommerce_default_country","IR:THR","yes"),
("161","woocommerce_allowed_countries","specific","yes"),
("162","woocommerce_all_except_countries","a:0:{}","yes"),
("163","woocommerce_specific_allowed_countries","a:1:{i:0;s:2:\"IR\";}","yes"),
("164","woocommerce_ship_to_countries","disabled","yes"),
("165","woocommerce_specific_ship_to_countries","a:0:{}","yes"),
("166","woocommerce_default_customer_address","geolocation","yes"),
("167","woocommerce_calc_taxes","no","yes"),
("168","woocommerce_demo_store","no","yes"),
("169","woocommerce_demo_store_notice","This is a demo store for testing purposes &mdash; no orders shall be fulfilled.","no"),
("170","woocommerce_currency","IRT","yes"),
("171","woocommerce_currency_pos","right_space","yes"),
("172","woocommerce_price_thousand_sep","","yes"),
("173","woocommerce_price_decimal_sep",".","yes"),
("174","woocommerce_price_num_decimals","0","yes"),
("175","woocommerce_weight_unit","kg","yes"),
("176","woocommerce_dimension_unit","cm","yes"),
("177","woocommerce_enable_review_rating","yes","yes"),
("178","woocommerce_review_rating_required","yes","no"),
("179","woocommerce_review_rating_verification_label","yes","no"),
("180","woocommerce_review_rating_verification_required","no","no"),
("181","woocommerce_shop_page_id","6","yes"),
("182","woocommerce_shop_page_display","","yes"),
("183","woocommerce_category_archive_display","","yes"),
("184","woocommerce_default_catalog_orderby","menu_order","yes"),
("185","woocommerce_cart_redirect_after_add","no","yes"),
("186","woocommerce_enable_ajax_add_to_cart","yes","yes"),
("187","shop_catalog_image_size","a:3:{s:5:\"width\";i:400;s:6:\"height\";i:400;s:4:\"crop\";i:1;}","yes"),
("188","shop_single_image_size","a:3:{s:5:\"width\";i:430;s:6:\"height\";i:430;s:4:\"crop\";i:1;}","yes"),
("189","shop_thumbnail_image_size","a:3:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"crop\";i:1;}","yes"),
("190","woocommerce_enable_lightbox","yes","yes"),
("191","woocommerce_manage_stock","yes","yes"),
("192","woocommerce_hold_stock_minutes","60","no"),
("193","woocommerce_notify_low_stock","yes","no"),
("194","woocommerce_notify_no_stock","yes","no"),
("195","woocommerce_stock_email_recipient","info@designertheme.ir","no"),
("196","woocommerce_notify_low_stock_amount","2","no"),
("197","woocommerce_notify_no_stock_amount","0","yes"),
("198","woocommerce_hide_out_of_stock_items","no","yes"),
("199","woocommerce_stock_format","","yes"),
("200","woocommerce_file_download_method","force","no"),
("201","woocommerce_downloads_require_login","no","no"),
("202","woocommerce_downloads_grant_access_after_payment","yes","no"),
("203","woocommerce_prices_include_tax","no","yes"),
("204","woocommerce_tax_based_on","shipping","yes"),
("205","woocommerce_shipping_tax_class","inherit","yes"),
("206","woocommerce_tax_round_at_subtotal","no","yes"),
("208","woocommerce_tax_display_shop","excl","yes"),
("209","woocommerce_tax_display_cart","excl","no"),
("210","woocommerce_price_display_suffix","","yes"),
("211","woocommerce_tax_total_display","itemized","no"),
("212","woocommerce_enable_shipping_calc","yes","no"),
("213","woocommerce_shipping_cost_requires_address","no","no"),
("214","woocommerce_ship_to_destination","billing","no"),
("215","woocommerce_enable_coupons","yes","yes"),
("216","woocommerce_calc_discounts_sequentially","no","no"),
("217","woocommerce_enable_guest_checkout","yes","no"),
("218","woocommerce_force_ssl_checkout","no","yes"),
("219","woocommerce_unforce_ssl_checkout","no","yes"),
("220","woocommerce_cart_page_id","7","yes"),
("221","woocommerce_checkout_page_id","975","yes"),
("222","woocommerce_terms_page_id","2","no"),
("223","woocommerce_checkout_pay_endpoint","order-pay","yes"),
("224","woocommerce_checkout_order_received_endpoint","order-received","yes"),
("225","woocommerce_myaccount_add_payment_method_endpoint","add-payment-method","yes"),
("226","woocommerce_myaccount_delete_payment_method_endpoint","delete-payment-method","yes"),
("227","woocommerce_myaccount_set_default_payment_method_endpoint","set-default-payment-method","yes"),
("228","woocommerce_myaccount_page_id","9","yes"),
("229","woocommerce_enable_signup_and_login_from_checkout","yes","no"),
("230","woocommerce_enable_myaccount_registration","yes","no"),
("231","woocommerce_enable_checkout_login_reminder","yes","no"),
("232","woocommerce_registration_generate_username","yes","no"),
("233","woocommerce_registration_generate_password","no","no"),
("234","woocommerce_myaccount_orders_endpoint","orders","yes"),
("235","woocommerce_myaccount_view_order_endpoint","view-order","yes"),
("236","woocommerce_myaccount_downloads_endpoint","downloads","yes"),
("237","woocommerce_myaccount_edit_account_endpoint","edit-account","yes"),
("238","woocommerce_myaccount_edit_address_endpoint","edit-address","yes"),
("239","woocommerce_myaccount_payment_methods_endpoint","payment-methods","yes"),
("240","woocommerce_myaccount_lost_password_endpoint","lost-password","yes"),
("241","woocommerce_logout_endpoint","customer-logout","yes"),
("242","woocommerce_email_from_name","سایت","no"),
("243","woocommerce_email_from_address","info@designertheme.ir","no"),
("244","woocommerce_email_header_image","","no"),
("245","woocommerce_email_footer_text","سایت - Powered by WooCommerce","no"),
("246","woocommerce_email_base_color","#557da1","no"),
("247","woocommerce_email_background_color","#f5f5f5","no"),
("248","woocommerce_email_body_background_color","#fdfdfd","no"),
("249","woocommerce_email_text_color","#505050","no"),
("250","woocommerce_api_enabled","no","yes"),
("256","woosidebars-version","1.4.3","yes"),
("257","woocommerce_admin_notices","a:1:{i:0;s:6:\"update\";}","yes"),
("261","widget_akismet_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("262","widget_post_views_counter_list_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("277","visualizer_install","1502309786","yes"),
("281","woocommerce_meta_box_errors","a:0:{}","yes"),
("320","woocommerce_gateway_order","a:5:{s:4:\"bacs\";i:0;s:6:\"cheque\";i:1;s:3:\"cod\";i:2;s:6:\"paypal\";i:3;s:5:\"payir\";i:4;}","yes"),
("354","current_theme","Ingenious","yes"),
("356","theme_switched","","yes"),
("365","background-color","#ffffff","yes"),
("376","wpgmza_temp_api","AIzaSyDo_fG7DXBOVvdhlrLa-PHREuFDpTklWhY","yes"),
("377","wpgmza_xml_location","home/parsthem/rtl.pars-themes.com/ingenious/wp-content/uploads/wp-google-maps/","yes"),
("378","wpgmza_xml_url","https://rtl.pars-themes.com/ingenious/wp-content/uploads/wp-google-maps/","yes"),
("379","wpgmza_db_version","9.0.40","yes"),
("380","wpgmaps_current_version","8.0.31","yes"),
("381","WPGM_V6_FIRST_TIME","1","yes"),
("384","vc_version","7.0","yes"),
("385","WPGMZA_OTHER_SETTINGS","a:9:{s:27:\"wpgmza_settings_marker_pull\";s:1:\"0\";s:19:\"wpgmza_gdpr_enabled\";i:1;s:18:\"wpgmza_gdpr_notice\";s:421:\"I agree for my personal data, provided via submission through \'User Generated Markers\' to be processed by {COMPANY_NAME}.\r\n		\r\nI agree for my personal data, provided via map API calls, to be processed by the API provider, for the purposes of geocoding (converting addresses to coordinates).\r\n\r\nWhen using the User Generated Marker addon, data will be stored indefinitiely for the following purpose(s): {RETENTION_PURPOSE}\";s:29:\"wpgmza_gdpr_retention_purpose\";s:50:\"presenting the data you have submitted on the map.\";s:26:\"wpgmza_google_maps_api_key\";b:0;s:20:\"user_interface_style\";s:6:\"legacy\";s:26:\"wpgmza_marker_xml_location\";s:78:\"home/parsthem/rtl.pars-themes.com/ingenious/wp-content/uploads/wp-google-maps/\";s:21:\"wpgmza_marker_xml_url\";s:72:\"https://rtl.pars-themes.com/ingenious/wp-content/uploads/wp-google-maps/\";s:15:\"internal_engine\";s:6:\"legacy\";}","yes"),
("388","wpb_js_composer_license_activation_notified","yes","yes"),
("389","revslider_servers","a:3:{i:0;s:22:\"themepunch-ext-c.tools\";i:1;s:22:\"themepunch-ext-a.tools\";i:2;s:22:\"themepunch-ext-b.tools\";}","yes"),
("390","revslider_server_refresh","1719184867","yes"),
("391","revslider-update-check-short","1720261463","yes"),
("392","revslider-templates-check","1720013716","yes"),
("397","revslider-library-check","1719001821","yes"),
("398","rs-library","a:3:{s:4:\"hash\";s:32:\"dae3de1eb57eeeee008b70e9a23844b5\";s:7:\"objects\";a:417:{i:0;a:12:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:1;a:12:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:2;a:12:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:3;a:12:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:4;a:12:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:5;a:12:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:6;a:12:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:7;a:12:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:8;a:12:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:9;a:12:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:10;a:12:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:11;a:12:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:12;a:12:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:13;a:12:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:14;a:12:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:15;a:12:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:16;a:12:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:17;a:12:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:18;a:12:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:19;a:12:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:20;a:12:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:21;a:12:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:22;a:12:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:23;a:12:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:24;a:12:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:25;a:12:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:26;a:12:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:27;a:12:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:28;a:12:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:29;a:12:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:30;a:12:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:31;a:12:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:32;a:12:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:33;a:12:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:34;a:12:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:35;a:12:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:36;a:12:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:37;a:12:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:38;a:12:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:39;a:12:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:40;a:12:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:41;a:12:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:42;a:12:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:43;a:12:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:44;a:12:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:45;a:12:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:46;a:12:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:47;a:12:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:48;a:12:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:49;a:12:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:50;a:12:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:51;a:12:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:52;a:12:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:53;a:12:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:54;a:12:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:55;a:12:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:56;a:12:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:57;a:12:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:58;a:12:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:59;a:12:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:60;a:12:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:61;a:12:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:62;a:12:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:63;a:12:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:64;a:12:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:65;a:12:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:66;a:12:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:67;a:12:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:68;a:12:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:69;a:12:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:70;a:12:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:71;a:12:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:72;a:12:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:73;a:12:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:74;a:12:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:75;a:12:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:76;a:12:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:77;a:12:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:78;a:12:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:79;a:12:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:80;a:12:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:81;a:12:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:82;a:12:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:83;a:12:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:84;a:12:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:85;a:12:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:86;a:12:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:87;a:12:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:88;a:12:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:89;a:12:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:90;a:12:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:91;a:12:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:92;a:12:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:93;a:12:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:94;a:12:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:95;a:12:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:96;a:12:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:97;a:12:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:98;a:12:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:99;a:12:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:100;a:12:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:101;a:12:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:102;a:12:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:103;a:12:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:104;a:12:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:105;a:12:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:106;a:12:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:107;a:12:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:108;a:12:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:109;a:12:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:110;a:12:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:111;a:12:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:112;a:12:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:113;a:12:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:114;a:12:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:115;a:12:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:116;a:12:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:117;a:12:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:118;a:12:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:119;a:12:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:120;a:12:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:121;a:12:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:122;a:12:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:123;a:12:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:124;a:12:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:125;a:12:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:126;a:12:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:127;a:12:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:128;a:12:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:129;a:12:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:130;a:12:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:131;a:12:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:132;a:12:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:133;a:12:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:134;a:12:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:135;a:12:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:136;a:12:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:137;a:12:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:138;a:12:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:139;a:12:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:140;a:12:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:141;a:12:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:142;a:12:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:143;a:12:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:144;a:12:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:145;a:12:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:146;a:12:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:147;a:12:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:148;a:12:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:149;a:12:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:150;a:12:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:151;a:12:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:152;a:12:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:153;a:12:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:154;a:12:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:155;a:12:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:156;a:12:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:157;a:12:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:158;a:12:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:159;a:12:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:160;a:12:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:161;a:12:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:162;a:12:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:163;a:12:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:164;a:12:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:165;a:12:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:166;a:12:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:167;a:12:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:168;a:12:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:169;a:12:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:170;a:12:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:171;a:12:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:172;a:12:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:173;a:12:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:174;a:12:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:175;a:12:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:176;a:12:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:177;a:12:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:178;a:12:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:179;a:12:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:180;a:12:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:181;a:12:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:182;a:12:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:183;a:12:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:184;a:12:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:185;a:12:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:186;a:12:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:187;a:12:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:188;a:12:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:189;a:12:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:190;a:12:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:191;a:12:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:192;a:12:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:193;a:12:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:194;a:12:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:195;a:12:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:196;a:12:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:197;a:12:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:198;a:12:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:199;a:12:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:200;a:12:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:201;a:12:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:202;a:12:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:203;a:12:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:204;a:12:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:205;a:12:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:206;a:12:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:207;a:12:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:208;a:12:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:209;a:12:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:210;a:12:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:211;a:12:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:212;a:12:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:213;a:12:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:214;a:12:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:215;a:12:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:216;a:12:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:217;a:12:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:218;a:12:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:219;a:12:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:220;a:12:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:221;a:12:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:222;a:12:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:223;a:12:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:224;a:12:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:225;a:12:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:226;a:12:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:227;a:12:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:228;a:12:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:229;a:12:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:230;a:12:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:231;a:12:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:232;a:12:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:233;a:12:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:234;a:12:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:235;a:12:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:236;a:12:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:237;a:12:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:238;a:12:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:239;a:12:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:240;a:12:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:241;a:12:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:242;a:12:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:243;a:12:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:244;a:12:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:245;a:12:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:246;a:12:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:247;a:12:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:248;a:12:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:249;a:12:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:250;a:12:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:251;a:12:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:252;a:12:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:253;a:12:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:254;a:12:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:255;a:12:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:256;a:12:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:257;a:12:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:258;a:12:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:259;a:12:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:260;a:12:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:261;a:12:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:262;a:12:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:263;a:12:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:264;a:12:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:265;a:12:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:266;a:12:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:267;a:12:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:268;a:12:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:269;a:12:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:270;a:12:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:271;a:12:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:272;a:12:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:273;a:12:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:274;a:12:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:275;a:12:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:276;a:12:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:277;a:12:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:278;a:12:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:279;a:12:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:280;a:12:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:281;a:12:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:282;a:12:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:283;a:12:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:284;a:12:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:285;a:12:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:286;a:12:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:287;a:12:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:288;a:12:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:289;a:12:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:290;a:12:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:291;a:12:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:292;a:12:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:293;a:12:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:294;a:12:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:295;a:12:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:296;a:12:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:297;a:12:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:298;a:12:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:299;a:12:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:300;a:12:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:301;a:12:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:302;a:12:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:303;a:12:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:304;a:12:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:305;a:12:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:306;a:12:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:307;a:12:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:308;a:12:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:309;a:13:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:310;a:13:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:311;a:13:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:312;a:13:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:313;a:13:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:314;a:13:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:315;a:13:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:316;a:13:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:317;a:13:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:318;a:13:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:319;a:13:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:320;a:13:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:321;a:13:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:322;a:13:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:323;a:13:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:324;a:13:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:325;a:13:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:326;a:13:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:327;a:13:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:328;a:13:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:329;a:13:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:330;a:13:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:331;a:13:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:332;a:13:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:333;a:13:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:334;a:13:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:335;a:13:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:336;a:13:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:337;a:13:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:338;a:13:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:339;a:13:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:340;a:13:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:341;a:13:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:342;a:13:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:343;a:13:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:344;a:13:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:345;a:13:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:346;a:13:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:347;a:13:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:348;a:13:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:349;a:13:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:350;a:13:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:351;a:13:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:352;a:13:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:353;a:13:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:354;a:13:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:355;a:13:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:356;a:13:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:357;a:13:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:358;a:13:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:359;a:13:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:360;a:13:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:361;a:13:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:362;a:13:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:363;a:13:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:364;a:13:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:365;a:13:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:366;a:13:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:367;a:13:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:368;a:13:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:369;a:13:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:370;a:13:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:371;a:13:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:372;a:13:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:373;a:13:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:374;a:13:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:375;a:13:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:376;a:13:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:377;a:13:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:378;a:13:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:379;a:13:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:380;a:13:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:381;a:13:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:382;a:13:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:383;a:13:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:384;a:13:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:385;a:13:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:386;a:13:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:387;a:13:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:388;a:13:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:389;a:13:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:390;a:13:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:391;a:13:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:392;a:13:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:393;a:13:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:394;a:13:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:395;a:13:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:396;a:13:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:397;a:13:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:398;a:13:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:399;a:13:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:400;a:13:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:401;a:13:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:402;a:13:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:403;a:13:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:404;a:13:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:405;a:13:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:406;a:13:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:407;a:13:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:408;a:13:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:409;a:13:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:410;a:13:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:411;a:13:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:412;a:13:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:413;a:13:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:414;a:13:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:415;a:13:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:416;a:13:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}","no");

INSERT IGNORE INTO `wp_options` VALUES 
("399","revslider_checktables","1","yes"),
("400","rs_tables_created","1","yes"),
("401","revslider_table_version","1.0.12","yes"),
("402","revslider-global-settings","{\"permission\":\"admin\",\"lang\":\"default\",\"allinclude\":\"true\",\"highContrast\":\"false\",\"includeids\":\"\",\"script\":{\"footer\":\"false\",\"defer\":\"false\",\"full\":\"false\",\"async\":\"false\"},\"imgcrossOrigin\":\"unset\",\"lazyloaddata\":\"\",\"fontdownload\":\"disable\",\"fontawesomedisable\":\"false\",\"onedpronmobile\":\"false\",\"forceLazyLoading\":\"smart\",\"forceViewport\":\"true\",\"lazyonbg\":\"false\",\"forcedViewportDistance\":\"-200px\",\"internalcaching\":\"false\",\"fonturl\":\"\",\"size\":{\"desktop\":\"1240\",\"notebook\":\"1024\",\"tablet\":\"768\",\"mobile\":\"480\"},\"customfonts\":\"\",\"customFontList\":[{\"family\":\"\",\"url\":\"\",\"frontend\":\"false\",\"backend\":\"true\",\"weights\":\"200,300,400,500,600,700,800,900\"}]}","yes"),
("403","revslider_update_version","6.6.0","yes"),
("409","revslider-valid-notice","false","yes"),
("410","rs_cache_overlay","6.6.11","yes"),
("426","ingenious","a:98:{s:4:\"logo\";a:3:{s:3:\"src\";s:85:\"https://rtl.pars-themes.com/ingenious/wp-content/uploads/2020/10/logo-dark-big2-1.png\";s:2:\"id\";s:4:\"4744\";s:11:\"is_high_dpi\";s:1:\"1\";}s:10:\"light_logo\";a:3:{s:3:\"src\";s:84:\"https://rtl.pars-themes.com/ingenious/wp-content/uploads/2020/10/logo-white-big1.png\";s:2:\"id\";s:4:\"4740\";s:11:\"is_high_dpi\";s:1:\"1\";}s:17:\"header_logo_light\";s:5:\"white\";s:9:\"logo_dims\";a:2:{s:5:\"width\";s:0:\"\";s:6:\"height\";s:2:\"40\";}s:8:\"logo_pos\";s:5:\"right\";s:12:\"logo_margins\";a:4:{s:3:\"top\";s:2:\"12\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:2:\"12\";}s:11:\"mobile_logo\";a:3:{s:3:\"src\";s:84:\"https://rtl.pars-themes.com/ingenious/wp-content/uploads/2020/10/logo-white-big1.png\";s:2:\"id\";s:4:\"4740\";s:11:\"is_high_dpi\";s:1:\"0\";}s:11:\"sticky_logo\";a:3:{s:3:\"src\";s:85:\"https://rtl.pars-themes.com/ingenious/wp-content/uploads/2020/10/logo-dark-big2-1.png\";s:2:\"id\";s:4:\"4744\";s:11:\"is_high_dpi\";s:1:\"0\";}s:13:\"menu_spacings\";a:2:{s:3:\"top\";s:2:\"20\";s:6:\"bottom\";s:2:\"20\";}s:19:\"menu_items_spacings\";s:2:\"20\";s:8:\"menu_pos\";s:4:\"left\";s:12:\"menu_opacity\";s:1:\"0\";s:13:\"menu_bg_color\";s:7:\"#f8f8f8\";s:15:\"menu_font_color\";s:7:\"#ffffff\";s:7:\"menu_fw\";s:1:\"0\";s:14:\"wmpl_menu_icon\";s:1:\"1\";s:20:\"header_covers_slider\";s:1:\"1\";s:10:\"menu_stick\";s:5:\"smart\";s:10:\"hide_title\";s:1:\"0\";s:19:\"page_title_spacings\";a:4:{s:3:\"top\";s:3:\"170\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:3:\"130\";}s:20:\"default_header_image\";a:5:{s:5:\"image\";a:2:{s:3:\"src\";s:83:\"https://rtl.pars-themes.com/ingenious/wp-content/uploads/2017/11/header-default.jpg\";s:2:\"id\";s:4:\"3916\";}s:4:\"size\";s:7:\"initial\";s:6:\"repeat\";s:8:\"repeat-x\";s:10:\"attachment\";s:6:\"scroll\";s:8:\"position\";s:2:\"tc\";}s:11:\"add_pattern\";s:1:\"1\";s:21:\"default_pattern_image\";a:5:{s:5:\"image\";a:2:{s:3:\"src\";s:83:\"https://rtl.pars-themes.com/ingenious/wp-content/uploads/2017/10/slider-pattern.png\";s:2:\"id\";s:4:\"3802\";}s:4:\"size\";s:7:\"initial\";s:6:\"repeat\";s:8:\"repeat-x\";s:10:\"attachment\";s:6:\"scroll\";s:8:\"position\";s:2:\"cc\";}s:17:\"header_font_color\";s:7:\"#ffffff\";s:19:\"header_overlay_type\";s:8:\"gradient\";s:26:\"header_bg_overlay_gradient\";a:7:{s:2:\"c1\";s:7:\"#6b797f\";s:3:\"op1\";s:3:\"100\";s:2:\"c2\";s:7:\"#4ab769\";s:3:\"op2\";s:3:\"100\";s:4:\"type\";s:6:\"linear\";s:6:\"linear\";a:1:{s:5:\"angle\";s:2:\"45\";}s:10:\"custom_css\";s:736:\"/* Permalink - use to edit and share this gradient: http://colorzilla.com/gradient-editor/#586e6f 0,36a268 50,0f7860 100 */\r\nbackground: rgb(88,110,111); /* Old browsers */\r\nbackground: -moz-linear-gradient(left, rgba(88,110,111,1) 0%, rgba(54,162,104,1) 50%, rgba(15,120,96,1) 100%); /* FF3.6-15 */\r\nbackground: -webkit-linear-gradient(left, rgba(88,110,111,1) 0%,rgba(54,162,104,1) 50%,rgba(15,120,96,1) 100%); /* Chrome10-25,Safari5.1-6 */\r\nbackground: linear-gradient(to right, rgba(88,110,111,1) 0%,rgba(54,162,104,1) 50%,rgba(15,120,96,1) 100%); /* W3C, IE10 , FF16 , Chrome26 , Opera12 , Safari7  */\r\nfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'#586e6f\', endColorstr=\'#0f7860\',GradientType=1 ); /* IE6-9 */\";}s:17:\"header_bg_opacity\";s:2:\"90\";s:10:\"header_sep\";s:1:\"1\";s:11:\"header_crop\";a:3:{i:0;s:11:\"!!!dummy!!!\";i:1;s:9:\"left_crop\";i:2;s:10:\"right_crop\";}s:15:\"header_crossing\";s:2:\"50\";s:19:\"header_left_overlay\";s:1:\"0\";s:20:\"header_right_overlay\";s:1:\"0\";s:17:\"header_left_layer\";s:1:\"1\";s:21:\"header_left_layer_box\";a:9:{s:2:\"bg\";s:8:\"gradient\";s:13:\"gradient_from\";s:7:\"#737f82\";s:12:\"from_opacity\";s:1:\"0\";s:11:\"gradient_to\";s:7:\"#158a61\";s:10:\"to_opacity\";s:1:\"0\";s:14:\"gradient_angle\";s:1:\"0\";s:6:\"points\";s:1:\"1\";s:9:\"top_point\";s:3:\"100\";s:9:\"bot_point\";s:3:\"100\";}s:18:\"header_right_layer\";s:1:\"0\";s:11:\"theme_color\";s:7:\"#59ab66\";s:18:\"theme_helper_color\";s:7:\"#ff6c3a\";s:12:\"boxed_layout\";s:1:\"0\";s:11:\"hide_footer\";s:1:\"0\";s:15:\"footer_bg_color\";s:7:\"#111111\";s:17:\"footer_bg_opacity\";s:2:\"95\";s:17:\"footer_font_color\";s:7:\"#b0b0b0\";s:18:\"footer_title_color\";s:7:\"#ffffff\";s:20:\"default_footer_image\";a:2:{s:3:\"src\";s:78:\"https://rtl.pars-themes.com/ingenious/wp-content/uploads/2017/10/footer_bg.jpg\";s:2:\"id\";s:4:\"2901\";}s:9:\"footer_sb\";s:11:\"footer_area\";s:15:\"copyrights_text\";s:86:\"<center>\r\nتهیه و فارسی سازی قالب توسط پارس تمز\r\n</center>\";s:19:\"copyrights_bg_color\";s:7:\"#2b2b2b\";s:21:\"copyrights_bg_opacity\";s:3:\"100\";s:21:\"copyrights_font_color\";s:7:\"#dddddd\";s:18:\"footer_fixed_style\";s:1:\"1\";s:16:\"home_slider_type\";s:10:\"img_slider\";s:21:\"home_slider_shortcode\";s:30:\"[rev_slider alias=\\\"default\\\"]\";s:15:\"def-home-layout\";s:4:\"none\";s:15:\"def-page-layout\";s:4:\"none\";s:15:\"def-blog-layout\";s:4:\"none\";s:18:\"blog_meta_position\";s:3:\"top\";s:15:\"def_blog_layout\";s:1:\"1\";s:18:\"def_post_hide_meta\";a:1:{i:0;s:11:\"!!!dummy!!!\";}s:20:\"def_portfolio_layout\";s:1:\"4\";s:26:\"def_portfolio_data_to_show\";a:4:{i:0;s:11:\"!!!dummy!!!\";i:1;s:5:\"title\";i:2;s:7:\"excerpt\";i:3;s:4:\"cats\";}s:25:\"def_portfolio_chars_count\";s:3:\"200\";s:16:\"def_staff_layout\";s:1:\"2\";s:22:\"def_staff_data_to_hide\";a:1:{i:0;s:11:\"!!!dummy!!!\";}s:8:\"sidebars\";a:4:{i:0;a:1:{s:5:\"title\";s:11:\"WooCommerce\";}i:1;a:1:{s:5:\"title\";s:17:\"Blog Left Sidebar\";}i:2;a:1:{s:5:\"title\";s:18:\"Blog Right Sidebar\";}i:3;a:1:{s:5:\"title\";s:0:\"\";}}s:15:\"sticky_sidebars\";s:1:\"1\";s:9:\"menu_font\";a:7:{s:11:\"font-family\";s:10:\"iransansdn\";s:11:\"font-weight\";a:1:{i:0;s:7:\"regular\";}s:8:\"font-sub\";a:1:{i:0;s:5:\"latin\";}s:9:\"font-type\";s:0:\"\";s:5:\"color\";s:7:\"#363636\";s:9:\"font-size\";s:4:\"15px\";s:11:\"line-height\";s:4:\"36px\";}s:11:\"header_font\";a:7:{s:11:\"font-family\";s:9:\"iranyekan\";s:11:\"font-weight\";a:1:{i:0;s:7:\"regular\";}s:8:\"font-sub\";a:1:{i:0;s:5:\"latin\";}s:9:\"font-type\";s:0:\"\";s:5:\"color\";s:7:\"#363636\";s:9:\"font-size\";s:4:\"28px\";s:11:\"line-height\";s:4:\"39px\";}s:9:\"body_font\";a:7:{s:11:\"font-family\";s:10:\"iransansdn\";s:11:\"font-weight\";a:1:{i:0;s:7:\"regular\";}s:8:\"font-sub\";a:1:{i:0;s:5:\"latin\";}s:9:\"font-type\";s:0:\"\";s:5:\"color\";s:7:\"#363636\";s:9:\"font-size\";s:4:\"15px\";s:11:\"line-height\";s:4:\"28px\";}s:15:\"social_location\";s:4:\"none\";s:11:\"show_loader\";s:1:\"1\";s:16:\"show_breadcrumbs\";s:1:\"1\";s:13:\"scroll_to_top\";s:5:\"smart\";s:14:\"portfolio_slug\";s:9:\"portfolio\";s:10:\"staff_slug\";s:5:\"staff\";s:20:\"_theme_purchase_code\";s:0:\"\";s:6:\"crop_x\";s:6:\"center\";s:6:\"crop_y\";s:6:\"center\";s:15:\"woo_cart_enable\";s:1:\"1\";s:19:\"header_woo_logo_sel\";s:5:\"black\";s:10:\"woo_column\";s:9:\"columns_3\";s:16:\"woo_num_products\";s:2:\"12\";s:19:\"woo_related_columns\";s:1:\"3\";s:24:\"woo_related_num_products\";s:1:\"3\";s:13:\"woo_sb_layout\";s:5:\"right\";s:11:\"woo_sidebar\";s:11:\"woocommerce\";s:16:\"woo_menu_opacity\";s:1:\"0\";s:17:\"woo_menu_bg_color\";s:7:\"#000000\";s:19:\"woo_menu_font_color\";s:7:\"#ffffff\";s:24:\"woo_header_covers_slider\";s:1:\"1\";s:14:\"woo_hide_title\";s:1:\"0\";s:23:\"woo_page_title_spacings\";a:4:{s:3:\"top\";s:3:\"170\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:3:\"130\";}s:24:\"woo_default_header_image\";a:5:{s:5:\"image\";a:2:{s:3:\"src\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:4:\"size\";s:7:\"initial\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"attachment\";s:6:\"scroll\";s:8:\"position\";s:2:\"cc\";}s:15:\"woo_add_pattern\";s:1:\"1\";s:25:\"woo_default_pattern_image\";a:5:{s:5:\"image\";a:2:{s:3:\"src\";s:83:\"https://rtl.pars-themes.com/ingenious/wp-content/uploads/2017/10/slider-pattern.png\";s:2:\"id\";s:4:\"3802\";}s:4:\"size\";s:7:\"initial\";s:6:\"repeat\";s:9:\"no-repeat\";s:10:\"attachment\";s:6:\"scroll\";s:8:\"position\";s:2:\"cc\";}s:21:\"woo_header_font_color\";s:7:\"#ffffff\";s:23:\"woo_header_overlay_type\";s:8:\"gradient\";s:30:\"woo_header_bg_overlay_gradient\";a:7:{s:2:\"c1\";s:7:\"#6b797f\";s:3:\"op1\";s:3:\"100\";s:2:\"c2\";s:7:\"#4ab769\";s:3:\"op2\";s:3:\"100\";s:4:\"type\";s:6:\"linear\";s:6:\"linear\";a:1:{s:5:\"angle\";s:2:\"45\";}s:10:\"custom_css\";s:736:\"/* Permalink - use to edit and share this gradient: http://colorzilla.com/gradient-editor/#586e6f 0,36a268 50,0f7860 100 */\r\nbackground: rgb(88,110,111); /* Old browsers */\r\nbackground: -moz-linear-gradient(left, rgba(88,110,111,1) 0%, rgba(54,162,104,1) 50%, rgba(15,120,96,1) 100%); /* FF3.6-15 */\r\nbackground: -webkit-linear-gradient(left, rgba(88,110,111,1) 0%,rgba(54,162,104,1) 50%,rgba(15,120,96,1) 100%); /* Chrome10-25,Safari5.1-6 */\r\nbackground: linear-gradient(to right, rgba(88,110,111,1) 0%,rgba(54,162,104,1) 50%,rgba(15,120,96,1) 100%); /* W3C, IE10 , FF16 , Chrome26 , Opera12 , Safari7  */\r\nfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'#586e6f\', endColorstr=\'#0f7860\',GradientType=1 ); /* IE6-9 */\";}s:21:\"woo_header_bg_opacity\";s:2:\"90\";}","yes"),
("427","theme_mods_ingenious","a:4:{i:0;b:0;s:18:\"custom_css_post_id\";i:4507;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";s:2:\"35\";}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1664264258;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:17:\"page_left_sidebar\";a:5:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:13:\"cws-gallery-3\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";}s:18:\"page_right_sidebar\";a:5:{i:0;s:18:\"ingenious-search-2\";i:1;s:12:\"categories-3\";i:2;s:13:\"cws-gallery-5\";i:3;s:17:\"recent-comments-3\";i:4;s:11:\"tag_cloud-2\";}s:11:\"footer_area\";a:3:{i:0;s:6:\"text-2\";i:1;s:24:\"ingenious-latest-posts-2\";i:2;s:13:\"custom_html-2\";}s:11:\"woocommerce\";a:5:{i:0;s:32:\"woocommerce_product_categories-2\";i:1;s:26:\"woocommerce_price_filter-2\";i:2;s:25:\"woocommerce_widget_cart-2\";i:3;s:22:\"woocommerce_products-2\";i:4;s:31:\"woocommerce_product_tag_cloud-2\";}s:17:\"blog_left_sidebar\";a:4:{i:0;s:13:\"cws-gallery-4\";i:1;s:12:\"categories-5\";i:2;s:8:\"search-5\";i:3;s:10:\"calendar-4\";}s:18:\"blog_right_sidebar\";a:6:{i:0;s:8:\"search-4\";i:1;s:12:\"categories-4\";i:2;s:13:\"cws-gallery-2\";i:3;s:17:\"recent-comments-4\";i:4;s:20:\"parsidate_calendar-2\";i:5;s:11:\"tag_cloud-3\";}}}}","yes"),
("428","page_on_front","178","yes"),
("429","sidebars_widgets","a:8:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:13:\"cws-gallery-2\";i:1;s:13:\"cws-gallery-3\";i:2;s:13:\"cws-gallery-4\";i:3;s:13:\"cws-gallery-5\";i:4;s:18:\"ingenious-search-2\";i:5;s:20:\"parsidate_calendar-2\";}s:17:\"page_left_sidebar\";a:4:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:10:\"archives-2\";i:3;s:12:\"categories-2\";}s:18:\"page_right_sidebar\";a:5:{i:0;s:12:\"categories-3\";i:1;s:17:\"recent-comments-3\";i:2;s:11:\"tag_cloud-2\";i:3;s:6:\"text-2\";i:4;s:13:\"custom_html-2\";}s:11:\"footer_area\";a:3:{i:0;s:6:\"text-4\";i:1;s:24:\"ingenious-latest-posts-2\";i:2;s:6:\"text-3\";}s:11:\"woocommerce\";a:5:{i:0;s:32:\"woocommerce_product_categories-2\";i:1;s:26:\"woocommerce_price_filter-2\";i:2;s:25:\"woocommerce_widget_cart-2\";i:3;s:22:\"woocommerce_products-2\";i:4;s:31:\"woocommerce_product_tag_cloud-2\";}s:17:\"blog_left_sidebar\";a:3:{i:0;s:12:\"categories-5\";i:1;s:8:\"search-5\";i:2;s:10:\"calendar-4\";}s:18:\"blog_right_sidebar\";a:4:{i:0;s:8:\"search-4\";i:1;s:12:\"categories-4\";i:2;s:17:\"recent-comments-4\";i:3;s:11:\"tag_cloud-3\";}s:13:\"array_version\";i:3;}","yes"),
("430","widget_archives","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("431","widget_calendar","a:2:{i:4;a:1:{s:5:\"title\";s:10:\"تقویم\";}s:12:\"_multiwidget\";i:1;}","yes"),
("432","widget_categories","a:5:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:3;a:4:{s:5:\"title\";s:22:\"دسته بندی ها\";s:5:\"count\";i:1;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:4;a:4:{s:5:\"title\";s:22:\"دسته بندی ها\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:5;a:4:{s:5:\"title\";s:22:\"دسته بندی ها\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("433","widget_custom_html","a:2:{i:2;a:2:{s:5:\"title\";s:21:\"راه ارتباطی\";s:7:\"content\";s:355:\"<i class=\'fa fa-envelope-o color_icon\'></i>  example@gmail.com\r\n<br>\r\n<i class=\'fa fa-phone color_icon\'></i>  +987654321\r\n<br>\r\n<i class=\'fa fa-facebook color_icon\'></i>\r\n<i class=\'fa fa fa-twitter color_icon\'></i>\r\n<i class=\'fa fa fa-instagram color_icon\'></i>\r\n<i class=\'fa fa fa-linkedin color_icon\'></i>\r\n<i class=\'fa fa fa-signal color_icon\'></i>\r\n\r\n\";}s:12:\"_multiwidget\";i:1;}","yes"),
("434","widget_cws-about","a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("435","widget_cws-gallery","a:5:{i:2;a:8:{s:5:\"title\";s:10:\"گالری\";s:7:\"gallery\";s:72:\"[gallery link=\"file\" ids=\"1974,1938,1936,1907,1972,1935,1906,1905,1903\"]\";s:7:\"bg_fill\";s:4:\"none\";s:14:\"bg_title_color\";s:7:\"#ffffff\";s:13:\"bg_font_color\";s:7:\"#ffffff\";s:8:\"bg_color\";s:7:\"#59ab66\";s:19:\"bg_overlay_gradient\";a:8:{s:2:\"c1\";s:7:\"#6b797f\";s:3:\"op1\";s:3:\"100\";s:2:\"c2\";s:7:\"#4ab769\";s:3:\"op2\";s:3:\"100\";s:4:\"type\";s:6:\"linear\";s:6:\"linear\";a:1:{s:5:\"angle\";s:2:\"45\";}s:6:\"radial\";a:4:{s:10:\"shape_type\";s:6:\"simple\";s:5:\"shape\";s:7:\"ellipse\";s:4:\"size\";s:0:\"\";s:7:\"keyword\";s:15:\"farthest-corner\";}s:10:\"custom_css\";s:0:\"\";}s:10:\"bg_opacity\";s:3:\"100\";}i:3;a:8:{s:5:\"title\";s:10:\"گالری\";s:7:\"gallery\";s:71:\"[gallery link=\"file\" ids=\"1974,1973,1905,1938,1329,1936,1907,958,1972\"]\";s:7:\"bg_fill\";s:4:\"none\";s:14:\"bg_title_color\";s:7:\"#ffffff\";s:13:\"bg_font_color\";s:7:\"#ffffff\";s:8:\"bg_color\";s:7:\"#59ab66\";s:19:\"bg_overlay_gradient\";a:8:{s:2:\"c1\";s:7:\"#6b797f\";s:3:\"op1\";s:3:\"100\";s:2:\"c2\";s:7:\"#4ab769\";s:3:\"op2\";s:3:\"100\";s:4:\"type\";s:6:\"linear\";s:6:\"linear\";a:1:{s:5:\"angle\";s:2:\"45\";}s:6:\"radial\";a:4:{s:10:\"shape_type\";s:6:\"simple\";s:5:\"shape\";s:7:\"ellipse\";s:4:\"size\";s:0:\"\";s:7:\"keyword\";s:15:\"farthest-corner\";}s:10:\"custom_css\";s:0:\"\";}s:10:\"bg_opacity\";s:3:\"100\";}i:4;a:8:{s:5:\"title\";s:10:\"گالری\";s:7:\"gallery\";s:72:\"[gallery link=\"file\" ids=\"1974,1907,1329,1938,1320,1905,1137,1935,1135\"]\";s:7:\"bg_fill\";s:4:\"none\";s:14:\"bg_title_color\";s:7:\"#ffffff\";s:13:\"bg_font_color\";s:7:\"#ffffff\";s:8:\"bg_color\";s:7:\"#59ab66\";s:19:\"bg_overlay_gradient\";a:8:{s:2:\"c1\";s:7:\"#6b797f\";s:3:\"op1\";s:3:\"100\";s:2:\"c2\";s:7:\"#4ab769\";s:3:\"op2\";s:3:\"100\";s:4:\"type\";s:6:\"linear\";s:6:\"linear\";a:1:{s:5:\"angle\";s:2:\"45\";}s:6:\"radial\";a:4:{s:10:\"shape_type\";s:6:\"simple\";s:5:\"shape\";s:7:\"ellipse\";s:4:\"size\";s:0:\"\";s:7:\"keyword\";s:15:\"farthest-corner\";}s:10:\"custom_css\";s:0:\"\";}s:10:\"bg_opacity\";s:3:\"100\";}i:5;a:8:{s:5:\"title\";s:10:\"گالری\";s:7:\"gallery\";s:84:\"[gallery size=\"full\" link=\"file\" ids=\"2369,2363,2373,2372,1938,1972,1935,1907,1973\"]\";s:7:\"bg_fill\";s:4:\"none\";s:14:\"bg_title_color\";s:7:\"#ffffff\";s:13:\"bg_font_color\";s:7:\"#ffffff\";s:8:\"bg_color\";s:7:\"#59ab66\";s:19:\"bg_overlay_gradient\";a:8:{s:2:\"c1\";s:7:\"#6b797f\";s:3:\"op1\";s:3:\"100\";s:2:\"c2\";s:7:\"#4ab769\";s:3:\"op2\";s:3:\"100\";s:4:\"type\";s:6:\"linear\";s:6:\"linear\";a:1:{s:5:\"angle\";s:2:\"45\";}s:6:\"radial\";a:4:{s:10:\"shape_type\";s:6:\"simple\";s:5:\"shape\";s:7:\"ellipse\";s:4:\"size\";s:0:\"\";s:7:\"keyword\";s:15:\"farthest-corner\";}s:10:\"custom_css\";s:0:\"\";}s:10:\"bg_opacity\";s:3:\"100\";}s:12:\"_multiwidget\";i:1;}","yes"),
("436","widget_ing-cws-staff","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("437","widget_ing-latest-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("438","widget_ing-social","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("439","widget_ing-text","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("440","widget_ing-twitter","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("441","widget_ingeni-about","a:2:{i:2;a:8:{s:5:\"title\";s:15:\"About Ingenious\";s:5:\"image\";a:2:{s:3:\"src\";s:103:\"https://rtl.pars-themes.com/ingenious/wp-content/uploads/2017/07/Fotolia_5788780729_Subscription_XL.jpg\";s:2:\"id\";s:2:\"11\";}s:11:\"description\";s:153:\"Interdum et malesuada fames ac ante ipsum primis in faucibus. Pellentesque habitant morbi tristique senectus netus et malesuada fames ac turpis egestas. \";s:10:\"add_button\";s:1:\"1\";s:11:\"button_text\";s:4:\"More\";s:10:\"button_url\";s:1:\"#\";s:14:\"button_new_tab\";s:1:\"1\";s:11:\"add_fill_bg\";s:1:\"1\";}s:12:\"_multiwidget\";i:1;}","yes"),
("442","widget_ingeni-cws-staff","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("443","widget_ingeni-latest-posts","a:3:{i:2;a:9:{s:5:\"title\";s:12:\"Latest Posts\";s:4:\"icon\";s:0:\"\";s:16:\"add_custom_color\";s:1:\"0\";s:5:\"color\";s:7:\"#59ab66\";s:9:\"filter_by\";s:4:\"none\";s:13:\"visible_count\";s:1:\"2\";s:5:\"count\";s:1:\"4\";s:11:\"chars_count\";s:2:\"70\";s:11:\"add_fill_bg\";s:1:\"1\";}i:3;a:11:{s:5:\"title\";s:11:\"Latest Post\";s:4:\"icon\";s:0:\"\";s:16:\"add_custom_color\";s:1:\"0\";s:5:\"color\";s:7:\"#59ab66\";s:9:\"filter_by\";s:3:\"cat\";s:4:\"cats\";a:2:{i:0;s:5:\"alarm\";i:1;s:7:\"heating\";}s:13:\"visible_count\";s:1:\"3\";s:5:\"count\";s:1:\"1\";s:9:\"hide_data\";a:2:{i:0;s:4:\"tags\";i:1;s:4:\"desc\";}s:11:\"chars_count\";s:0:\"\";s:11:\"add_fill_bg\";s:1:\"0\";}s:12:\"_multiwidget\";i:1;}","yes"),
("444","widget_ingeni-search","a:3:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:11:\"add_fill_bg\";s:1:\"1\";}i:3;a:2:{s:5:\"title\";s:0:\"\";s:11:\"add_fill_bg\";s:1:\"1\";}s:12:\"_multiwidget\";i:1;}","yes"),
("445","widget_ingeni-social","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("446","widget_ingeni-text","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("447","widget_ingeni-twitter","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("448","widget_ingenious-about","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("449","widget_ingenious-cws-staff","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("450","widget_ingenious-latest-posts","a:2:{i:2;a:16:{s:5:\"title\";s:22:\"پست های اخیر\";s:4:\"icon\";s:0:\"\";s:16:\"add_custom_color\";s:1:\"0\";s:5:\"color\";s:7:\"#59ab66\";s:9:\"filter_by\";s:3:\"cat\";s:4:\"cats\";a:2:{i:0;s:13:\"energy-saving\";i:1;s:5:\"alarm\";}s:13:\"visible_count\";s:1:\"3\";s:5:\"count\";s:1:\"1\";s:9:\"hide_data\";a:2:{i:0;s:11:\"!!!dummy!!!\";i:1;s:4:\"tags\";}s:11:\"chars_count\";s:2:\"35\";s:7:\"bg_fill\";s:4:\"none\";s:14:\"bg_title_color\";s:7:\"#ffffff\";s:13:\"bg_font_color\";s:7:\"#ffffff\";s:8:\"bg_color\";s:7:\"#59ab66\";s:19:\"bg_overlay_gradient\";a:8:{s:2:\"c1\";s:7:\"#6b797f\";s:3:\"op1\";s:3:\"100\";s:2:\"c2\";s:7:\"#4ab769\";s:3:\"op2\";s:3:\"100\";s:4:\"type\";s:6:\"linear\";s:6:\"linear\";a:1:{s:5:\"angle\";s:2:\"45\";}s:6:\"radial\";a:4:{s:10:\"shape_type\";s:6:\"simple\";s:5:\"shape\";s:7:\"ellipse\";s:4:\"size\";s:0:\"\";s:7:\"keyword\";s:15:\"farthest-corner\";}s:10:\"custom_css\";s:0:\"\";}s:10:\"bg_opacity\";s:3:\"100\";}s:12:\"_multiwidget\";i:1;}","yes"),
("451","widget_ingenious-search","a:2:{i:2;a:7:{s:5:\"title\";s:0:\"\";s:7:\"bg_fill\";s:4:\"none\";s:14:\"bg_title_color\";s:7:\"#ffffff\";s:13:\"bg_font_color\";s:7:\"#ffffff\";s:8:\"bg_color\";s:7:\"#59ab66\";s:19:\"bg_overlay_gradient\";a:8:{s:2:\"c1\";s:7:\"#6b797f\";s:3:\"op1\";s:3:\"100\";s:2:\"c2\";s:7:\"#4ab769\";s:3:\"op2\";s:3:\"100\";s:4:\"type\";s:6:\"linear\";s:6:\"linear\";a:1:{s:5:\"angle\";s:2:\"45\";}s:6:\"radial\";a:4:{s:10:\"shape_type\";s:6:\"simple\";s:5:\"shape\";s:7:\"ellipse\";s:4:\"size\";s:0:\"\";s:7:\"keyword\";s:15:\"farthest-corner\";}s:10:\"custom_css\";s:0:\"\";}s:10:\"bg_opacity\";s:3:\"100\";}s:12:\"_multiwidget\";i:1;}","yes"),
("452","widget_ingenious-social","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("453","widget_ingenious-text","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("454","widget_ingenious-twitter","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("455","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("456","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("457","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("458","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("459","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("460","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("461","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("462","widget_recent-comments","a:3:{i:3;a:2:{s:5:\"title\";s:28:\"دیدگاه های اخیر\";s:6:\"number\";i:3;}i:4;a:2:{s:5:\"title\";s:28:\"دیدگاه های اخیر\";s:6:\"number\";i:3;}s:12:\"_multiwidget\";i:1;}","yes"),
("463","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes"),
("464","widget_rev-slider-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("465","widget_rss","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("466","widget_search","a:4:{i:2;a:1:{s:5:\"title\";s:0:\"\";}i:4;a:1:{s:5:\"title\";s:0:\"\";}i:5;a:1:{s:5:\"title\";s:10:\"جستجو\";}s:12:\"_multiwidget\";i:1;}","yes"),
("467","widget_tag_cloud","a:3:{i:2;a:3:{s:5:\"title\";s:15:\"برچسب ها\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";}i:3;a:3:{s:5:\"title\";s:15:\"برچسب ها\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}","yes"),
("468","widget_text","a:5:{i:1;a:0:{}i:2;a:4:{s:5:\"title\";s:12:\"ابتکار\";s:4:\"text\";s:456:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:3;a:4:{s:5:\"title\";s:18:\"تماس با ما\";s:4:\"text\";s:380:\"<i class=\"fa fa-envelope-o color_icon\"></i> Ingenious@gmail.com\r\n<i class=\"fa fa-phone color_icon\"></i> (+123) 456 - 7890\r\n<i class=\"fab fa-facebook-f color_icon nobreak\"></i>\r\n<i class=\"fab fa-twitter color_icon nobreak\"></i>\r\n<i class=\"fab fa-instagram color_icon nobreak\"></i>\r\n<i class=\"fab fa-linkedin color_icon nobreak\"></i>\r\n<i class=\"fa fa-signal color_icon nobreak\"></i>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:4;a:4:{s:5:\"title\";s:25:\"درباره ابتکار\";s:4:\"text\";s:456:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}","yes"),
("469","widget_woocommerce_layered_nav","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("470","widget_woocommerce_layered_nav_filters","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("471","widget_woocommerce_price_filter","a:2:{i:2;a:1:{s:5:\"title\";s:33:\"فیلتر بر اساس قیمت\";}s:12:\"_multiwidget\";i:1;}","yes"),
("472","widget_woocommerce_product_categories","a:2:{i:2;a:8:{s:5:\"title\";s:22:\"دسته بندی ها\";s:7:\"orderby\";s:5:\"order\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;s:9:\"max_depth\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("473","widget_woocommerce_product_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("474","widget_woocommerce_product_tag_cloud","a:2:{i:2;a:1:{s:5:\"title\";s:15:\"برچسب ها\";}s:12:\"_multiwidget\";i:1;}","yes"),
("475","widget_woocommerce_products","a:2:{i:2;a:7:{s:5:\"title\";s:24:\"محبوب ترین ها\";s:6:\"number\";i:1;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:3:\"asc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("476","widget_woocommerce_rating_filter","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("477","widget_woocommerce_recent_reviews","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("478","widget_woocommerce_recently_viewed_products","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("479","widget_woocommerce_top_rated_products","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("480","widget_woocommerce_widget_cart","a:2:{i:2;a:2:{s:5:\"title\";s:15:\"سبد خرید\";s:13:\"hide_if_empty\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("481","widget_wpgmza_map_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("655","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes"),
("685","revslider-connection","1","yes"),
("686","revslider-latest-version","6.7.14","yes"),
("687","revslider-stable-version","4.2.0","yes"),
("688","revslider-notices","a:2:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:952:\"<div style=\"display: block; background: #1b0e41;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-c.tools//banners/rs60/cyberweek.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-c.tools//banners/rs60/cyberweek.jpg\"></div>\n<map name=\"srbannermap\">\n    <area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks22\" coords=\"569,135,890,196\" shape=\"rect\">\n    <area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks22\" coords=\"570,200,889,260\" shape=\"rect\">\n</map>\";s:4:\"code\";s:9:\"TPSRCW111\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:527:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 504px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium3\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 900px; height: 504px; display: inline-block;\" muted loop autoplay preload=\"auto\"><source src=\"//updates.themepunch-ext-c.tools//banners/rs60/buypremium3.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:11:\"TPSNOTR3011\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}}","yes"),
("689","revslider-dashboard","a:0:{}","yes"),
("690","revslider-addons","O:8:\"stdClass\":35:{s:28:\"revslider-particlewave-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"380\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:28:\"revslider-particlewave-addon\";s:12:\"version_from\";s:6:\"6.5.15\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Particle Wave\";s:6:\"line_1\";s:36:\"Create 3D particle and polygon grids\";s:6:\"line_2\";s:40:\"with lots of style and animation options\";s:9:\"available\";s:5:\"1.1.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:1:\"9\";s:11:\"last_update\";s:10:\"2023-08-24\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_particlewave.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_particlewave.jpg\";s:7:\"img_md5\";s:32:\"623bec30f175f4cc541048f1d6d5fd07\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"424\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"3.3.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2023-07-28\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_particles.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_particles.jpg\";s:7:\"img_md5\";s:32:\"b668a4015ddc6a532b43bb558967a062\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_bubblemorph.jpg\";s:7:\"img_md5\";s:32:\"22d03d5de3034069c6db1fdeafd467cd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-thecluster-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"481\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:26:\"revslider-thecluster-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"The Cluster\";s:6:\"line_1\";s:24:\"Cluster Particle Effects\";s:6:\"line_2\";s:27:\"with millions of Variations\";s:9:\"available\";s:6:\"1.0.10\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_cluster.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_cluster.jpg\";s:7:\"img_md5\";s:32:\"7ada93a9f08a3bcfddc078699674d755\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TC\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-fluiddynamics-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"493\";s:9:\"releaseid\";s:2:\"31\";s:4:\"slug\";s:29:\"revslider-fluiddynamics-addon\";s:12:\"version_from\";s:6:\"6.4.10\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Fluid Dynamics\";s:6:\"line_1\";s:46:\"Creating breathtaking Dynamic Fluid animations\";s:6:\"line_2\";s:25:\"as layer or as background\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:11:\"last_update\";s:10:\"2023-11-16\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_fluid.png\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_fluid.png\";s:7:\"img_md5\";s:32:\"4e52333540d80bcb2a41b8ed5961e088\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FD\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"369\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2023-02-23\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_transition.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_transition.jpg\";s:7:\"img_md5\";s:32:\"fe0f1c539053620039a0ad96c4ac27e6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"404\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"3.1.0\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2023-05-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_beforeafter.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_beforeafter.jpg\";s:7:\"img_md5\";s:32:\"5a34f20417a7874e1b95693ef37a0758\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"418\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_typewriter.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_typewriter.jpg\";s:7:\"img_md5\";s:32:\"727b604f6fd3fc55894ba50eb566efed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"499\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"3.1.0\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2023-10-06\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_mousetrap.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_mousetrap.jpg\";s:7:\"img_md5\";s:32:\"2329053c3b1d19bdaee131c3dc258d3a\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"500\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_distortion.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_distortion.jpg\";s:7:\"img_md5\";s:32:\"c26c52a563008b7dc907a288c1e4bb8e\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"420\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"3.1.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_lottie.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_lottie.jpg\";s:7:\"img_md5\";s:32:\"4aa677a45bb13732e4f10bcb632afcce\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"411\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2023-08-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_paintbrush.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_paintbrush.jpg\";s:7:\"img_md5\";s:32:\"308a56289b9a29d1916c2acfc141b699\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"483\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:6:\"6.5.17\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2022-08-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_charts.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_charts.jpg\";s:7:\"img_md5\";s:32:\"d2c184371a575faade425c0377c1fdbd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_slicey.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_slicey.jpg\";s:7:\"img_md5\";s:32:\"28afd29b7738a452194f0a0bc1d21cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"422\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_filmstrip.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_filmstrip.jpg\";s:7:\"img_md5\";s:32:\"dac40ee57d2be9aaf01faacf51ccb412\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"421\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2023-07-17\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:84:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_underconstruction.jpg\";s:8:\"img_file\";s:51:\"revslider/addons/images/addon_underconstruction.jpg\";s:7:\"img_md5\";s:32:\"17f8cba84931541c065cfb1943edafb2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"416\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_reveal.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reveal.jpg\";s:7:\"img_md5\";s:32:\"a7ce4bf5eb6fdc1497ed6276ca623046\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"423\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"3.0.9\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_panorama.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_panorama.jpg\";s:7:\"img_md5\";s:32:\"210953d59903bed91688138cb60777d2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"498\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:15:\"background_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:14:\"background_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:7:\"img_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"407\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_exploding.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_exploding.jpg\";s:7:\"img_md5\";s:32:\"44d60b83cdf5b29033d41feb516b47e1\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"397\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2023-07-08\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:80:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_socialsharing.jpg\";s:8:\"img_file\";s:47:\"revslider/addons/images/addon_socialsharing.jpg\";s:7:\"img_md5\";s:32:\"6b074630853c4f95d5337bc85e496cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"419\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:81:\"//updates.themepunch-ext-c.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:15:\"background_file\";s:48:\"revslider/addons/images/whiteboard_widget_bg.jpg\";s:14:\"background_md5\";s:32:\"cc69160eb95469dc033e0cc094a24847\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_whiteboard.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_whiteboard.jpg\";s:7:\"img_md5\";s:32:\"b0bb636fb30ffc3d112ba4c563395ee6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"414\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_polyfold.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_polyfold.jpg\";s:7:\"img_md5\";s:32:\"02c6af89e4208f0da5920c6c3e6bb744\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2022-02-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_domainswitch.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_domainswitch.jpg\";s:7:\"img_md5\";s:32:\"f2036924e7993f94bd5c9876fa0bf09b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"415\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_reload.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reload.jpg\";s:7:\"img_md5\";s:32:\"d1d34d204e627168f4cc4e7422a6d40c\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2023-06-12\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wprelated.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wprelated.jpg\";s:7:\"img_md5\";s:32:\"e2e7d6c3a428a55442ba90131556c930\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"399\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:71:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_snow.jpg\";s:8:\"img_file\";s:38:\"revslider/addons/images/addon_snow.jpg\";s:7:\"img_md5\";s:32:\"d6bac718866b0070198a4340041bc60b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2023-12-11\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpgallery.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wpgallery.jpg\";s:7:\"img_md5\";s:32:\"74392a04b741d83c51e55059dbb388ef\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_backup.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_backup.jpg\";s:7:\"img_md5\";s:32:\"104797323a0293cd3f200b0172db1186\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2022-12-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:70:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_404.jpg\";s:8:\"img_file\";s:37:\"revslider/addons/images/addon_404.jpg\";s:7:\"img_md5\";s:32:\"217b0d118a107dc50979740dd61228df\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2023-08-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpadjacent.jpg\";s:7:\"img_md5\";s:32:\"cb1feb1257e55d0f42c29dfde2d809ed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2023-06-12\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_login.jpg\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_login.jpg\";s:7:\"img_md5\";s:32:\"f0f2edffb4e155acf67799692428644d\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpfeatured.jpg\";s:7:\"img_md5\";s:32:\"bcc840e68194f3eb05795e1353954bda\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"402\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_weather.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_weather.jpg\";s:7:\"img_md5\";s:32:\"c69d1c9a69c2dec43ca0578ac35792bd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"406\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_duotone.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_duotone.jpg\";s:7:\"img_md5\";s:32:\"fb666e487e7ac28e6a2a157eed1fb682\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}}","yes"),
("728","category_children","a:0:{}","yes"),
("729","woocommerce_permalinks","a:5:{s:12:\"product_base\";s:8:\"/product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}","yes"),
("825","woocommerce_store_address","","yes"),
("826","woocommerce_store_address_2","","yes"),
("827","woocommerce_store_city","","yes"),
("828","woocommerce_store_postcode","","yes"),
("829","woocommerce_enable_reviews","yes","yes"),
("830","woocommerce_shipping_debug_mode","no","no"),
("884","cwssvgi","a:4:{s:14:\"New Collection\";a:171:{i:0;s:14:\"010-heater.svg\";i:1;s:18:\"011-light-bulb.svg\";i:2;s:14:\"022-garage.svg\";i:3;s:18:\"025-flashlight.svg\";i:4;s:16:\"026-password.svg\";i:5;s:13:\"028-house.svg\";i:6;s:15:\"051-alarm-1.svg\";i:7;s:18:\"051-alarm-bell.svg\";i:8;s:12:\"051-bell.svg\";i:9;s:14:\"051-cctv-1.svg\";i:10;s:12:\"051-cctv.svg\";i:11;s:11:\"051-eye.svg\";i:12;s:15:\"051-flasher.svg\";i:13;s:12:\"051-home.svg\";i:14;s:15:\"051-nuclear.svg\";i:15;s:15:\"051-padlock.svg\";i:16;s:18:\"051-password-1.svg\";i:17;s:16:\"051-password.svg\";i:18;s:19:\"051-safety-belt.svg\";i:19;s:16:\"051-shield-1.svg\";i:20;s:16:\"051-umbrella.svg\";i:21;s:12:\"051-wifi.svg\";i:22;s:9:\"apple.svg\";i:23;s:12:\"armchair.svg\";i:24;s:20:\"audio-speaker-on.svg\";i:25;s:19:\"battery-warning.svg\";i:26;s:10:\"bell-1.svg\";i:27;s:20:\"big-full-battery.svg\";i:28;s:26:\"big-square-play-button.svg\";i:29;s:25:\"big-television-screen.svg\";i:30;s:14:\"big-trophy.svg\";i:31;s:19:\"big-world-globe.svg\";i:32;s:10:\"blinds.svg\";i:33;s:13:\"browser-1.svg\";i:34;s:14:\"calendar-4.svg\";i:35;s:12:\"calendar.svg\";i:36;s:10:\"cctv-1.svg\";i:37;s:8:\"chat.svg\";i:38;s:15:\"checked (1).svg\";i:39;s:11:\"clock-3.svg\";i:40;s:19:\"cloud-computing.svg\";i:41;s:15:\"combination.svg\";i:42;s:11:\"compass.svg\";i:43;s:16:\"computer-cpu.svg\";i:44;s:10:\"cursor.svg\";i:45;s:10:\"delete.svg\";i:46;s:14:\"devices(2).svg\";i:47;s:11:\"devices.svg\";i:48;s:14:\"directions.svg\";i:49;s:17:\"discuss-issue.svg\";i:50;s:21:\"electrical-worker.svg\";i:51;s:17:\"elemental-tip.svg\";i:52;s:9:\"email.svg\";i:53;s:14:\"erase-text.svg\";i:54;s:10:\"expand.svg\";i:55;s:12:\"facebook.svg\";i:56;s:10:\"family.svg\";i:57;s:23:\"fast-forward-square.svg\";i:58;s:22:\"fingerprint-scan-1.svg\";i:59;s:42:\"fire-inside-a-home-like-heating-symbol.svg\";i:60;s:9:\"flash.svg\";i:61;s:13:\"furniture.svg\";i:62;s:15:\"google-plus.svg\";i:63;s:10:\"heater.svg\";i:64;s:8:\"help.svg\";i:65;s:15:\"high-volume.svg\";i:66;s:21:\"home-construction.svg\";i:67;s:13:\"home-lock.svg\";i:68;s:8:\"home.svg\";i:69;s:8:\"hood.svg\";i:70;s:15:\"hourglass-2.svg\";i:71;s:9:\"house.svg\";i:72;s:10:\"icon 1.svg\";i:73;s:11:\"icon 10.svg\";i:74;s:11:\"icon 11.svg\";i:75;s:11:\"icon 12.svg\";i:76;s:11:\"icon 13.svg\";i:77;s:11:\"icon 14.svg\";i:78;s:10:\"icon 2.svg\";i:79;s:10:\"icon 3.svg\";i:80;s:10:\"icon 4.svg\";i:81;s:10:\"icon 5.svg\";i:82;s:10:\"icon 6.svg\";i:83;s:10:\"icon 7.svg\";i:84;s:10:\"icon 8.svg\";i:85;s:10:\"icon 9.svg\";i:86;s:8:\"idea.svg\";i:87;s:13:\"instagram.svg\";i:88;s:13:\"insurance.svg\";i:89;s:8:\"lamp.svg\";i:90;s:13:\"laptop(2).svg\";i:91;s:13:\"laptop(3).svg\";i:92;s:12:\"laptop-2.svg\";i:93;s:19:\"laptop-settings.svg\";i:94;s:10:\"laptop.svg\";i:95;s:17:\"light-bulb(2).svg\";i:96;s:14:\"light-bulb.svg\";i:97;s:9:\"light.svg\";i:98;s:12:\"linkedin.svg\";i:99;s:11:\"manager.svg\";i:100;s:18:\"mechanic-tools.svg\";i:101;s:18:\"mouse-settings.svg\";i:102;s:9:\"mouse.svg\";i:103;s:12:\"new-file.svg\";i:104;s:16:\"notification.svg\";i:105;s:24:\"old-radio-microphone.svg\";i:106;s:19:\"on-time-support.svg\";i:107;s:16:\"organization.svg\";i:108;s:63:\"padlock-black-opened-tool-shape-for-unlock-interface-symbol.svg\";i:109;s:11:\"padlock.svg\";i:110;s:11:\"parking.svg\";i:111;s:14:\"phone-call.svg\";i:112;s:12:\"plug (1).svg\";i:113;s:8:\"plug.svg\";i:114;s:9:\"plug2.svg\";i:115;s:9:\"power.svg\";i:116;s:18:\"refresh-button.svg\";i:117;s:17:\"reload-arrows.svg\";i:118;s:23:\"remote-control-1(2).svg\";i:119;s:20:\"remote-control-1.svg\";i:120;s:23:\"remote-control-2(2).svg\";i:121;s:20:\"remote-control-2.svg\";i:122;s:24:\"renewable-energy (1).svg\";i:123;s:20:\"renewable-energy.svg\";i:124;s:14:\"retirement.svg\";i:125;s:10:\"rocket.svg\";i:126;s:27:\"school-maths-calculator.svg\";i:127;s:10:\"search.svg\";i:128;s:21:\"security-camera-1.svg\";i:129;s:21:\"security-camera-3.svg\";i:130;s:16:\"settings (1).svg\";i:131;s:15:\"settings(2).svg\";i:132;s:24:\"settings-with-hammer.svg\";i:133;s:12:\"settings.svg\";i:134;s:21:\"share-data-signal.svg\";i:135;s:9:\"share.svg\";i:136;s:17:\"shopping-cart.svg\";i:137;s:10:\"shower.svg\";i:138;s:14:\"skype-logo.svg\";i:139;s:16:\"smart-home-1.svg\";i:140;s:16:\"smart-home-4.svg\";i:141;s:16:\"smart-home-5.svg\";i:142;s:16:\"smart-home-6.svg\";i:143;s:16:\"smart-home-9.svg\";i:144;s:17:\"smartphone(2).svg\";i:145;s:17:\"smartphone(6).svg\";i:146;s:16:\"smartphone-1.svg\";i:147;s:16:\"smartphone-2.svg\";i:148;s:14:\"smartphone.svg\";i:149;s:10:\"socket.svg\";i:150;s:22:\"softtware-engineer.svg\";i:151;s:16:\"solar-energy.svg\";i:152;s:13:\"stopwatch.svg\";i:153;s:12:\"suitcase.svg\";i:154;s:11:\"support.svg\";i:155;s:10:\"switch.svg\";i:156;s:12:\"target-1.svg\";i:157;s:14:\"thermostat.svg\";i:158;s:7:\"tie.svg\";i:159;s:11:\"tracker.svg\";i:160;s:11:\"twitter.svg\";i:161;s:13:\"unlocked2.svg\";i:162;s:20:\"upload-to-cloud2.svg\";i:163;s:9:\"user2.svg\";i:164;s:9:\"water.svg\";i:165;s:8:\"wifi.svg\";i:166;s:12:\"windmill.svg\";i:167;s:14:\"window (1).svg\";i:168;s:14:\"window (2).svg\";i:169;s:13:\"window(2).svg\";i:170;s:10:\"window.svg\";}s:15:\"New Collection2\";a:80:{i:0;s:8:\"chat.svg\";i:1;s:13:\"bar-chart.svg\";i:2;s:11:\"user-12.svg\";i:3;s:14:\"transfer-1.svg\";i:4;s:19:\"cloud-computing.svg\";i:5;s:11:\"refresh.svg\";i:6;s:14:\"transfer-2.svg\";i:7;s:18:\"shopping-bag-1.svg\";i:8;s:10:\"target.svg\";i:9;s:14:\"settings-2.svg\";i:10;s:16:\"networking-2.svg\";i:11;s:14:\"piggy-bank.svg\";i:12;s:12:\"transfer.svg\";i:13;s:9:\"mouse.svg\";i:14;s:14:\"smartphone.svg\";i:15;s:16:\"networking-3.svg\";i:16;s:11:\"user-17.svg\";i:17;s:11:\"package.svg\";i:18;s:8:\"team.svg\";i:19;s:8:\"desk.svg\";i:20;s:12:\"teamwork.svg\";i:21;s:14:\"networking.svg\";i:22;s:10:\"user-6.svg\";i:23;s:11:\"user-13.svg\";i:24;s:11:\"group-2.svg\";i:25;s:17:\"dollar-symbol.svg\";i:26;s:8:\"user.svg\";i:27;s:14:\"binoculars.svg\";i:28;s:11:\"startup.svg\";i:29;s:10:\"user-5.svg\";i:30;s:10:\"like-2.svg\";i:31;s:10:\"user-4.svg\";i:32;s:11:\"padlock.svg\";i:33;s:19:\"dollar-symbol-1.svg\";i:34;s:16:\"presentation.svg\";i:35;s:14:\"transfer-3.svg\";i:36;s:13:\"handshake.svg\";i:37;s:14:\"settings-3.svg\";i:38;s:12:\"strategy.svg\";i:39;s:8:\"next.svg\";i:40;s:10:\"user-7.svg\";i:41;s:10:\"laptop.svg\";i:42;s:13:\"pie-chart.svg\";i:43;s:11:\"user-16.svg\";i:44;s:11:\"user-19.svg\";i:45;s:11:\"user-10.svg\";i:46;s:9:\"group.svg\";i:47;s:14:\"settings-1.svg\";i:48;s:10:\"user-8.svg\";i:49;s:11:\"user-15.svg\";i:50;s:10:\"like-1.svg\";i:51;s:16:\"networking-1.svg\";i:52;s:12:\"download.svg\";i:53;s:10:\"user-9.svg\";i:54;s:11:\"printer.svg\";i:55;s:11:\"group-1.svg\";i:56;s:13:\"worldwide.svg\";i:57;s:8:\"list.svg\";i:58;s:11:\"user-14.svg\";i:59;s:11:\"user-18.svg\";i:60;s:10:\"upload.svg\";i:61;s:12:\"settings.svg\";i:62;s:10:\"user-1.svg\";i:63;s:8:\"like.svg\";i:64;s:12:\"previous.svg\";i:65;s:7:\"add.svg\";i:66;s:16:\"shopping-bag.svg\";i:67;s:11:\"user-11.svg\";i:68;s:15:\"pie-chart-1.svg\";i:69;s:12:\"laptop-1.svg\";i:70;s:12:\"laptop-2.svg\";i:71;s:12:\"computer.svg\";i:72;s:16:\"piggy-bank-1.svg\";i:73;s:10:\"user-2.svg\";i:74;s:17:\"speech-bubble.svg\";i:75;s:10:\"pencil.svg\";i:76;s:10:\"list-1.svg\";i:77;s:16:\"office-block.svg\";i:78;s:11:\"compass.svg\";i:79;s:10:\"user-3.svg\";}s:11:\"SVGIconPack\";a:171:{i:0;s:14:\"010-heater.svg\";i:1;s:18:\"011-light-bulb.svg\";i:2;s:14:\"022-garage.svg\";i:3;s:18:\"025-flashlight.svg\";i:4;s:16:\"026-password.svg\";i:5;s:13:\"028-house.svg\";i:6;s:15:\"051-alarm-1.svg\";i:7;s:18:\"051-alarm-bell.svg\";i:8;s:12:\"051-bell.svg\";i:9;s:14:\"051-cctv-1.svg\";i:10;s:12:\"051-cctv.svg\";i:11;s:11:\"051-eye.svg\";i:12;s:15:\"051-flasher.svg\";i:13;s:12:\"051-home.svg\";i:14;s:15:\"051-nuclear.svg\";i:15;s:15:\"051-padlock.svg\";i:16;s:18:\"051-password-1.svg\";i:17;s:16:\"051-password.svg\";i:18;s:19:\"051-safety-belt.svg\";i:19;s:16:\"051-shield-1.svg\";i:20;s:16:\"051-umbrella.svg\";i:21;s:12:\"051-wifi.svg\";i:22;s:9:\"apple.svg\";i:23;s:12:\"armchair.svg\";i:24;s:20:\"audio-speaker-on.svg\";i:25;s:19:\"battery-warning.svg\";i:26;s:10:\"bell-1.svg\";i:27;s:20:\"big-full-battery.svg\";i:28;s:26:\"big-square-play-button.svg\";i:29;s:25:\"big-television-screen.svg\";i:30;s:14:\"big-trophy.svg\";i:31;s:19:\"big-world-globe.svg\";i:32;s:10:\"blinds.svg\";i:33;s:13:\"browser-1.svg\";i:34;s:14:\"calendar-4.svg\";i:35;s:12:\"calendar.svg\";i:36;s:10:\"cctv-1.svg\";i:37;s:8:\"chat.svg\";i:38;s:15:\"checked (1).svg\";i:39;s:11:\"clock-3.svg\";i:40;s:19:\"cloud-computing.svg\";i:41;s:15:\"combination.svg\";i:42;s:11:\"compass.svg\";i:43;s:16:\"computer-cpu.svg\";i:44;s:10:\"cursor.svg\";i:45;s:10:\"delete.svg\";i:46;s:14:\"devices(2).svg\";i:47;s:11:\"devices.svg\";i:48;s:14:\"directions.svg\";i:49;s:17:\"discuss-issue.svg\";i:50;s:21:\"electrical-worker.svg\";i:51;s:17:\"elemental-tip.svg\";i:52;s:9:\"email.svg\";i:53;s:14:\"erase-text.svg\";i:54;s:10:\"expand.svg\";i:55;s:12:\"facebook.svg\";i:56;s:10:\"family.svg\";i:57;s:23:\"fast-forward-square.svg\";i:58;s:22:\"fingerprint-scan-1.svg\";i:59;s:42:\"fire-inside-a-home-like-heating-symbol.svg\";i:60;s:9:\"flash.svg\";i:61;s:13:\"furniture.svg\";i:62;s:15:\"google-plus.svg\";i:63;s:10:\"heater.svg\";i:64;s:8:\"help.svg\";i:65;s:15:\"high-volume.svg\";i:66;s:21:\"home-construction.svg\";i:67;s:13:\"home-lock.svg\";i:68;s:8:\"home.svg\";i:69;s:8:\"hood.svg\";i:70;s:15:\"hourglass-2.svg\";i:71;s:9:\"house.svg\";i:72;s:10:\"icon 1.svg\";i:73;s:11:\"icon 10.svg\";i:74;s:11:\"icon 11.svg\";i:75;s:11:\"icon 12.svg\";i:76;s:11:\"icon 13.svg\";i:77;s:11:\"icon 14.svg\";i:78;s:10:\"icon 2.svg\";i:79;s:10:\"icon 3.svg\";i:80;s:10:\"icon 4.svg\";i:81;s:10:\"icon 5.svg\";i:82;s:10:\"icon 6.svg\";i:83;s:10:\"icon 7.svg\";i:84;s:10:\"icon 8.svg\";i:85;s:10:\"icon 9.svg\";i:86;s:8:\"idea.svg\";i:87;s:13:\"instagram.svg\";i:88;s:13:\"insurance.svg\";i:89;s:8:\"lamp.svg\";i:90;s:13:\"laptop(2).svg\";i:91;s:13:\"laptop(3).svg\";i:92;s:12:\"laptop-2.svg\";i:93;s:19:\"laptop-settings.svg\";i:94;s:10:\"laptop.svg\";i:95;s:17:\"light-bulb(2).svg\";i:96;s:14:\"light-bulb.svg\";i:97;s:9:\"light.svg\";i:98;s:12:\"linkedin.svg\";i:99;s:11:\"manager.svg\";i:100;s:18:\"mechanic-tools.svg\";i:101;s:18:\"mouse-settings.svg\";i:102;s:9:\"mouse.svg\";i:103;s:12:\"new-file.svg\";i:104;s:16:\"notification.svg\";i:105;s:24:\"old-radio-microphone.svg\";i:106;s:19:\"on-time-support.svg\";i:107;s:16:\"organization.svg\";i:108;s:63:\"padlock-black-opened-tool-shape-for-unlock-interface-symbol.svg\";i:109;s:11:\"padlock.svg\";i:110;s:11:\"parking.svg\";i:111;s:14:\"phone-call.svg\";i:112;s:12:\"plug (1).svg\";i:113;s:8:\"plug.svg\";i:114;s:9:\"plug2.svg\";i:115;s:9:\"power.svg\";i:116;s:18:\"refresh-button.svg\";i:117;s:17:\"reload-arrows.svg\";i:118;s:23:\"remote-control-1(2).svg\";i:119;s:20:\"remote-control-1.svg\";i:120;s:23:\"remote-control-2(2).svg\";i:121;s:20:\"remote-control-2.svg\";i:122;s:24:\"renewable-energy (1).svg\";i:123;s:20:\"renewable-energy.svg\";i:124;s:14:\"retirement.svg\";i:125;s:10:\"rocket.svg\";i:126;s:27:\"school-maths-calculator.svg\";i:127;s:10:\"search.svg\";i:128;s:21:\"security-camera-1.svg\";i:129;s:21:\"security-camera-3.svg\";i:130;s:16:\"settings (1).svg\";i:131;s:15:\"settings(2).svg\";i:132;s:24:\"settings-with-hammer.svg\";i:133;s:12:\"settings.svg\";i:134;s:21:\"share-data-signal.svg\";i:135;s:9:\"share.svg\";i:136;s:17:\"shopping-cart.svg\";i:137;s:10:\"shower.svg\";i:138;s:14:\"skype-logo.svg\";i:139;s:16:\"smart-home-1.svg\";i:140;s:16:\"smart-home-4.svg\";i:141;s:16:\"smart-home-5.svg\";i:142;s:16:\"smart-home-6.svg\";i:143;s:16:\"smart-home-9.svg\";i:144;s:17:\"smartphone(2).svg\";i:145;s:17:\"smartphone(6).svg\";i:146;s:16:\"smartphone-1.svg\";i:147;s:16:\"smartphone-2.svg\";i:148;s:14:\"smartphone.svg\";i:149;s:10:\"socket.svg\";i:150;s:22:\"softtware-engineer.svg\";i:151;s:16:\"solar-energy.svg\";i:152;s:13:\"stopwatch.svg\";i:153;s:12:\"suitcase.svg\";i:154;s:11:\"support.svg\";i:155;s:10:\"switch.svg\";i:156;s:12:\"target-1.svg\";i:157;s:14:\"thermostat.svg\";i:158;s:7:\"tie.svg\";i:159;s:11:\"tracker.svg\";i:160;s:11:\"twitter.svg\";i:161;s:13:\"unlocked2.svg\";i:162;s:20:\"upload-to-cloud2.svg\";i:163;s:9:\"user2.svg\";i:164;s:9:\"water.svg\";i:165;s:8:\"wifi.svg\";i:166;s:12:\"windmill.svg\";i:167;s:14:\"window (1).svg\";i:168;s:14:\"window (2).svg\";i:169;s:13:\"window(2).svg\";i:170;s:10:\"window.svg\";}s:19:\"SVGIconPack-Landing\";a:80:{i:0;s:8:\"chat.svg\";i:1;s:13:\"bar-chart.svg\";i:2;s:11:\"user-12.svg\";i:3;s:14:\"transfer-1.svg\";i:4;s:19:\"cloud-computing.svg\";i:5;s:11:\"refresh.svg\";i:6;s:14:\"transfer-2.svg\";i:7;s:18:\"shopping-bag-1.svg\";i:8;s:10:\"target.svg\";i:9;s:14:\"settings-2.svg\";i:10;s:16:\"networking-2.svg\";i:11;s:14:\"piggy-bank.svg\";i:12;s:12:\"transfer.svg\";i:13;s:9:\"mouse.svg\";i:14;s:14:\"smartphone.svg\";i:15;s:16:\"networking-3.svg\";i:16;s:11:\"user-17.svg\";i:17;s:11:\"package.svg\";i:18;s:8:\"team.svg\";i:19;s:8:\"desk.svg\";i:20;s:12:\"teamwork.svg\";i:21;s:14:\"networking.svg\";i:22;s:10:\"user-6.svg\";i:23;s:11:\"user-13.svg\";i:24;s:11:\"group-2.svg\";i:25;s:17:\"dollar-symbol.svg\";i:26;s:8:\"user.svg\";i:27;s:14:\"binoculars.svg\";i:28;s:11:\"startup.svg\";i:29;s:10:\"user-5.svg\";i:30;s:10:\"like-2.svg\";i:31;s:10:\"user-4.svg\";i:32;s:11:\"padlock.svg\";i:33;s:19:\"dollar-symbol-1.svg\";i:34;s:16:\"presentation.svg\";i:35;s:14:\"transfer-3.svg\";i:36;s:13:\"handshake.svg\";i:37;s:14:\"settings-3.svg\";i:38;s:12:\"strategy.svg\";i:39;s:8:\"next.svg\";i:40;s:10:\"user-7.svg\";i:41;s:10:\"laptop.svg\";i:42;s:13:\"pie-chart.svg\";i:43;s:11:\"user-16.svg\";i:44;s:11:\"user-19.svg\";i:45;s:11:\"user-10.svg\";i:46;s:9:\"group.svg\";i:47;s:14:\"settings-1.svg\";i:48;s:10:\"user-8.svg\";i:49;s:11:\"user-15.svg\";i:50;s:10:\"like-1.svg\";i:51;s:16:\"networking-1.svg\";i:52;s:12:\"download.svg\";i:53;s:10:\"user-9.svg\";i:54;s:11:\"printer.svg\";i:55;s:11:\"group-1.svg\";i:56;s:13:\"worldwide.svg\";i:57;s:8:\"list.svg\";i:58;s:11:\"user-14.svg\";i:59;s:11:\"user-18.svg\";i:60;s:10:\"upload.svg\";i:61;s:12:\"settings.svg\";i:62;s:10:\"user-1.svg\";i:63;s:8:\"like.svg\";i:64;s:12:\"previous.svg\";i:65;s:7:\"add.svg\";i:66;s:16:\"shopping-bag.svg\";i:67;s:11:\"user-11.svg\";i:68;s:15:\"pie-chart-1.svg\";i:69;s:12:\"laptop-1.svg\";i:70;s:12:\"laptop-2.svg\";i:71;s:12:\"computer.svg\";i:72;s:16:\"piggy-bank-1.svg\";i:73;s:10:\"user-2.svg\";i:74;s:17:\"speech-bubble.svg\";i:75;s:10:\"pencil.svg\";i:76;s:10:\"list-1.svg\";i:77;s:16:\"office-block.svg\";i:78;s:11:\"compass.svg\";i:79;s:10:\"user-3.svg\";}}","yes"),
("885","cwsfi","a:3:{s:2:\"td\";i:1549382881;s:3:\"css\";s:88:\"https://rtl.pars-themes.com/ingenious/wp-content/uploads/cws-flaticons/font/flaticon.css\";s:7:\"entries\";a:255:{i:0;s:15:\"shopping-cart-2\";i:1;s:55:\"logout-or-send-square-with-right-arrow-interface-symbol\";i:2;s:29:\"shopping-cart-empty-side-view\";i:3;s:15:\"shopping-cart-1\";i:4;s:4:\"cart\";i:5;s:8:\"up-arrow\";i:6;s:9:\"interface\";i:7;s:5:\"check\";i:8;s:10:\"left-quote\";i:9;s:6:\"quotes\";i:10;s:20:\"window-with-curtains\";i:11;s:6:\"window\";i:12;s:26:\"wind-turbine-outlined-tool\";i:13;s:10:\"windmill-2\";i:14;s:10:\"windmill-1\";i:15;s:8:\"windmill\";i:16;s:11:\"water-cycle\";i:17;s:8:\"raindrop\";i:18;s:4:\"drop\";i:19;s:15:\"upload-to-cloud\";i:20;s:8:\"unlocked\";i:21;s:7:\"tracker\";i:22;s:10:\"thermostat\";i:23;s:8:\"target-3\";i:24;s:8:\"target-2\";i:25;s:8:\"target-1\";i:26;s:6:\"target\";i:27;s:6:\"switch\";i:28;s:9:\"headset-2\";i:29;s:9:\"headset-1\";i:30;s:7:\"headset\";i:31;s:9:\"briefcase\";i:32;s:8:\"suitcase\";i:33;s:9:\"stopwatch\";i:34;s:14:\"solar-energy-2\";i:35;s:14:\"solar-energy-1\";i:36;s:11:\"solar-panel\";i:37;s:12:\"solar-energy\";i:38;s:18:\"softtware-engineer\";i:39;s:8:\"socket-3\";i:40;s:8:\"socket-2\";i:41;s:8:\"socket-1\";i:42;s:10:\"phone-lock\";i:43;s:12:\"smartphone-4\";i:44;s:12:\"smartphone-3\";i:45;s:16:\"message-on-phone\";i:46;s:12:\"smartphone-2\";i:47;s:12:\"smartphone-1\";i:48;s:10:\"smartphone\";i:49;s:6:\"home-3\";i:50;s:12:\"smart-home-4\";i:51;s:12:\"smart-home-3\";i:52;s:12:\"smart-home-2\";i:53;s:12:\"smart-home-1\";i:54;s:10:\"smart-home\";i:55;s:8:\"shower-2\";i:56;s:8:\"shower-1\";i:57;s:6:\"shower\";i:58;s:13:\"shopping-cart\";i:59;s:20:\"online-shopping-cart\";i:60;s:17:\"share-data-signal\";i:61;s:12:\"share-symbol\";i:62;s:4:\"tool\";i:63;s:10:\"settings-2\";i:64;s:20:\"settings-with-hammer\";i:65;s:10:\"settings-1\";i:66;s:13:\"hidden-camera\";i:67;s:25:\"surveillance-video-camera\";i:68;s:17:\"security-camera-1\";i:69;s:15:\"security-camera\";i:70;s:6:\"search\";i:71;s:23:\"school-maths-calculator\";i:72;s:6:\"rocket\";i:73;s:13:\"rocket-launch\";i:74;s:10:\"retirement\";i:75;s:21:\"leaf-inside-lightbulb\";i:76;s:18:\"renewable-energy-1\";i:77;s:16:\"renewable-energy\";i:78;s:16:\"remote-control-2\";i:79;s:16:\"remote-control-1\";i:80;s:14:\"remote-control\";i:81;s:8:\"garage-2\";i:82;s:6:\"rotate\";i:83;s:14:\"refresh-button\";i:84;s:16:\"power-button-off\";i:85;s:5:\"power\";i:86;s:50:\"ecological-energy-plug-symbol-with-cord-and-a-leaf\";i:87;s:9:\"eco-power\";i:88;s:10:\"eco-energy\";i:89;s:6:\"plug-2\";i:90;s:6:\"socket\";i:91;s:6:\"plug-1\";i:92;s:4:\"plug\";i:93;s:9:\"padlock-1\";i:94;s:15:\"on-time-support\";i:95;s:20:\"old-radio-microphone\";i:96;s:4:\"ring\";i:97;s:14:\"notification-1\";i:98;s:8:\"new-file\";i:99;s:16:\"mouse-peripheral\";i:100;s:13:\"mouse-clicker\";i:101;s:5:\"mouse\";i:102;s:14:\"mouse-settings\";i:103;s:14:\"mechanic-tools\";i:104;s:15:\"decision-making\";i:105;s:7:\"manager\";i:106;s:8:\"laptop-3\";i:107;s:8:\"laptop-2\";i:108;s:8:\"laptop-1\";i:109;s:6:\"laptop\";i:110;s:6:\"lamp-1\";i:111;s:4:\"lamp\";i:112;s:11:\"insurance-2\";i:113;s:11:\"insurance-1\";i:114;s:6:\"idea-2\";i:115;s:9:\"hourglass\";i:116;s:4:\"hood\";i:117;s:6:\"home-2\";i:118;s:9:\"home-lock\";i:119;s:7:\"house-1\";i:120;s:12:\"house-sketch\";i:121;s:4:\"help\";i:122;s:8:\"heater-1\";i:123;s:5:\"flash\";i:124;s:38:\"fire-inside-a-home-like-heating-symbol\";i:125;s:16:\"fingerprint-scan\";i:126;s:32:\"fingerprint-with-crosshair-focus\";i:127;s:19:\"fast-forward-square\";i:128;s:30:\"family-under-a-ceiling-outline\";i:129;s:6:\"family\";i:130;s:11:\"full-screen\";i:131;s:10:\"erase-text\";i:132;s:5:\"email\";i:133;s:21:\"opened-email-envelope\";i:134;s:13:\"elemental-tip\";i:135;s:11:\"electrician\";i:136;s:17:\"electrical-worker\";i:137;s:13:\"discuss-issue\";i:138;s:11:\"direction-1\";i:139;s:9:\"direction\";i:140;s:4:\"sign\";i:141;s:9:\"devices-1\";i:142;s:12:\"responsive-1\";i:143;s:7:\"devices\";i:144;s:6:\"cursor\";i:145;s:12:\"computer-cpu\";i:146;s:9:\"compass-1\";i:147;s:7:\"compass\";i:148;s:11:\"combination\";i:149;s:15:\"cloud-computing\";i:150;s:13:\"24-hour-clock\";i:151;s:10:\"24-hours-2\";i:152;s:10:\"24-hours-1\";i:153;s:8:\"24-hours\";i:154;s:13:\"speech-bubble\";i:155;s:6:\"chat-1\";i:156;s:4:\"chat\";i:157;s:10:\"calendar-3\";i:158;s:14:\"small-calendar\";i:159;s:10:\"calendar-2\";i:160;s:10:\"calendar-1\";i:161;s:8:\"calendar\";i:162;s:9:\"browser-2\";i:163;s:9:\"browser-1\";i:164;s:7:\"browser\";i:165;s:6:\"blinds\";i:166;s:15:\"big-world-globe\";i:167;s:10:\"big-trophy\";i:168;s:22:\"big-square-play-button\";i:169;s:9:\"battery-4\";i:170;s:9:\"battery-3\";i:171;s:9:\"battery-2\";i:172;s:9:\"battery-1\";i:173;s:6:\"bell-3\";i:174;s:12:\"notification\";i:175;s:7:\"battery\";i:176;s:17:\"battery-warning-1\";i:177;s:15:\"battery-warning\";i:178;s:6:\"volume\";i:179;s:9:\"speaker-2\";i:180;s:9:\"speaker-1\";i:181;s:7:\"speaker\";i:182;s:8:\"armchair\";i:183;s:7:\"apple-2\";i:184;s:7:\"apple-1\";i:185;s:5:\"apple\";i:186;s:34:\"apple-black-silhouette-with-a-leaf\";i:187;s:6:\"wifi-3\";i:188;s:6:\"wifi-2\";i:189;s:6:\"wifi-1\";i:190;s:4:\"wifi\";i:191;s:9:\"weather-3\";i:192;s:9:\"weather-2\";i:193;s:9:\"weather-1\";i:194;s:7:\"weather\";i:195;s:8:\"umbrella\";i:196;s:8:\"shield-2\";i:197;s:8:\"shield-1\";i:198;s:6:\"shield\";i:199;s:11:\"safety-belt\";i:200;s:4:\"hand\";i:201;s:8:\"security\";i:202;s:10:\"password-1\";i:203;s:6:\"lock-3\";i:204;s:6:\"lock-2\";i:205;s:6:\"lock-1\";i:206;s:4:\"lock\";i:207;s:7:\"padlock\";i:208;s:9:\"radiation\";i:209;s:14:\"nuclear-energy\";i:210;s:24:\"home-with-locked-padlock\";i:211;s:54:\"house-with-lock-outline-on-a-circular-black-background\";i:212;s:9:\"lock-home\";i:213;s:6:\"home-1\";i:214;s:13:\"flasher-light\";i:215;s:9:\"flasher-1\";i:216;s:7:\"flasher\";i:217;s:4:\"view\";i:218;s:5:\"eye-1\";i:219;s:3:\"eye\";i:220;s:6:\"cctv-1\";i:221;s:11:\"casino-cctv\";i:222;s:12:\"surveillance\";i:223;s:4:\"cctv\";i:224;s:6:\"danger\";i:225;s:6:\"bell-2\";i:226;s:6:\"bell-1\";i:227;s:4:\"bell\";i:228;s:5:\"music\";i:229;s:5:\"alarm\";i:230;s:12:\"construction\";i:231;s:4:\"home\";i:232;s:5:\"stack\";i:233;s:9:\"insurance\";i:234;s:5:\"house\";i:235;s:8:\"password\";i:236;s:10:\"flashlight\";i:237;s:8:\"garage-1\";i:238;s:13:\"car-in-garage\";i:239;s:6:\"garage\";i:240;s:8:\"eco-bulb\";i:241;s:6:\"idea-1\";i:242;s:4:\"idea\";i:243;s:10:\"light-bulb\";i:244;s:6:\"heater\";i:245;s:6:\"user-1\";i:246;s:4:\"user\";i:247;s:8:\"settings\";i:248;s:6:\"scroll\";i:249;s:20:\"responsive-marketing\";i:250;s:58:\"responsive-design-for-different-monitors-formats-and-sizes\";i:251;s:10:\"responsive\";i:252;s:7:\"refresh\";i:253;s:10:\"headphones\";i:254;s:9:\"drag-down\";}}","yes"),
("1039","cwsportfolio-cat_children","a:0:{}","yes"),
("1149","loco_settings","a:3:{s:1:\"c\";s:18:\"Loco_data_Settings\";s:1:\"v\";i:0;s:1:\"d\";a:11:{s:7:\"version\";s:5:\"2.1.2\";s:8:\"gen_hash\";b:0;s:9:\"use_fuzzy\";b:1;s:11:\"num_backups\";i:1;s:9:\"pot_alias\";a:3:{i:0;s:10:\"default.po\";i:1;s:8:\"en_US.po\";i:2;s:5:\"en.po\";}s:9:\"php_alias\";a:2:{i:0;s:3:\"php\";i:1;s:4:\"twig\";}s:10:\"fs_persist\";b:0;s:10:\"fs_protect\";i:1;s:12:\"max_php_size\";s:4:\"100K\";s:11:\"po_utf8_bom\";b:0;s:8:\"po_width\";s:2:\"79\";}}","yes"),
("1152","loco_recent","a:3:{s:1:\"c\";s:21:\"Loco_data_RecentItems\";s:1:\"v\";i:0;s:1:\"d\";a:1:{s:6:\"bundle\";a:1:{s:50:\"plugin.cws-portfolio-staff/cws-portfolio-staff.php\";i:1523018397;}}}","no"),
("1557","revslider_slide_editor_sticky","false","yes"),
("1721","current_theme_supports_woocommerce","yes","yes"),
("1722","woocommerce_queue_flush_rewrite_rules","no","yes"),
("1725","woocommerce_erasure_request_removes_order_data","no","no"),
("1726","woocommerce_erasure_request_removes_download_data","no","no"),
("1727","wp_page_for_privacy_policy","","yes"),
("1728","woocommerce_registration_privacy_policy_text","اطلاعات شخصی شما برای بهبود تجربه شما در این سایت و برای مدیریت دسترسی به حساب کاربری و یا دیگر اهداف ذکر شده در [privacy_policy] استفاده می گردد.","yes"),
("1729","woocommerce_checkout_privacy_policy_text","داده های شخصی شما برای پردازش سفارش شما مورد استفاده قرار می گیرد، تجربه شما را در این وب سایت و سایر موارد ذکر شده در [privacy_policy] ما پشتیبانی می کند","yes"),
("1730","woocommerce_delete_inactive_accounts","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","no"),
("1731","woocommerce_trash_pending_orders","","no"),
("1732","woocommerce_trash_failed_orders","","no"),
("1733","woocommerce_trash_cancelled_orders","","no"),
("1734","woocommerce_anonymize_completed_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","no"),
("1735","woocommerce_single_image_width","430","yes"),
("1736","woocommerce_thumbnail_image_width","400","yes"),
("1737","woocommerce_checkout_highlight_required_fields","yes","yes"),
("1739","default_product_cat","58","yes"),
("1808","woocommerce_thumbnail_cropping","1:1","yes"),
("2022","akismet_spam_count","1","yes"),
("6236","duplicator_pro_license_key","activated","yes"),
("6239","6cca33b1ed17892c7315622a31344aef","a:2:{s:7:\"timeout\";d:1564068149;s:5:\"value\";s:123:\"{\"new_version\":\"\",\"stable_version\":\"\",\"sections\":\"\",\"license_check\":\"\",\"msg\":\"License key is not valid for Duplicator Pro\"}\";}","yes"),
("8889","wpgmza_global_settings","{\"wpgmza_settings_marker_pull\":\"0\",\"wpgmza_gdpr_enabled\":1,\"wpgmza_gdpr_notice\":\"I agree for my personal data, provided via submission through \'User Generated Markers\' to be processed by {COMPANY_NAME}.\\r\\n\\t\\t\\r\\nI agree for my personal data, provided via map API calls, to be processed by the API provider, for the purposes of geocoding (converting addresses to coordinates).\\r\\n\\r\\nWhen using the User Generated Marker addon, data will be stored indefinitiely for the following purpose(s): {RETENTION_PURPOSE}\",\"wpgmza_gdpr_retention_purpose\":\"presenting the data you have submitted on the map.\",\"wpgmza_google_maps_api_key\":false,\"user_interface_style\":\"legacy\",\"wpgmza_marker_xml_location\":\"home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/wp-google-maps\\/\",\"wpgmza_marker_xml_url\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/wp-google-maps\\/\",\"internal_engine\":\"legacy\"}","yes"),
("11826","woocommerce_placeholder_image","4505","yes"),
("11827","woocommerce_allow_bulk_remove_personal_data","no","no"),
("11828","woocommerce_allow_tracking","no","no"),
("11829","woocommerce_show_marketplace_suggestions","no","no"),
("11853","persian_woocommerce_dismissed_notices","a:6:{i:0;b:0;i:1;s:14:\"checkout-tools\";i:2;s:15:\"tapin-dashboard\";i:3;s:11:\"tapin-tools\";i:4;s:12:\"persian-date\";i:5;s:3:\"pws\";}","yes"),
("11939","cwsfw_cust_id","1912","yes"),
("11970","woocommerce_maybe_regenerate_images_hash","91b4c9009722c706e00dfc584c4f8626","yes"),
("12036","show_comments_cookies_opt_in","1","yes"),
("12037","db_upgraded","","yes"),
("12043","recovery_keys","a:0:{}","yes"),
("19631","rs-templates-new","","no"),
("19632","rs-templates","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","no");

INSERT IGNORE INTO `wp_options` VALUES 
("19703","cws_plugin_ver","a:2:{s:4:\"data\";s:43930:\"<!DOCTYPE html>\n<html dir=\"rtl\" lang=\"fa-IR\">\n\n<head>\n	<meta charset=\'UTF-8\'>\n	<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n	<link rel=\"profile\" href=\"http://gmpg.org/xfn/11\">\n		<meta name=\'robots\' content=\'index, follow, max-image-preview:large, max-snippet:-1, max-video-preview:-1\' />\n\n	<!-- This site is optimized with the Yoast SEO plugin v19.2 - https://yoast.com/wordpress/plugins/seo/ -->\n	<title>شما به این سطح از خدمات دسترسی ندارید - شکن</title>\n	<link rel=\"canonical\" href=\"https://shecan.ir/denied/\" />\n	<meta property=\"og:locale\" content=\"fa_IR\" />\n	<meta property=\"og:type\" content=\"article\" />\n	<meta property=\"og:title\" content=\"شما به این سطح از خدمات دسترسی ندارید - شکن\" />\n	<meta property=\"og:description\" content=\"نحوه استفاده شما از خدمات تحریم‌شکن اینترنتی «شکن» خارج از شرایط مجاز در خدمات رایگان است. به همین دلیل دسترسی شما به این سطح از خدمات، مسدود شده است. ممکن است این مشکل به خاطر تنظیمات نامناسب توسط تأمین‌کننده اینترنت (ISP) شما و یا راهبر شبکه مورد استفاده شما برای [&hellip;]\" />\n	<meta property=\"og:url\" content=\"https://shecan.ir/denied/\" />\n	<meta property=\"og:site_name\" content=\"شکن\" />\n	<meta property=\"article:modified_time\" content=\"2022-06-30T07:49:44+00:00\" />\n	<meta name=\"author\" content=\"ابراهیم محمدی\" />\n	<meta name=\"twitter:card\" content=\"summary_large_image\" />\n	<meta name=\"twitter:site\" content=\"@shecan_ir\" />\n	<meta name=\"twitter:label1\" content=\"زمان تقریبی برای خواندن\" />\n	<meta name=\"twitter:data1\" content=\"1 دقیقه\" />\n	<script type=\"application/ld+json\" class=\"yoast-schema-graph\">{\"@context\":\"https://schema.org\",\"@graph\":[{\"@type\":\"WebSite\",\"@id\":\"https://shecan.ir/#website\",\"url\":\"https://shecan.ir/\",\"name\":\"شکن\",\"description\":\"شکن، یک تحریم‌شکن!\",\"potentialAction\":[{\"@type\":\"SearchAction\",\"target\":{\"@type\":\"EntryPoint\",\"urlTemplate\":\"https://shecan.ir/?s={search_term_string}\"},\"query-input\":\"required name=search_term_string\"}],\"inLanguage\":\"fa-IR\"},{\"@type\":\"WebPage\",\"@id\":\"https://shecan.ir/denied/#webpage\",\"url\":\"https://shecan.ir/denied/\",\"name\":\"شما به این سطح از خدمات دسترسی ندارید - شکن\",\"isPartOf\":{\"@id\":\"https://shecan.ir/#website\"},\"datePublished\":\"2021-09-19T13:25:09+00:00\",\"dateModified\":\"2022-06-30T07:49:44+00:00\",\"breadcrumb\":{\"@id\":\"https://shecan.ir/denied/#breadcrumb\"},\"inLanguage\":\"fa-IR\",\"potentialAction\":[{\"@type\":\"ReadAction\",\"target\":[\"https://shecan.ir/denied/\"]}]},{\"@type\":\"BreadcrumbList\",\"@id\":\"https://shecan.ir/denied/#breadcrumb\",\"itemListElement\":[{\"@type\":\"ListItem\",\"position\":1,\"name\":\"خانه\",\"item\":\"https://shecan.ir/\"},{\"@type\":\"ListItem\",\"position\":2,\"name\":\"شما به این سطح از خدمات دسترسی ندارید\"}]}]}</script>\n	<!-- / Yoast SEO plugin. -->\n\n\n<link rel=\'dns-prefetch\' href=\'//fonts.googleapis.com\' />\n<link rel=\'dns-prefetch\' href=\'//s.w.org\' />\n<link rel=\"alternate\" type=\"application/rss+xml\" title=\"شکن &raquo; خوراک\" href=\"https://shecan.ir/feed/\" />\n<link rel=\"alternate\" type=\"application/rss+xml\" title=\"شکن &raquo; خوراک دیدگاه‌ها\" href=\"https://shecan.ir/comments/feed/\" />\n<script type=\"text/javascript\">\nwindow._wpemojiSettings = {\"baseUrl\":\"https:\\/\\/s.w.org\\/images\\/core\\/emoji\\/14.0.0\\/72x72\\/\",\"ext\":\".png\",\"svgUrl\":\"https:\\/\\/s.w.org\\/images\\/core\\/emoji\\/14.0.0\\/svg\\/\",\"svgExt\":\".svg\",\"source\":{\"concatemoji\":\"https:\\/\\/shecan.ir\\/wp-includes\\/js\\/wp-emoji-release.min.js?ver=6.0\"}};\n/*! This file is auto-generated */\n!function(e,a,t){var n,r,o,i=a.createElement(\"canvas\"),p=i.getContext&&i.getContext(\"2d\");function s(e,t){var a=String.fromCharCode,e=(p.clearRect(0,0,i.width,i.height),p.fillText(a.apply(this,e),0,0),i.toDataURL());return p.clearRect(0,0,i.width,i.height),p.fillText(a.apply(this,t),0,0),e===i.toDataURL()}function c(e){var t=a.createElement(\"script\");t.src=e,t.defer=t.type=\"text/javascript\",a.getElementsByTagName(\"head\")[0].appendChild(t)}for(o=Array(\"flag\",\"emoji\"),t.supports={everything:!0,everythingExceptFlag:!0},r=0;r<o.length;r++)t.supports[o[r]]=function(e){if(!p||!p.fillText)return!1;switch(p.textBaseline=\"top\",p.font=\"600 32px Arial\",e){case\"flag\":return s([127987,65039,8205,9895,65039],[127987,65039,8203,9895,65039])?!1:!s([55356,56826,55356,56819],[55356,56826,8203,55356,56819])&&!s([55356,57332,56128,56423,56128,56418,56128,56421,56128,56430,56128,56423,56128,56447],[55356,57332,8203,56128,56423,8203,56128,56418,8203,56128,56421,8203,56128,56430,8203,56128,56423,8203,56128,56447]);case\"emoji\":return!s([129777,127995,8205,129778,127999],[129777,127995,8203,129778,127999])}return!1}(o[r]),t.supports.everything=t.supports.everything&&t.supports[o[r]],\"flag\"!==o[r]&&(t.supports.everythingExceptFlag=t.supports.everythingExceptFlag&&t.supports[o[r]]);t.supports.everythingExceptFlag=t.supports.everythingExceptFlag&&!t.supports.flag,t.DOMReady=!1,t.readyCallback=function(){t.DOMReady=!0},t.supports.everything||(n=function(){t.readyCallback()},a.addEventListener?(a.addEventListener(\"DOMContentLoaded\",n,!1),e.addEventListener(\"load\",n,!1)):(e.attachEvent(\"onload\",n),a.attachEvent(\"onreadystatechange\",function(){\"complete\"===a.readyState&&t.readyCallback()})),(e=t.source||{}).concatemoji?c(e.concatemoji):e.wpemoji&&e.twemoji&&(c(e.twemoji),c(e.wpemoji)))}(window,document,window._wpemojiSettings);\n</script>\n<style type=\"text/css\">\nimg.wp-smiley,\nimg.emoji {\n	display: inline !important;\n	border: none !important;\n	box-shadow: none !important;\n	height: 1em !important;\n	width: 1em !important;\n	margin: 0 0.07em !important;\n	vertical-align: -0.1em !important;\n	background: none !important;\n	padding: 0 !important;\n}\n</style>\n	<link rel=\'stylesheet\' id=\'bootstrap-rtl-css\'  href=\'https://shecan.ir/wp-content/themes/hestia/assets/bootstrap/css/bootstrap-rtl.min.css?ver=1.0.2\' type=\'text/css\' media=\'all\' />\n<link rel=\'stylesheet\' id=\'hestia-font-sizes-css\'  href=\'https://shecan.ir/wp-content/themes/hestia/assets/css/font-sizes.min.css?ver=3.0.22\' type=\'text/css\' media=\'all\' />\n<link rel=\'stylesheet\' id=\'wp-block-library-rtl-css\'  href=\'https://shecan.ir/wp-includes/css/dist/block-library/style-rtl.min.css?ver=6.0\' type=\'text/css\' media=\'all\' />\n<style id=\'global-styles-inline-css\' type=\'text/css\'>\nbody{--wp--preset--color--black: #000000;--wp--preset--color--cyan-bluish-gray: #abb8c3;--wp--preset--color--white: #ffffff;--wp--preset--color--pale-pink: #f78da7;--wp--preset--color--vivid-red: #cf2e2e;--wp--preset--color--luminous-vivid-orange: #ff6900;--wp--preset--color--luminous-vivid-amber: #fcb900;--wp--preset--color--light-green-cyan: #7bdcb5;--wp--preset--color--vivid-green-cyan: #00d084;--wp--preset--color--pale-cyan-blue: #8ed1fc;--wp--preset--color--vivid-cyan-blue: #0693e3;--wp--preset--color--vivid-purple: #9b51e0;--wp--preset--color--accent: #41a87c;--wp--preset--color--background-color: #ffffff;--wp--preset--color--header-gradient: #41a87c;--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple: linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%);--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan: linear-gradient(135deg,rgb(122,220,180) 0%,rgb(0,208,130) 100%);--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange: linear-gradient(135deg,rgba(252,185,0,1) 0%,rgba(255,105,0,1) 100%);--wp--preset--gradient--luminous-vivid-orange-to-vivid-red: linear-gradient(135deg,rgba(255,105,0,1) 0%,rgb(207,46,46) 100%);--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray: linear-gradient(135deg,rgb(238,238,238) 0%,rgb(169,184,195) 100%);--wp--preset--gradient--cool-to-warm-spectrum: linear-gradient(135deg,rgb(74,234,220) 0%,rgb(151,120,209) 20%,rgb(207,42,186) 40%,rgb(238,44,130) 60%,rgb(251,105,98) 80%,rgb(254,248,76) 100%);--wp--preset--gradient--blush-light-purple: linear-gradient(135deg,rgb(255,206,236) 0%,rgb(152,150,240) 100%);--wp--preset--gradient--blush-bordeaux: linear-gradient(135deg,rgb(254,205,165) 0%,rgb(254,45,45) 50%,rgb(107,0,62) 100%);--wp--preset--gradient--luminous-dusk: linear-gradient(135deg,rgb(255,203,112) 0%,rgb(199,81,192) 50%,rgb(65,88,208) 100%);--wp--preset--gradient--pale-ocean: linear-gradient(135deg,rgb(255,245,203) 0%,rgb(182,227,212) 50%,rgb(51,167,181) 100%);--wp--preset--gradient--electric-grass: linear-gradient(135deg,rgb(202,248,128) 0%,rgb(113,206,126) 100%);--wp--preset--gradient--midnight: linear-gradient(135deg,rgb(2,3,129) 0%,rgb(40,116,252) 100%);--wp--preset--duotone--dark-grayscale: url(\'#wp-duotone-dark-grayscale\');--wp--preset--duotone--grayscale: url(\'#wp-duotone-grayscale\');--wp--preset--duotone--purple-yellow: url(\'#wp-duotone-purple-yellow\');--wp--preset--duotone--blue-red: url(\'#wp-duotone-blue-red\');--wp--preset--duotone--midnight: url(\'#wp-duotone-midnight\');--wp--preset--duotone--magenta-yellow: url(\'#wp-duotone-magenta-yellow\');--wp--preset--duotone--purple-green: url(\'#wp-duotone-purple-green\');--wp--preset--duotone--blue-orange: url(\'#wp-duotone-blue-orange\');--wp--preset--font-size--small: 13px;--wp--preset--font-size--medium: 20px;--wp--preset--font-size--large: 36px;--wp--preset--font-size--x-large: 42px;}.has-black-color{color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-color{color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-color{color: var(--wp--preset--color--white) !important;}.has-pale-pink-color{color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-color{color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-color{color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-color{color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-color{color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-color{color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-color{color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-color{color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-color{color: var(--wp--preset--color--vivid-purple) !important;}.has-black-background-color{background-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-background-color{background-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-background-color{background-color: var(--wp--preset--color--white) !important;}.has-pale-pink-background-color{background-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-background-color{background-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-background-color{background-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-background-color{background-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-background-color{background-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-background-color{background-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-background-color{background-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-background-color{background-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-background-color{background-color: var(--wp--preset--color--vivid-purple) !important;}.has-black-border-color{border-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-border-color{border-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-border-color{border-color: var(--wp--preset--color--white) !important;}.has-pale-pink-border-color{border-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-border-color{border-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-border-color{border-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-border-color{border-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-border-color{border-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-border-color{border-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-border-color{border-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-border-color{border-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-border-color{border-color: var(--wp--preset--color--vivid-purple) !important;}.has-vivid-cyan-blue-to-vivid-purple-gradient-background{background: var(--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple) !important;}.has-light-green-cyan-to-vivid-green-cyan-gradient-background{background: var(--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan) !important;}.has-luminous-vivid-amber-to-luminous-vivid-orange-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange) !important;}.has-luminous-vivid-orange-to-vivid-red-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-orange-to-vivid-red) !important;}.has-very-light-gray-to-cyan-bluish-gray-gradient-background{background: var(--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray) !important;}.has-cool-to-warm-spectrum-gradient-background{background: var(--wp--preset--gradient--cool-to-warm-spectrum) !important;}.has-blush-light-purple-gradient-background{background: var(--wp--preset--gradient--blush-light-purple) !important;}.has-blush-bordeaux-gradient-background{background: var(--wp--preset--gradient--blush-bordeaux) !important;}.has-luminous-dusk-gradient-background{background: var(--wp--preset--gradient--luminous-dusk) !important;}.has-pale-ocean-gradient-background{background: var(--wp--preset--gradient--pale-ocean) !important;}.has-electric-grass-gradient-background{background: var(--wp--preset--gradient--electric-grass) !important;}.has-midnight-gradient-background{background: var(--wp--preset--gradient--midnight) !important;}.has-small-font-size{font-size: var(--wp--preset--font-size--small) !important;}.has-medium-font-size{font-size: var(--wp--preset--font-size--medium) !important;}.has-large-font-size{font-size: var(--wp--preset--font-size--large) !important;}.has-x-large-font-size{font-size: var(--wp--preset--font-size--x-large) !important;}\n</style>\n<link rel=\'stylesheet\' id=\'hestia-style-rtl-css\'  href=\'https://shecan.ir/wp-content/themes/hestia/style-rtl.css?ver=6.0\' type=\'text/css\' media=\'all\' />\n<link rel=\'stylesheet\' id=\'hestia-child-editor-rtl-css\'  href=\'https://shecan.ir/wp-content/themes/hestia-child/editor-style-rtl.css?ver=6.0\' type=\'text/css\' media=\'all\' />\n<link rel=\'stylesheet\' id=\'hestia-child-style-rtl-css\'  href=\'https://shecan.ir/wp-content/themes/hestia-child/style-rtl.css?ver=6.0\' type=\'text/css\' media=\'all\' />\n<link rel=\'stylesheet\' id=\'hestia_style-rtl-css\'  href=\'https://shecan.ir/wp-content/themes/hestia-child/style.css?ver=3.0.22\' type=\'text/css\' media=\'all\' />\n<style id=\'hestia_style-inline-css\' type=\'text/css\'>\n\n		.elementor-page .hestia-about > .container {\n		  width: 100%;\n		}\n		.elementor-page .pagebuilder-section {\n		  padding: 0;\n		}\n		.elementor-page .title-in-content, .elementor-page .image-in-page {\n		  display: none;\n		}\n		\n		.home.elementor-page .main-raised > section.hestia-about {\n		  overflow: visible;\n		}\n		\n		.elementor-editor-active .navbar {\n		  pointer-events: none;\n		}\n		\n		.elementor-editor-active #elementor.elementor-edit-mode .elementor-element-overlay {\n		  z-index: 1000000;\n		}\n		\n		.elementor-page.page-template-template-fullwidth .blog-post-wrapper > .container {\n		  width: 100%;\n		}\n		.elementor-page.page-template-template-fullwidth .blog-post-wrapper > .container .col-md-12 {\n		  padding: 0;\n		}\n		.elementor-page.page-template-template-fullwidth article.section {\n		  padding: 0;\n		}\n\n		.elementor-text-editor p, \n		.elementor-text-editor h1, \n		.elementor-text-editor h2, \n		.elementor-text-editor h3, \n		.elementor-text-editor h4, \n		.elementor-text-editor h5, \n		.elementor-text-editor h6 {\n		  font-size: inherit;\n		}\n.hestia-top-bar, .hestia-top-bar .widget.widget_shopping_cart .cart_list {\n			background-color: #363537\n		}\n		.hestia-top-bar .widget .label-floating input[type=search]:-webkit-autofill {\n			-webkit-box-shadow: inset 0 0 0px 9999px #363537\n		}.hestia-top-bar, .hestia-top-bar .widget .label-floating input[type=search], .hestia-top-bar .widget.widget_search form.form-group:before, .hestia-top-bar .widget.widget_product_search form.form-group:before, .hestia-top-bar .widget.widget_shopping_cart:before {\n			color: #ffffff\n		} \n		.hestia-top-bar .widget .label-floating input[type=search]{\n			-webkit-text-fill-color:#ffffff !important \n		}\n		.hestia-top-bar div.widget.widget_shopping_cart:before, .hestia-top-bar .widget.widget_product_search form.form-group:before, .hestia-top-bar .widget.widget_search form.form-group:before{\n			background-color: #ffffff\n		}.hestia-top-bar a, .hestia-top-bar .top-bar-nav li a {\n			color: #ffffff\n		}\n		.hestia-top-bar ul li a[href*=\"mailto:\"]:before, .hestia-top-bar ul li a[href*=\"tel:\"]:before{\n			background-color: #ffffff\n		}\n		.hestia-top-bar a:hover, .hestia-top-bar .top-bar-nav li a:hover {\n			color: #eeeeee\n		}\n		.hestia-top-bar ul li:hover a[href*=\"mailto:\"]:before, .hestia-top-bar ul li:hover a[href*=\"tel:\"]:before{\n			background-color: #eeeeee\n		}\n		\n\n		a,\n		.navbar .dropdown-menu li:hover > a,\n		.navbar .dropdown-menu li:focus > a,\n		.navbar .dropdown-menu li:active > a,\n		.navbar .navbar-nav > li .dropdown-menu li:hover > a,\n		body:not(.home) .navbar-default .navbar-nav > .active:not(.btn) > a,\n		body:not(.home) .navbar-default .navbar-nav > .active:not(.btn) > a:hover,\n		body:not(.home) .navbar-default .navbar-nav > .active:not(.btn) > a:focus,\n		a:hover,\n		.card-blog a.moretag:hover,\n		.card-blog a.more-link:hover,\n		.widget a:hover,\n		.has-text-color.has-accent-color,\n		p.has-text-color a {\n		    color:#41a87c;\n		}\n		\n		.svg-text-color{\n			fill:#41a87c;\n		}\n		\n		.pagination span.current, .pagination span.current:focus, .pagination span.current:hover {\n			border-color:#41a87c\n		}\n		\n		button,\n		button:hover,\n		.woocommerce .track_order button[type=\"submit\"],\n		.woocommerce .track_order button[type=\"submit\"]:hover,\n		div.wpforms-container .wpforms-form button[type=submit].wpforms-submit,\n		div.wpforms-container .wpforms-form button[type=submit].wpforms-submit:hover,\n		input[type=\"button\"],\n		input[type=\"button\"]:hover,\n		input[type=\"submit\"],\n		input[type=\"submit\"]:hover,\n		input#searchsubmit,\n		.pagination span.current,\n		.pagination span.current:focus,\n		.pagination span.current:hover,\n		.btn.btn-primary,\n		.btn.btn-primary:link,\n		.btn.btn-primary:hover,\n		.btn.btn-primary:focus,\n		.btn.btn-primary:active,\n		.btn.btn-primary.active,\n		.btn.btn-primary.active:focus,\n		.btn.btn-primary.active:hover,\n		.btn.btn-primary:active:hover,\n		.btn.btn-primary:active:focus,\n		.btn.btn-primary:active:hover,\n		.hestia-sidebar-open.btn.btn-rose,\n		.hestia-sidebar-close.btn.btn-rose,\n		.hestia-sidebar-open.btn.btn-rose:hover,\n		.hestia-sidebar-close.btn.btn-rose:hover,\n		.hestia-sidebar-open.btn.btn-rose:focus,\n		.hestia-sidebar-close.btn.btn-rose:focus,\n		.label.label-primary,\n		.hestia-work .portfolio-item:nth-child(6n+1) .label,\n		.nav-cart .nav-cart-content .widget .buttons .button,\n		.has-accent-background-color[class*=\"has-background\"] {\n		    background-color: #41a87c;\n		}\n		\n		@media (max-width: 768px) {\n	\n			.navbar-default .navbar-nav>li>a:hover,\n			.navbar-default .navbar-nav>li>a:focus,\n			.navbar .navbar-nav .dropdown .dropdown-menu li a:hover,\n			.navbar .navbar-nav .dropdown .dropdown-menu li a:focus,\n			.navbar button.navbar-toggle:hover,\n			.navbar .navbar-nav li:hover > a i {\n			    color: #41a87c;\n			}\n		}\n		\n		body:not(.woocommerce-page) button:not([class^=\"fl-\"]):not(.hestia-scroll-to-top):not(.navbar-toggle):not(.close),\n		body:not(.woocommerce-page) .button:not([class^=\"fl-\"]):not(hestia-scroll-to-top):not(.navbar-toggle):not(.add_to_cart_button):not(.product_type_grouped):not(.product_type_external),\n		div.wpforms-container .wpforms-form button[type=submit].wpforms-submit,\n		input[type=\"submit\"],\n		input[type=\"button\"],\n		.btn.btn-primary,\n		.widget_product_search button[type=\"submit\"],\n		.hestia-sidebar-open.btn.btn-rose,\n		.hestia-sidebar-close.btn.btn-rose,\n		.everest-forms button[type=submit].everest-forms-submit-button {\n		    -webkit-box-shadow: 0 2px 2px 0 rgba(65,168,124,0.14),0 3px 1px -2px rgba(65,168,124,0.2),0 1px 5px 0 rgba(65,168,124,0.12);\n		    box-shadow: 0 2px 2px 0 rgba(65,168,124,0.14),0 3px 1px -2px rgba(65,168,124,0.2),0 1px 5px 0 rgba(65,168,124,0.12);\n		}\n		\n		.card .header-primary, .card .content-primary,\n		.everest-forms button[type=submit].everest-forms-submit-button {\n		    background: #41a87c;\n		}\n		\n		body:not(.woocommerce-page) .button:not([class^=\"fl-\"]):not(.hestia-scroll-to-top):not(.navbar-toggle):not(.add_to_cart_button):hover,\n		body:not(.woocommerce-page) button:not([class^=\"fl-\"]):not(.hestia-scroll-to-top):not(.navbar-toggle):not(.close):hover,\n		div.wpforms-container .wpforms-form button[type=submit].wpforms-submit:hover,\n		input[type=\"submit\"]:hover,\n		input[type=\"button\"]:hover,\n		input#searchsubmit:hover,\n		.widget_product_search button[type=\"submit\"]:hover,\n		.pagination span.current,\n		.btn.btn-primary:hover,\n		.btn.btn-primary:focus,\n		.btn.btn-primary:active,\n		.btn.btn-primary.active,\n		.btn.btn-primary:active:focus,\n		.btn.btn-primary:active:hover,\n		.hestia-sidebar-open.btn.btn-rose:hover,\n		.hestia-sidebar-close.btn.btn-rose:hover,\n		.pagination span.current:hover,\n		.everest-forms button[type=submit].everest-forms-submit-button:hover,\n 		.everest-forms button[type=submit].everest-forms-submit-button:focus,\n 		.everest-forms button[type=submit].everest-forms-submit-button:active {\n			-webkit-box-shadow: 0 14px 26px -12px rgba(65,168,124,0.42),0 4px 23px 0 rgba(0,0,0,0.12),0 8px 10px -5px rgba(65,168,124,0.2);\n		    box-shadow: 0 14px 26px -12px rgba(65,168,124,0.42),0 4px 23px 0 rgba(0,0,0,0.12),0 8px 10px -5px rgba(65,168,124,0.2);\n			color: #fff;\n		}\n		\n		.form-group.is-focused .form-control {\n			background-image: -webkit-gradient(linear,left top, left bottom,from(#41a87c),to(#41a87c)),-webkit-gradient(linear,left top, left bottom,from(#d2d2d2),to(#d2d2d2));\n			background-image: -webkit-linear-gradient(linear,left top, left bottom,from(#41a87c),to(#41a87c)),-webkit-linear-gradient(linear,left top, left bottom,from(#d2d2d2),to(#d2d2d2));\n			background-image: linear-gradient(linear,left top, left bottom,from(#41a87c),to(#41a87c)),linear-gradient(linear,left top, left bottom,from(#d2d2d2),to(#d2d2d2));\n		}\n		\n		.navbar:not(.navbar-transparent) li:not(.btn):hover > a,\n		.navbar li.on-section:not(.btn) > a,\n		.navbar.full-screen-menu.navbar-transparent li:not(.btn):hover > a,\n		.navbar.full-screen-menu .navbar-toggle:hover,\n		.navbar:not(.navbar-transparent) .nav-cart:hover,\n		.navbar:not(.navbar-transparent) .hestia-toggle-search:hover {\n				color:#41a87c\n		}\n		\n			.header-filter-gradient {\n				background: linear-gradient(-45deg, rgba(65,168,124,1) 0%, rgb(131,196,103) 100%);\n			}\n			.has-text-color.has-header-gradient-color { color: #41a87c; }\n			.has-header-gradient-background-color[class*=\"has-background\"] { background-color: #41a87c; }\n			\n		.has-text-color.has-background-color-color { color: #ffffff; }\n		.has-background-color-background-color[class*=\"has-background\"] { background-color: #ffffff; }\n		\n.btn.btn-primary:not(.colored-button):not(.btn-left):not(.btn-right):not(.btn-just-icon):not(.menu-item), input[type=\"submit\"]:not(.search-submit), body:not(.woocommerce-account) .woocommerce .button.woocommerce-Button, .woocommerce .product button.button, .woocommerce .product button.button.alt, .woocommerce .product #respond input#submit, .woocommerce-cart .blog-post .woocommerce .cart-collaterals .cart_totals .checkout-button, .woocommerce-checkout #payment #place_order, .woocommerce-account.woocommerce-page button.button, .woocommerce .track_order button[type=\"submit\"], .nav-cart .nav-cart-content .widget .buttons .button, .woocommerce a.button.wc-backward, body.woocommerce .wccm-catalog-item a.button, body.woocommerce a.wccm-button.button, form.woocommerce-form-coupon button.button, div.wpforms-container .wpforms-form button[type=submit].wpforms-submit, div.woocommerce a.button.alt, div.woocommerce table.my_account_orders .button, .btn.colored-button, .btn.btn-left, .btn.btn-right, .btn:not(.colored-button):not(.btn-left):not(.btn-right):not(.btn-just-icon):not(.menu-item):not(.hestia-sidebar-open):not(.hestia-sidebar-close){ padding-top:15px;  padding-bottom:15px;  padding-left:33px;  padding-right:33px; }\n.btn.btn-primary:not(.colored-button):not(.btn-left):not(.btn-right):not(.btn-just-icon):not(.menu-item), input[type=\"submit\"]:not(.search-submit), body:not(.woocommerce-account) .woocommerce .button.woocommerce-Button, .woocommerce .product button.button, .woocommerce .product button.button.alt, .woocommerce .product #respond input#submit, .woocommerce-cart .blog-post .woocommerce .cart-collaterals .cart_totals .checkout-button, .woocommerce-checkout #payment #place_order, .woocommerce-account.woocommerce-page button.button, .woocommerce .track_order button[type=\"submit\"], .nav-cart .nav-cart-content .widget .buttons .button, .woocommerce a.button.wc-backward, body.woocommerce .wccm-catalog-item a.button, body.woocommerce a.wccm-button.button, form.woocommerce-form-coupon button.button, div.wpforms-container .wpforms-form button[type=submit].wpforms-submit, div.woocommerce a.button.alt, div.woocommerce table.my_account_orders .button, input[type=\"submit\"].search-submit, .hestia-view-cart-wrapper .added_to_cart.wc-forward, .woocommerce-product-search button, .woocommerce-cart .actions .button, #secondary div[id^=woocommerce_price_filter] .button, .woocommerce div[id^=woocommerce_widget_cart].widget .buttons .button, .searchform input[type=submit], .searchform button, .search-form:not(.media-toolbar-primary) input[type=submit], .search-form:not(.media-toolbar-primary) button, .woocommerce-product-search input[type=submit], .btn.colored-button, .btn.btn-left, .btn.btn-right, .btn:not(.colored-button):not(.btn-left):not(.btn-right):not(.btn-just-icon):not(.menu-item):not(.hestia-sidebar-open):not(.hestia-sidebar-close){border-radius:50px;}\n@media (min-width: 769px){\n			.page-header.header-small .hestia-title,\n			.page-header.header-small .title,\n			h1.hestia-title.title-in-content,\n			.main article.section .has-title-font-size {\n				font-size: 42px;\n			}}\n</style>\n<link rel=\'stylesheet\' id=\'hestia_fonts-css\'  href=\'https://fonts.googleapis.com/css?family=Roboto%3A300%2C400%2C500%2C700%7CRoboto+Slab%3A400%2C700&#038;subset=latin%2Clatin-ext&#038;ver=3.0.22\' type=\'text/css\' media=\'all\' />\n<script type=\'text/javascript\' src=\'https://shecan.ir/wp-includes/js/jquery/jquery.min.js?ver=3.6.0\' id=\'jquery-core-js\'></script>\n<script type=\'text/javascript\' src=\'https://shecan.ir/wp-includes/js/jquery/jquery-migrate.min.js?ver=3.3.2\' id=\'jquery-migrate-js\'></script>\n<script type=\'text/javascript\' src=\'https://shecan.ir/wp-content/themes/hestia-child/js/myscript.js?ver=6.0\' id=\'myscript-js\'></script>\n<script type=\'text/javascript\' src=\'https://shecan.ir/wp-content/themes/hestia-child/particles/particles.min.js?ver=6.0\' id=\'particles-script-js\'></script>\n<script type=\'text/javascript\' src=\'https://shecan.ir/wp-content/themes/hestia-child/particles/part-app.js?ver=6.0\' id=\'particles-ploader-js\'></script>\n<link rel=\"https://api.w.org/\" href=\"https://shecan.ir/wp-json/\" /><link rel=\"alternate\" type=\"application/json\" href=\"https://shecan.ir/wp-json/wp/v2/pages/1374\" /><link rel=\"EditURI\" type=\"application/rsd+xml\" title=\"RSD\" href=\"https://shecan.ir/xmlrpc.php?rsd\" />\n<link rel=\"wlwmanifest\" type=\"application/wlwmanifest+xml\" href=\"https://shecan.ir/wp-includes/wlwmanifest.xml\" /> \n<meta name=\"generator\" content=\"WordPress 6.0\" />\n<link rel=\'shortlink\' href=\'https://shecan.ir/?p=1374\' />\n<link rel=\"alternate\" type=\"application/json+oembed\" href=\"https://shecan.ir/wp-json/oembed/1.0/embed?url=https%3A%2F%2Fshecan.ir%2Fdenied%2F\" />\n<link rel=\"alternate\" type=\"text/xml+oembed\" href=\"https://shecan.ir/wp-json/oembed/1.0/embed?url=https%3A%2F%2Fshecan.ir%2Fdenied%2F&#038;format=xml\" />\n<style type=\"text/css\">.recentcomments a{display:inline !important;padding:0 !important;margin:0 !important;}</style><style type=\"text/css\" id=\"custom-background-css\">\nbody.custom-background { background-color: #ffffff; }\n</style>\n	<link rel=\"icon\" href=\"https://shecan.ir/wp-content/uploads/2018/11/logo-1.png\" sizes=\"32x32\" />\n<link rel=\"icon\" href=\"https://shecan.ir/wp-content/uploads/2018/11/logo-1.png\" sizes=\"192x192\" />\n<link rel=\"apple-touch-icon\" href=\"https://shecan.ir/wp-content/uploads/2018/11/logo-1.png\" />\n<meta name=\"msapplication-TileImage\" content=\"https://shecan.ir/wp-content/uploads/2018/11/logo-1.png\" />\n		<style type=\"text/css\" id=\"wp-custom-css\">\n			.samandehi-logo{\n	max-height:80px;\n}\n\n.home footer{\n	display:none;\n}\n@media screen and (min-width:769px){\n.rocketchat-widget{\n  height:2.5em;\n	bottom:1em !important;\n	right:1em !important;\n	border-radius: 	2em!important;\n  overflow: hidden;\n}\n\ndiv[data-state^=\"open\"].rocketchat-widget{\n		border-radius: 	.5em!important;\n}\n}\n.bale_shecan{\nbackground:rgba(255,255,255,0.28);\n	border-radius:100%;\n	width:75px!important;\n	height:75px;\n	padding:22px;\n	margin-right: calc(50% - 37.5px);\n	margin-bottom: 27px!important\n}\n.bale_shecan:hover{\nbackground:rgba(0,0,0,0.18)}\n#header-particles{\nposition: absolute;\ntop: 0;\nopacity: .45;\n	height:100%;\n	width:100%;\n}\n.page-id-1374 .hestia-title {\n	color: red;\n}		</style>\n		</head>\n\n<body class=\"rtl page-template-default page page-id-1374 custom-background wp-custom-logo blog-post header-layout-default elementor-beta elementor-default elementor-kit-1303\">\n	<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-dark-grayscale\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncG type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncB type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-grayscale\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 1\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0 1\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-purple-yellow\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.54901960784314 0.98823529411765\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0.71764705882353 0.25490196078431\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-blue-red\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 1\" /><feFuncG type=\"table\" tableValues=\"0 0.27843137254902\" /><feFuncB type=\"table\" tableValues=\"0.5921568627451 0.27843137254902\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-midnight\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 0\" /><feFuncG type=\"table\" tableValues=\"0 0.64705882352941\" /><feFuncB type=\"table\" tableValues=\"0 1\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-magenta-yellow\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.78039215686275 1\" /><feFuncG type=\"table\" tableValues=\"0 0.94901960784314\" /><feFuncB type=\"table\" tableValues=\"0.35294117647059 0.47058823529412\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-purple-green\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.65098039215686 0.40392156862745\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0.44705882352941 0.4\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-blue-orange\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.098039215686275 1\" /><feFuncG type=\"table\" tableValues=\"0 0.66274509803922\" /><feFuncB type=\"table\" tableValues=\"0.84705882352941 0.41960784313725\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg>	<div class=\"wrapper  default \">\n		<header class=\"header \">\n			<div style=\"display: none\"></div>		<nav class=\"navbar navbar-default navbar-fixed-top  hestia_left navbar-not-transparent\">\n						<div class=\"container\">\n						<div class=\"navbar-header\">\n			<div class=\"title-logo-wrapper\">\n				<a class=\"navbar-brand\" href=\"https://shecan.ir/\"\n						title=\"شکن\">\n					<img  src=\"https://shecan.ir/wp-content/uploads/2018/11/logo_title.png\" alt=\"شکن\"></a>\n			</div>\n								<div class=\"navbar-toggle-wrapper\">\n						<button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\"#main-navigation\">\n				<span class=\"icon-bar\"></span>\n				<span class=\"icon-bar\"></span>\n				<span class=\"icon-bar\"></span>\n				<span class=\"sr-only\">تغییر ناوبری</span>\n			</button>\n					</div>\n				</div>\n		<div id=\"main-navigation\" class=\"collapse navbar-collapse\"><ul id=\"menu-%d9%85%d9%86%d9%88%db%8c-%d8%a7%d8%b5%d9%84%db%8c\" class=\"nav navbar-nav\"><li id=\"menu-item-257\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-home menu-item-257\"><a title=\"پشتیبانی می‌شه؟\" href=\"https://shecan.ir/#report\">پشتیبانی می‌شه؟</a></li>\n<li id=\"menu-item-908\" class=\"menu-item menu-item-type-post_type menu-item-object-page menu-item-908\"><a title=\"راهنما\" href=\"https://shecan.ir/tutorials/\">راهنما</a></li>\n<li id=\"menu-item-305\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-305\"><a title=\"سفارش شکن حرفه‌ای\" href=\"https://support.peygir.net/order?order=9\">سفارش شکن حرفه‌ای</a></li>\n<li id=\"menu-item-258\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-home menu-item-258\"><a title=\"سازمان و شرکت‌ها\" href=\"https://shecan.ir/#companies\">سازمان و شرکت‌ها</a></li>\n<li id=\"menu-item-1262\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-1262\"><a title=\"سامانه پشتیبانی\" href=\"https://support.peygir.net/\">سامانه پشتیبانی</a></li>\n<li id=\"menu-item-256\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-256\"><a title=\"پرسش‌های پرتکرار\" href=\"https://shecan.ir/faq/\">پرسش‌های پرتکرار</a></li>\n<li id=\"menu-item-261\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-home menu-item-261\"><a title=\"تماس\" href=\"https://shecan.ir/#contact\">تماس</a></li>\n</ul></div>			</div>\n					</nav>\n				</header>\n<div id=\"primary\" class=\" page-header header-small\" data-parallax=\"active\" ><div class=\"container\"><div class=\"row\"><div class=\"col-md-10 col-md-offset-1 text-center\"><h1 class=\"hestia-title \">شما به این سطح از خدمات دسترسی ندارید</h1></div></div></div><div class=\"header-filter header-filter-gradient\"></div></div><div class=\"main \">\n		<div class=\"blog-post \">\n		<div class=\"container\">\n			\n\n	<article id=\"post-1374\" class=\"section section-text\">\n		<div class=\"row\">\n						<div class=\"col-md-8 page-content-wrap  col-md-offset-2\">\n				\n<p>نحوه استفاده شما از خدمات تحریم‌شکن اینترنتی «شکن» خارج از شرایط مجاز در خدمات رایگان است. به همین دلیل دسترسی شما به این سطح از خدمات، مسدود شده است.</p>\n\n\n\n<p>ممکن است این مشکل به خاطر تنظیمات نامناسب توسط تأمین‌کننده اینترنت (ISP) شما و یا راهبر شبکه مورد استفاده شما برای اتصال به اینترنت ایجاد شده باشد. در این صورت خواهشمند است مشکل را با ایشان در میان بگذارید.</p>\n\n\n\n<p>پیش‌نهاد ما این است که یا نسبت به تهیه اشتراک <a href=\"https://support.peygir.net/order?order=9\">شکن حرفه‌ای</a> اقدام نمایید یا  این که استفاده خود از خدمات رایگان شکن را به موارد شخصی، محدود کنید؛ هر گونه استفاده غیرشخصی از شکن، مستلزم تهیه اشتراک تجاری است.</p>\n\n\n\n<p>در صورتی که مطمئن هستید نحوه استفاده شما از خدمات رایگان شکن، طبق راهنماهای موجود در سایت و همچنین محدود به موارد شخصی است، لطفاً موضوع را <a href=\"https://shecan.ir/#contact\">با ما مطرح کنید</a>.</p>\n			</div>\n					</div>\n	</article>\n		</div>\n	</div>\n						<footer class=\"footer footer-black footer-big\">\n						<div class=\"container\">\n																<div class=\"hestia-bottom-footer-content\"><ul id=\"menu-%d9%85%d9%86%d9%88%db%8c-%d9%be%d8%a7%d8%a8%d8%b1%da%af\" class=\"footer-menu pull-left\"><li id=\"menu-item-512\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-512\"><a href=\"https://bonyan.co/terms\">شرایط استفاده و حریم خصوصی</a></li>\n</ul>					<div class=\"copyright pull-right\">\n				هستیا | توسعه توسط <a href=\"https://themeisle.com\" rel=\"nofollow\">ThemeIsle</a>			</div>\n			</div>			</div>\n					</footer>\n				</div>\n	</div>\n            <!-- Start of Rocket.Chat Livechat Script -->\n            <script type=\"text/javascript\">\n                (function(w, d, s, u) {\n                    w.RocketChat = function(c) { w.RocketChat._.push(c) }; w.RocketChat._ = []; w.RocketChat.url = u;\n                    var h = d.getElementsByTagName(s)[0], j = d.createElement(s);\n					j.async = true; j.src = \'https://chat.bonyan.co/livechat/rocketchat-livechat.min.js?_=201912110000\';\n                    h.parentNode.insertBefore(j, h);\n                })(window, document, \'script\', \'https://chat.bonyan.co/livechat\');\n            </script>\n            <!-- End of Rocket.Chat Livechat Script -->\n			<!-- Piwik -->\r\n<script type=\"text/javascript\">\r\n  var _paq = _paq || [];\r\n  /* tracker methods like \"setCustomDimension\" should be called before \"trackPageView\" */\r\n  _paq.push([\'trackPageView\']);\r\n  _paq.push([\'enableLinkTracking\']);\r\n  (function() {\r\n    var u=\"//stat.bonyan.co/\";\r\n    _paq.push([\'setTrackerUrl\', u+\'s.jsp\']);\r\n    _paq.push([\'setSiteId\', \'6\']);\r\n    var d=document, g=d.createElement(\'script\'), s=d.getElementsByTagName(\'script\')[0];\r\n    g.type=\'text/javascript\'; g.async=true; g.defer=true; g.src=u+\'s.js\'; s.parentNode.insertBefore(g,s);\r\n  })();\r\n</script>\r\n<!-- End Piwik Code -->\r\n<noscript><p><img src=\"//stat.bonyan.co/s.jsp?idsite=6&rec=1\" style=\"border:0;\" alt=\"\" /></p></noscript>\n<script type=\'text/javascript\' src=\'https://shecan.ir/wp-includes/js/comment-reply.min.js?ver=6.0\' id=\'comment-reply-js\'></script>\n<script type=\'text/javascript\' src=\'https://shecan.ir/wp-content/themes/hestia/assets/bootstrap/js/bootstrap.min.js?ver=1.0.2\' id=\'jquery-bootstrap-js\'></script>\n<script type=\'text/javascript\' src=\'https://shecan.ir/wp-includes/js/jquery/ui/core.min.js?ver=1.13.1\' id=\'jquery-ui-core-js\'></script>\n<script type=\'text/javascript\' id=\'hestia_scripts-js-extra\'>\n/* <![CDATA[ */\nvar requestpost = {\"ajaxurl\":\"https:\\/\\/shecan.ir\\/wp-admin\\/admin-ajax.php\",\"disable_autoslide\":\"\",\"masonry\":\"\"};\n/* ]]> */\n</script>\n<script type=\'text/javascript\' src=\'https://shecan.ir/wp-content/themes/hestia/assets/js/script.min.js?ver=3.0.22\' id=\'hestia_scripts-js\'></script>\n</body>\n</html>\n\r\n<!--\r\nPerformance optimized by W3 Total Cache. Learn more: https://www.boldgrid.com/w3-total-cache/\r\n\r\nPage Caching using disk: enhanced \r\n\r\nServed from: shecan.ir @ 1401-04-09 12:20:59 by W3 Total Cache\r\n-->\n\";s:8:\"lasttime\";s:10:\"1716973317\";}","yes"),
("19753","revslider_update_revision_current","6.6.0","yes"),
("19958","revslider-update-hash","a8041db8f4bbf80ad295c54fa31b6a01","yes"),
("20110","revslider-templates-hash","adb124a80d1ef0a591c3197a97b2d096","yes"),
("20255","revslider-library-hash","dae3de1eb57eeeee008b70e9a23844b5","yes"),
("35825","admin_email_lifespan","1732896615","yes"),
("35826","disallowed_keys","","no"),
("35827","comment_previously_approved","1","yes"),
("35828","auto_plugin_theme_update_emails","a:0:{}","no"),
("35829","finished_updating_comment_type","1","yes"),
("35873","woocommerce_maxmind_geolocation_settings","a:1:{s:15:\"database_prefix\";s:32:\"pfNAdIBGRZixbQJ3DOwNlnlnCuTAHU4w\";}","yes"),
("35876","action_scheduler_hybrid_store_demarkation","4541","yes"),
("35877","schema-ActionScheduler_StoreSchema","7.0.1691395203","yes"),
("35878","schema-ActionScheduler_LoggerSchema","3.0.1659523006","yes"),
("35881","woocommerce_schema_version","430","yes"),
("35882","woocommerce_downloads_add_hash_to_filename","yes","yes"),
("35886","woocommerce_onboarding_profile","a:1:{s:9:\"completed\";b:1;}","yes"),
("35891","woocommerce_admin_install_timestamp","1601722817","yes"),
("35895","wc_blocks_db_schema_version","260","yes"),
("35906","action_scheduler_lock_async-request-runner","6689272d6846f0.64655345|1720264553","yes"),
("36151","277c9a3a6c5fca0bbf0e19b7a0613520","a:2:{s:7:\"timeout\";i:1604425897;s:5:\"value\";s:174:\"{\"new_version\":\"\",\"stable_version\":\"\",\"sections\":\"\",\"license_check\":\"\",\"msg\":\"License key is not valid for Duplicator Pro\",\"homepage\":\"\",\"package\":\"\",\"icons\":[],\"banners\":[]}\";}","yes"),
("36157","wpp_settings","a:19:{s:10:\"admin_lang\";s:7:\"disable\";s:9:\"user_lang\";s:7:\"disable\";s:12:\"submenu_move\";s:6:\"enable\";s:12:\"persian_date\";s:6:\"enable\";s:10:\"conv_title\";s:6:\"enable\";s:13:\"conv_contents\";s:7:\"disable\";s:12:\"conv_excerpt\";s:6:\"enable\";s:13:\"conv_comments\";s:6:\"enable\";s:18:\"conv_comment_count\";s:6:\"enable\";s:10:\"conv_dates\";s:6:\"enable\";s:9:\"conv_cats\";s:6:\"enable\";s:11:\"conv_arabic\";s:7:\"disable\";s:15:\"conv_permalinks\";s:6:\"enable\";s:11:\"news_source\";s:5:\"parsi\";s:15:\"conv_page_title\";s:6:\"enable\";s:13:\"woo_per_price\";s:6:\"enable\";s:10:\"edd_prices\";s:7:\"disable\";s:12:\"edd_rial_fix\";s:7:\"disable\";s:9:\"dis_input\";s:0:\"\";}","yes"),
("36158","widget_parsidate_archive","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("36159","widget_parsidate_calendar","a:2:{i:2;a:1:{s:24:\"parsidate_calendar_title\";s:19:\"تاریخ شمسی\";}s:12:\"_multiwidget\";i:1;}","yes"),
("36839","rs-templates-counter","0","no"),
("36918","revslider-additions","O:8:\"stdClass\":2:{s:9:\"templates\";O:8:\"stdClass\":3:{s:9:\"tutorials\";a:3:{i:0;O:8:\"stdClass\":2:{s:5:\"title\";s:19:\"Rapid Fire Overview\";s:3:\"url\";s:49:\"https://www.youtube.com/watch?v=LRNTFu-MFgw&t=25s\";}i:1;O:8:\"stdClass\":2:{s:5:\"title\";s:34:\"Responsiveness in Edited Templates\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=hP4oV8SWgKY\";}i:2;O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Animation Basics\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=nn3azizwpbs\";}}s:5:\"guide\";O:8:\"stdClass\":3:{s:5:\"title\";s:78:\"Require Expert Technical Advice?<br />Submit a Ticket for Dedicated 1on1 Help.\";s:3:\"url\";s:36:\"https://support.sliderrevolution.com\";s:3:\"img\";s:67:\"//updates.themepunch-ext-c.tools/banners/default_template_guide.jpg\";}s:6:\"bottom\";O:8:\"stdClass\":2:{s:5:\"title\";s:32:\"Load A Template From The Library\";s:3:\"img\";s:61:\"//updates.themepunch-ext-c.tools/banners/guide_mod_banner.png\";}}s:7:\"selling\";b:1;}","yes"),
("37046","revslider-notices-dc","a:2:{i:0;s:10:\"TPRS999-01\";i:1;s:12:\"TPRSV6511-01\";}","yes"),
("37112","secret_key","UT$ip*3`NDWybSAb?QX;=(uKbZ8CS YsAfXN=AjfgAo]}{!47f^l2|>HzDR_Ordp","no"),
("37339","PW_Options","a:2:{s:15:\"fix_orders_list\";s:2:\"no\";s:24:\"enable_jalali_datepicker\";s:2:\"no\";}","yes"),
("46227","cwsstaff_member_department_children","a:0:{}","yes"),
("48813","product_cat_children","a:0:{}","yes"),
("52124","rs-addons-counter","1","yes"),
("60988","woocommerce_tax_classes","","yes"),
("60989","woocommerce_version","9.0.2","yes"),
("61208","auto_update_core_dev","enabled","yes"),
("61209","auto_update_core_minor","enabled","yes"),
("61210","auto_update_core_major","unset","yes"),
("61211","https_detection_errors","a:0:{}","yes"),
("61273","recovery_mode_email_last_sent","1664136993","yes"),
("61313","woocommerce_db_version","9.0.2","yes"),
("61319","woocommerce_merchant_email_notifications","no","no"),
("61320","woocommerce_paypal_settings","a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:16:\"info@demo-ds.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:16:\"info@demo-ds.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}","yes"),
("61321","woocommerce_inbox_variant_assignment","1","yes"),
("61327","wc_remote_inbox_notifications_wca_updated","","no"),
("61329","wc_remote_inbox_notifications_stored_state","O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:0;s:22:\"there_are_now_products\";b:1;}","no"),
("65209","wpgmza-first-run","2021-09-09T14:58:08+0000","yes"),
("65210","wpgmza_welcome_screen_done","1","yes"),
("65261","revslider-valid","false","yes"),
("65262","revslider-code","active","yes"),
("65263","revslider-temp-active-notice","false","yes"),
("65268","revslider-update-check","1720261515","yes"),
("65269","revslider_update_info","O:8:\"stdClass\":3:{s:7:\"checked\";i:1720261515;s:5:\"basic\";O:8:\"stdClass\":6:{s:4:\"slug\";s:9:\"revslider\";s:7:\"package\";s:0:\"\";s:6:\"tested\";s:5:\"6.5.5\";s:5:\"icons\";a:1:{s:2:\"1x\";s:62:\"//updates.themepunch-ext-c.tools/revslider/logo.png?rev=6.2.23\";}s:3:\"url\";s:33:\"https://www.sliderrevolution.com/\";s:11:\"new_version\";s:6:\"6.7.14\";}s:4:\"full\";O:8:\"stdClass\":19:{s:7:\"banners\";a:2:{s:3:\"low\";s:63:\"//updates.themepunch-ext-c.tools/revslider/banner.png?rev=6.5.5\";s:4:\"high\";s:63:\"//updates.themepunch-ext-c.tools/revslider/banner.png?rev=6.5.5\";}s:4:\"name\";s:17:\"Slider Revolution\";s:4:\"slug\";s:9:\"revslider\";s:6:\"stable\";s:5:\"4.2.0\";s:7:\"version\";s:6:\"6.7.14\";s:6:\"tested\";s:5:\"6.5.5\";s:14:\"upgrade_notice\";a:0:{}s:11:\"last_update\";s:10:\"2024-06-25\";s:12:\"last_updated\";s:10:\"2024-06-25\";s:8:\"requires\";s:3:\"3.6\";s:6:\"author\";s:51:\"<a href=\"https://www.themepunch.com\">ThemePunch</a>\";s:7:\"package\";s:0:\"\";s:13:\"download_link\";s:0:\"\";s:9:\"file_name\";s:13:\"revslider.zip\";s:15:\"active_installs\";i:9100000;s:8:\"homepage\";s:33:\"https://www.sliderrevolution.com/\";s:8:\"sections\";a:3:{s:11:\"description\";s:497:\"<h4>Slider Revolution WordPress Builder Plugin</h4>\n	<p>Slider Revolution 6 is a new way to build rich & dynamic content for your websites. With our powerful visual editor, you can create modern designs in no time, and with no coding experience required.</p><p>Create Sliders & Carousels, Hero Headers, Content Modules, Full Websites, Dynamic Solutions and Special FX with our amazing Add-Ons.</p>\n	<p>200+ templates are included in our online library. Cutting edge designs. Easily customized.</p>\";s:9:\"changelog\";s:155:\"<p>For Slider Revolution\'s changelog, please visit <a \nhref=\"https://www.sliderrevolution.com/documentation/changelog/\" \ntarget=\"_blank\">this</a> site!</p>\";s:3:\"faq\";s:2178:\"<div class=\"tp-faq-content\"><div class=\"tp-faq-column tp-faq-recent\"><h4>Recent Solutions</h4><ul class=\"tp-faq-recent-content ready\"><li><a href=\"https://www.youtube.com/watch?v=sCcnw5bZqYY&amp;list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_&amp;index=2&amp;t=111s\" target=\"_blank\" title=\"Video Tutorials\">Video Tutorials</a></li><li><a href=\"https://www.themepunch.com/faq/responsive-content/\" target=\"_blank\" title=\"Responsive Content Setup\">Responsive Content Setup</a></li><li><a href=\"https://www.themepunch.com/faq/video-content-mobile/\" target=\"_blank\" title=\"Video Content &amp; Mobile Considerations\">Video Content &amp; Mobile Considerations</a></li><li><a href=\"https://www.themepunch.com/faq/how-to-change-the-timing-of-slides/\" target=\"_blank\" title=\"How to change the timing of Slides\">How to change the timing of Slides</a></li><li><a href=\"https://www.themepunch.com/faq/mouse-hovers-for-layer-content/\" target=\"_blank\" title=\"Mouse Hovers for Layer Content\"> Mouse Hovers for Layer Content</a></li></ul></div><div class=\"tp-faq-column tp-faq-popular\"><h4>Popular Solutions</h4><ul class=\"tp-faq-popular-content ready\"><li><a href=\"https://www.themepunch.com/faq/after-updating-make-sure-to-clear-all-caches/\" target=\"_blank\" title=\"After updating – Make sure to clear all caches\">After updating – Make sure to clear all caches</a></li><li><a href=\"https://www.themepunch.com/faq/purchase-code-registration-faqs/\" target=\"_blank\" title=\"Purchase Code Registration FAQ’s\">Purchase Code Registration FAQ’s</a></li><li><a href=\"https://www.themepunch.com/faq/ideal-image-size/\" target=\"_blank\" title=\"Ideal Image Size\">Ideal Image Size</a></li><li><a href=\"https://www.themepunch.com/faq/add-links-to-slides-and-layers/\" target=\"_blank\" title=\"How to Hyperlink Slides and Layers\">How to Hyperlink Slides and Layers</a></li><li><a href=\"https://www.themepunch.com/faq/where-to-find-the-purchase-code/\" target=\"_blank\" title=\"Where to find the Purchase Code\">Where to find the Purchase Code</a></li></ul></div><div style=\"clear: both\"></div><p><a class=\"button button-primary\" href=\"https://themepunch.com/support-center\"><strong>See All Faq\'s</strong></a></p></div>\";}s:3:\"url\";s:33:\"https://www.sliderrevolution.com/\";s:8:\"external\";i:1;}}","yes"),
("65416","revslider-deact-notice","1","yes"),
("73133","woocommerce_downloads_redirect_fallback_allowed","no","no"),
("73163","woocommerce_admin_version","2.4.5","yes"),
("75060","ai1wm_backups_labels","a:0:{}","yes"),
("75118","ai1wm_updater","a:0:{}","yes"),
("77884","edd_sl_a3082723c63b116f21b97dfd1be654bd","a:2:{s:7:\"timeout\";i:1720306950;s:5:\"value\";s:5:\"false\";}","no"),
("77901","duplicator_pro_exe_safe_mode","0","yes"),
("77904","duplicator_pro_migration_data","{\n    \"installType\": -1,\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"\\/home\\/demodsco\\/rtl.pars-themes.com\\/ingenious\\/20220731_d8b3d8a7db8cd8aa_c08bb78d6b130fb15659_20220731095936_archive.zip\",\n    \"packageHash\": \"c08bb78-31095936\",\n    \"installerPath\": \"\\/home\\/demodsco\\/rtl.pars-themes.com\\/ingenious\\/installer.php\",\n    \"installerBootLog\": \"\\/home\\/demodsco\\/rtl.pars-themes.com\\/ingenious\\/dup-installer-bootlog__b645c52-31095936.txt\",\n    \"installerLog\": \"\\/home\\/demodsco\\/rtl.pars-themes.com\\/ingenious\\/dup-installer\\/dup-installer-log__b645c52-31095936.txt\",\n    \"dupInstallerPath\": \"\\/home\\/demodsco\\/rtl.pars-themes.com\\/ingenious\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/home\\/demodsco\\/rtl.pars-themes.com\\/ingenious\\/dup-installer\\/original_files_c08bb78-31095936\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true\n}","no"),
("78087","rocket_preload_batch_9d38fc3b86e892132bd4ef453f2c4741","a:82:{i:0;a:3:{s:3:\"url\";s:59:\"https://rtl.pars-themes.com/ingenious/interactive-security/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:1;a:3:{s:3:\"url\";s:57:\"https://rtl.pars-themes.com/ingenious/video-monitoring-2/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:2;a:3:{s:3:\"url\";s:56:\"https://rtl.pars-themes.com/ingenious/energy-management/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:3;a:3:{s:3:\"url\";s:51:\"https://rtl.pars-themes.com/ingenious/product-page/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:4;a:3:{s:3:\"url\";s:55:\"https://rtl.pars-themes.com/ingenious/intelligent-home/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:5;a:3:{s:3:\"url\";s:46:\"https://rtl.pars-themes.com/ingenious/landing/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:6;a:3:{s:3:\"url\";s:62:\"https://rtl.pars-themes.com/ingenious/manage-everything-alarm/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:7;a:3:{s:3:\"url\";s:59:\"https://rtl.pars-themes.com/ingenious/request-a-consulting/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:8;a:3:{s:3:\"url\";s:53:\"https://rtl.pars-themes.com/ingenious/find-a-partner/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:9;a:3:{s:3:\"url\";s:64:\"https://rtl.pars-themes.com/ingenious/pick-an-affordable-option/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:10;a:3:{s:3:\"url\";s:57:\"https://rtl.pars-themes.com/ingenious/smart-installation/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:11;a:3:{s:3:\"url\";s:59:\"https://rtl.pars-themes.com/ingenious/smart-installation-2/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:12;a:3:{s:3:\"url\";s:69:\"https://rtl.pars-themes.com/ingenious/smart-home-overview-security-4/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:13;a:3:{s:3:\"url\";s:65:\"https://rtl.pars-themes.com/ingenious/manage-everything-lighting/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:14;a:3:{s:3:\"url\";s:63:\"https://rtl.pars-themes.com/ingenious/manage-everything-energy/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:15;a:3:{s:3:\"url\";s:64:\"https://rtl.pars-themes.com/ingenious/manage-everything-heating/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:16;a:3:{s:3:\"url\";s:62:\"https://rtl.pars-themes.com/ingenious/manage-everything-music/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:17;a:3:{s:3:\"url\";s:63:\"https://rtl.pars-themes.com/ingenious/manage-everything-blinds/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:18;a:3:{s:3:\"url\";s:58:\"https://rtl.pars-themes.com/ingenious/smart-home-overview/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:19;a:3:{s:3:\"url\";s:69:\"https://rtl.pars-themes.com/ingenious/smart-home-overview-for-family/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:20;a:3:{s:3:\"url\";s:67:\"https://rtl.pars-themes.com/ingenious/smart-home-overview-security/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:21;a:3:{s:3:\"url\";s:69:\"https://rtl.pars-themes.com/ingenious/smart-home-overview-security-2/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:22;a:3:{s:3:\"url\";s:69:\"https://rtl.pars-themes.com/ingenious/smart-home-overview-security-3/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:23;a:3:{s:3:\"url\";s:47:\"https://rtl.pars-themes.com/ingenious/about-us/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:24;a:3:{s:3:\"url\";s:45:\"https://rtl.pars-themes.com/ingenious/1154-2/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:25;a:3:{s:3:\"url\";s:50:\"https://rtl.pars-themes.com/ingenious/our-process/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:26;a:3:{s:3:\"url\";s:46:\"https://rtl.pars-themes.com/ingenious/careers/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:27;a:3:{s:3:\"url\";s:47:\"https://rtl.pars-themes.com/ingenious/partners/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:28;a:3:{s:3:\"url\";s:42:\"https://rtl.pars-themes.com/ingenious/faq/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:29;a:3:{s:3:\"url\";s:44:\"https://rtl.pars-themes.com/ingenious/press/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:30;a:3:{s:3:\"url\";s:47:\"https://rtl.pars-themes.com/ingenious/elements/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:31;a:3:{s:3:\"url\";s:65:\"https://rtl.pars-themes.com/ingenious/portfolio/economy-strategy/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:32;a:3:{s:3:\"url\";s:61:\"https://rtl.pars-themes.com/ingenious/portfolio/heating-plan/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:33;a:3:{s:3:\"url\";s:62:\"https://rtl.pars-themes.com/ingenious/portfolio/motion-sensor/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:34;a:3:{s:3:\"url\";s:59:\"https://rtl.pars-themes.com/ingenious/portfolio/led-camera/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:35;a:3:{s:3:\"url\";s:57:\"https://rtl.pars-themes.com/ingenious/portfolio/strategy/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:36;a:3:{s:3:\"url\";s:61:\"https://rtl.pars-themes.com/ingenious/portfolio/auto-control/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:37;a:3:{s:3:\"url\";s:61:\"https://rtl.pars-themes.com/ingenious/portfolio/smart-player/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:38;a:3:{s:3:\"url\";s:59:\"https://rtl.pars-themes.com/ingenious/portfolio/headphones/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:39;a:3:{s:3:\"url\";s:63:\"https://rtl.pars-themes.com/ingenious/portfolio-4-cols-masonry/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:40;a:3:{s:3:\"url\";s:51:\"https://rtl.pars-themes.com/ingenious/masonry-grid/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:41;a:3:{s:3:\"url\";s:51:\"https://rtl.pars-themes.com/ingenious/masonry-wide/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:42;a:3:{s:3:\"url\";s:59:\"https://rtl.pars-themes.com/ingenious/masonry-wide-spacing/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:43;a:3:{s:3:\"url\";s:54:\"https://rtl.pars-themes.com/ingenious/three-cols-grid/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:44;a:3:{s:3:\"url\";s:56:\"https://rtl.pars-themes.com/ingenious/three-cols-wide-2/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:45;a:3:{s:3:\"url\";s:57:\"https://rtl.pars-themes.com/ingenious/three-cols-spacing/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:46;a:3:{s:3:\"url\";s:61:\"https://rtl.pars-themes.com/ingenious/three-cos-wide-spacing/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:47;a:3:{s:3:\"url\";s:55:\"https://rtl.pars-themes.com/ingenious/four-cols-grid-2/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:48;a:3:{s:3:\"url\";s:55:\"https://rtl.pars-themes.com/ingenious/four-cols-wide-2/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:49;a:3:{s:3:\"url\";s:56:\"https://rtl.pars-themes.com/ingenious/four-cols-spacing/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:50;a:3:{s:3:\"url\";s:60:\"https://rtl.pars-themes.com/ingenious/four-cos-wide-spacing/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:51;a:3:{s:3:\"url\";s:55:\"https://rtl.pars-themes.com/ingenious/two-cols-sidebar/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:52;a:3:{s:3:\"url\";s:52:\"https://rtl.pars-themes.com/ingenious/two-cols-wide/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:53;a:3:{s:3:\"url\";s:50:\"https://rtl.pars-themes.com/ingenious/3-cols-grid/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:54;a:3:{s:3:\"url\";s:53:\"https://rtl.pars-themes.com/ingenious/3-cols-sidebar/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:55;a:3:{s:3:\"url\";s:54:\"https://rtl.pars-themes.com/ingenious/three-cols-wide/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:56;a:3:{s:3:\"url\";s:53:\"https://rtl.pars-themes.com/ingenious/four-cols-grid/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:57;a:3:{s:3:\"url\";s:53:\"https://rtl.pars-themes.com/ingenious/four-cols-wide/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:58;a:3:{s:3:\"url\";s:51:\"https://rtl.pars-themes.com/ingenious/blog-masonry/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:59;a:3:{s:3:\"url\";s:51:\"https://rtl.pars-themes.com/ingenious/checkerboard/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:60;a:3:{s:3:\"url\";s:62:\"https://rtl.pars-themes.com/ingenious/blog-masonry-full-width/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:61;a:3:{s:3:\"url\";s:50:\"https://rtl.pars-themes.com/ingenious/two-columns/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:62;a:3:{s:3:\"url\";s:51:\"https://rtl.pars-themes.com/ingenious/three-colums/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:63;a:3:{s:3:\"url\";s:55:\"https://rtl.pars-themes.com/ingenious/four-cols-wide-3/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:64;a:3:{s:3:\"url\";s:51:\"https://rtl.pars-themes.com/ingenious/small-images/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:65;a:3:{s:3:\"url\";s:52:\"https://rtl.pars-themes.com/ingenious/medium-images/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:66;a:3:{s:3:\"url\";s:51:\"https://rtl.pars-themes.com/ingenious/large-images/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:67;a:3:{s:3:\"url\";s:73:\"https://rtl.pars-themes.com/ingenious/duis-in-viverra-velit-accumsan-sed/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:68;a:3:{s:3:\"url\";s:51:\"https://rtl.pars-themes.com/ingenious/blog-gallery/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:69;a:3:{s:3:\"url\";s:48:\"https://rtl.pars-themes.com/ingenious/blog-link/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:70;a:3:{s:3:\"url\";s:63:\"https://rtl.pars-themes.com/ingenious/etiam-lacus-consectetuer/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:71;a:3:{s:3:\"url\";s:64:\"https://rtl.pars-themes.com/ingenious/proin-bibendum-id-eu-diam/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:72;a:3:{s:3:\"url\";s:64:\"https://rtl.pars-themes.com/ingenious/accumsan-lacinia-accumsan/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:73;a:3:{s:3:\"url\";s:43:\"https://rtl.pars-themes.com/ingenious/shop/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:74;a:3:{s:3:\"url\";s:53:\"https://rtl.pars-themes.com/ingenious/woo-shortcodes/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:75;a:3:{s:3:\"url\";s:47:\"https://rtl.pars-themes.com/ingenious/contacts/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:76;a:3:{s:3:\"url\";s:60:\"https://rtl.pars-themes.com/ingenious/portfolio/portfolio-1/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:77;a:3:{s:3:\"url\";s:61:\"https://rtl.pars-themes.com/ingenious/portfolio/outdoor-cctv/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:78;a:3:{s:3:\"url\";s:71:\"https://rtl.pars-themes.com/ingenious/portfolio/temperature-controller/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:79;a:3:{s:3:\"url\";s:57:\"https://rtl.pars-themes.com/ingenious/portfolio/tracking/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:80;a:3:{s:3:\"url\";s:70:\"https://rtl.pars-themes.com/ingenious/fermentum-lorem-mi-metus-erat-2/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}i:81;a:3:{s:3:\"url\";s:53:\"https://rtl.pars-themes.com/ingenious/category/alarm/\";s:6:\"mobile\";b:0;s:6:\"source\";s:8:\"homepage\";}}","no"),
("78595","rocket_cache_dir_size_check","1","yes"),
("82750","theme_mods_twentytwenty","a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";s:2:\"35\";}s:16:\"background_color\";s:3:\"fff\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1664266714;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:15:{i:0;s:32:\"woocommerce_product_categories-2\";i:1;s:26:\"woocommerce_price_filter-2\";i:2;s:25:\"woocommerce_widget_cart-2\";i:3;s:22:\"woocommerce_products-2\";i:4;s:31:\"woocommerce_product_tag_cloud-2\";i:5;s:13:\"cws-gallery-4\";i:6;s:12:\"categories-5\";i:7;s:8:\"search-5\";i:8;s:10:\"calendar-4\";i:9;s:8:\"search-4\";i:10;s:12:\"categories-4\";i:11;s:13:\"cws-gallery-2\";i:12;s:17:\"recent-comments-4\";i:13;s:20:\"parsidate_calendar-2\";i:14;s:11:\"tag_cloud-3\";}s:9:\"sidebar-1\";a:5:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:13:\"cws-gallery-3\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";}s:9:\"sidebar-2\";a:8:{i:0;s:18:\"ingenious-search-2\";i:1;s:12:\"categories-3\";i:2;s:13:\"cws-gallery-5\";i:3;s:17:\"recent-comments-3\";i:4;s:11:\"tag_cloud-2\";i:5;s:6:\"text-2\";i:6;s:24:\"ingenious-latest-posts-2\";i:7;s:13:\"custom_html-2\";}}}s:18:\"custom_css_post_id\";i:-1;}","no"),
("83354","akismet_ssl_disabled","1664265577","yes"),
("83358","widget_block","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("83359","wp_force_deactivated_plugins","a:0:{}","yes"),
("83360","user_count","1","no"),
("83468","woocommerce_task_list_reminder_bar_hidden","yes","yes"),
("83472","woocommerce_attribute_lookup_direct_updates","no","yes"),
("83473","woocommerce_analytics_enabled","no","yes"),
("83478","woocommerce_task_list_hidden_lists","a:1:{i:0;s:5:\"setup\";}","yes"),
("83508","duplicator_pro_ui_view_state","a:1:{s:22:\"dup-pack-archive-panel\";s:1:\"1\";}","yes"),
("83510","duplicator_pro_package_active","{\n    \"ID\": null,\n    \"Created\": \"2024-07-06 11:13:16\",\n    \"Version\": \"4.5.9\",\n    \"VersionWP\": \"6.5.5\",\n    \"VersionDB\": \"8.0.33\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240706_ingenious\",\n    \"Hash\": \"b802e2b5201829135345_20240706111316\",\n    \"NameHash\": \"20240706_ingenious_b802e2b5201829135345_20240706111316\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240706_ingenious_b802e2b5201829135345_20240706111316_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": 0,\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/cache;\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/maintenance;\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/.wp-cli;\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/perfmatters\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/maintenance.php;\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/error_log\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/.opcache\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/.tmb\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/.wp-cli\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/bps-backup\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/cache\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/cache\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/maintenance\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/old-cache\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/perfmatters\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/updraft\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/wfcache\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/.htaccess\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/.user.ini\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/error_log\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/php.ini\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/web.config\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-config.php\",\n            \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/maintenance.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 1,\n        \"FilterNames\": true,\n        \"File\": null,\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\",\n        \"Size\": 415595536,\n        \"Dirs\": null,\n        \"DirCount\": 2340,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 17894,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"Warning\": [],\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [\n                    \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/.wp-cli\",\n                    \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/cache\",\n                    \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/maintenance\",\n                    \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/perfmatters\"\n                ],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Warning\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [\n                    \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/error_log\",\n                    \"\\/home\\/parsthem\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/maintenance.php\"\n                ],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null,\n            \"TreeWarning\": null\n        },\n        \"ListDelimiter\": \"\\n\",\n        \"throttleDelayInUs\": 0\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"blgh\\/fNCppggezJuIm3PHTnh0T5er69BdyO7ZfBytxvgVtmp3l0wDQ7V6WS19nwcGBWAxdOdh4G3jXGH+EpYyg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb3_persian_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\",\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"parsthem_ingenious2\",\n            \"tablesBaseCount\": 78,\n            \"tablesFinalCount\": 78,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 5607,\n            \"tablesSizeOnDisk\": 10190160,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": 34,\n                    \"insertedRows\": false,\n                    \"size\": 35840\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 3086\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": false,\n                    \"size\": 9456\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": 100,\n                    \"insertedRows\": false,\n                    \"size\": 24040\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": 138,\n                    \"insertedRows\": false,\n                    \"size\": 30936\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": 35,\n                    \"insertedRows\": false,\n                    \"size\": 12236\n                },\n                \"wp_cwssvgi\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": false,\n                    \"size\": 12316\n                },\n                \"wp_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": 709,\n                    \"insertedRows\": false,\n                    \"size\": 1206208\n                },\n                \"wp_post_views\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": 3152,\n                    \"insertedRows\": false,\n                    \"size\": 1093552\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": 546,\n                    \"insertedRows\": false,\n                    \"size\": 1338744\n                },\n                \"wp_revslider_css\": {\n                    \"inaccurateRows\": 109,\n                    \"insertedRows\": false,\n                    \"size\": 100400\n                },\n                \"wp_revslider_css_bkp\": {\n                    \"inaccurateRows\": 109,\n                    \"insertedRows\": false,\n                    \"size\": 95280\n                },\n                \"wp_revslider_layer_animations\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_revslider_layer_animations_bkp\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_revslider_navigations\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_revslider_navigations_bkp\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_revslider_sliders\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": false,\n                    \"size\": 63288\n                },\n                \"wp_revslider_sliders_bkp\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": false,\n                    \"size\": 81716\n                },\n                \"wp_revslider_slides\": {\n                    \"inaccurateRows\": 18,\n                    \"insertedRows\": false,\n                    \"size\": 2430032\n                },\n                \"wp_revslider_slides_bkp\": {\n                    \"inaccurateRows\": 19,\n                    \"insertedRows\": false,\n                    \"size\": 2732104\n                },\n                \"wp_revslider_static_slides\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": false,\n                    \"size\": 3856\n                },\n                \"wp_revslider_static_slides_bkp\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 2168\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": 172,\n                    \"insertedRows\": false,\n                    \"size\": 13852\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": 63,\n                    \"insertedRows\": false,\n                    \"size\": 8808\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": false,\n                    \"size\": 10460\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": 63,\n                    \"insertedRows\": false,\n                    \"size\": 17048\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": 67,\n                    \"insertedRows\": false,\n                    \"size\": 15360\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 8292\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": 118,\n                    \"insertedRows\": false,\n                    \"size\": 26192\n                },\n                \"wp_wc_admin_notes\": {\n                    \"inaccurateRows\": 75,\n                    \"insertedRows\": false,\n                    \"size\": 35988\n                },\n                \"wp_wc_category_lookup\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 2082\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 2048\n                },\n                \"wp_wc_download_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_wc_order_addresses\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_wc_order_stats\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_wc_orders\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 131072\n                },\n                \"wp_wc_orders_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": 16,\n                    \"insertedRows\": false,\n                    \"size\": 11064\n                },\n                \"wp_wc_rate_limits\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": false,\n                    \"size\": 9424\n                },\n                \"wp_wc_webhooks\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 2048\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_woocommerce_ir\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_woocommerce_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": false,\n                    \"size\": 10640\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 3128\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 82084\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_wpgmza\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_admin_notices\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_categories\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_category_maps\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_circles\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_image_overlays\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_maps\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_point_labels\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_polygon\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_polylines\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_rectangles\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                }\n            },\n            \"varLowerCaseTables\": \"0\",\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.33\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHP\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\"\n    },\n    \"Status\": 5,\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": -1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"-2\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 5\n}","yes"),
("84067","perfmatters_options","a:30:{s:14:\"disable_emojis\";s:1:\"1\";s:17:\"disable_dashicons\";s:1:\"1\";s:14:\"disable_embeds\";s:1:\"1\";s:14:\"disable_xmlrpc\";s:1:\"1\";s:21:\"remove_jquery_migrate\";s:1:\"1\";s:23:\"remove_wlwmanifest_link\";s:1:\"1\";s:15:\"remove_rsd_link\";s:1:\"1\";s:17:\"disable_rss_feeds\";s:1:\"1\";s:17:\"remove_feed_links\";s:1:\"1\";s:22:\"disable_self_pingbacks\";s:1:\"1\";s:16:\"disable_rest_api\";s:18:\"disable_non_admins\";s:21:\"remove_rest_api_links\";s:1:\"1\";s:19:\"disable_google_maps\";s:1:\"1\";s:30:\"disable_google_maps_exclusions\";s:0:\"\";s:13:\"blank_favicon\";s:1:\"1\";s:17:\"disable_heartbeat\";s:0:\"\";s:19:\"heartbeat_frequency\";s:0:\"\";s:20:\"limit_post_revisions\";s:5:\"false\";s:17:\"autosave_interval\";s:0:\"\";s:9:\"login_url\";s:0:\"\";s:18:\"login_url_behavior\";s:0:\"\";s:17:\"login_url_message\";s:0:\"\";s:18:\"login_url_redirect\";s:0:\"\";s:27:\"disable_woocommerce_scripts\";s:1:\"1\";s:6:\"assets\";a:13:{s:14:\"script_manager\";s:1:\"1\";s:8:\"defer_js\";s:1:\"1\";s:13:\"js_exclusions\";s:0:\"\";s:17:\"delay_js_behavior\";s:0:\"\";s:19:\"delay_js_inclusions\";s:0:\"\";s:19:\"delay_js_exclusions\";s:0:\"\";s:12:\"rucss_method\";s:0:\"\";s:25:\"rucss_stylesheet_behavior\";s:0:\"\";s:26:\"rucss_excluded_stylesheets\";s:0:\"\";s:24:\"rucss_excluded_selectors\";s:0:\"\";s:11:\"header_code\";s:0:\"\";s:9:\"body_code\";s:0:\"\";s:11:\"footer_code\";s:0:\"\";}s:7:\"preload\";a:4:{s:7:\"preload\";a:0:{}s:15:\"critical_images\";s:0:\"\";s:10:\"preconnect\";a:0:{}s:12:\"dns_prefetch\";s:0:\"\";}s:8:\"lazyload\";a:4:{s:22:\"exclude_leading_images\";s:0:\"\";s:23:\"lazy_loading_exclusions\";s:0:\"\";s:9:\"threshold\";s:0:\"\";s:24:\"css_background_selectors\";s:0:\"\";}s:5:\"fonts\";a:2:{s:7:\"cdn_url\";s:0:\"\";s:20:\"disable_google_fonts\";s:1:\"1\";}s:3:\"cdn\";a:3:{s:7:\"cdn_url\";s:0:\"\";s:15:\"cdn_directories\";s:0:\"\";s:14:\"cdn_exclusions\";s:0:\"\";}s:9:\"analytics\";a:6:{s:11:\"tracking_id\";s:0:\"\";s:22:\"tracking_code_position\";s:0:\"\";s:11:\"script_type\";s:0:\"\";s:20:\"adjusted_bounce_rate\";s:0:\"\";s:7:\"cdn_url\";s:0:\"\";s:14:\"measurement_id\";s:0:\"\";}}","yes"),
("84068","perfmatters_tools","a:3:{s:15:\"clean_uninstall\";s:1:\"1\";s:19:\"hide_admin_bar_menu\";s:1:\"1\";s:8:\"database\";a:1:{s:17:\"optimize_schedule\";s:0:\"\";}}","yes"),
("84069","perfmatters_version","2.1.3","no"),
("84072","woocommerce_refund_returns_page_id","4802","yes"),
("84077","wc_downloads_approved_directories_mode","disabled","yes"),
("87101","edd_sl_73499b5e164c73711a5f2eb6801dfa83","a:2:{s:7:\"timeout\";i:1691405763;s:5:\"value\";s:146024:\"{\"new_version\":\"2.1.3\",\"stable_version\":\"2.1.3\",\"name\":\"perfmatters\",\"slug\":\"perfmatters\",\"url\":\"https:\\/\\/perfmatters.io\\/downloads\\/perfmatters\\/?changelog=1\",\"last_updated\":\"2023-07-02 21:12:19\",\"homepage\":\"https:\\/\\/perfmatters.io\",\"package\":\"\",\"download_link\":\"\",\"sections\":{\"description\":\"<p><a href=\\\"https:\\/\\/perfmatters.io\\/\\\">Perfmatters<\\/a> is a lightweight web performance plugin designed to help increase Google Core Web Vitals scores and fine-tune how assets load on your site.<\\/p>\\n<h4> Features <\\/h4>\\n<ul>\\n<li>Easy quick toggle options to turn off resources that shouldn\'t be loading. <\\/li>\\n<li>Disable scripts and plugins on a per post\\/page or sitewide basis with the Script Manager. <\\/li>\\n<li>Defer and delay JavaScript, including third-party scripts.<\\/li>\\n<li>Automatically remove unused CSS.<\\/li>\\n<li>Preload resources, critical images, and prefetch links for quicker load times.<\\/li>\\n<li>Lazy load images and enable click-to-play thumbnails on videos.<\\/li>\\n<li>Host Google Analytics and Google Fonts locally.<\\/li>\\n<li>Change your WordPress login URL. <\\/li>\\n<li>Disable and limit WordPress revisions.<\\/li>\\n<li>Add code to your header, body, and footer.<\\/li>\\n<li>Optimize your database.<\\/li>\\n<\\/ul>\\n<h4> Documentation <\\/h4>\\n<p>Check out our <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/\\\">documentation<\\/a> for more information on how to use Perfmatters.<\\/p>\",\"changelog\":\"<p>2.1.3<\\/p>\\n<ul>\\n<li>Fixed an issue that was preventing existing Script Manager settings from showing up in certain instances.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>2.1.2<\\/p>\\n<ul>\\n<li>Added new lazy loading advanced option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#exclude-parent-selector\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Exclude Images by Parent Selector<\\/a>.<\\/li>\\n<li>Added built-in exclusion to Delay JS for jqueryParams inline script to prevent load order issues.<\\/li>\\n<li>Added additional built-in exclusions to Remove Unused CSS for better compatibility with Elementor.<\\/li>\\n<li>Added HTTPS check to PERFMATTERS_CACHE_URL definition.<\\/li>\\n<li>Updated Script Manager UI to sort plugins alphabetically by plugin name as well as assets inside each individual section alphabetically by script handle.<\\/li>\\n<li>Fixed an issue where plugins without any enqueued scripts would not always show up in the Script Manager (MU Mode) after visiting the global view.<\\/li>\\n<li>Updated background processing library to version 1.1.0.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>2.1.1<\\/p>\\n<ul>\\n<li>Added <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/wp-cli\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">WP-CLI<\\/a> support for managing plugin license key activation.<\\/li>\\n<li>Changed behavior of Disable Cart Fragments toggle to only load cart fragmentation script when there are items in the cart.<\\/li>\\n<li>Added default array for critical image preload exclusions that are always needed.<\\/li>\\n<li>Added additional Delay JS quick exclusions for Bricks Slider and WP Armour.<\\/li>\\n<li>Added additional built-in exclusions for Remove Unused CSS for better compatibility with Elementor and Google Reviews Widget.<\\/li>\\n<li>Updated lazy loading fade-in effect to use CSS animation property instead of transition for better compatibility with existing element transitions.<\\/li>\\n<li>Added requirement for advanced options to be turned on to be able to defer jQuery.<\\/li>\\n<li>Added WP-CLI request exclusion to MU plugin functions.<\\/li>\\n<li>Fixed a PHP warning that could sometimes be generated if an image was not able to be parsed for missing dimensions.<\\/li>\\n<li>Updated instant.page library to version 5.2.0.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>2.1.0<\\/p>\\n<ul>\\n<li>Added new delay JS option for <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/delay-javascript\\/#quick-exclusions\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Quick Exclusions<\\/a> that will show up when certain popular plugins and themes are activated.<\\/li>\\n<li>Made some updates to the Script Manager UI to match recent changes to the main plugin settings.<\\/li>\\n<li>Cleared out some code for the previous settings admin header that was no longer needed.<\\/li>\\n<li>Made an adjustment to CDN URL function to work even if a trailing slash was entered.<\\/li>\\n<li>Rearranged our local and Google font options to give frequently used options more priority.<\\/li>\\n<li>Fixed a bug where multiple settings sections were displaying at the same time after saving from the database tab.<\\/li>\\n<li>Fixed an issue where accessibility mode tooltips were not getting styled properly in the plugin UI.<\\/li>\\n<li>Fixed a styling issue where link and button colors were getting applied outside of the main Perfmatters admin container.<\\/li>\\n<li>Fixed an issue in MU Mode where the global filtered plugin list would not always return correctly.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>2.0.9<\\/p>\\n<ul>\\n<li>Updated Request library functions used to download local font files to fix a compatibility issue with WordPress 6.2.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_preloads_ready\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_preloads_ready<\\/a> filter.<\\/li>\\n<li>Fixed a styling issue in Safari where the settings UI logo was getting clipped.<\\/li>\\n<\\/ul>\\n<p>2.0.8<\\/p>\\n<ul>\\n<li>Updated plugin settings UI. Completely overhauled admin header and navigation. Made additional improvements to various elements (icons, buttons, toggles, etc.).<\\/li>\\n<li>Added additional checks to allow PERFMATTERS_CACHE_DIR and PERFMATTERS_CACHE_URL to be manually set in wp-config.php.<\\/li>\\n<li>Updated user agent for local font remote request.<\\/li>\\n<li>Fixed an issue where multiple preload tags for the same resource could be printed if the resource was matched more than once in the DOM.<\\/li>\\n<li>Fixed an issue where an individually delayed script would fail to load if it matched more than one delayed script entry.<\\/li>\\n<li>Fixed an issue where FastClick script could still load even if Delay JS was turned off.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>2.0.7<\\/p>\\n<ul>\\n<li>Fixed an issue that was introduced in the last update that was causing certain images that had their HTML modified by another tool not to lazy load correctly.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>2.0.6<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#minimal-v4\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Minimal v4<\\/a> script type option in local analytics.<\\/li>\\n<li>Added support for ::after pseudo element when lazy loading CSS background images.<\\/li>\\n<li>Added support for AVIF images in a source tag to preload critical images feature.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_preload_critical_images\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_preload_critical_images<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_image_dimensions_exclusions\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_image_dimensions_exclusions<\\/a> filter.<\\/li>\\n<li>Added notice to plugin update row if there is not an active license key.<\\/li>\\n<li>Added async attribute to Instant Page script tag.<\\/li>\\n<li>Added async attribute to all relevant local analytics script tags.<\\/li>\\n<li>Reworked preload class to allow managing preloads entirely with perfmatters_preloads filter if needed.<\\/li>\\n<li>Fixed an issue in MU Mode where plugins would not always disable correctly when helper plugins with similar directories were also active.<\\/li>\\n<li>Fixed a couple of PHP warnings in MU plugin that would show up when certain variables were not declared.<\\/li>\\n<li>Fixed an issue where our lazy loading script was attempting to load in images that had been prepped by another active lazy loader.<\\/li>\\n<li>Fixed an issue where base64 encoded images were being picked up by missing image dimensions feature.<\\/li>\\n<li>Removed BETA tag from preload critical images option.<\\/li>\\n<\\/ul>\\n<p>2.0.5<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_exclude_leading_images\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_exclude_leading_images<\\/a> filter.<\\/li>\\n<li>Fixed an issue that was affecting lazy loaded inline background images in certain formats.<\\/li>\\n<li>Fixed a PHP warning related to Fastclick and the built-in exclusion for WooCommerce pages.<\\/li>\\n<li>Updated license key field to prevent it from getting auto-filled by browser extensions.<\\/li>\\n<\\/ul>\\n<p>2.0.4<\\/p>\\n<ul>\\n<li>Fixed an issue that was causing the Perfmatters admin bar menu and meta options to not show up in the admin.<\\/li>\\n<li>Added additional nopin attribute for Pinterest to YouTube preview thumbnails.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>2.0.3<\\/p>\\n<ul>\\n<li>Added new local Google fonts advanced option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/host-google-fonts-locally\\/#async\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Load Asynchronously<\\/a>.<\\/li>\\n<li>Added user agent check before running output buffer with initial exclusion for Usercentrics scanner.<\\/li>\\n<li>Added support for CSS variables when they are being used for lazy loaded inline background images.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_lazyload_youtube_autoplay\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload_youtube_autoplay<\\/a> filter.<\\/li>\\n<li>Improved delay all script handling of jQuery load event.<\\/li>\\n<li>Changed all WooCommerce checks to use class_exists for better compatibility.<\\/li>\\n<li>Adjusted the order of preloads in the buffer to make sure they print above used CSS.<\\/li>\\n<li>Moved buffer class initialization to wp action hook to improve filtering possibilities.<\\/li>\\n<li>Moved WooCommerce built-in exclusions to apply to select individual features instead of the entire buffer.<\\/li>\\n<li>Slight modification to previous MU Mode addition to fix an issue.<\\/li>\\n<li>Fixed an issue where custom heartbeat interval was not being applied correctly when editing certain custom post types.<\\/li>\\n<li>Fixed an issue with the local stylesheet CDN URL when advanced options were turned on but no URL was set.<\\/li>\\n<li>Fixed an issue where delay script was printing out more than once if multiple closing body tags were present in the DOM.<\\/li>\\n<\\/ul>\\n<p>2.0.2<\\/p>\\n<ul>\\n<li>Fixed an issue that was preventing Removed Unused CSS from running correctly in certain cases when Advanced Options were toggled on.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>2.0.1<\\/p>\\n<ul>\\n<li>Added new toggle to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/advanced-options\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Show Advanced Options<\\/a> in the Perfmatters UI.<\\/li>\\n<li>Added new advanced option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/delay-javascript\\/#disable-click-delay\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Disable Click Delay<\\/a> in JavaScript section.<\\/li>\\n<li>Added new advanced option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/delay-javascript\\/#fastclick\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Enable FastClick<\\/a> in JavaScript section.<\\/li>\\n<li>Added new advanced option to specify a <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/remove-unused-css\\/#cdn-url\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">CDN URL<\\/a> in CSS section.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/change-wordpress-login-url\\/#local-redirect\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Local Redirect<\\/a> option to existing login URL disabled behavior selection.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_buffer_excluded_extensions\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_buffer_excluded_extensions<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_rucss_excluded_stylesheets\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_rucss_excluded_stylesheets<\\/a> filter.<\\/li>\\n<li>Added additional built-in exclusions for Remove Unused CSS for better compatibility with Elementor, Divi, Slider Revolution, OptimizePress, and WordPress core.<\\/li>\\n<li>Added additional logic in MU Mode to more reliably retrieve the ID for certain custom post types.<\\/li>\\n<li>Moved lazyload functions to new class structure to be more inline with current codebase.<\\/li>\\n<li>Modified regex for lazy loading inline background images to support additional formats.<\\/li>\\n<li>Integrated lazyload functions into the main output buffer to allow interaction with other existing features.<\\/li>\\n<li>Fixed an issue where dynamic preloads were not recognizing existing query strings in some cases.<\\/li>\\n<li>Fixed a PHP warning that would show up in some cases by adding additional string check when looping through rewrite array.<\\/li>\\n<li>Fixed an issue with MU Mode where sometimes the wrong plugin would get disabled if there were multiple plugins using similar directory paths.<\\/li>\\n<li>Fixed an issue where images inside script tags were being picked up by the Preload Critical Images function.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>2.0.0<\\/p>\\n<ul>\\n<li>Added new system for query string timestamps for Used CSS file method to help see changes quicker in environments with caching.<\\/li>\\n<li>Added support for ?perfmattersoff query string which gives the ability to quickly prevent the majority of Perfmatters features from running on the front end for testing purposes.<\\/li>\\n<li>Added additional support for updating the plugin via WP-CLI.<\\/li>\\n<li>Made some changes to admin bar menu item. There is now a Perfmatters top-level admin bar menu item that links to our plugin settings page. The Script Manager and Clear Used CSS function can be accessed by hovering over that main menu item if those features are enabled.<\\/li>\\n<li>Added new toggle in tools to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/hide-admin-bar-menu\\/\\\" target=\\\"_blank\\\" rel=\\\"noreferrer noopener\\\">Hide Admin Bar Menu<\\/a>.<\\/li>\\n<li>Disabled certain features from running on WooCommerce cart, checkout, and account pages for better compatibility.<\\/li>\\n<li>Increased site limit in dropdowns on Multisite network settings page.<\\/li>\\n<li>Added additional compatibility styles to the Script Manager.<\\/li>\\n<li>Added additional built-in exclusions for Remove Unused CSS for better compatibility with Elementor, Astra, Kadence, and GenerateBlocks.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_login_url\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_login_url<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_lazyload_noscript\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload_noscript<\\/a> filter.<\\/li>\\n<li>Fixed an issue where YouTube preview thumbnails were generating a preload warning in certain instances.<\\/li>\\n<li>Fixed an issue that was causing analytics.js not to be served over HTTPS in instances where an SSL migration had been done previously on the site.<\\/li>\\n<li>Fixed an issue where delayed style attribute was applied to preloaded stylesheets that already existed in the DOM.<\\/li>\\n<li>Fixed an issue where some features were being allowed to run on XML sitemap URLs in certain cases.<\\/li>\\n<li>Fixed an issue where theme and plugin files were not falling back to a WordPress version query string when present in a dynamic preload.<\\/li>\\n<\\/ul>\\n<p>1.9.9<\\/p>\\n<ul>\\n<li>Added additional autosave interval options.<\\/li>\\n<li>Added WPBakery query string parameter to excluded page builders array.<\\/li>\\n<li>Changed certain lazy loading classes to be more specific to prevent conflicts.<\\/li>\\n<li>Adjusted lazy loading image attribute filter to not run unless images specifically are meant to be lazy loaded by Perfmatters.<\\/li>\\n<li>Added an additional function_exists check in the JS class to prevent an error from being thrown in some cases.<\\/li>\\n<\\/ul>\\n<p>1.9.8<\\/p>\\n<ul>\\n<li>Made adjustments to the CSS Background Image styles to work with some changes in the latest version of our lazy loading library.<\\/li>\\n<li>Fixed an issue that was preventing quotations from being stripped from background image URLs when prepping an inline background image for lazy loading.<\\/li>\\n<li>Fixed an issue where delayed CSS was not loading properly when using individual JS delay.<\\/li>\\n<li>Fixed an error that was being logged in some cases when checking for an active plugin in the JS class.<\\/li>\\n<\\/ul>\\n<p>1.9.7<\\/p>\\n<ul>\\n<li>Made an adjustment to how inline background images are prepped to work with some changes in the latest version of our lazy loading library.<\\/li>\\n<\\/ul>\\n<p>1.9.6<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_delay_js_delay_click\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_delay_js_delay_click<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_local_stylesheet_url\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_local_stylesheet_url<\\/a> filter.<\\/li>\\n<li>Made some performance improvements to the way the lazy loading script and inline code are loaded.<\\/li>\\n<li>Added additional compatibility for Elementor animations when using Delay JS.<\\/li>\\n<li>Added additional details in the Script Manager global view for individual stored settings.<\\/li>\\n<li>Added the ability to identify and clear outdated post IDs set in the Script Manager options from the global view.<\\/li>\\n<li>Script Manager global view organization and style improvements.<\\/li>\\n<li>Updated lazy loading library to version 17.8.<\\/li>\\n<li>Updated instant.page library to version 5.1.1.<\\/li>\\n<li>Added Bricks query string parameter to excluded page builders array.<\\/li>\\n<li>Fixed an issue that was causing the cache directory to not create unique subsite paths for specific multisite setups.<\\/li>\\n<li>Fixed an issue where delayed stylesheets were not being loaded if Delay JS was toggled off in the post meta options.<\\/li>\\n<\\/ul>\\n<p>1.9.5<\\/p>\\n<ul>\\n<li>Added additional logic to Delay JS script to make sure the initial interaction is processed.<\\/li>\\n<li>Added additional styles to CSS Background Image feature to work with background images set on ::before selectors.<\\/li>\\n<li>Added additional default tags to various dropdowns in plugin settings for better clarification.<\\/li>\\n<li>Added default arrays for stylesheet and selector exclusions that are always needed.<\\/li>\\n<li>Adjusted perfmatters_cdn filter location for compatibility.<\\/li>\\n<li>Made some adjustments to CDN Rewrite Regex to fix some issues where unwanted strings were getting picked up as URLs in some cases.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.9.4<\\/p>\\n<ul>\\n<li>Updated EDD plugin updater class to version 1.9.2.<\\/li>\\n<li>Added default exclusion to REST API option for compatibility.<\\/li>\\n<\\/ul>\\n<p>1.9.3<\\/p>\\n<ul>\\n<li>Remove Used CSS filter adjustment to fix an issue where certain WordPress post functions wouldn\'t be available when trying to selectively disable the feature.<\\/li>\\n<li>Rolled back minor plugin UI JavaScript addition, as it was interfering with entering data on multiple lines in certain input fields.<\\/li>\\n<\\/ul>\\n<p>1.9.2<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_allow_buffer https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_used_css\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_used_css<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_allow_buffer\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_allow_buffer<\\/a> filter.<\\/li>\\n<li>Added a notice in the Script Manager when Testing Mode is enabled.<\\/li>\\n<li>Improved reliability of CSS Background Image function when child elements with additional background images are present.<\\/li>\\n<li>Script Manager style compatibility fixes.<\\/li>\\n<li>Fixed an issue where some post specific meta options were not being respected when determining if a feature should run.<\\/li>\\n<li>Fixed an issue where pressing enter on the main plugin settings page would trigger a specific form action instead of save settings.<\\/li>\\n<li>Changed CSS class initialization hook to be in the correct order with other output buffer functions.<\\/li>\\n<li>Made an adjustment to how we generate the local used stylesheet URL for better compatibility.<\\/li>\\n<li>Fixed an issue where loading attribute was still getting applied to images that were excluded from lazy loading.<\\/li>\\n<li>Fixed an issue where images inside an excluded picture element were not also getting excluded.<\\/li>\\n<li>Fixed an issue in the Script Manager where archives were not being grouped together with their respective post type.<\\/li>\\n<li>Additions to plugin UI JavaScript to allow for disabled sections to be hidden even when nested controllers are present.<\\/li>\\n<li>Moved background process library to composer autoloader.<\\/li>\\n<li>Removed BETA tag from Remove Unused CSS option.<\\/li>\\n<\\/ul>\\n<p>1.9.1<\\/p>\\n<ul>\\n<li>Added new option to lazy load <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#css-background-images\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">CSS Background Images<\\/a>.<\\/li>\\n<li>Added new option for <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#dual-tracking\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Dual Tracking<\\/a> when using gtag.js in local analytics.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_rest_api_exceptions\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_rest_api_exceptions<\\/a> filter.<\\/li>\\n<li>Fixed an issue where individually delayed local scripts would not get correctly rewritten to load from the CDN.<\\/li>\\n<li>Fixed an issue where lazy loading would run into an error if no px or % was specified with the threshold value.<\\/li>\\n<li>Fixed an issue with buffer validation that was conflicting with certain caching setups.<\\/li>\\n<li>Fixed an issue where existing font preconnect and prefetch tags were not being detected properly when using Local Fonts.<\\/li>\\n<li>Fixed an error related to cookie constants when running MU Mode in certain environments.<\\/li>\\n<li>Fixed multiple AMP validation errors and added additional checks to prevent certain functions from running on AMP URLs.<\\/li>\\n<li>Minor adjustment to CDN rewrite regex pattern to work with encoded quotation characters.<\\/li>\\n<li>Changed toggle CSS selectors to be more specific to prevent conflicts.<\\/li>\\n<li>Moved plugin settings header output to in_admin_header action hook for compatibility.<\\/li>\\n<li>Moved JS optimization functions to new class structure to be more inline with current codebase.<\\/li>\\n<li>Improvements to critical image preloading allowed for a move to a singular output buffer.<\\/li>\\n<\\/ul>\\n<p>1.9.0<\\/p>\\n<ul>\\n<li>Fixed an issue that was causing excluded selectors to not be recognized properly after Used CSS was cleared.<\\/li>\\n<li>Minor adjustments to the new plugin UI.<\\/li>\\n<\\/ul>\\n<p>1.8.9<\\/p>\\n<ul>\\n<li>Updated plugin settings UI.<\\/li>\\n<li>Added new post meta option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/remove-unused-css\\/#clear-individual\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Clear Used CSS<\\/a> for an individual page or post type.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_rucss_excluded_selectors\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_rucss_excluded_selectors<\\/a> filter.<\\/li>\\n<li>Fixed a lazy loading issue that was preventing some images from loading properly in Safari.<\\/li>\\n<li>Migrated Delay JS Timeout dropdown to a simpler on\\/off toggle that will default to 10 seconds. Our filter is also still available to set a custom timeout value.<\\/li>\\n<li>Fixed an issue with MU plugin that was interfering with rewrite rules in some instances.<\\/li>\\n<li>Added additional excluded page builder parameter for Flatsome UX.<\\/li>\\n<li>Moved restore default functionality to a separate option on the tools page.<\\/li>\\n<li>Code refactoring.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.8.8<\\/p>\\n<ul>\\n<li>Changed default setting for Used CSS Method from file to inline, as we think this will be the more compatible solution for most users going forward. If you were previously using the file method, you may need to save that option again.<\\/li>\\n<li>Added width and height parameters to placeholder SVGs to prevent warnings for a ratio mismatch that would happen for some images.<\\/li>\\n<li>Fixed an issue where the noscript tags were getting malformed for some images inside picture tags after lazy loading.<\\/li>\\n<li>Removed placeholder SVGs on source tags since the image tag will already have one.<\\/li>\\n<li>Changed settings export file name date format to be easier to organize when managing multiples.<\\/li>\\n<li>Updated tooltip for Blank Favicon option to be more clear.<\\/li>\\n<\\/ul>\\n<p>1.8.7<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/remove-unused-css\\/#css-method\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Used CSS Method<\\/a> option to choose whether to load used CSS from a file or inline.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_cache_path\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_cache_path<\\/a> filter.<\\/li>\\n<li>Updated metabox functions to restrict metabox display to administrators only.<\\/li>\\n<li>Made some adjustments to custom login URL function to better support 3rd party tools using WP CLI.<\\/li>\\n<li>Added Fusion Builder query string parameters to excluded page builders array.<\\/li>\\n<li>Adjusted Unused CSS regex to be more consistent when stylesheets are placed in between other link tags.<\\/li>\\n<li>Changes to instances where ABSPATH was used to determine a directory location for better compatibility with certain hosts.<\\/li>\\n<li>Fixed an issue with Remove Global Styles option where duotone SVGs were not being removed on WordPress 5.9.2.<\\/li>\\n<li>Fixed an issue where WooCommerce block stylesheets were not getting correctly dequeued when Disable Scripts option was set.<\\/li>\\n<li>Fixed an issue that was causing the CSS Parser library not to get included correctly in certain cases.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.8.6<\\/p>\\n<ul>\\n<li>Added new option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/remove-global-inline-styles-wordpress\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Remove Global Styles<\\/a> related to duotone filters.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_script_manager_locale\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_script_manager_locale<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_disable_woocommerce_scripts\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_disable_woocommerce_scripts<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_page_builders\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_page_builders<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_delay_js_behavior\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_delay_js_behavior<\\/a> filter.<\\/li>\\n<li>Fixed an issue with the unused CSS parser that was incorrectly rewriting relative URLs if there was no query string present on the original stylesheet src.<\\/li>\\n<li>Added additional parameter to page builders array for compatibility.<\\/li>\\n<li>Fixed an issue that was causing the login URL disabled 404 behavior to result in an error if a 404 template was not found.<\\/li>\\n<li>Added some additional checks before creating cache directories for local fonts and used CSS.<\\/li>\\n<li>Fixed an issue that was causing the fade-in effect to conflict with child images inside a lazy loaded container.<\\/li>\\n<li>Fixed an undefined index warning coming from unused CSS settings update function.<\\/li>\\n<li>Added a default delay JS exclusion for admin only inline customize-support script.<\\/li>\\n<li>Refactored entire meta.php code to be more efficient (38% smaller) and in line with current structure.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.8.5<\\/p>\\n<ul>\\n<li>Added new feature to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/remove-unused-css\\/#remove-unused-css\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Remove Unused CSS<\\/a> (BETA).<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_remove_unused_css\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_remove_unused_css<\\/a> filter.<\\/li>\\n<li>Adjusted CDN Rewrite buffer priority for better compatibility with other features.<\\/li>\\n<li>Made an improvement to the Disable XML-RPC function to return a 403 error when xmlrpc.php is accessed directly.<\\/li>\\n<li>Script Manager stylesheet updates for better compatibility.<\\/li>\\n<li>Fixed an issue in the Script Manager where the input controls were sometimes not displaying after toggling a script off.<\\/li>\\n<li>Added additional style for YouTube preview thumbnail play button to fix an alignment issue with certain setups.<\\/li>\\n<li>Buffer adjustments for compatibility.<\\/li>\\n<\\/ul>\\n<p>1.8.4<\\/p>\\n<ul>\\n<li>Fixed an issue that was interfering with sitemap display in certain configurations.<\\/li>\\n<li>Added &lt;a&gt; element support for lazy loading inline background images.<\\/li>\\n<\\/ul>\\n<p>1.8.3<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_fade_in_speed\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_fade_in_speed<\\/a> filter.<\\/li>\\n<li>Fixed an issue that was preventing lazy loading fade in from working correctly with certain background images.<\\/li>\\n<li>Fixed an issue that was interfering with the display of certain inline SVG elements.<\\/li>\\n<li>Adjusted local analytics hook priority for better compatibility.<\\/li>\\n<li>Script Manager style updates for better compatibility.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.8.2<\\/p>\\n<ul>\\n<li>New Lazy Loading option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#exclude-leading-images\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Exclude Leading Images<\\/a>.<\\/li>\\n<li>New Lazy Loading option to add a <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#fade-in\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Fade In<\\/a> effect.<\\/li>\\n<li>New option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/preload\\/#critical-images\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Preload Critical Images<\\/a> (BETA).<\\/li>\\n<li>Expanded Disable XML-RPC function to also remove pingback link tag if it is present in the document.<\\/li>\\n<li>Added new Delay JavaScript checkbox to meta options in the post editor.<\\/li>\\n<li>Added additional integration with perfmatters_delay_js filter.<\\/li>\\n<li>Moved YouTube autoplay parameter placement on lazy loaded iframes for better compatibility with existing query strings.<\\/li>\\n<li>Optimizations to lazy loading inline CSS functions.<\\/li>\\n<li>Various optimizations and improvements to the output buffer.<\\/li>\\n<li>Migrated manual preload functionality to use the output buffer which will allow for easier integration with new features.<\\/li>\\n<li>Made some adjustments to MU plugin functions to more reliably detect post IDs when using specific permalink setups.<\\/li>\\n<li>Fixed an issue where some Current URL links in the Script Manager\'s Global View were not pointing to the right posts.<\\/li>\\n<li>Fixed an issue with a certain endpoint that was redirecting to the custom login URL.<\\/li>\\n<li>Fixed a PHP notice that was sometimes appearing when refreshing local fonts.<\\/li>\\n<li>Removed BETA tag from Delay All JS option.<\\/li>\\n<\\/ul>\\n<p>1.8.1<\\/p>\\n<ul>\\n<li>Updated Local Google Font function to more effectively remove existing font preconnect and prefetch tags.<\\/li>\\n<li>Updated Local Google Font function for better compatibility with sites that still have remnants from a previous http to https migration.<\\/li>\\n<li>Fixed an issue in the Script Manager where the home page was being treated as a post if set to display the blog feed.<\\/li>\\n<\\/ul>\\n<p>1.8.0<\\/p>\\n<ul>\\n<li>Fixed an issue with Delay All JS that was preventing certain async scripts from fully loading.<\\/li>\\n<\\/ul>\\n<p>1.7.9<\\/p>\\n<ul>\\n<li>Added new options to the Script Manager to disable assets directly by post type, archive, user status, and device type.<\\/li>\\n<li>Added support for dynamic preloading by handle for enqueued scripts and styles.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_lazyload\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_cdn\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_cdn<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_delay_js_timeout\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_delay_js_timeout<\\/a> filter.<\\/li>\\n<li>Fix to Delay All JS script for better compatibility with certain page builder animations.<\\/li>\\n<li>Updated class initialization for better compatibility.<\\/li>\\n<li>Fixed an issue where the Script Manager was interpreting certain array keys as shortcodes if they were identical.<\\/li>\\n<li>Added an additional check to prevent the Script Manager from being able to load on top of a page builder.<\\/li>\\n<li>Fixed a PHP notice coming from the MU plugin.<\\/li>\\n<li>Made some changes to our plugin updater function that should help with auto-updates in a multisite environment.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.7.8<\\/p>\\n<ul>\\n<li>Added new option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/missing-width-height-images\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Add Missing Image Dimensions<\\/a>.<\\/li>\\n<li>Added the ability to delete individual Script Manager options from the Global View.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_delay_js\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_delay_js<\\/a> filter.<\\/li>\\n<li>Updated EDD plugin updater class to version 1.9.0.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.7.7<\\/p>\\n<ul>\\n<li>Fixed a PHP warning related to JavaScript deferral for specific configurations.<\\/li>\\n<li>Fixed an issue with lazy loading exclusions not being loaded correctly in some cases.<\\/li>\\n<\\/ul>\\n<p>1.7.6<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/delay-javascript\\/#behavior\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Delay Behavior<\\/a> dropdown with a new option to Delay All Scripts.<\\/li>\\n<li>Added new Lazy Loading <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#threshold\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Threshold<\\/a> option and adjusted the default value if not set to improve performance.<\\/li>\\n<li>Added confirmation message when manually running the database optimization tool.<\\/li>\\n<li>Updated disable emoji function to get rid of a PHP notice.<\\/li>\\n<li>Added additional check to MU Mode to only filter GET requests.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/defer-javascript-wordpress\\/#perfmatters_defer_js-filter\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_defer_js<\\/a> filter.<\\/li>\\n<li>Fixed an issue where Instant Page was attempting to run on the new widgets screen in WordPress 5.8.<\\/li>\\n<li>Fixed an issue with Local Google Fonts where certain invalid font URLs would still attempt to be downloaded and served.<\\/li>\\n<li>Removed BETA tag from fonts section.<\\/li>\\n<li>Delay JavaScript compatibility improvements.<\\/li>\\n<li>Added additional input validation functionality to plugin settings page.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.7.5<\\/p>\\n<ul>\\n<li>Added new custom login URL options to change the <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/change-wordpress-login-url\\/#disabled-behavior\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Disabled Behavior<\\/a> and set a custom <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/change-wordpress-login-url\\/#message\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Message<\\/a>.<\\/li>\\n<li>Migrated CDN, Analytics, and Extras tab data to separate sections in the Options tab for better organization and easier access.<\\/li>\\n<li>CDN rewrite improvements to better handle sites with multiple domain URLs.<\\/li>\\n<li>Regex adjustments to Local Fonts function for better reliability.<\\/li>\\n<li>Added exclusion checks to individual &lt;source&gt; tags when using WebP images.<\\/li>\\n<li>Added function to disable capital_P_dangit filter.<\\/li>\\n<li>Fixed a lazy loading warning that was showing in Microsoft Edge.<\\/li>\\n<li>Removed loading attribute that was getting applied to &lt;picture&gt; tags in some cases when using WebP images.<\\/li>\\n<li>Plugin UI navigation performance improvements.<\\/li>\\n<li>Plugin UI style fixes.<\\/li>\\n<li>Added a conditional check to only show WooCommerce options when WooCommerce is installed and activated.<\\/li>\\n<li>Fixed an MU Mode issue where the Home URL did not trigger a match if a query string was present.<\\/li>\\n<li>Fixed an issue where the Customizer was getting certain optimizations applied.<\\/li>\\n<li>Fixed an issue where the Disable Embeds toggle was interfering with responsive video styles.<\\/li>\\n<li>Script Manager UI fixes.<\\/li>\\n<li>Updated uninstall function to remove Perfmatters cache folder.<\\/li>\\n<li>Added readme.txt file.<\\/li>\\n<\\/ul>\\n<p>1.7.4<\\/p>\\n<ul>\\n<li>Re-enabled Local Google Fonts functionality.<\\/li>\\n<li>Refactoring of buffer-related code and various functions that were already using our main buffer filter.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.7.3<\\/p>\\n<ul>\\n<li>Rolled back the latest changes related to the new universal buffer class and Local Google Fonts while we do some more in-depth testing. We\'ll be working to release this feature next week using an alternative method.<\\/li>\\n<\\/ul>\\n<p>1.7.2<\\/p>\\n<ul>\\n<li>Added new Fonts section inside of the main Options tab.<\\/li>\\n<li>Added new option to use <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/font-display-swap\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Display Swap<\\/a> for Google fonts.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/host-google-fonts-locally\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Local Google Fonts<\\/a> option which will attempt to download any Google Font files and serve them from your local server or CDN.<\\/li>\\n<li>Integrated new universal HTML buffer library to help going forward with plugin features that manipulate DOM elements.<\\/li>\\n<li>Migrated CDN Rewrite feature to the universal buffer class.<\\/li>\\n<li>Added new perfmatters_delayed_scripts filter to modify the Delay JavaScript input array before any scripts are delayed.<\\/li>\\n<li>Added new perfmatters_preload filter to modify the Preloads data array before anything is printed.<\\/li>\\n<li>Made some compatibility improvements to the inline lazy loading JavaScript.<\\/li>\\n<li>Added attributes to delayed scripts to exclude them from being picked up by Litespeed Cache.<\\/li>\\n<li>Added exclusion for SiteGround Optimizer to the main Script Manager JavaScript file.<\\/li>\\n<li>Added CodeMirror support to all code text area inputs in plugin settings.<\\/li>\\n<li>Removed license activation check and corresponding links from the plugins page to improve back-end performance.<\\/li>\\n<\\/ul>\\n<p>1.7.1<\\/p>\\n<ul>\\n<li>Added expiration date row to license tab in plugin settings.<\\/li>\\n<li>Added support for WooCommerce shop page when setting a preload location by post ID.<\\/li>\\n<li>Fixed an issue with device exceptions not working correctly in MU Mode.<\\/li>\\n<li>Fixed a query string encoding issue that was affecting some email templates when using a custom login URL.<\\/li>\\n<\\/ul>\\n<p>1.7.0<\\/p>\\n<ul>\\n<li>Fixed an issue where Preload tags were still being printed on archive pages even if a location was set.<\\/li>\\n<li>Fixed a compatibility issue with older WordPress versions when using certain functions that check for a JSON request.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.6.9<\\/p>\\n<ul>\\n<li>New additions to preload feature, allowing specification for device type and location.<\\/li>\\n<li>Script Manager improvements to allow for Regex disable to be used alongside Current URL disables for the same script.<\\/li>\\n<li>Added new Script Manager exception for device type.<\\/li>\\n<li>Add new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/delay-javascript\\/#timeout\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Delay Timeout<\\/a> option when delaying JavaScript.<\\/li>\\n<li>Added new wheel event to user interaction script for delay function.<\\/li>\\n<li>Added new multisite network administration tool to apply default site settings to all subsites.<\\/li>\\n<li>Multiple improvements to WooCommerce disable scripts toggle for increased effectiveness.<\\/li>\\n<li>Added additional exclusions for JSON and REST requests to all asset optimization functions.<\\/li>\\n<li>Fixed an undefined index warning coming from local analytics function.<\\/li>\\n<li>Fixed an issue where YouTube preview thumbnails were getting a layout shift warning when using a theme with responsive embed support.<\\/li>\\n<li>Fixed a Script Manager bug that was not fully clearing exceptions when changing disable away from everywhere.<\\/li>\\n<li>Script Manager styling compatibility fixes.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.6.8<\\/p>\\n<ul>\\n<li>Compatibility fixes for local analytics when using MonsterInsights.<\\/li>\\n<li>Local analytics improvements for multisite.<\\/li>\\n<li>Added alt tag to YouTube preview thumbnail images.<\\/li>\\n<li>Fixed a PHP undefined index notice coming from functions.php.<\\/li>\\n<li>Translation file updates.<\\/li>\\n<\\/ul>\\n<p>1.6.7<\\/p>\\n<ul>\\n<li>Added new tool to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/purge-meta-options\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Purge Perfmatters Meta Options<\\/a>.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/disable-google-maps-api-wordpress\\/#exclude\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Exclude Post IDs<\\/a> input for existing Disable Google Maps option.<\\/li>\\n<li>Added new gtag.js option to local analytics script type selection.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#gtag-cdn\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">CDN URL<\\/a> input to local analytics options when using gtag.js.<\\/li>\\n<li>Added new option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#amp\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Enable AMP Support<\\/a> to local analytics.<\\/li>\\n<li>Moved Use MonsterInsights option to gtag.js script type and updated script replacement hook.<\\/li>\\n<li>Added onload function to style preloads to prevent duplicate preloads from occurring.<\\/li>\\n<li>Added exception for WP Rocket script deferral to our lazy load script.<\\/li>\\n<li>Added exception for site health tool to disable heartbeat function.<\\/li>\\n<li>Fixed an issue where background images weren\\u2019t being lazy loaded if the style attribute was the first attribute declared on the element.<\\/li>\\n<li>Script Manager styling fixes.<\\/li>\\n<li>Fixed a PHP warning coming from settings.php.<\\/li>\\n<li>Translation file updates.<\\/li>\\n<\\/ul>\\n<p>1.6.6<\\/p>\\n<ul>\\n<li>Added new Script Manager exception to select <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/script-manager-logged-in-logged-out\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">logged in or logged out<\\/a> users.<\\/li>\\n<li>Added new option in Script Manager settings to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/script-dependencies\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Display Dependencies<\\/a>.<\\/li>\\n<li>Added total plugin sizes in the Script Manager.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#viewport-threshold\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload_threshold<\\/a> filter to adjust the distance at which lazy elements are loaded.<\\/li>\\n<li>Multiple Script Manager style and UI improvements.<\\/li>\\n<li>Fixed an issue where MU mode script was attempting to run on wp-login.php.<\\/li>\\n<li>Multiple page builder compatibility fixes.<\\/li>\\n<li>Made an adjustment to prevent YouTube preview thumbnails from getting picked up by Pinterest image hover tools.<\\/li>\\n<li>Removed deprecated plugin option to Remove Query Strings. Make sure to double-check your preloads as Google needs the exact URL when preloading.<\\/li>\\n<li>PHP 8 compatibility testing.<\\/li>\\n<li>Minor adjustments to lazy load inline scripts to fix invalid markup warnings.<\\/li>\\n<\\/ul>\\n<p>1.6.5<\\/p>\\n<ul>\\n<li>Added new option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/delay-javascript\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Delay JavaScript<\\/a> from loading until user interaction.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#script-type\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">gtag.js v4<\\/a> option to local analytics.<\\/li>\\n<li>Added new built-in option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#exclude\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Exclude from Lazy Loading<\\/a> which can be used in addition to the existing filter.<\\/li>\\n<li>Add new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#youtube-preview-thumbnails\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload_youtube_thumbnail_resolution<\\/a> filter to adjust YouTube preview thumbnail quality.<\\/li>\\n<li>Optimized analytics updater function.<\\/li>\\n<li>Updated EDD plugin updater class which will now allow for WordPress auto-update support.<\\/li>\\n<li>Removed option to Defer Inline JavaScript which is now being replaced by the new Delay JavaScript option.<\\/li>\\n<li>Adjusted Script Manager hook priority for better compatibility.<\\/li>\\n<li>Compatability fix to the DOM Monitoring lazy load option.<\\/li>\\n<li>Added compatibility fix for jQuery fitVids to lazy loading function.<\\/li>\\n<li>Fixed an issue where lazy loading was attempting to run on AMP pages.<\\/li>\\n<\\/ul>\\n<p>1.6.4<\\/p>\\n<ul>\\n<li>Fixed an issue that was causing the Reset Script Manager button to not work correctly.<\\/li>\\n<li>Fixed an issue where the Perfmatters meta box wouldn\'t display if only using Lazy Loading.<\\/li>\\n<li>Adjusted Script Manager hook priority for better compatibility.<\\/li>\\n<li>Added additional checks to MU Mode plugin file to prevent it from interfering with certain REST API requests. (Fixes a bug when running the Yoast SEO data indexer.)<\\/li>\\n<li>Added additional checks to confirm user functions are available before verifying admin status.<\\/li>\\n<li>Updated translation files.<\\/li>\\n<\\/ul>\\n<p>1.6.3<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/testing-mode\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Testing Mode<\\/a> option to the Script Manager settings.<\\/li>\\n<li>Rewrote script-manager.js entirely using vanilla JavaScript to get rid of jQuery dependency.<\\/li>\\n<li>Added additional MU Mode check to help prevent certain configurations from interfering with AJAX requests.<\\/li>\\n<li>Improved Script Manager form handling.<\\/li>\\n<li>Adjusted Script Manager disclaimer text and added a close button.<\\/li>\\n<li>Moved the Script Manager print function from the wp_footer hook to shutdown for better compatibility.<\\/li>\\n<li>Fixed an undefined index warning in the Lazy Load function.<\\/li>\\n<li>Added a Lazy Load exclusion for Gravity Forms iframes.<\\/li>\\n<li>Added a Rocket Loader exclusion to the Instant Page JS file.<\\/li>\\n<li>Added an exclusion to the CDN Rewrite for script-manager.js.<\\/li>\\n<li>Script Manager styling fixes for better compatibility.<\\/li>\\n<\\/ul>\\n<p>1.6.2<\\/p>\\n<ul>\\n<li>Updated placeholder text in Preload UI.<\\/li>\\n<li>Fixed an issue where the Password Strength Meter script was getting disabled in the admin.<\\/li>\\n<li>Small tweak to JS Deferral buffer to make sure HTML is being filtered correctly.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.6.1<\\/p>\\n<ul>\\n<li>New Local Analytics Script Type toggle with new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Minimal Analytics<\\/a> options.<\\/li>\\n<li>New <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/defer-javascript-wordpress\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">JavaScript Deferral<\\/a> options in Extras &gt; Assets.<\\/li>\\n<li>Updates to Cart Fragments and Password Strength Meter toggles to improve effectiveness.<\\/li>\\n<li>Multiple updates to Instant Page functionality for better compatibility.<\\/li>\\n<li>Multiple plugin admin UI updates and improvements.<\\/li>\\n<li>Script Manager style updates for better compatibility.<\\/li>\\n<li>MU Mode improvements for increased stability.<\\/li>\\n<li>Fixed an issue causing Preload and Preconnect settings to not save correctly in some cases.<\\/li>\\n<\\/ul>\\n<p>1.6.0<\\/p>\\n<ul>\\n<li>Added a filter to disable WordPress\' native lazy loading when Perfmatters\' lazy loading is active.<\\/li>\\n<li>Adjusted Script Manager styles to more effectively overlay the entire page while still allowing admin bar functions to be fully available.<\\/li>\\n<li>Fixed an undefined index notice that was appearing on specific lazy loading and script manager functions.<\\/li>\\n<li>Updated translation files.<\\/li>\\n<\\/ul>\\n<p>1.5.9<\\/p>\\n<ul>\\n<li>Added new Preloading section in the Extras tab, with new options for <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/link-prefetch\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Instant Page<\\/a> and <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/preload\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Preload<\\/a>.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload_forced_attributes<\\/a> filter to allow for matched elements to be skipped when checking for exclusions.<\\/li>\\n<li>Added support for WooCommerce Shop page to show up as a Current URL option in the Script Manager.<\\/li>\\n<li>Added exclusions for REST and AJAX requests to MU Mode function.<\\/li>\\n<li>Fixed a bug that was causing the MU Mode function to still run even if the Script Manager was disabled.<\\/li>\\n<li>Fixed an issue where images were being prepped for lazy loading on feed URLs.<\\/li>\\n<li>Fixed an issue where lazy loading was breaking images in embeds from the same site.<\\/li>\\n<li>Compatibility fixes for lazy load script with Autoptimize and Litespeed Cache.<\\/li>\\n<\\/ul>\\n<p>1.5.8<\\/p>\\n<ul>\\n<li>Added support for lazy loading background images, iframes, and videos.<\\/li>\\n<li>Added new lazy loading option to enable Youtube Preview Thumbnails.<\\/li>\\n<li>Added multiple page builder exclusions to our lazy load functions.<\\/li>\\n<li>Added proper support for 404 templates in the Script Manager (non-MU).<\\/li>\\n<li>Fixed some minor styling issues in the Script Manager UI.<\\/li>\\n<li>Fixed an undefined index in the database optimizer class.<\\/li>\\n<li>Removed customer email row from the license tab.<\\/li>\\n<\\/ul>\\n<p>1.5.7<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/optimize-wordpress-database\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Database Optimization<\\/a> section in the Extras tab.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">DOM Monitoring<\\/a> option to complement our existing lazy load settings.<\\/li>\\n<li>Added additional input styles in the Script Manager for better compatibility<\\/li>\\n<li>Made some changes to the Script Manager file include process for better compatibility.<\\/li>\\n<li>Fixed multiple undefined index notices.<\\/li>\\n<li>Updated translation files.<\\/li>\\n<\\/ul>\\n<p>1.5.6<\\/p>\\n<ul>\\n<li>Plugin UI improvements, new tooltip styles.<\\/li>\\n<li>Licensing workflow improvements. Simpler UI, license no longer deactivated on plugin deactivation, license auto-activates on input.<\\/li>\\n<li>Moved Script Manager javascript back to a separate plugin file for better compatibility.<\\/li>\\n<li>Added Remove Query Strings exemption to the Script Manager javascript file.<\\/li>\\n<li>Code refactoring.<\\/li>\\n<\\/ul>\\n<p>1.5.5<\\/p>\\n<ul>\\n<li>Added a new modified function to the MU plugin file which should be able to get the current post ID more effectively for certain types of URLs (custom post types, blog page, etc...).<\\/li>\\n<li>Made some improvements to the MU plugin file detection and update process.<\\/li>\\n<\\/ul>\\n<p>1.5.4<\\/p>\\n<ul>\\n<li>Added additional tooltip warning text to the MU Mode toggle.<\\/li>\\n<li>Added <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/mu-mode\\/#debug-mode\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">mu_mode=off<\\/a> URL parameter to force the page to load with MU Mode settings disabled.<\\/li>\\n<li>Added an additi0nal check to make sure MU Mode settings don\'t run if the base Perfmatters plugin is not activated.<\\/li>\\n<\\/ul>\\n<p>1.5.3<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/mu-mode\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">MU Mode<\\/a> (BETA) feature in the Script Manager which can be used to disable plugins per page.<\\/li>\\n<li>Reworked main Script Manager update function to dynamically save settings via AJAX to prevent having to reload the page every time options are saved.<\\/li>\\n<li>Moved Script Manager javascript inline to better support further updates.<\\/li>\\n<li>Fixed an issue in the Script Manager where a Current URL disable would not function correctly for an individual script if the plugin\'s scripts were disabled globally on a different Current URL.<\\/li>\\n<li>Changed hooks for Disable Google Maps and Disable Google Fonts toggles to prevent a conflict with Gutenberg.<\\/li>\\n<li>Added an exclusion attribute to our LazyLoad script to prevent it from conflicting with WP Rocket\'s JS deferral feature.<\\/li>\\n<li>Updated EDD Plugin Updater Class to version 1.7.1.<\\/li>\\n<li>Updated various translation files.<\\/li>\\n<\\/ul>\\n<p>1.5.2<\\/p>\\n<ul>\\n<li>Added new options in Extras \\u2192 Tools to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/import-export\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Import and Export Plugin Settings<\\/a>.<\\/li>\\n<li>Updated Script Manager form input names to be more specific to prevent conflicts when saving Script Manager settings.<\\/li>\\n<li>Added compatibility fix for Beaver Builder to the Script Manager dequeue function.<\\/li>\\n<li>Updated French and German translation files.<\\/li>\\n<\\/ul>\\n<p>1.5.1<\\/p>\\n<ul>\\n<li>Adjusted the Script Manager styles for better compatibility with other admin bar tools when the Script Manager UI is being displayed.<\\/li>\\n<li>Fixed an issue in the Script Manager that was causing individual script settings to not work correctly when the parent group had previously been disabled.<\\/li>\\n<li>Updated Russian (ru_RU) translation files.<\\/li>\\n<li>Updated plugin description.<\\/li>\\n<\\/ul>\\n<p>1.5.0<\\/p>\\n<ul>\\n<li>Fixed a bug that was causing the Script Manager dequeue function to interfere with the query loop in certain cases.<\\/li>\\n<\\/ul>\\n<p>1.4.9<\\/p>\\n<ul>\\n<li>Performance update to Script Manager form submission function which should help dramatically reduce the footprint when saving script configurations.<\\/li>\\n<li>Removed the Current URL option in the Script Manager when loaded on URLs without a valid post ID. (ex. dynamically generated archive templates)<\\/li>\\n<li>Added plugin settings page header with links to Contact and Support.<\\/li>\\n<li>Minor styling fixes in plugin settings UI.<\\/li>\\n<li>Updated Russian (ru_RU) translation files.<\\/li>\\n<\\/ul>\\n<p>1.4.8<\\/p>\\n<ul>\\n<li>Added new \'Body Code\' box in the Extras tab to go along with our existing header + footer boxes to give some more control there.<\\/li>\\n<li>Added some limits to the Script Manager action links in WP Admin to ensure they are only showing up for public post types.<\\/li>\\n<li>Fixed a bug that was causing the admin stylesheet not to load on the network settings page when running on a multisite.<\\/li>\\n<li>Added Russian (ru_RU) translation files. (credit: Sergey Shljahov)<\\/li>\\n<\\/ul>\\n<p>1.4.7<\\/p>\\n<ul>\\n<li>Added an exception for Gravity Forms to the Disable Heartbeat function.<\\/li>\\n<li>Added an exception for Contact Form 7 to the Disable REST API function.<\\/li>\\n<li>Added updated German (de_DE) translation files. (credit: Daniel Luttermann)<\\/li>\\n<\\/ul>\\n<p>1.4.6<\\/p>\\n<ul>\\n<li>Added a specific and more generous threshold for lazy loading.<\\/li>\\n<li>Added some additional dequeues to the Disable WooCommerce function to target inline CSS and JS.<\\/li>\\n<\\/ul>\\n<p>1.4.5<\\/p>\\n<ul>\\n<li>Updated Disable Google Maps and Disable Google Fonts toggles to not run in WP Admin.<\\/li>\\n<li>Turned off native lazy loading by default and added new option to Use Native.<\\/li>\\n<li>Added perfmatters_lazyload_excluded_attributes filter which allows for an array of attribute strings to be given that if found will exclude the matched image\\/s from lazy loading.<\\/li>\\n<li>Made some compatibility improvements to the Script Manager function that gets the ID of the current post.<\\/li>\\n<li>Added perfmatters_get_current_ID filter which allows the user to extend or modify the functionality of the Script Manager\'s current ID function.<\\/li>\\n<\\/ul>\\n<p>1.4.4<\\/p>\\n<ul>\\n<li>Fixed undefined index PHP Notice coming from the Preconnect settings display function.<\\/li>\\n<li>Added additional compatibility with Elementor when using the Script Manager to disable certain Elementor scripts + styles.<\\/li>\\n<li>Added a ignore flag class to all Lazy Load functions. Simply add the \'no-lazy\' class to any image element you want to be exempt from lazy loading.<\\/li>\\n<li>Added validation filter to Login URL input to prevent incompatible characters from being entered.<\\/li>\\n<\\/ul>\\n<p>1.4.3<\\/p>\\n<ul>\\n<li>Fixed an issue with the Lazy Load function that was causing an error with some older PHP versions.<\\/li>\\n<\\/ul>\\n<p>1.4.2<\\/p>\\n<ul>\\n<li>Added new option for <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/\\\">Lazy Loading<\\/a> images (BETA).<\\/li>\\n<\\/ul>\\n<p>1.4.1<\\/p>\\n<ul>\\n<li>New addition to the Preconnect option, you can now choose to whether or not to add the crossorigin property for each Preconnect URL.<\\/li>\\n<li>Optimization to the loading of Perfmatters admin scripts + styles.<\\/li>\\n<li>Added additional Script Manager styles for better compatibility.<\\/li>\\n<li>Added an additional function for the Custom Login URL to help rewrite certain wp-admin links in specific multisite setups.<\\/li>\\n<li>Reorganized plugin action links in the plugins table.<\\/li>\\n<\\/ul>\\n<p>1.4.0<\\/p>\\n<ul>\\n<li>Fixed an issue where the Current URL Exceptions were not loading correctly after saving in the Script Manager.<\\/li>\\n<\\/ul>\\n<p>1.3.9<\\/p>\\n<ul>\\n<li>Added new Extra options to Add Header Code and Add Footer Code.<\\/li>\\n<li>Added missing blank defaults for DNS Prefetch and Preconnect options.<\\/li>\\n<li>Added functionality to force the Admin Bar to display when the Script Manager is loaded.<\\/li>\\n<li>Script Manager styling adjustments.<\\/li>\\n<li>Added success message on save when the Script Manager options are updated.<\\/li>\\n<li>Added support for 404 page when trying to disable or enable on the Current URL.<\\/li>\\n<\\/ul>\\n<p>1.3.8<\\/p>\\n<ul>\\n<li>Added new option to Disable Comments.<\\/li>\\n<li>Updated a section of the Script Manager to better reflect the Current URL when determining if it is a match for the given regex pattern.<\\/li>\\n<\\/ul>\\n<p>1.3.7<\\/p>\\n<ul>\\n<li>Added links to the Script Manager from the posts list page and post edit page which will take you to the front end and load the Script Manager for the corresponding post.<\\/li>\\n<li>Added warning notices for both WP_POST_REVISIONS and AUTOSAVE_INTERVAL if they are set in Perfmatters while also defined elsewhere.<\\/li>\\n<\\/ul>\\n<p>1.3.6<\\/p>\\n<ul>\\n<li>Added new option to Disable Google Fonts.<\\/li>\\n<li>Removed option to Disable Completely from the Disable REST API dropdown to due core WordPress compatibility issues.<\\/li>\\n<li>Added additional object check to prevent PHP warning in certain cases when using the Separate Archives option in the Script Manager.<\\/li>\\n<li>Added some additional logic to filter duplicate scripts out of the Script Manager master array if they are present.<\\/li>\\n<li>CSS fixes in the Script Manager for better compatibility.<\\/li>\\n<li>Expanded the Script Manager current ID function for better reliability.<\\/li>\\n<\\/ul>\\n<p>1.3.5<\\/p>\\n<ul>\\n<li>Added new Disable REST API option which will disable REST API requests and display an authentication error message if the requester doesn\'t have permission.<\\/li>\\n<li>Added additional action removal to the Remove REST API Links function.<\\/li>\\n<li>Made some changes to the Script Manager save button. It is now fixed on the bottom of the screen for easier access without having to scroll.<\\/li>\\n<li>Additional Script Manager style adjustments.<\\/li>\\n<\\/ul>\\n<p>1.3.4<\\/p>\\n<ul>\\n<li>Minor update to Remove Comment URLs function priority for better compatibility with theme templates.<\\/li>\\n<\\/ul>\\n<p>1.3.3<\\/p>\\n<ul>\\n<li>Added new option to Remove Comment URLs.<\\/li>\\n<li>Added French (fr_FR) language translation.<\\/li>\\n<li>Fixed a PHP warning that would occur when saving Script Manager settings in some instances when Display Archives was also enabled.<\\/li>\\n<\\/ul>\\n<p>1.3.2<\\/p>\\n<ul>\\n<li>Added new option to Add Blank Favicon in the Extras tab.<\\/li>\\n<li>Fixed an issue in the Script Manager Global View where options set for the home page would show up as a 0 with a broken link.<\\/li>\\n<li>Added some additional styles to the main Script Manager view for better compatibility.<\\/li>\\n<\\/ul>\\n<p>1.3.1<\\/p>\\n<ul>\\n<li>Fixed a bug that would sometimes cause an enabled message to display on the front end when using the Regex option in the Script Manager.<\\/li>\\n<\\/ul>\\n<p>1.3.0<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/regex\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Regex<\\/a> option the Script Manager for both disables and exceptions.<\\/li>\\n<li>Added new Reset option in the Script Manager settings which allows for a complete wipe + reset of all configured Script Manager options.<\\/li>\\n<li>Added additional Script Manager styles to improve compatability.<\\/li>\\n<li>Added new status message in Script Manager global view when no options have been set.<\\/li>\\n<\\/ul>\\n<p>1.2.9<\\/p>\\n<ul>\\n<li>Updated uninstallation function to account for new Script Manager settings<\\/li>\\n<li>Updated Google Analytics Disable Display Features function to work correctly with Google\'s new format.<\\/li>\\n<li>Added support to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#monster-insights\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Use MonsterInsights<\\/a> along with Perfmatters local analytics functionality.<\\/li>\\n<li>Added new option in Script Manager settings to Display Archives which will allow you to selectively enable scripts on generated archive pages.<\\/li>\\n<\\/ul>\\n<p>1.2.8<\\/p>\\n<ul>\\n<li>Added mobile + responsive styles to the Script Manager navigation.<\\/li>\\n<li>Added additional styles to the Script Manager for compatibility.<\\/li>\\n<li>Script Manager javascript changes + improvements, specifically for compatibility with sites script minification plugins.<\\/li>\\n<li>Fixed a bug where the Script Manager disclaimer would not turn back on after being switched off.<\\/li>\\n<\\/ul>\\n<p>1.2.7<\\/p>\\n<ul>\\n<li>Small patch to check for a required WP function and include core file if necessary for some setups.<\\/li>\\n<\\/ul>\\n<p>1.2.6<\\/p>\\n<ul>\\n<li>All new Script Manager! View updated documentation at\\u00a0<a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/disable-scripts-per-post-page\\/\\\">https:\\/\\/perfmatters.io\\/docs\\/disable-scripts-per-post-page\\/<\\/a>.<\\/li>\\n<li>Fix to remove Emoji DNS Prefetch when Emojis are disabled<\\/li>\\n<\\/ul>\\n<p>1.2.5<\\/p>\\n<ul>\\n<li>Fixed an issue with the Change Login URL function that was causing an error when using WP-CLI.<\\/li>\\n<li>Added some additional compatibility styles to the Script Manager.<\\/li>\\n<\\/ul>\\n<p>1.2.4<\\/p>\\n<ul>\\n<li>Fixed a bug in the Script Manager that caused Current URL Enable checkboxes to not save properly in certain situations.<\\/li>\\n<li>Updated EDD license functions to process proper SSL verification when calling the WordPress HTTP API.<\\/li>\\n<li>Updated perfmatters_default_options array with new options from recent updates.<\\/li>\\n<li>Removed BETA tag from Local Analytics option.<\\/li>\\n<li>Added more details to the Script Manager Global Settings to see which post IDs and post types have settings assigned to them.<\\/li>\\n<li>Additional styles added to the Script Manager for better compatibility.<\\/li>\\n<li>Updated .pot and translation files.<\\/li>\\n<\\/ul>\\n<p>1.2.3<\\/p>\\n<ul>\\n<li>Bugfix - Rolled back some of the heartbeat changes from the previous update to do some additional testing. Should solve some plugin conflicts that popped up.<\\/li>\\n<\\/ul>\\n<p>1.2.2<\\/p>\\n<ul>\\n<li>Added additional WooCommerce checks for WC specific pages before running disable functions.<\\/li>\\n<li>Changes to the Disable Heartbeat function to avoid causing a script dependency error.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/disable-password-meter-strength\\/\\\">Disable Password Strength Meter<\\/a> option.<\\/li>\\n<li>Fixed an issue that was causing Script Manger dropdown colors to not display correctly when jQuery was disabled.<\\/li>\\n<li>Modified admin notice to print our using \'admin_notices\' hook. (credit: Christian Follmann)<\\/li>\\n<li>Made some adjustments to Script Manager copy to remove unnecessary HTML from the translations. (credit: Christian Follmann)<\\/li>\\n<li>Props to Hasan Basri (<a href=\\\"http:\\/\\/www.hasanbasri93.com\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\" data-saferedirecturl=\\\"https:\\/\\/www.google.com\\/url?q=http:\\/\\/www.hasanbasri93.com&amp;source=gmail&amp;ust=1530375831273000&amp;usg=AFQjCNHnfwHkAwWtNxgfmCyGrwSm3NEyng\\\">www.hasanbasri93.com<\\/a>) for Indonesian (id_ID) translation.\\u00a0&#x1f44f;<\\/li>\\n<li>Updated translations based on the new .pot file.<\\/li>\\n<li>Various other minor tweaks + improvements.<\\/li>\\n<\\/ul>\\n<p>1.2.1<\\/p>\\n<ul>\\n<li>Updated Local Analytics function to improve compatibility with different server setups.<\\/li>\\n<\\/ul>\\n<p>1.2.0<\\/p>\\n<ul>\\n<li>New option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/\\\">Enable Local Analytics<\\/a>, along with a new dedicated Google Analytics tab with various related options.<\\/li>\\n<li>Added some additional logic to redirect RSS Feed URLs when Disable RSS Feeds is toggled on.<\\/li>\\n<li>Fixed an issue that was causing certain email links not to work when using a Custom Login URL.<\\/li>\\n<li>Fixed a bug that was causing the password reset link not to function properly when using a Custom Login URL in a multisite environment.<\\/li>\\n<li>Made some adjustments to the Disable Self Pingbacks function to fix an issue with case sensitivity.<\\/li>\\n<li>Updated text domain for translations in the EDD Updater class.<\\/li>\\n<li>Fixed a bug where the Clean Uninstall option would still show up on individual sites in a multisite environment.<\\/li>\\n<li>Props to\\u00a0PDPK di Mauro Panzarola\\u00a0(<a href=\\\"https:\\/\\/pdpkapp.com\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\" data-saferedirecturl=\\\"https:\\/\\/www.google.com\\/url?q=https:\\/\\/pdpkapp.com&amp;source=gmail&amp;ust=1526653041476000&amp;usg=AFQjCNHfek6Z-CMgUhd0MwvU5QGK6cm0hg\\\">https:\\/\\/pdpkapp.com<\\/a>) for Italian (it_IT) translation.\\u00a0&#x1f44f;<\\/li>\\n<\\/ul>\\n<p>1.1.9<\\/p>\\n<ul>\\n<li>Perfmatters is now translation ready! If you are interested in helping out with a translation, please <a href=\\\"https:\\/\\/perfmatters.io\\/contact\\/\\\">contact us<\\/a>.<\\/li>\\n<li>Props to Christian Foellmann (<a href=\\\"https:\\/\\/github.com\\/cfoellmann\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">cfoellmann@GitHub<\\/a>) for German (de_DE) translation.\\u00a0&#x1f44f;<\\/li>\\n<li>Fixed a PHP undefined index warning in the Script Manager.<\\/li>\\n<li>Fixed a bug that was causing issues with the Change Login URL slug when using certain permalink settings.<\\/li>\\n<\\/ul>\\n<p>1.1.8<\\/p>\\n<ul>\\n<li>Fixed a compatibility issue with Script Manager dequeue priority that could cause it to not function properly.<\\/li>\\n<li>Minor update to the uninstall function.<\\/li>\\n<\\/ul>\\n<p>1.1.7<\\/p>\\n<ul>\\n<li>Fixed a bug that was causing the remove query strings option to conflict with files that have necessary query string parameters (Google Fonts).<\\/li>\\n<\\/ul>\\n<p>1.1.6<\\/p>\\n<ul>\\n<li>Added new Clean Uninstall option in the extras tab.<\\/li>\\n<li>Added new Preconnect option in the extras tab.<\\/li>\\n<\\/ul>\\n<p>1.1.5<\\/p>\\n<ul>\\n<li>Fixed multiple PHP warnings related to settings + option initialization.<\\/li>\\n<\\/ul>\\n<p>1.1.4<\\/p>\\n<ul>\\n<li>Added multisite support with the ability to manage default network settings and network access control.<\\/li>\\n<li>Made some adjustments to plugin naming conventions throughout WordPress admin screens, menus, etc...<\\/li>\\n<li>Removed BETA tag on Change Login URL option.<\\/li>\\n<\\/ul>\\n<p>1.1.3<\\/p>\\n<ul>\\n<li>Added new Change Login URL (BETA) feature to change your WordPress login URL and block the default wp-admin and wp-login endpoints from being directly accessed.<\\/li>\\n<li>Added new Disable Dashicons feature to disable Dashicons from the front end when not logged in.<\\/li>\\n<\\/ul>\\n<p>1.1.2<\\/p>\\n<ul>\\n<li>Added character masking to the license key input field.<\\/li>\\n<\\/ul>\\n<p>1.1.1<\\/p>\\n<ul>\\n<li>Added new CDN URL Rewrite feature in a new settings tab with various settings to customize your configuration.<\\/li>\\n<li>Added new Global Settings section in the Script Manager with a visual representation of the Script Manager options set across the entire site.<\\/li>\\n<li>Made some updates to the Script Manager layout in preparation for future additional features.<\\/li>\\n<\\/ul>\\n<p>1.1.0<\\/p>\\n<ul>\\n<li>Added new Disable Google Maps toggle.<\\/li>\\n<li>Added some backend logic to the Script Manager to hide scripts that have already been disabled sitewide via the main plugin settings.<\\/li>\\n<li>Update to the EDD license activation function variables to help prevent activation conflicts with other plugins.<\\/li>\\n<\\/ul>\\n<p>1.0.9<\\/p>\\n<ul>\\n<li>Removed the toggle to disable WooCommerce reviews, as there is already a WooCommerce setting that provides that functionality.<\\/li>\\n<\\/ul>\\n<p>1.0.8<\\/p>\\n<ul>\\n<li>Added new WooCommerce section to the options tab with multiple toggles to disable or limit certain WooCommerce scripts and functionality.<\\/li>\\n<li>Added some new styles to the plugin admin page to allow for clearer organization of different sections.<\\/li>\\n<li>Fixed an undefined index notice in the Script Manager.<\\/li>\\n<li>Added some additional styles to the checkboxes in the Script Manager to fix a theme compatibility issue.<\\/li>\\n<\\/ul>\\n<p>1.0.7<\\/p>\\n<ul>\\n<li>Added functionality to remove the shortlink\\u00a0HTTP header when \'Remove Shortlink\' is toggled on.<\\/li>\\n<li>Added functionality to remove the xmlrpc.php link as well as the X-Pingback HTTP header when \'Disable XML-RPC\' is toggled on.<\\/li>\\n<\\/ul>\\n<p>1.0.6<\\/p>\\n<ul>\\n<li>Removed BETA label from Script Manager.<\\/li>\\n<li>Added new \'DNS Prefetch\' option in the Extras tab.<\\/li>\\n<\\/ul>\\n<p>1.0.5<\\/p>\\n<ul>\\n<li>Added new toggle to \'Remove REST API Links\'.<\\/li>\\n<li>Renamed \'Remove Feed Links\' toggle for more clarification.<\\/li>\\n<li>UI improvements, hovering tooltips, more links to the web documentation, etc\\u2026<\\/li>\\n<li>Added version numbers to admin scripts to avoid caching on plugin update.<\\/li>\\n<li>Refactored a good portion of the settings initialization code.<\\/li>\\n<li>Removed \\\"Beta\\\" status for script manager. It has been fully tested now and is ready to use in production.<\\/li>\\n<li><\\/li>\\n<\\/ul>\\n<p>1.0.4<\\/p>\\n<ul>\\n<li>Fixed a few PHP warnings dealing with the Script Manager option array management.<\\/li>\\n<li>Fixed a UI bug in the Script Manager causing certain post type checkboxes\\u00a0to not be selectable.<\\/li>\\n<\\/ul>\\n<p>1.0.3<\\/p>\\n<ul>\\n<li>Introduced the new Script Manager feature to disable scripts on a per page\\/post basis.<\\/li>\\n<\\/ul>\\n<p>1.0.2<\\/p>\\n<ul>\\n<li>Added Extras tab with a new option for Accessibility\\u00a0Mode. Enabling this will turn off the custom styles we use for our settings toggles and revert to standard HTML checkboxes.<\\/li>\\n<li>Additional accessibility improvements.<\\/li>\\n<li>A few style fixes.<\\/li>\\n<\\/ul>\\n<p>1.0.1<\\/p>\\n<ul>\\n<li>Accessibility improvements to the plugin settings page.<\\/li>\\n<\\/ul>\\n<p>1.0.0<\\/p>\\n<ul>\\n<li>Plugin launched.<\\/li>\\n<\\/ul>\\n\"},\"banners\":{\"high\":\"https:\\/\\/perfmatters.io\\/wp-content\\/uploads\\/edd\\/2021\\/07\\/perfmatters-plugin-banner-1544x500-1.png\",\"low\":\"https:\\/\\/perfmatters.io\\/wp-content\\/uploads\\/edd\\/2021\\/07\\/perfmatters-plugin-banner-772x250-1.png\"},\"icons\":{\"1x\":\"https:\\/\\/perfmatters.io\\/wp-content\\/uploads\\/edd\\/2021\\/11\\/perfmatters-logo-250x250-1-128x128.png\",\"2x\":\"https:\\/\\/perfmatters.io\\/wp-content\\/uploads\\/edd\\/2021\\/11\\/perfmatters-logo-250x250-1.png\"},\"msg\":\"No license key has been provided.\",\"tested\":\"6.2.2\",\"description\":[\"<p><a href=\\\"https:\\/\\/perfmatters.io\\/\\\">Perfmatters<\\/a> is a lightweight web performance plugin designed to help increase Google Core Web Vitals scores and fine-tune how assets load on your site.<\\/p>\\n<h4> Features <\\/h4>\\n<ul>\\n<li>Easy quick toggle options to turn off resources that shouldn\'t be loading. <\\/li>\\n<li>Disable scripts and plugins on a per post\\/page or sitewide basis with the Script Manager. <\\/li>\\n<li>Defer and delay JavaScript, including third-party scripts.<\\/li>\\n<li>Automatically remove unused CSS.<\\/li>\\n<li>Preload resources, critical images, and prefetch links for quicker load times.<\\/li>\\n<li>Lazy load images and enable click-to-play thumbnails on videos.<\\/li>\\n<li>Host Google Analytics and Google Fonts locally.<\\/li>\\n<li>Change your WordPress login URL. <\\/li>\\n<li>Disable and limit WordPress revisions.<\\/li>\\n<li>Add code to your header, body, and footer.<\\/li>\\n<li>Optimize your database.<\\/li>\\n<\\/ul>\\n<h4> Documentation <\\/h4>\\n<p>Check out our <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/\\\">documentation<\\/a> for more information on how to use Perfmatters.<\\/p>\"],\"changelog\":[\"<p>2.1.3<\\/p>\\n<ul>\\n<li>Fixed an issue that was preventing existing Script Manager settings from showing up in certain instances.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>2.1.2<\\/p>\\n<ul>\\n<li>Added new lazy loading advanced option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#exclude-parent-selector\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Exclude Images by Parent Selector<\\/a>.<\\/li>\\n<li>Added built-in exclusion to Delay JS for jqueryParams inline script to prevent load order issues.<\\/li>\\n<li>Added additional built-in exclusions to Remove Unused CSS for better compatibility with Elementor.<\\/li>\\n<li>Added HTTPS check to PERFMATTERS_CACHE_URL definition.<\\/li>\\n<li>Updated Script Manager UI to sort plugins alphabetically by plugin name as well as assets inside each individual section alphabetically by script handle.<\\/li>\\n<li>Fixed an issue where plugins without any enqueued scripts would not always show up in the Script Manager (MU Mode) after visiting the global view.<\\/li>\\n<li>Updated background processing library to version 1.1.0.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>2.1.1<\\/p>\\n<ul>\\n<li>Added <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/wp-cli\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">WP-CLI<\\/a> support for managing plugin license key activation.<\\/li>\\n<li>Changed behavior of Disable Cart Fragments toggle to only load cart fragmentation script when there are items in the cart.<\\/li>\\n<li>Added default array for critical image preload exclusions that are always needed.<\\/li>\\n<li>Added additional Delay JS quick exclusions for Bricks Slider and WP Armour.<\\/li>\\n<li>Added additional built-in exclusions for Remove Unused CSS for better compatibility with Elementor and Google Reviews Widget.<\\/li>\\n<li>Updated lazy loading fade-in effect to use CSS animation property instead of transition for better compatibility with existing element transitions.<\\/li>\\n<li>Added requirement for advanced options to be turned on to be able to defer jQuery.<\\/li>\\n<li>Added WP-CLI request exclusion to MU plugin functions.<\\/li>\\n<li>Fixed a PHP warning that could sometimes be generated if an image was not able to be parsed for missing dimensions.<\\/li>\\n<li>Updated instant.page library to version 5.2.0.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>2.1.0<\\/p>\\n<ul>\\n<li>Added new delay JS option for <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/delay-javascript\\/#quick-exclusions\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Quick Exclusions<\\/a> that will show up when certain popular plugins and themes are activated.<\\/li>\\n<li>Made some updates to the Script Manager UI to match recent changes to the main plugin settings.<\\/li>\\n<li>Cleared out some code for the previous settings admin header that was no longer needed.<\\/li>\\n<li>Made an adjustment to CDN URL function to work even if a trailing slash was entered.<\\/li>\\n<li>Rearranged our local and Google font options to give frequently used options more priority.<\\/li>\\n<li>Fixed a bug where multiple settings sections were displaying at the same time after saving from the database tab.<\\/li>\\n<li>Fixed an issue where accessibility mode tooltips were not getting styled properly in the plugin UI.<\\/li>\\n<li>Fixed a styling issue where link and button colors were getting applied outside of the main Perfmatters admin container.<\\/li>\\n<li>Fixed an issue in MU Mode where the global filtered plugin list would not always return correctly.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>2.0.9<\\/p>\\n<ul>\\n<li>Updated Request library functions used to download local font files to fix a compatibility issue with WordPress 6.2.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_preloads_ready\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_preloads_ready<\\/a> filter.<\\/li>\\n<li>Fixed a styling issue in Safari where the settings UI logo was getting clipped.<\\/li>\\n<\\/ul>\\n<p>2.0.8<\\/p>\\n<ul>\\n<li>Updated plugin settings UI. Completely overhauled admin header and navigation. Made additional improvements to various elements (icons, buttons, toggles, etc.).<\\/li>\\n<li>Added additional checks to allow PERFMATTERS_CACHE_DIR and PERFMATTERS_CACHE_URL to be manually set in wp-config.php.<\\/li>\\n<li>Updated user agent for local font remote request.<\\/li>\\n<li>Fixed an issue where multiple preload tags for the same resource could be printed if the resource was matched more than once in the DOM.<\\/li>\\n<li>Fixed an issue where an individually delayed script would fail to load if it matched more than one delayed script entry.<\\/li>\\n<li>Fixed an issue where FastClick script could still load even if Delay JS was turned off.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>2.0.7<\\/p>\\n<ul>\\n<li>Fixed an issue that was introduced in the last update that was causing certain images that had their HTML modified by another tool not to lazy load correctly.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>2.0.6<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#minimal-v4\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Minimal v4<\\/a> script type option in local analytics.<\\/li>\\n<li>Added support for ::after pseudo element when lazy loading CSS background images.<\\/li>\\n<li>Added support for AVIF images in a source tag to preload critical images feature.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_preload_critical_images\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_preload_critical_images<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_image_dimensions_exclusions\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_image_dimensions_exclusions<\\/a> filter.<\\/li>\\n<li>Added notice to plugin update row if there is not an active license key.<\\/li>\\n<li>Added async attribute to Instant Page script tag.<\\/li>\\n<li>Added async attribute to all relevant local analytics script tags.<\\/li>\\n<li>Reworked preload class to allow managing preloads entirely with perfmatters_preloads filter if needed.<\\/li>\\n<li>Fixed an issue in MU Mode where plugins would not always disable correctly when helper plugins with similar directories were also active.<\\/li>\\n<li>Fixed a couple of PHP warnings in MU plugin that would show up when certain variables were not declared.<\\/li>\\n<li>Fixed an issue where our lazy loading script was attempting to load in images that had been prepped by another active lazy loader.<\\/li>\\n<li>Fixed an issue where base64 encoded images were being picked up by missing image dimensions feature.<\\/li>\\n<li>Removed BETA tag from preload critical images option.<\\/li>\\n<\\/ul>\\n<p>2.0.5<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_exclude_leading_images\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_exclude_leading_images<\\/a> filter.<\\/li>\\n<li>Fixed an issue that was affecting lazy loaded inline background images in certain formats.<\\/li>\\n<li>Fixed a PHP warning related to Fastclick and the built-in exclusion for WooCommerce pages.<\\/li>\\n<li>Updated license key field to prevent it from getting auto-filled by browser extensions.<\\/li>\\n<\\/ul>\\n<p>2.0.4<\\/p>\\n<ul>\\n<li>Fixed an issue that was causing the Perfmatters admin bar menu and meta options to not show up in the admin.<\\/li>\\n<li>Added additional nopin attribute for Pinterest to YouTube preview thumbnails.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>2.0.3<\\/p>\\n<ul>\\n<li>Added new local Google fonts advanced option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/host-google-fonts-locally\\/#async\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Load Asynchronously<\\/a>.<\\/li>\\n<li>Added user agent check before running output buffer with initial exclusion for Usercentrics scanner.<\\/li>\\n<li>Added support for CSS variables when they are being used for lazy loaded inline background images.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_lazyload_youtube_autoplay\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload_youtube_autoplay<\\/a> filter.<\\/li>\\n<li>Improved delay all script handling of jQuery load event.<\\/li>\\n<li>Changed all WooCommerce checks to use class_exists for better compatibility.<\\/li>\\n<li>Adjusted the order of preloads in the buffer to make sure they print above used CSS.<\\/li>\\n<li>Moved buffer class initialization to wp action hook to improve filtering possibilities.<\\/li>\\n<li>Moved WooCommerce built-in exclusions to apply to select individual features instead of the entire buffer.<\\/li>\\n<li>Slight modification to previous MU Mode addition to fix an issue.<\\/li>\\n<li>Fixed an issue where custom heartbeat interval was not being applied correctly when editing certain custom post types.<\\/li>\\n<li>Fixed an issue with the local stylesheet CDN URL when advanced options were turned on but no URL was set.<\\/li>\\n<li>Fixed an issue where delay script was printing out more than once if multiple closing body tags were present in the DOM.<\\/li>\\n<\\/ul>\\n<p>2.0.2<\\/p>\\n<ul>\\n<li>Fixed an issue that was preventing Removed Unused CSS from running correctly in certain cases when Advanced Options were toggled on.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>2.0.1<\\/p>\\n<ul>\\n<li>Added new toggle to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/advanced-options\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Show Advanced Options<\\/a> in the Perfmatters UI.<\\/li>\\n<li>Added new advanced option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/delay-javascript\\/#disable-click-delay\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Disable Click Delay<\\/a> in JavaScript section.<\\/li>\\n<li>Added new advanced option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/delay-javascript\\/#fastclick\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Enable FastClick<\\/a> in JavaScript section.<\\/li>\\n<li>Added new advanced option to specify a <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/remove-unused-css\\/#cdn-url\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">CDN URL<\\/a> in CSS section.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/change-wordpress-login-url\\/#local-redirect\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Local Redirect<\\/a> option to existing login URL disabled behavior selection.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_buffer_excluded_extensions\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_buffer_excluded_extensions<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_rucss_excluded_stylesheets\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_rucss_excluded_stylesheets<\\/a> filter.<\\/li>\\n<li>Added additional built-in exclusions for Remove Unused CSS for better compatibility with Elementor, Divi, Slider Revolution, OptimizePress, and WordPress core.<\\/li>\\n<li>Added additional logic in MU Mode to more reliably retrieve the ID for certain custom post types.<\\/li>\\n<li>Moved lazyload functions to new class structure to be more inline with current codebase.<\\/li>\\n<li>Modified regex for lazy loading inline background images to support additional formats.<\\/li>\\n<li>Integrated lazyload functions into the main output buffer to allow interaction with other existing features.<\\/li>\\n<li>Fixed an issue where dynamic preloads were not recognizing existing query strings in some cases.<\\/li>\\n<li>Fixed a PHP warning that would show up in some cases by adding additional string check when looping through rewrite array.<\\/li>\\n<li>Fixed an issue with MU Mode where sometimes the wrong plugin would get disabled if there were multiple plugins using similar directory paths.<\\/li>\\n<li>Fixed an issue where images inside script tags were being picked up by the Preload Critical Images function.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>2.0.0<\\/p>\\n<ul>\\n<li>Added new system for query string timestamps for Used CSS file method to help see changes quicker in environments with caching.<\\/li>\\n<li>Added support for ?perfmattersoff query string which gives the ability to quickly prevent the majority of Perfmatters features from running on the front end for testing purposes.<\\/li>\\n<li>Added additional support for updating the plugin via WP-CLI.<\\/li>\\n<li>Made some changes to admin bar menu item. There is now a Perfmatters top-level admin bar menu item that links to our plugin settings page. The Script Manager and Clear Used CSS function can be accessed by hovering over that main menu item if those features are enabled.<\\/li>\\n<li>Added new toggle in tools to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/hide-admin-bar-menu\\/\\\" target=\\\"_blank\\\" rel=\\\"noreferrer noopener\\\">Hide Admin Bar Menu<\\/a>.<\\/li>\\n<li>Disabled certain features from running on WooCommerce cart, checkout, and account pages for better compatibility.<\\/li>\\n<li>Increased site limit in dropdowns on Multisite network settings page.<\\/li>\\n<li>Added additional compatibility styles to the Script Manager.<\\/li>\\n<li>Added additional built-in exclusions for Remove Unused CSS for better compatibility with Elementor, Astra, Kadence, and GenerateBlocks.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_login_url\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_login_url<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_lazyload_noscript\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload_noscript<\\/a> filter.<\\/li>\\n<li>Fixed an issue where YouTube preview thumbnails were generating a preload warning in certain instances.<\\/li>\\n<li>Fixed an issue that was causing analytics.js not to be served over HTTPS in instances where an SSL migration had been done previously on the site.<\\/li>\\n<li>Fixed an issue where delayed style attribute was applied to preloaded stylesheets that already existed in the DOM.<\\/li>\\n<li>Fixed an issue where some features were being allowed to run on XML sitemap URLs in certain cases.<\\/li>\\n<li>Fixed an issue where theme and plugin files were not falling back to a WordPress version query string when present in a dynamic preload.<\\/li>\\n<\\/ul>\\n<p>1.9.9<\\/p>\\n<ul>\\n<li>Added additional autosave interval options.<\\/li>\\n<li>Added WPBakery query string parameter to excluded page builders array.<\\/li>\\n<li>Changed certain lazy loading classes to be more specific to prevent conflicts.<\\/li>\\n<li>Adjusted lazy loading image attribute filter to not run unless images specifically are meant to be lazy loaded by Perfmatters.<\\/li>\\n<li>Added an additional function_exists check in the JS class to prevent an error from being thrown in some cases.<\\/li>\\n<\\/ul>\\n<p>1.9.8<\\/p>\\n<ul>\\n<li>Made adjustments to the CSS Background Image styles to work with some changes in the latest version of our lazy loading library.<\\/li>\\n<li>Fixed an issue that was preventing quotations from being stripped from background image URLs when prepping an inline background image for lazy loading.<\\/li>\\n<li>Fixed an issue where delayed CSS was not loading properly when using individual JS delay.<\\/li>\\n<li>Fixed an error that was being logged in some cases when checking for an active plugin in the JS class.<\\/li>\\n<\\/ul>\\n<p>1.9.7<\\/p>\\n<ul>\\n<li>Made an adjustment to how inline background images are prepped to work with some changes in the latest version of our lazy loading library.<\\/li>\\n<\\/ul>\\n<p>1.9.6<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_delay_js_delay_click\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_delay_js_delay_click<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_local_stylesheet_url\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_local_stylesheet_url<\\/a> filter.<\\/li>\\n<li>Made some performance improvements to the way the lazy loading script and inline code are loaded.<\\/li>\\n<li>Added additional compatibility for Elementor animations when using Delay JS.<\\/li>\\n<li>Added additional details in the Script Manager global view for individual stored settings.<\\/li>\\n<li>Added the ability to identify and clear outdated post IDs set in the Script Manager options from the global view.<\\/li>\\n<li>Script Manager global view organization and style improvements.<\\/li>\\n<li>Updated lazy loading library to version 17.8.<\\/li>\\n<li>Updated instant.page library to version 5.1.1.<\\/li>\\n<li>Added Bricks query string parameter to excluded page builders array.<\\/li>\\n<li>Fixed an issue that was causing the cache directory to not create unique subsite paths for specific multisite setups.<\\/li>\\n<li>Fixed an issue where delayed stylesheets were not being loaded if Delay JS was toggled off in the post meta options.<\\/li>\\n<\\/ul>\\n<p>1.9.5<\\/p>\\n<ul>\\n<li>Added additional logic to Delay JS script to make sure the initial interaction is processed.<\\/li>\\n<li>Added additional styles to CSS Background Image feature to work with background images set on ::before selectors.<\\/li>\\n<li>Added additional default tags to various dropdowns in plugin settings for better clarification.<\\/li>\\n<li>Added default arrays for stylesheet and selector exclusions that are always needed.<\\/li>\\n<li>Adjusted perfmatters_cdn filter location for compatibility.<\\/li>\\n<li>Made some adjustments to CDN Rewrite Regex to fix some issues where unwanted strings were getting picked up as URLs in some cases.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.9.4<\\/p>\\n<ul>\\n<li>Updated EDD plugin updater class to version 1.9.2.<\\/li>\\n<li>Added default exclusion to REST API option for compatibility.<\\/li>\\n<\\/ul>\\n<p>1.9.3<\\/p>\\n<ul>\\n<li>Remove Used CSS filter adjustment to fix an issue where certain WordPress post functions wouldn\'t be available when trying to selectively disable the feature.<\\/li>\\n<li>Rolled back minor plugin UI JavaScript addition, as it was interfering with entering data on multiple lines in certain input fields.<\\/li>\\n<\\/ul>\\n<p>1.9.2<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_allow_buffer https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_used_css\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_used_css<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_allow_buffer\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_allow_buffer<\\/a> filter.<\\/li>\\n<li>Added a notice in the Script Manager when Testing Mode is enabled.<\\/li>\\n<li>Improved reliability of CSS Background Image function when child elements with additional background images are present.<\\/li>\\n<li>Script Manager style compatibility fixes.<\\/li>\\n<li>Fixed an issue where some post specific meta options were not being respected when determining if a feature should run.<\\/li>\\n<li>Fixed an issue where pressing enter on the main plugin settings page would trigger a specific form action instead of save settings.<\\/li>\\n<li>Changed CSS class initialization hook to be in the correct order with other output buffer functions.<\\/li>\\n<li>Made an adjustment to how we generate the local used stylesheet URL for better compatibility.<\\/li>\\n<li>Fixed an issue where loading attribute was still getting applied to images that were excluded from lazy loading.<\\/li>\\n<li>Fixed an issue where images inside an excluded picture element were not also getting excluded.<\\/li>\\n<li>Fixed an issue in the Script Manager where archives were not being grouped together with their respective post type.<\\/li>\\n<li>Additions to plugin UI JavaScript to allow for disabled sections to be hidden even when nested controllers are present.<\\/li>\\n<li>Moved background process library to composer autoloader.<\\/li>\\n<li>Removed BETA tag from Remove Unused CSS option.<\\/li>\\n<\\/ul>\\n<p>1.9.1<\\/p>\\n<ul>\\n<li>Added new option to lazy load <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#css-background-images\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">CSS Background Images<\\/a>.<\\/li>\\n<li>Added new option for <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#dual-tracking\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Dual Tracking<\\/a> when using gtag.js in local analytics.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_rest_api_exceptions\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_rest_api_exceptions<\\/a> filter.<\\/li>\\n<li>Fixed an issue where individually delayed local scripts would not get correctly rewritten to load from the CDN.<\\/li>\\n<li>Fixed an issue where lazy loading would run into an error if no px or % was specified with the threshold value.<\\/li>\\n<li>Fixed an issue with buffer validation that was conflicting with certain caching setups.<\\/li>\\n<li>Fixed an issue where existing font preconnect and prefetch tags were not being detected properly when using Local Fonts.<\\/li>\\n<li>Fixed an error related to cookie constants when running MU Mode in certain environments.<\\/li>\\n<li>Fixed multiple AMP validation errors and added additional checks to prevent certain functions from running on AMP URLs.<\\/li>\\n<li>Minor adjustment to CDN rewrite regex pattern to work with encoded quotation characters.<\\/li>\\n<li>Changed toggle CSS selectors to be more specific to prevent conflicts.<\\/li>\\n<li>Moved plugin settings header output to in_admin_header action hook for compatibility.<\\/li>\\n<li>Moved JS optimization functions to new class structure to be more inline with current codebase.<\\/li>\\n<li>Improvements to critical image preloading allowed for a move to a singular output buffer.<\\/li>\\n<\\/ul>\\n<p>1.9.0<\\/p>\\n<ul>\\n<li>Fixed an issue that was causing excluded selectors to not be recognized properly after Used CSS was cleared.<\\/li>\\n<li>Minor adjustments to the new plugin UI.<\\/li>\\n<\\/ul>\\n<p>1.8.9<\\/p>\\n<ul>\\n<li>Updated plugin settings UI.<\\/li>\\n<li>Added new post meta option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/remove-unused-css\\/#clear-individual\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Clear Used CSS<\\/a> for an individual page or post type.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_rucss_excluded_selectors\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_rucss_excluded_selectors<\\/a> filter.<\\/li>\\n<li>Fixed a lazy loading issue that was preventing some images from loading properly in Safari.<\\/li>\\n<li>Migrated Delay JS Timeout dropdown to a simpler on\\/off toggle that will default to 10 seconds. Our filter is also still available to set a custom timeout value.<\\/li>\\n<li>Fixed an issue with MU plugin that was interfering with rewrite rules in some instances.<\\/li>\\n<li>Added additional excluded page builder parameter for Flatsome UX.<\\/li>\\n<li>Moved restore default functionality to a separate option on the tools page.<\\/li>\\n<li>Code refactoring.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.8.8<\\/p>\\n<ul>\\n<li>Changed default setting for Used CSS Method from file to inline, as we think this will be the more compatible solution for most users going forward. If you were previously using the file method, you may need to save that option again.<\\/li>\\n<li>Added width and height parameters to placeholder SVGs to prevent warnings for a ratio mismatch that would happen for some images.<\\/li>\\n<li>Fixed an issue where the noscript tags were getting malformed for some images inside picture tags after lazy loading.<\\/li>\\n<li>Removed placeholder SVGs on source tags since the image tag will already have one.<\\/li>\\n<li>Changed settings export file name date format to be easier to organize when managing multiples.<\\/li>\\n<li>Updated tooltip for Blank Favicon option to be more clear.<\\/li>\\n<\\/ul>\\n<p>1.8.7<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/remove-unused-css\\/#css-method\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Used CSS Method<\\/a> option to choose whether to load used CSS from a file or inline.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_cache_path\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_cache_path<\\/a> filter.<\\/li>\\n<li>Updated metabox functions to restrict metabox display to administrators only.<\\/li>\\n<li>Made some adjustments to custom login URL function to better support 3rd party tools using WP CLI.<\\/li>\\n<li>Added Fusion Builder query string parameters to excluded page builders array.<\\/li>\\n<li>Adjusted Unused CSS regex to be more consistent when stylesheets are placed in between other link tags.<\\/li>\\n<li>Changes to instances where ABSPATH was used to determine a directory location for better compatibility with certain hosts.<\\/li>\\n<li>Fixed an issue with Remove Global Styles option where duotone SVGs were not being removed on WordPress 5.9.2.<\\/li>\\n<li>Fixed an issue where WooCommerce block stylesheets were not getting correctly dequeued when Disable Scripts option was set.<\\/li>\\n<li>Fixed an issue that was causing the CSS Parser library not to get included correctly in certain cases.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.8.6<\\/p>\\n<ul>\\n<li>Added new option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/remove-global-inline-styles-wordpress\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Remove Global Styles<\\/a> related to duotone filters.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_script_manager_locale\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_script_manager_locale<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_disable_woocommerce_scripts\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_disable_woocommerce_scripts<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_page_builders\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_page_builders<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_delay_js_behavior\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_delay_js_behavior<\\/a> filter.<\\/li>\\n<li>Fixed an issue with the unused CSS parser that was incorrectly rewriting relative URLs if there was no query string present on the original stylesheet src.<\\/li>\\n<li>Added additional parameter to page builders array for compatibility.<\\/li>\\n<li>Fixed an issue that was causing the login URL disabled 404 behavior to result in an error if a 404 template was not found.<\\/li>\\n<li>Added some additional checks before creating cache directories for local fonts and used CSS.<\\/li>\\n<li>Fixed an issue that was causing the fade-in effect to conflict with child images inside a lazy loaded container.<\\/li>\\n<li>Fixed an undefined index warning coming from unused CSS settings update function.<\\/li>\\n<li>Added a default delay JS exclusion for admin only inline customize-support script.<\\/li>\\n<li>Refactored entire meta.php code to be more efficient (38% smaller) and in line with current structure.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.8.5<\\/p>\\n<ul>\\n<li>Added new feature to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/remove-unused-css\\/#remove-unused-css\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Remove Unused CSS<\\/a> (BETA).<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_remove_unused_css\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_remove_unused_css<\\/a> filter.<\\/li>\\n<li>Adjusted CDN Rewrite buffer priority for better compatibility with other features.<\\/li>\\n<li>Made an improvement to the Disable XML-RPC function to return a 403 error when xmlrpc.php is accessed directly.<\\/li>\\n<li>Script Manager stylesheet updates for better compatibility.<\\/li>\\n<li>Fixed an issue in the Script Manager where the input controls were sometimes not displaying after toggling a script off.<\\/li>\\n<li>Added additional style for YouTube preview thumbnail play button to fix an alignment issue with certain setups.<\\/li>\\n<li>Buffer adjustments for compatibility.<\\/li>\\n<\\/ul>\\n<p>1.8.4<\\/p>\\n<ul>\\n<li>Fixed an issue that was interfering with sitemap display in certain configurations.<\\/li>\\n<li>Added &lt;a&gt; element support for lazy loading inline background images.<\\/li>\\n<\\/ul>\\n<p>1.8.3<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_fade_in_speed\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_fade_in_speed<\\/a> filter.<\\/li>\\n<li>Fixed an issue that was preventing lazy loading fade in from working correctly with certain background images.<\\/li>\\n<li>Fixed an issue that was interfering with the display of certain inline SVG elements.<\\/li>\\n<li>Adjusted local analytics hook priority for better compatibility.<\\/li>\\n<li>Script Manager style updates for better compatibility.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.8.2<\\/p>\\n<ul>\\n<li>New Lazy Loading option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#exclude-leading-images\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Exclude Leading Images<\\/a>.<\\/li>\\n<li>New Lazy Loading option to add a <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#fade-in\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Fade In<\\/a> effect.<\\/li>\\n<li>New option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/preload\\/#critical-images\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Preload Critical Images<\\/a> (BETA).<\\/li>\\n<li>Expanded Disable XML-RPC function to also remove pingback link tag if it is present in the document.<\\/li>\\n<li>Added new Delay JavaScript checkbox to meta options in the post editor.<\\/li>\\n<li>Added additional integration with perfmatters_delay_js filter.<\\/li>\\n<li>Moved YouTube autoplay parameter placement on lazy loaded iframes for better compatibility with existing query strings.<\\/li>\\n<li>Optimizations to lazy loading inline CSS functions.<\\/li>\\n<li>Various optimizations and improvements to the output buffer.<\\/li>\\n<li>Migrated manual preload functionality to use the output buffer which will allow for easier integration with new features.<\\/li>\\n<li>Made some adjustments to MU plugin functions to more reliably detect post IDs when using specific permalink setups.<\\/li>\\n<li>Fixed an issue where some Current URL links in the Script Manager\'s Global View were not pointing to the right posts.<\\/li>\\n<li>Fixed an issue with a certain endpoint that was redirecting to the custom login URL.<\\/li>\\n<li>Fixed a PHP notice that was sometimes appearing when refreshing local fonts.<\\/li>\\n<li>Removed BETA tag from Delay All JS option.<\\/li>\\n<\\/ul>\\n<p>1.8.1<\\/p>\\n<ul>\\n<li>Updated Local Google Font function to more effectively remove existing font preconnect and prefetch tags.<\\/li>\\n<li>Updated Local Google Font function for better compatibility with sites that still have remnants from a previous http to https migration.<\\/li>\\n<li>Fixed an issue in the Script Manager where the home page was being treated as a post if set to display the blog feed.<\\/li>\\n<\\/ul>\\n<p>1.8.0<\\/p>\\n<ul>\\n<li>Fixed an issue with Delay All JS that was preventing certain async scripts from fully loading.<\\/li>\\n<\\/ul>\\n<p>1.7.9<\\/p>\\n<ul>\\n<li>Added new options to the Script Manager to disable assets directly by post type, archive, user status, and device type.<\\/li>\\n<li>Added support for dynamic preloading by handle for enqueued scripts and styles.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_lazyload\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_cdn\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_cdn<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_delay_js_timeout\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_delay_js_timeout<\\/a> filter.<\\/li>\\n<li>Fix to Delay All JS script for better compatibility with certain page builder animations.<\\/li>\\n<li>Updated class initialization for better compatibility.<\\/li>\\n<li>Fixed an issue where the Script Manager was interpreting certain array keys as shortcodes if they were identical.<\\/li>\\n<li>Added an additional check to prevent the Script Manager from being able to load on top of a page builder.<\\/li>\\n<li>Fixed a PHP notice coming from the MU plugin.<\\/li>\\n<li>Made some changes to our plugin updater function that should help with auto-updates in a multisite environment.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.7.8<\\/p>\\n<ul>\\n<li>Added new option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/missing-width-height-images\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Add Missing Image Dimensions<\\/a>.<\\/li>\\n<li>Added the ability to delete individual Script Manager options from the Global View.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_delay_js\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_delay_js<\\/a> filter.<\\/li>\\n<li>Updated EDD plugin updater class to version 1.9.0.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.7.7<\\/p>\\n<ul>\\n<li>Fixed a PHP warning related to JavaScript deferral for specific configurations.<\\/li>\\n<li>Fixed an issue with lazy loading exclusions not being loaded correctly in some cases.<\\/li>\\n<\\/ul>\\n<p>1.7.6<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/delay-javascript\\/#behavior\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Delay Behavior<\\/a> dropdown with a new option to Delay All Scripts.<\\/li>\\n<li>Added new Lazy Loading <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#threshold\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Threshold<\\/a> option and adjusted the default value if not set to improve performance.<\\/li>\\n<li>Added confirmation message when manually running the database optimization tool.<\\/li>\\n<li>Updated disable emoji function to get rid of a PHP notice.<\\/li>\\n<li>Added additional check to MU Mode to only filter GET requests.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/defer-javascript-wordpress\\/#perfmatters_defer_js-filter\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_defer_js<\\/a> filter.<\\/li>\\n<li>Fixed an issue where Instant Page was attempting to run on the new widgets screen in WordPress 5.8.<\\/li>\\n<li>Fixed an issue with Local Google Fonts where certain invalid font URLs would still attempt to be downloaded and served.<\\/li>\\n<li>Removed BETA tag from fonts section.<\\/li>\\n<li>Delay JavaScript compatibility improvements.<\\/li>\\n<li>Added additional input validation functionality to plugin settings page.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.7.5<\\/p>\\n<ul>\\n<li>Added new custom login URL options to change the <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/change-wordpress-login-url\\/#disabled-behavior\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Disabled Behavior<\\/a> and set a custom <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/change-wordpress-login-url\\/#message\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Message<\\/a>.<\\/li>\\n<li>Migrated CDN, Analytics, and Extras tab data to separate sections in the Options tab for better organization and easier access.<\\/li>\\n<li>CDN rewrite improvements to better handle sites with multiple domain URLs.<\\/li>\\n<li>Regex adjustments to Local Fonts function for better reliability.<\\/li>\\n<li>Added exclusion checks to individual &lt;source&gt; tags when using WebP images.<\\/li>\\n<li>Added function to disable capital_P_dangit filter.<\\/li>\\n<li>Fixed a lazy loading warning that was showing in Microsoft Edge.<\\/li>\\n<li>Removed loading attribute that was getting applied to &lt;picture&gt; tags in some cases when using WebP images.<\\/li>\\n<li>Plugin UI navigation performance improvements.<\\/li>\\n<li>Plugin UI style fixes.<\\/li>\\n<li>Added a conditional check to only show WooCommerce options when WooCommerce is installed and activated.<\\/li>\\n<li>Fixed an MU Mode issue where the Home URL did not trigger a match if a query string was present.<\\/li>\\n<li>Fixed an issue where the Customizer was getting certain optimizations applied.<\\/li>\\n<li>Fixed an issue where the Disable Embeds toggle was interfering with responsive video styles.<\\/li>\\n<li>Script Manager UI fixes.<\\/li>\\n<li>Updated uninstall function to remove Perfmatters cache folder.<\\/li>\\n<li>Added readme.txt file.<\\/li>\\n<\\/ul>\\n<p>1.7.4<\\/p>\\n<ul>\\n<li>Re-enabled Local Google Fonts functionality.<\\/li>\\n<li>Refactoring of buffer-related code and various functions that were already using our main buffer filter.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.7.3<\\/p>\\n<ul>\\n<li>Rolled back the latest changes related to the new universal buffer class and Local Google Fonts while we do some more in-depth testing. We\'ll be working to release this feature next week using an alternative method.<\\/li>\\n<\\/ul>\\n<p>1.7.2<\\/p>\\n<ul>\\n<li>Added new Fonts section inside of the main Options tab.<\\/li>\\n<li>Added new option to use <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/font-display-swap\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Display Swap<\\/a> for Google fonts.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/host-google-fonts-locally\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Local Google Fonts<\\/a> option which will attempt to download any Google Font files and serve them from your local server or CDN.<\\/li>\\n<li>Integrated new universal HTML buffer library to help going forward with plugin features that manipulate DOM elements.<\\/li>\\n<li>Migrated CDN Rewrite feature to the universal buffer class.<\\/li>\\n<li>Added new perfmatters_delayed_scripts filter to modify the Delay JavaScript input array before any scripts are delayed.<\\/li>\\n<li>Added new perfmatters_preload filter to modify the Preloads data array before anything is printed.<\\/li>\\n<li>Made some compatibility improvements to the inline lazy loading JavaScript.<\\/li>\\n<li>Added attributes to delayed scripts to exclude them from being picked up by Litespeed Cache.<\\/li>\\n<li>Added exclusion for SiteGround Optimizer to the main Script Manager JavaScript file.<\\/li>\\n<li>Added CodeMirror support to all code text area inputs in plugin settings.<\\/li>\\n<li>Removed license activation check and corresponding links from the plugins page to improve back-end performance.<\\/li>\\n<\\/ul>\\n<p>1.7.1<\\/p>\\n<ul>\\n<li>Added expiration date row to license tab in plugin settings.<\\/li>\\n<li>Added support for WooCommerce shop page when setting a preload location by post ID.<\\/li>\\n<li>Fixed an issue with device exceptions not working correctly in MU Mode.<\\/li>\\n<li>Fixed a query string encoding issue that was affecting some email templates when using a custom login URL.<\\/li>\\n<\\/ul>\\n<p>1.7.0<\\/p>\\n<ul>\\n<li>Fixed an issue where Preload tags were still being printed on archive pages even if a location was set.<\\/li>\\n<li>Fixed a compatibility issue with older WordPress versions when using certain functions that check for a JSON request.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.6.9<\\/p>\\n<ul>\\n<li>New additions to preload feature, allowing specification for device type and location.<\\/li>\\n<li>Script Manager improvements to allow for Regex disable to be used alongside Current URL disables for the same script.<\\/li>\\n<li>Added new Script Manager exception for device type.<\\/li>\\n<li>Add new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/delay-javascript\\/#timeout\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Delay Timeout<\\/a> option when delaying JavaScript.<\\/li>\\n<li>Added new wheel event to user interaction script for delay function.<\\/li>\\n<li>Added new multisite network administration tool to apply default site settings to all subsites.<\\/li>\\n<li>Multiple improvements to WooCommerce disable scripts toggle for increased effectiveness.<\\/li>\\n<li>Added additional exclusions for JSON and REST requests to all asset optimization functions.<\\/li>\\n<li>Fixed an undefined index warning coming from local analytics function.<\\/li>\\n<li>Fixed an issue where YouTube preview thumbnails were getting a layout shift warning when using a theme with responsive embed support.<\\/li>\\n<li>Fixed a Script Manager bug that was not fully clearing exceptions when changing disable away from everywhere.<\\/li>\\n<li>Script Manager styling compatibility fixes.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.6.8<\\/p>\\n<ul>\\n<li>Compatibility fixes for local analytics when using MonsterInsights.<\\/li>\\n<li>Local analytics improvements for multisite.<\\/li>\\n<li>Added alt tag to YouTube preview thumbnail images.<\\/li>\\n<li>Fixed a PHP undefined index notice coming from functions.php.<\\/li>\\n<li>Translation file updates.<\\/li>\\n<\\/ul>\\n<p>1.6.7<\\/p>\\n<ul>\\n<li>Added new tool to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/purge-meta-options\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Purge Perfmatters Meta Options<\\/a>.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/disable-google-maps-api-wordpress\\/#exclude\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Exclude Post IDs<\\/a> input for existing Disable Google Maps option.<\\/li>\\n<li>Added new gtag.js option to local analytics script type selection.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#gtag-cdn\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">CDN URL<\\/a> input to local analytics options when using gtag.js.<\\/li>\\n<li>Added new option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#amp\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Enable AMP Support<\\/a> to local analytics.<\\/li>\\n<li>Moved Use MonsterInsights option to gtag.js script type and updated script replacement hook.<\\/li>\\n<li>Added onload function to style preloads to prevent duplicate preloads from occurring.<\\/li>\\n<li>Added exception for WP Rocket script deferral to our lazy load script.<\\/li>\\n<li>Added exception for site health tool to disable heartbeat function.<\\/li>\\n<li>Fixed an issue where background images weren\\u2019t being lazy loaded if the style attribute was the first attribute declared on the element.<\\/li>\\n<li>Script Manager styling fixes.<\\/li>\\n<li>Fixed a PHP warning coming from settings.php.<\\/li>\\n<li>Translation file updates.<\\/li>\\n<\\/ul>\\n<p>1.6.6<\\/p>\\n<ul>\\n<li>Added new Script Manager exception to select <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/script-manager-logged-in-logged-out\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">logged in or logged out<\\/a> users.<\\/li>\\n<li>Added new option in Script Manager settings to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/script-dependencies\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Display Dependencies<\\/a>.<\\/li>\\n<li>Added total plugin sizes in the Script Manager.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#viewport-threshold\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload_threshold<\\/a> filter to adjust the distance at which lazy elements are loaded.<\\/li>\\n<li>Multiple Script Manager style and UI improvements.<\\/li>\\n<li>Fixed an issue where MU mode script was attempting to run on wp-login.php.<\\/li>\\n<li>Multiple page builder compatibility fixes.<\\/li>\\n<li>Made an adjustment to prevent YouTube preview thumbnails from getting picked up by Pinterest image hover tools.<\\/li>\\n<li>Removed deprecated plugin option to Remove Query Strings. Make sure to double-check your preloads as Google needs the exact URL when preloading.<\\/li>\\n<li>PHP 8 compatibility testing.<\\/li>\\n<li>Minor adjustments to lazy load inline scripts to fix invalid markup warnings.<\\/li>\\n<\\/ul>\\n<p>1.6.5<\\/p>\\n<ul>\\n<li>Added new option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/delay-javascript\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Delay JavaScript<\\/a> from loading until user interaction.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#script-type\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">gtag.js v4<\\/a> option to local analytics.<\\/li>\\n<li>Added new built-in option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#exclude\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Exclude from Lazy Loading<\\/a> which can be used in addition to the existing filter.<\\/li>\\n<li>Add new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#youtube-preview-thumbnails\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload_youtube_thumbnail_resolution<\\/a> filter to adjust YouTube preview thumbnail quality.<\\/li>\\n<li>Optimized analytics updater function.<\\/li>\\n<li>Updated EDD plugin updater class which will now allow for WordPress auto-update support.<\\/li>\\n<li>Removed option to Defer Inline JavaScript which is now being replaced by the new Delay JavaScript option.<\\/li>\\n<li>Adjusted Script Manager hook priority for better compatibility.<\\/li>\\n<li>Compatability fix to the DOM Monitoring lazy load option.<\\/li>\\n<li>Added compatibility fix for jQuery fitVids to lazy loading function.<\\/li>\\n<li>Fixed an issue where lazy loading was attempting to run on AMP pages.<\\/li>\\n<\\/ul>\\n<p>1.6.4<\\/p>\\n<ul>\\n<li>Fixed an issue that was causing the Reset Script Manager button to not work correctly.<\\/li>\\n<li>Fixed an issue where the Perfmatters meta box wouldn\'t display if only using Lazy Loading.<\\/li>\\n<li>Adjusted Script Manager hook priority for better compatibility.<\\/li>\\n<li>Added additional checks to MU Mode plugin file to prevent it from interfering with certain REST API requests. (Fixes a bug when running the Yoast SEO data indexer.)<\\/li>\\n<li>Added additional checks to confirm user functions are available before verifying admin status.<\\/li>\\n<li>Updated translation files.<\\/li>\\n<\\/ul>\\n<p>1.6.3<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/testing-mode\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Testing Mode<\\/a> option to the Script Manager settings.<\\/li>\\n<li>Rewrote script-manager.js entirely using vanilla JavaScript to get rid of jQuery dependency.<\\/li>\\n<li>Added additional MU Mode check to help prevent certain configurations from interfering with AJAX requests.<\\/li>\\n<li>Improved Script Manager form handling.<\\/li>\\n<li>Adjusted Script Manager disclaimer text and added a close button.<\\/li>\\n<li>Moved the Script Manager print function from the wp_footer hook to shutdown for better compatibility.<\\/li>\\n<li>Fixed an undefined index warning in the Lazy Load function.<\\/li>\\n<li>Added a Lazy Load exclusion for Gravity Forms iframes.<\\/li>\\n<li>Added a Rocket Loader exclusion to the Instant Page JS file.<\\/li>\\n<li>Added an exclusion to the CDN Rewrite for script-manager.js.<\\/li>\\n<li>Script Manager styling fixes for better compatibility.<\\/li>\\n<\\/ul>\\n<p>1.6.2<\\/p>\\n<ul>\\n<li>Updated placeholder text in Preload UI.<\\/li>\\n<li>Fixed an issue where the Password Strength Meter script was getting disabled in the admin.<\\/li>\\n<li>Small tweak to JS Deferral buffer to make sure HTML is being filtered correctly.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.6.1<\\/p>\\n<ul>\\n<li>New Local Analytics Script Type toggle with new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Minimal Analytics<\\/a> options.<\\/li>\\n<li>New <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/defer-javascript-wordpress\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">JavaScript Deferral<\\/a> options in Extras &gt; Assets.<\\/li>\\n<li>Updates to Cart Fragments and Password Strength Meter toggles to improve effectiveness.<\\/li>\\n<li>Multiple updates to Instant Page functionality for better compatibility.<\\/li>\\n<li>Multiple plugin admin UI updates and improvements.<\\/li>\\n<li>Script Manager style updates for better compatibility.<\\/li>\\n<li>MU Mode improvements for increased stability.<\\/li>\\n<li>Fixed an issue causing Preload and Preconnect settings to not save correctly in some cases.<\\/li>\\n<\\/ul>\\n<p>1.6.0<\\/p>\\n<ul>\\n<li>Added a filter to disable WordPress\' native lazy loading when Perfmatters\' lazy loading is active.<\\/li>\\n<li>Adjusted Script Manager styles to more effectively overlay the entire page while still allowing admin bar functions to be fully available.<\\/li>\\n<li>Fixed an undefined index notice that was appearing on specific lazy loading and script manager functions.<\\/li>\\n<li>Updated translation files.<\\/li>\\n<\\/ul>\\n<p>1.5.9<\\/p>\\n<ul>\\n<li>Added new Preloading section in the Extras tab, with new options for <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/link-prefetch\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Instant Page<\\/a> and <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/preload\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Preload<\\/a>.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload_forced_attributes<\\/a> filter to allow for matched elements to be skipped when checking for exclusions.<\\/li>\\n<li>Added support for WooCommerce Shop page to show up as a Current URL option in the Script Manager.<\\/li>\\n<li>Added exclusions for REST and AJAX requests to MU Mode function.<\\/li>\\n<li>Fixed a bug that was causing the MU Mode function to still run even if the Script Manager was disabled.<\\/li>\\n<li>Fixed an issue where images were being prepped for lazy loading on feed URLs.<\\/li>\\n<li>Fixed an issue where lazy loading was breaking images in embeds from the same site.<\\/li>\\n<li>Compatibility fixes for lazy load script with Autoptimize and Litespeed Cache.<\\/li>\\n<\\/ul>\\n<p>1.5.8<\\/p>\\n<ul>\\n<li>Added support for lazy loading background images, iframes, and videos.<\\/li>\\n<li>Added new lazy loading option to enable Youtube Preview Thumbnails.<\\/li>\\n<li>Added multiple page builder exclusions to our lazy load functions.<\\/li>\\n<li>Added proper support for 404 templates in the Script Manager (non-MU).<\\/li>\\n<li>Fixed some minor styling issues in the Script Manager UI.<\\/li>\\n<li>Fixed an undefined index in the database optimizer class.<\\/li>\\n<li>Removed customer email row from the license tab.<\\/li>\\n<\\/ul>\\n<p>1.5.7<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/optimize-wordpress-database\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Database Optimization<\\/a> section in the Extras tab.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">DOM Monitoring<\\/a> option to complement our existing lazy load settings.<\\/li>\\n<li>Added additional input styles in the Script Manager for better compatibility<\\/li>\\n<li>Made some changes to the Script Manager file include process for better compatibility.<\\/li>\\n<li>Fixed multiple undefined index notices.<\\/li>\\n<li>Updated translation files.<\\/li>\\n<\\/ul>\\n<p>1.5.6<\\/p>\\n<ul>\\n<li>Plugin UI improvements, new tooltip styles.<\\/li>\\n<li>Licensing workflow improvements. Simpler UI, license no longer deactivated on plugin deactivation, license auto-activates on input.<\\/li>\\n<li>Moved Script Manager javascript back to a separate plugin file for better compatibility.<\\/li>\\n<li>Added Remove Query Strings exemption to the Script Manager javascript file.<\\/li>\\n<li>Code refactoring.<\\/li>\\n<\\/ul>\\n<p>1.5.5<\\/p>\\n<ul>\\n<li>Added a new modified function to the MU plugin file which should be able to get the current post ID more effectively for certain types of URLs (custom post types, blog page, etc...).<\\/li>\\n<li>Made some improvements to the MU plugin file detection and update process.<\\/li>\\n<\\/ul>\\n<p>1.5.4<\\/p>\\n<ul>\\n<li>Added additional tooltip warning text to the MU Mode toggle.<\\/li>\\n<li>Added <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/mu-mode\\/#debug-mode\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">mu_mode=off<\\/a> URL parameter to force the page to load with MU Mode settings disabled.<\\/li>\\n<li>Added an additi0nal check to make sure MU Mode settings don\'t run if the base Perfmatters plugin is not activated.<\\/li>\\n<\\/ul>\\n<p>1.5.3<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/mu-mode\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">MU Mode<\\/a> (BETA) feature in the Script Manager which can be used to disable plugins per page.<\\/li>\\n<li>Reworked main Script Manager update function to dynamically save settings via AJAX to prevent having to reload the page every time options are saved.<\\/li>\\n<li>Moved Script Manager javascript inline to better support further updates.<\\/li>\\n<li>Fixed an issue in the Script Manager where a Current URL disable would not function correctly for an individual script if the plugin\'s scripts were disabled globally on a different Current URL.<\\/li>\\n<li>Changed hooks for Disable Google Maps and Disable Google Fonts toggles to prevent a conflict with Gutenberg.<\\/li>\\n<li>Added an exclusion attribute to our LazyLoad script to prevent it from conflicting with WP Rocket\'s JS deferral feature.<\\/li>\\n<li>Updated EDD Plugin Updater Class to version 1.7.1.<\\/li>\\n<li>Updated various translation files.<\\/li>\\n<\\/ul>\\n<p>1.5.2<\\/p>\\n<ul>\\n<li>Added new options in Extras \\u2192 Tools to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/import-export\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Import and Export Plugin Settings<\\/a>.<\\/li>\\n<li>Updated Script Manager form input names to be more specific to prevent conflicts when saving Script Manager settings.<\\/li>\\n<li>Added compatibility fix for Beaver Builder to the Script Manager dequeue function.<\\/li>\\n<li>Updated French and German translation files.<\\/li>\\n<\\/ul>\\n<p>1.5.1<\\/p>\\n<ul>\\n<li>Adjusted the Script Manager styles for better compatibility with other admin bar tools when the Script Manager UI is being displayed.<\\/li>\\n<li>Fixed an issue in the Script Manager that was causing individual script settings to not work correctly when the parent group had previously been disabled.<\\/li>\\n<li>Updated Russian (ru_RU) translation files.<\\/li>\\n<li>Updated plugin description.<\\/li>\\n<\\/ul>\\n<p>1.5.0<\\/p>\\n<ul>\\n<li>Fixed a bug that was causing the Script Manager dequeue function to interfere with the query loop in certain cases.<\\/li>\\n<\\/ul>\\n<p>1.4.9<\\/p>\\n<ul>\\n<li>Performance update to Script Manager form submission function which should help dramatically reduce the footprint when saving script configurations.<\\/li>\\n<li>Removed the Current URL option in the Script Manager when loaded on URLs without a valid post ID. (ex. dynamically generated archive templates)<\\/li>\\n<li>Added plugin settings page header with links to Contact and Support.<\\/li>\\n<li>Minor styling fixes in plugin settings UI.<\\/li>\\n<li>Updated Russian (ru_RU) translation files.<\\/li>\\n<\\/ul>\\n<p>1.4.8<\\/p>\\n<ul>\\n<li>Added new \'Body Code\' box in the Extras tab to go along with our existing header + footer boxes to give some more control there.<\\/li>\\n<li>Added some limits to the Script Manager action links in WP Admin to ensure they are only showing up for public post types.<\\/li>\\n<li>Fixed a bug that was causing the admin stylesheet not to load on the network settings page when running on a multisite.<\\/li>\\n<li>Added Russian (ru_RU) translation files. (credit: Sergey Shljahov)<\\/li>\\n<\\/ul>\\n<p>1.4.7<\\/p>\\n<ul>\\n<li>Added an exception for Gravity Forms to the Disable Heartbeat function.<\\/li>\\n<li>Added an exception for Contact Form 7 to the Disable REST API function.<\\/li>\\n<li>Added updated German (de_DE) translation files. (credit: Daniel Luttermann)<\\/li>\\n<\\/ul>\\n<p>1.4.6<\\/p>\\n<ul>\\n<li>Added a specific and more generous threshold for lazy loading.<\\/li>\\n<li>Added some additional dequeues to the Disable WooCommerce function to target inline CSS and JS.<\\/li>\\n<\\/ul>\\n<p>1.4.5<\\/p>\\n<ul>\\n<li>Updated Disable Google Maps and Disable Google Fonts toggles to not run in WP Admin.<\\/li>\\n<li>Turned off native lazy loading by default and added new option to Use Native.<\\/li>\\n<li>Added perfmatters_lazyload_excluded_attributes filter which allows for an array of attribute strings to be given that if found will exclude the matched image\\/s from lazy loading.<\\/li>\\n<li>Made some compatibility improvements to the Script Manager function that gets the ID of the current post.<\\/li>\\n<li>Added perfmatters_get_current_ID filter which allows the user to extend or modify the functionality of the Script Manager\'s current ID function.<\\/li>\\n<\\/ul>\\n<p>1.4.4<\\/p>\\n<ul>\\n<li>Fixed undefined index PHP Notice coming from the Preconnect settings display function.<\\/li>\\n<li>Added additional compatibility with Elementor when using the Script Manager to disable certain Elementor scripts + styles.<\\/li>\\n<li>Added a ignore flag class to all Lazy Load functions. Simply add the \'no-lazy\' class to any image element you want to be exempt from lazy loading.<\\/li>\\n<li>Added validation filter to Login URL input to prevent incompatible characters from being entered.<\\/li>\\n<\\/ul>\\n<p>1.4.3<\\/p>\\n<ul>\\n<li>Fixed an issue with the Lazy Load function that was causing an error with some older PHP versions.<\\/li>\\n<\\/ul>\\n<p>1.4.2<\\/p>\\n<ul>\\n<li>Added new option for <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/\\\">Lazy Loading<\\/a> images (BETA).<\\/li>\\n<\\/ul>\\n<p>1.4.1<\\/p>\\n<ul>\\n<li>New addition to the Preconnect option, you can now choose to whether or not to add the crossorigin property for each Preconnect URL.<\\/li>\\n<li>Optimization to the loading of Perfmatters admin scripts + styles.<\\/li>\\n<li>Added additional Script Manager styles for better compatibility.<\\/li>\\n<li>Added an additional function for the Custom Login URL to help rewrite certain wp-admin links in specific multisite setups.<\\/li>\\n<li>Reorganized plugin action links in the plugins table.<\\/li>\\n<\\/ul>\\n<p>1.4.0<\\/p>\\n<ul>\\n<li>Fixed an issue where the Current URL Exceptions were not loading correctly after saving in the Script Manager.<\\/li>\\n<\\/ul>\\n<p>1.3.9<\\/p>\\n<ul>\\n<li>Added new Extra options to Add Header Code and Add Footer Code.<\\/li>\\n<li>Added missing blank defaults for DNS Prefetch and Preconnect options.<\\/li>\\n<li>Added functionality to force the Admin Bar to display when the Script Manager is loaded.<\\/li>\\n<li>Script Manager styling adjustments.<\\/li>\\n<li>Added success message on save when the Script Manager options are updated.<\\/li>\\n<li>Added support for 404 page when trying to disable or enable on the Current URL.<\\/li>\\n<\\/ul>\\n<p>1.3.8<\\/p>\\n<ul>\\n<li>Added new option to Disable Comments.<\\/li>\\n<li>Updated a section of the Script Manager to better reflect the Current URL when determining if it is a match for the given regex pattern.<\\/li>\\n<\\/ul>\\n<p>1.3.7<\\/p>\\n<ul>\\n<li>Added links to the Script Manager from the posts list page and post edit page which will take you to the front end and load the Script Manager for the corresponding post.<\\/li>\\n<li>Added warning notices for both WP_POST_REVISIONS and AUTOSAVE_INTERVAL if they are set in Perfmatters while also defined elsewhere.<\\/li>\\n<\\/ul>\\n<p>1.3.6<\\/p>\\n<ul>\\n<li>Added new option to Disable Google Fonts.<\\/li>\\n<li>Removed option to Disable Completely from the Disable REST API dropdown to due core WordPress compatibility issues.<\\/li>\\n<li>Added additional object check to prevent PHP warning in certain cases when using the Separate Archives option in the Script Manager.<\\/li>\\n<li>Added some additional logic to filter duplicate scripts out of the Script Manager master array if they are present.<\\/li>\\n<li>CSS fixes in the Script Manager for better compatibility.<\\/li>\\n<li>Expanded the Script Manager current ID function for better reliability.<\\/li>\\n<\\/ul>\\n<p>1.3.5<\\/p>\\n<ul>\\n<li>Added new Disable REST API option which will disable REST API requests and display an authentication error message if the requester doesn\'t have permission.<\\/li>\\n<li>Added additional action removal to the Remove REST API Links function.<\\/li>\\n<li>Made some changes to the Script Manager save button. It is now fixed on the bottom of the screen for easier access without having to scroll.<\\/li>\\n<li>Additional Script Manager style adjustments.<\\/li>\\n<\\/ul>\\n<p>1.3.4<\\/p>\\n<ul>\\n<li>Minor update to Remove Comment URLs function priority for better compatibility with theme templates.<\\/li>\\n<\\/ul>\\n<p>1.3.3<\\/p>\\n<ul>\\n<li>Added new option to Remove Comment URLs.<\\/li>\\n<li>Added French (fr_FR) language translation.<\\/li>\\n<li>Fixed a PHP warning that would occur when saving Script Manager settings in some instances when Display Archives was also enabled.<\\/li>\\n<\\/ul>\\n<p>1.3.2<\\/p>\\n<ul>\\n<li>Added new option to Add Blank Favicon in the Extras tab.<\\/li>\\n<li>Fixed an issue in the Script Manager Global View where options set for the home page would show up as a 0 with a broken link.<\\/li>\\n<li>Added some additional styles to the main Script Manager view for better compatibility.<\\/li>\\n<\\/ul>\\n<p>1.3.1<\\/p>\\n<ul>\\n<li>Fixed a bug that would sometimes cause an enabled message to display on the front end when using the Regex option in the Script Manager.<\\/li>\\n<\\/ul>\\n<p>1.3.0<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/regex\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Regex<\\/a> option the Script Manager for both disables and exceptions.<\\/li>\\n<li>Added new Reset option in the Script Manager settings which allows for a complete wipe + reset of all configured Script Manager options.<\\/li>\\n<li>Added additional Script Manager styles to improve compatability.<\\/li>\\n<li>Added new status message in Script Manager global view when no options have been set.<\\/li>\\n<\\/ul>\\n<p>1.2.9<\\/p>\\n<ul>\\n<li>Updated uninstallation function to account for new Script Manager settings<\\/li>\\n<li>Updated Google Analytics Disable Display Features function to work correctly with Google\'s new format.<\\/li>\\n<li>Added support to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#monster-insights\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Use MonsterInsights<\\/a> along with Perfmatters local analytics functionality.<\\/li>\\n<li>Added new option in Script Manager settings to Display Archives which will allow you to selectively enable scripts on generated archive pages.<\\/li>\\n<\\/ul>\\n<p>1.2.8<\\/p>\\n<ul>\\n<li>Added mobile + responsive styles to the Script Manager navigation.<\\/li>\\n<li>Added additional styles to the Script Manager for compatibility.<\\/li>\\n<li>Script Manager javascript changes + improvements, specifically for compatibility with sites script minification plugins.<\\/li>\\n<li>Fixed a bug where the Script Manager disclaimer would not turn back on after being switched off.<\\/li>\\n<\\/ul>\\n<p>1.2.7<\\/p>\\n<ul>\\n<li>Small patch to check for a required WP function and include core file if necessary for some setups.<\\/li>\\n<\\/ul>\\n<p>1.2.6<\\/p>\\n<ul>\\n<li>All new Script Manager! View updated documentation at\\u00a0<a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/disable-scripts-per-post-page\\/\\\">https:\\/\\/perfmatters.io\\/docs\\/disable-scripts-per-post-page\\/<\\/a>.<\\/li>\\n<li>Fix to remove Emoji DNS Prefetch when Emojis are disabled<\\/li>\\n<\\/ul>\\n<p>1.2.5<\\/p>\\n<ul>\\n<li>Fixed an issue with the Change Login URL function that was causing an error when using WP-CLI.<\\/li>\\n<li>Added some additional compatibility styles to the Script Manager.<\\/li>\\n<\\/ul>\\n<p>1.2.4<\\/p>\\n<ul>\\n<li>Fixed a bug in the Script Manager that caused Current URL Enable checkboxes to not save properly in certain situations.<\\/li>\\n<li>Updated EDD license functions to process proper SSL verification when calling the WordPress HTTP API.<\\/li>\\n<li>Updated perfmatters_default_options array with new options from recent updates.<\\/li>\\n<li>Removed BETA tag from Local Analytics option.<\\/li>\\n<li>Added more details to the Script Manager Global Settings to see which post IDs and post types have settings assigned to them.<\\/li>\\n<li>Additional styles added to the Script Manager for better compatibility.<\\/li>\\n<li>Updated .pot and translation files.<\\/li>\\n<\\/ul>\\n<p>1.2.3<\\/p>\\n<ul>\\n<li>Bugfix - Rolled back some of the heartbeat changes from the previous update to do some additional testing. Should solve some plugin conflicts that popped up.<\\/li>\\n<\\/ul>\\n<p>1.2.2<\\/p>\\n<ul>\\n<li>Added additional WooCommerce checks for WC specific pages before running disable functions.<\\/li>\\n<li>Changes to the Disable Heartbeat function to avoid causing a script dependency error.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/disable-password-meter-strength\\/\\\">Disable Password Strength Meter<\\/a> option.<\\/li>\\n<li>Fixed an issue that was causing Script Manger dropdown colors to not display correctly when jQuery was disabled.<\\/li>\\n<li>Modified admin notice to print our using \'admin_notices\' hook. (credit: Christian Follmann)<\\/li>\\n<li>Made some adjustments to Script Manager copy to remove unnecessary HTML from the translations. (credit: Christian Follmann)<\\/li>\\n<li>Props to Hasan Basri (<a href=\\\"http:\\/\\/www.hasanbasri93.com\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\" data-saferedirecturl=\\\"https:\\/\\/www.google.com\\/url?q=http:\\/\\/www.hasanbasri93.com&amp;source=gmail&amp;ust=1530375831273000&amp;usg=AFQjCNHnfwHkAwWtNxgfmCyGrwSm3NEyng\\\">www.hasanbasri93.com<\\/a>) for Indonesian (id_ID) translation.\\u00a0&#x1f44f;<\\/li>\\n<li>Updated translations based on the new .pot file.<\\/li>\\n<li>Various other minor tweaks + improvements.<\\/li>\\n<\\/ul>\\n<p>1.2.1<\\/p>\\n<ul>\\n<li>Updated Local Analytics function to improve compatibility with different server setups.<\\/li>\\n<\\/ul>\\n<p>1.2.0<\\/p>\\n<ul>\\n<li>New option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/\\\">Enable Local Analytics<\\/a>, along with a new dedicated Google Analytics tab with various related options.<\\/li>\\n<li>Added some additional logic to redirect RSS Feed URLs when Disable RSS Feeds is toggled on.<\\/li>\\n<li>Fixed an issue that was causing certain email links not to work when using a Custom Login URL.<\\/li>\\n<li>Fixed a bug that was causing the password reset link not to function properly when using a Custom Login URL in a multisite environment.<\\/li>\\n<li>Made some adjustments to the Disable Self Pingbacks function to fix an issue with case sensitivity.<\\/li>\\n<li>Updated text domain for translations in the EDD Updater class.<\\/li>\\n<li>Fixed a bug where the Clean Uninstall option would still show up on individual sites in a multisite environment.<\\/li>\\n<li>Props to\\u00a0PDPK di Mauro Panzarola\\u00a0(<a href=\\\"https:\\/\\/pdpkapp.com\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\" data-saferedirecturl=\\\"https:\\/\\/www.google.com\\/url?q=https:\\/\\/pdpkapp.com&amp;source=gmail&amp;ust=1526653041476000&amp;usg=AFQjCNHfek6Z-CMgUhd0MwvU5QGK6cm0hg\\\">https:\\/\\/pdpkapp.com<\\/a>) for Italian (it_IT) translation.\\u00a0&#x1f44f;<\\/li>\\n<\\/ul>\\n<p>1.1.9<\\/p>\\n<ul>\\n<li>Perfmatters is now translation ready! If you are interested in helping out with a translation, please <a href=\\\"https:\\/\\/perfmatters.io\\/contact\\/\\\">contact us<\\/a>.<\\/li>\\n<li>Props to Christian Foellmann (<a href=\\\"https:\\/\\/github.com\\/cfoellmann\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">cfoellmann@GitHub<\\/a>) for German (de_DE) translation.\\u00a0&#x1f44f;<\\/li>\\n<li>Fixed a PHP undefined index warning in the Script Manager.<\\/li>\\n<li>Fixed a bug that was causing issues with the Change Login URL slug when using certain permalink settings.<\\/li>\\n<\\/ul>\\n<p>1.1.8<\\/p>\\n<ul>\\n<li>Fixed a compatibility issue with Script Manager dequeue priority that could cause it to not function properly.<\\/li>\\n<li>Minor update to the uninstall function.<\\/li>\\n<\\/ul>\\n<p>1.1.7<\\/p>\\n<ul>\\n<li>Fixed a bug that was causing the remove query strings option to conflict with files that have necessary query string parameters (Google Fonts).<\\/li>\\n<\\/ul>\\n<p>1.1.6<\\/p>\\n<ul>\\n<li>Added new Clean Uninstall option in the extras tab.<\\/li>\\n<li>Added new Preconnect option in the extras tab.<\\/li>\\n<\\/ul>\\n<p>1.1.5<\\/p>\\n<ul>\\n<li>Fixed multiple PHP warnings related to settings + option initialization.<\\/li>\\n<\\/ul>\\n<p>1.1.4<\\/p>\\n<ul>\\n<li>Added multisite support with the ability to manage default network settings and network access control.<\\/li>\\n<li>Made some adjustments to plugin naming conventions throughout WordPress admin screens, menus, etc...<\\/li>\\n<li>Removed BETA tag on Change Login URL option.<\\/li>\\n<\\/ul>\\n<p>1.1.3<\\/p>\\n<ul>\\n<li>Added new Change Login URL (BETA) feature to change your WordPress login URL and block the default wp-admin and wp-login endpoints from being directly accessed.<\\/li>\\n<li>Added new Disable Dashicons feature to disable Dashicons from the front end when not logged in.<\\/li>\\n<\\/ul>\\n<p>1.1.2<\\/p>\\n<ul>\\n<li>Added character masking to the license key input field.<\\/li>\\n<\\/ul>\\n<p>1.1.1<\\/p>\\n<ul>\\n<li>Added new CDN URL Rewrite feature in a new settings tab with various settings to customize your configuration.<\\/li>\\n<li>Added new Global Settings section in the Script Manager with a visual representation of the Script Manager options set across the entire site.<\\/li>\\n<li>Made some updates to the Script Manager layout in preparation for future additional features.<\\/li>\\n<\\/ul>\\n<p>1.1.0<\\/p>\\n<ul>\\n<li>Added new Disable Google Maps toggle.<\\/li>\\n<li>Added some backend logic to the Script Manager to hide scripts that have already been disabled sitewide via the main plugin settings.<\\/li>\\n<li>Update to the EDD license activation function variables to help prevent activation conflicts with other plugins.<\\/li>\\n<\\/ul>\\n<p>1.0.9<\\/p>\\n<ul>\\n<li>Removed the toggle to disable WooCommerce reviews, as there is already a WooCommerce setting that provides that functionality.<\\/li>\\n<\\/ul>\\n<p>1.0.8<\\/p>\\n<ul>\\n<li>Added new WooCommerce section to the options tab with multiple toggles to disable or limit certain WooCommerce scripts and functionality.<\\/li>\\n<li>Added some new styles to the plugin admin page to allow for clearer organization of different sections.<\\/li>\\n<li>Fixed an undefined index notice in the Script Manager.<\\/li>\\n<li>Added some additional styles to the checkboxes in the Script Manager to fix a theme compatibility issue.<\\/li>\\n<\\/ul>\\n<p>1.0.7<\\/p>\\n<ul>\\n<li>Added functionality to remove the shortlink\\u00a0HTTP header when \'Remove Shortlink\' is toggled on.<\\/li>\\n<li>Added functionality to remove the xmlrpc.php link as well as the X-Pingback HTTP header when \'Disable XML-RPC\' is toggled on.<\\/li>\\n<\\/ul>\\n<p>1.0.6<\\/p>\\n<ul>\\n<li>Removed BETA label from Script Manager.<\\/li>\\n<li>Added new \'DNS Prefetch\' option in the Extras tab.<\\/li>\\n<\\/ul>\\n<p>1.0.5<\\/p>\\n<ul>\\n<li>Added new toggle to \'Remove REST API Links\'.<\\/li>\\n<li>Renamed \'Remove Feed Links\' toggle for more clarification.<\\/li>\\n<li>UI improvements, hovering tooltips, more links to the web documentation, etc\\u2026<\\/li>\\n<li>Added version numbers to admin scripts to avoid caching on plugin update.<\\/li>\\n<li>Refactored a good portion of the settings initialization code.<\\/li>\\n<li>Removed \\\"Beta\\\" status for script manager. It has been fully tested now and is ready to use in production.<\\/li>\\n<li><\\/li>\\n<\\/ul>\\n<p>1.0.4<\\/p>\\n<ul>\\n<li>Fixed a few PHP warnings dealing with the Script Manager option array management.<\\/li>\\n<li>Fixed a UI bug in the Script Manager causing certain post type checkboxes\\u00a0to not be selectable.<\\/li>\\n<\\/ul>\\n<p>1.0.3<\\/p>\\n<ul>\\n<li>Introduced the new Script Manager feature to disable scripts on a per page\\/post basis.<\\/li>\\n<\\/ul>\\n<p>1.0.2<\\/p>\\n<ul>\\n<li>Added Extras tab with a new option for Accessibility\\u00a0Mode. Enabling this will turn off the custom styles we use for our settings toggles and revert to standard HTML checkboxes.<\\/li>\\n<li>Additional accessibility improvements.<\\/li>\\n<li>A few style fixes.<\\/li>\\n<\\/ul>\\n<p>1.0.1<\\/p>\\n<ul>\\n<li>Accessibility improvements to the plugin settings page.<\\/li>\\n<\\/ul>\\n<p>1.0.0<\\/p>\\n<ul>\\n<li>Plugin launched.<\\/li>\\n<\\/ul>\\n\"],\"plugin\":\"perfmatters\\/perfmatters.php\",\"id\":\"perfmatters\\/perfmatters.php\"}\";}","no");

INSERT IGNORE INTO `wp_options` VALUES 
("100449","wpb_license_errors","a:0:{}","yes"),
("100967","woocommerce_downloads_deliver_inline","","no"),
("100968","woocommerce_navigation_enabled","no","yes"),
("100969","woocommerce_new_product_management_enabled","no","yes"),
("100970","woocommerce_feature_custom_order_tables_enabled","no","yes"),
("101051","perfmatters_script_manager","a:2:{s:8:\"disabled\";a:2:{s:7:\"plugins\";a:1:{s:14:\"contact-form-7\";a:1:{s:10:\"everywhere\";i:1;}}s:3:\"css\";a:2:{s:9:\"rs-roboto\";a:1:{s:10:\"everywhere\";i:1;}s:2:\"gf\";a:1:{s:10:\"everywhere\";i:1;}}}s:7:\"enabled\";a:1:{s:7:\"plugins\";a:1:{s:14:\"contact-form-7\";a:1:{s:5:\"regex\";s:8:\"contacts\";}}}}","yes"),
("118424","persian_woocommerce_translates","a:1:{s:28:\"مشاهده سبد خرید\";s:15:\"سبد خرید\";}","yes"),
("118428","wc_blocks_use_blockified_product_grid_block_as_template","no","yes"),
("118429","wc_blocks_version","11.8.0-dev","yes"),
("118430","jetpack_connection_active_plugins","a:1:{s:11:\"woocommerce\";a:1:{s:4:\"name\";s:14:\"ووکامرس\";}}","yes"),
("118433","woocommerce_feature_product_block_editor_enabled","no","yes"),
("118441","jetpack_options","a:1:{s:14:\"last_heartbeat\";i:1720177714;}","yes"),
("118457","pw_dismiss_notice_persian-date","1723110695","yes"),
("118458","pw_dismiss_notice_all","1710751683","yes"),
("118483","woocommerce_task_list_tracked_completed_tasks","a:2:{i:0;s:8:\"purchase\";i:1;s:8:\"products\";}","yes"),
("119763","pw_dismiss_notice_pw_gateways_setup","1726217283","yes"),
("123777","woocommerce_custom_orders_table_enabled","no","yes"),
("123778","woocommerce_custom_orders_table_data_sync_enabled","no","yes"),
("123779","woocommerce_custom_orders_table_created","yes","yes"),
("123781","woocommerce_feature_marketplace_enabled","yes","yes"),
("123787","wcpay_was_in_use","no","yes"),
("127852","wp_attachment_pages_enabled","1","yes"),
("132375","_transient_timeout_woocommerce_blocks_asset_api_script_data_ssl","1722856539","no"),
("132376","_transient_woocommerce_blocks_asset_api_script_data_ssl","{\"script_data\":{\"assets\\/client\\/blocks\\/wc-settings.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-settings.js\",\"version\":\"07c2f0675ddd247d2325\",\"dependencies\":[\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-types.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-types.js\",\"version\":\"bda84b1be3361607d04a\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-middleware.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-middleware.js\",\"version\":\"ca04183222edaf8a26be\",\"dependencies\":[\"wp-api-fetch\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-data.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-data.js\",\"version\":\"aa70187e428ac61bcae6\",\"dependencies\":[\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-data\",\"wp-data-controls\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-vendors.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-vendors.js\",\"version\":\"119e7bb2c4461381cedb\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-registry.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-registry.js\",\"version\":\"1c879273bd5c193cad0a\",\"dependencies\":[\"react\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks.js\",\"version\":\"cd474ab94f869686fedb\",\"dependencies\":[\"react\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-dom-ready\",\"wp-element\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-context.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-context.js\",\"version\":\"6eb6865831aa5a75475d\",\"dependencies\":[\"react\",\"wp-element\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\",\"version\":\"4f21a9f43ea5bfa7f02e\",\"dependencies\":[\"react\",\"wc-blocks-data-store\",\"wc-blocks-shared-context\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/price-format.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-format.js\",\"version\":\"eb7a7398126f71912b09\",\"dependencies\":[\"wc-settings\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-vendors-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-vendors-frontend.js\",\"version\":\"714ee664806bf8b8881d\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-checkout.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout.js\",\"version\":\"e3cd3448f27240725bf3\",\"dependencies\":[\"react\",\"react-dom\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/blocks-components.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-components.js\",\"version\":\"b7375a203f24f090b6a3\",\"dependencies\":[\"react\",\"react-dom\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/wc-interactivity-dropdown.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-interactivity-dropdown.js\",\"version\":\"8997b5406dcf18064a4e\",\"dependencies\":[\"wc-interactivity\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-interactivity-checkbox-list.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-interactivity-checkbox-list.js\",\"version\":\"c33101c7e57ca780e0d8\",\"dependencies\":[\"wc-interactivity\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/active-filters.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/active-filters.js\",\"version\":\"c9da03c2e68f9e545610\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/active-filters-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/active-filters-frontend.js\",\"version\":\"c819300b49a36b4c9be2\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/all-products.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/all-products.js\",\"version\":\"ce97a7b3d8b80da5751c\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/all-products-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/all-products-frontend.js\",\"version\":\"cfb32215d6a78960d688\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-autop\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/all-reviews.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/all-reviews.js\",\"version\":\"6d41699f5c3d2bcf0174\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-escape-html\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/reviews-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/reviews-frontend.js\",\"version\":\"dc5699f515001ffbb402\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-settings\",\"wp-a11y\",\"wp-api-fetch\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/attribute-filter.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/attribute-filter.js\",\"version\":\"45dfd905c04b5b3e2831\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/attribute-filter-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/attribute-filter-frontend.js\",\"version\":\"50dc20e4dab67d67842d\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/breadcrumbs.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/breadcrumbs.js\",\"version\":\"63ecba4abb05451b314b\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/catalog-sorting.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/catalog-sorting.js\",\"version\":\"6c2e6a0a2cd09107cf04\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/legacy-template.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/legacy-template.js\",\"version\":\"e386b835b18cc2ae8098\",\"dependencies\":[\"react\",\"wc-settings\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/classic-shortcode.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/classic-shortcode.js\",\"version\":\"67871d4353bd5acc02fb\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/coming-soon.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/coming-soon.js\",\"version\":\"c6d2e77a8930f58cbff8\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-i18n\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/customer-account.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/customer-account.js\",\"version\":\"167585d7d1516357f5d6\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/featured-category.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/featured-category.js\",\"version\":\"15d9438d6a088e437e7b\",\"dependencies\":[\"react\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\"]},\"assets\\/client\\/blocks\\/featured-product.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/featured-product.js\",\"version\":\"14a144067bf359f6e20c\",\"dependencies\":[\"react\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\"]},\"assets\\/client\\/blocks\\/filter-wrapper.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/filter-wrapper.js\",\"version\":\"7f2269e03957a553e47c\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/filter-wrapper-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/filter-wrapper-frontend.js\",\"version\":\"6ba7aa27fa18d2bfa52e\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/handpicked-products.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/handpicked-products.js\",\"version\":\"8a3aa6ce345089ea5d94\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/mini-cart.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart.js\",\"version\":\"79083d99d985f9e20a24\",\"dependencies\":[\"react\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/mini-cart-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-frontend.js\",\"version\":\"eba896c62201a23c4175\",\"dependencies\":[\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-i18n\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/store-notices.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/store-notices.js\",\"version\":\"2332d8c6c55f663b1ce9\",\"dependencies\":[\"react\",\"wp-a11y\",\"wp-block-editor\",\"wp-blocks\",\"wp-deprecated\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/price-filter.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-filter.js\",\"version\":\"7f180a29fc278dc59601\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/price-filter-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-filter-frontend.js\",\"version\":\"4911df2a2c3d0a898613\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-best-sellers.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-best-sellers.js\",\"version\":\"a946f5f222769d44b244\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-button.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-button.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/product-button-interactivity-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-button-interactivity-frontend.js\",\"version\":\"a2bc639c0616290818e3\",\"dependencies\":[\"react\",\"wc-blocks-data-store\",\"wc-interactivity\",\"wp-a11y\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-categories.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-categories.js\",\"version\":\"19dfea34dec3553590a0\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\"]},\"assets\\/client\\/blocks\\/product-category.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-category.js\",\"version\":\"6372f5dfe447f9bba675\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-collection.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-collection.js\",\"version\":\"59ca790e39baeb30b400\",\"dependencies\":[\"react\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-editor\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-collection-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-collection-frontend.js\",\"version\":\"37b3a37d0211278e6a0c\",\"dependencies\":[\"wc-interactivity\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/product-collection-no-results.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-collection-no-results.js\",\"version\":\"d1c4e65a98c9f79e8930\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-gallery.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-gallery.js\",\"version\":\"e69aeaf2e9f5d5f485ad\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-gallery-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-gallery-frontend.js\",\"version\":\"c340254c6c31444370fb\",\"dependencies\":[\"wc-interactivity\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/product-gallery-large-image.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-gallery-large-image.js\",\"version\":\"4623f1b31944fd3c89d4\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/product-gallery-large-image-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-gallery-large-image-frontend.js\",\"version\":\"dd8201c48d0f0223ee5a\",\"dependencies\":[\"wc-interactivity\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/product-new.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-new.js\",\"version\":\"7e976feaa8e491a59d78\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-on-sale.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-on-sale.js\",\"version\":\"291bbe4ab78db3422b64\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-template.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-template.js\",\"version\":\"6bf76a2b8c7f0eb1715f\",\"dependencies\":[\"react\",\"wc-blocks-shared-context\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-query.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-query.js\",\"version\":\"c96d96278decc57537fa\",\"dependencies\":[\"react\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-query-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-query-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/product-results-count.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-results-count.js\",\"version\":\"f5e7da47100ae9363279\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-search.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-search.js\",\"version\":\"c85a1964c97a41d1137a\",\"dependencies\":[\"react\",\"wc-settings\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-summary.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-summary.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/product-tag.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-tag.js\",\"version\":\"6a1606b0580db424ba0a\",\"dependencies\":[\"react\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-title.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-title.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/product-title-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-title-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/product-top-rated.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-top-rated.js\",\"version\":\"184f77fd8db7e4cc9432\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/products-by-attribute.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/products-by-attribute.js\",\"version\":\"57b51671a04848288dc7\",\"dependencies\":[\"react\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/rating-filter.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/rating-filter.js\",\"version\":\"ba520db336105c07fcc2\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/reviews-by-category.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/reviews-by-category.js\",\"version\":\"b9582fd96ad3d61d13e5\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/reviews-by-product.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/reviews-by-product.js\",\"version\":\"4f6e417f7c17f88e4346\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/single-product.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/single-product.js\",\"version\":\"b0d3e97eddefc63f28d7\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wc-store-data\",\"wc-types\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/stock-filter.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/stock-filter.js\",\"version\":\"90dfc5dbe81525ab2dde\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/stock-filter-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/stock-filter-frontend.js\",\"version\":\"62af5e36a57873525d0e\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/page-content-wrapper.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/page-content-wrapper.js\",\"version\":\"56b4438fb405c2978396\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-status.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-status.js\",\"version\":\"2c059192f836902afc42\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-summary.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-summary.js\",\"version\":\"bce30c87f99abc744d6b\",\"dependencies\":[\"react\",\"wc-price-format\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-date\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-totals.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-totals.js\",\"version\":\"3578f6bba1fdfa8f4584\",\"dependencies\":[\"react\",\"wc-price-format\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-totals-wrapper.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-totals-wrapper.js\",\"version\":\"186984378635e6e08423\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-downloads.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-downloads.js\",\"version\":\"1d9816820e49da031b6c\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-downloads-wrapper.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-downloads-wrapper.js\",\"version\":\"30996a1e56bfad5c506f\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-billing-address.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-billing-address.js\",\"version\":\"3c5b3c652ebfe139adfa\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-shipping-address.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-shipping-address.js\",\"version\":\"3067fbc4dc75b1f74271\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-billing-wrapper.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-billing-wrapper.js\",\"version\":\"fce4c23d911cc8526506\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-shipping-wrapper.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-shipping-wrapper.js\",\"version\":\"b923bf1dbf6392c32509\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-additional-information.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-additional-information.js\",\"version\":\"f4a1c3f8c632681e85dd\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-additional-fields-wrapper.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-additional-fields-wrapper.js\",\"version\":\"7d9924812d7a1d07c078\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-additional-fields.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-additional-fields.js\",\"version\":\"c0ff0169274420939c6b\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/cart.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart.js\",\"version\":\"8f351ba9d17d461e1c55\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-editor\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-notices\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/cart-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-frontend.js\",\"version\":\"52a762d265a6430503c7\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-blocks\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/cart-blocks\\/proceed-to-checkout-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/proceed-to-checkout-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-shipping-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-shipping-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-accepted-payment-methods-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-accepted-payment-methods-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-items-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-items-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-express-payment-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-express-payment-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/empty-cart-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/empty-cart-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-heading-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-heading-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-totals-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-totals-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-cross-sells-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-cross-sells-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-heading-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-heading-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-cross-sells-products-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-cross-sells-products-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/empty-cart-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/empty-cart-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-totals-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-totals-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-discount-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-discount-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-coupon-form-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-coupon-form-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-totals-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-totals-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-taxes-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-taxes-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-subtotal-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-subtotal-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-discount-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-discount-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-express-payment-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-express-payment-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-order-summary-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-order-summary-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-subtotal-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-subtotal-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/proceed-to-checkout-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/proceed-to-checkout-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/filled-cart-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/filled-cart-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-totals-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-totals-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-fee-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-fee-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-order-summary-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-order-summary-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-items-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-items-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-fee-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-fee-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/filled-cart-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/filled-cart-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-coupon-form-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-coupon-form-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-cross-sells-products-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-cross-sells-products-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-accepted-payment-methods-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-accepted-payment-methods-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-cross-sells-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-cross-sells-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-shipping-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-shipping-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-taxes-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-taxes-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-taxes-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-taxes-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-subtotal-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-subtotal-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-totals-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-totals-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/filled-cart-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/filled-cart-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/empty-cart-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/empty-cart-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-totals-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-totals-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-items-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-items-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-line-items-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-line-items-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-express-payment-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-express-payment-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/proceed-to-checkout-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/proceed-to-checkout-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-accepted-payment-methods-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-accepted-payment-methods-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-coupon-form-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-coupon-form-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-discount-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-discount-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-fee-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-fee-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-heading-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-heading-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-shipping-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-shipping-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-cross-sells-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-cross-sells-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-cross-sells-products-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-cross-sells-products-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout.js\",\"version\":\"e6c1b11832db8f183eb7\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-editor\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-notices\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/checkout-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-frontend.js\",\"version\":\"d9423ebd342bbf2764f8\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/checkout-blocks\\/fields-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/fields-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/billing-address-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/billing-address-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/fields-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/fields-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/shipping-methods-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/shipping-methods-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-shipping-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-shipping-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/contact-information-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/contact-information-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/additional-information-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/additional-information-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/shipping-method-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/shipping-method-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-note-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-note-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/actions-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/actions-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/additional-information-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/additional-information-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/express-payment-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/express-payment-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/totals-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/totals-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/terms-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/terms-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/shipping-method-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/shipping-method-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/billing-address-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/billing-address-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/shipping-address-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/shipping-address-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-discount-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-discount-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-coupon-form-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-coupon-form-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/shipping-methods-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/shipping-methods-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-taxes-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-taxes-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-subtotal-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-subtotal-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/actions-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/actions-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-discount-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-discount-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-cart-items-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-cart-items-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/contact-information-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/contact-information-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-subtotal-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-subtotal-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/payment-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/payment-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/terms-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/terms-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/pickup-options-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/pickup-options-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-cart-items-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-cart-items-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-fee-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-fee-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-fee-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-fee-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/pickup-options-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/pickup-options-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-coupon-form-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-coupon-form-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/shipping-address-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/shipping-address-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/payment-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/payment-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/totals-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/totals-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-shipping-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-shipping-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-taxes-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-taxes-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-express-payment--checkout-blocks\\/express-payment-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-express-payment--checkout-blocks\\/express-payment-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-actions-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-actions-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-additional-information-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-additional-information-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-billing-address-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-billing-address-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-contact-information-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-contact-information-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-express-payment-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-express-payment-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-fields-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-fields-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-note-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-note-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-cart-items-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-cart-items-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-coupon-form-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-coupon-form-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-discount-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-discount-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-fee-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-fee-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-shipping-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-shipping-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-subtotal-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-subtotal-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-taxes-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-taxes-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-totals-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-totals-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-payment-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-payment-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-shipping-address-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-shipping-address-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-shipping-methods-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-shipping-methods-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-shipping-method-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-shipping-method-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-pickup-options-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-pickup-options-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-terms-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-terms-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-totals-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-totals-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents.js\",\"version\":\"c925533fdaadf54fdb18\",\"dependencies\":[\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/empty-mini-cart-contents-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/empty-mini-cart-contents-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/filled-mini-cart-contents-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/filled-mini-cart-contents-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-footer-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-footer-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-items-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-items-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-products-table-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-products-table-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-shopping-button-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-shopping-button-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-cart-button-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-cart-button-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-checkout-button-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-checkout-button-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-title-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-title-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-title-items-counter-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-title-items-counter-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-title-label-block.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-title-label-block.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\",\"version\":\"bc495a4e0336aa3953db\",\"dependencies\":[\"react\",\"react-dom\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/mini-cart-component-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-component-frontend.js\",\"version\":\"24fa89fe1cb0205c0bb6\",\"dependencies\":[\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-autop\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\",\"version\":\"wc-9.0.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\":{\"src\":\"https:\\/\\/rtl.pars-themes.com\\/ingenious\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-c