<?php
/*
Plugin Name: Ingenious Shortcodes
Plugin URI:  http://cwsthemes.com
Description: Internal use for cwsthemes themes only.
Version:     1.0.6
Author:      CWSThemes
Text Domain: ingenious-shortcodes
*/

/**
 * Load plugin textdomain.
 */
function cws_load_shortc_textdomain() {
  load_plugin_textdomain( 'ingenious-shortcodes', false, basename( dirname( __FILE__ ) ) . '/languages' ); 
}
add_action( 'plugins_loaded', 'cws_load_shortc_textdomain' );


//Add Widgets
add_action( "widgets_init", "cws_register_widgets" );
function cws_register_widgets() {
	// widgets
	require_once( 'widgets/ingenious_widget_social.php' );
	require_once( 'widgets/ingenious_widget_gallery.php' );
	require_once( 'widgets/ingenious_widget_twitter.php' );
	require_once( 'widgets/ingenious_widget_staff.php' );
	require_once( 'widgets/ingenious_widget_latest_posts.php' );
	require_once( 'widgets/ingenious_widget_text.php' );
	require_once( 'widgets/ingenious_widget_search.php' );
	require_once( 'widgets/ingenious_widget_about.php' );
	// \widgets

	register_widget( 'Ingenious_Social_Widget' );
	register_widget( 'Ingenious_Gallery' );
	register_widget( 'Ingenious_Twitter_Widget' );
	register_widget( 'Ingenious_Staff_Widget' );
	register_widget( 'Ingenious_Latest_Posts' );
	register_widget( 'Ingenious_Text_Widget' );
	register_widget( 'Ingenious_Search_Widget' );
	register_widget( 'Ingenious_About' );

}

require_once( 'metaboxes.php' );


function cws_vc_shortcode_sl_shortcode() {
	return cws_vc_shortcode_get_simple_likes_button( get_the_ID(), 0 );
}
add_shortcode( 'jmliker', 'cws_vc_shortcode_sl_shortcode' );

add_action( 'wp_ajax_nopriv_cws_vc_shortcode_process_simple_like', 'cws_vc_shortcode_process_simple_like' );
add_action( 'wp_ajax_cws_vc_shortcode_process_simple_like', 'cws_vc_shortcode_process_simple_like' );
function cws_vc_shortcode_process_simple_like() {
	// Security
	$nonce = isset( $_REQUEST['nonce'] ) ? sanitize_text_field( $_REQUEST['nonce'] ) : 0;
	if ( !wp_verify_nonce( $nonce, 'simple-likes-nonce' ) ) {
		exit( esc_html__( 'Not permitted', 'ingenious-shortcodes' ) );
	}
	// Test if javascript is disabled
	$disabled = ( isset( $_REQUEST['disabled'] ) && $_REQUEST['disabled'] == true ) ? true : false;
	// Test if this is a comment
	$is_comment = ( isset( $_REQUEST['is_comment'] ) && $_REQUEST['is_comment'] == 1 ) ? 1 : 0;
	// Base variables
	$post_id = ( isset( $_REQUEST['post_id'] ) && is_numeric( $_REQUEST['post_id'] ) ) ? $_REQUEST['post_id'] : '';
	$result = array();
	$post_users = NULL;
	$like_count = 0;
	// Get plugin options
	if ( $post_id != '' ) {
		$count = ( $is_comment == 1 ) ? get_comment_meta( $post_id, "_comment_like_count", true ) : get_post_meta( $post_id, "_post_like_count", true ); // like count
		$count = ( isset( $count ) && is_numeric( $count ) ) ? $count : 0;
		if ( !cws_vc_shortcode_already_liked( $post_id, $is_comment ) ) { // Like the post
			if ( is_user_logged_in() ) { // user is logged in
				$user_id = get_current_user_id();
				$post_users = cws_vc_shortcode_post_user_likes( $user_id, $post_id, $is_comment );
				if ( $is_comment == 1 ) {
					// Update User & Comment
					$user_like_count = get_user_option( "_comment_like_count", $user_id );
					$user_like_count =  ( isset( $user_like_count ) && is_numeric( $user_like_count ) ) ? $user_like_count : 0;
					update_user_option( $user_id, "_comment_like_count", ++$user_like_count );
					if ( $post_users ) {
						update_comment_meta( $post_id, "_user_comment_liked", $post_users );
					}
				} else {
					// Update User & Post
					$user_like_count = get_user_option( "_user_like_count", $user_id );
					$user_like_count =  ( isset( $user_like_count ) && is_numeric( $user_like_count ) ) ? $user_like_count : 0;
					update_user_option( $user_id, "_user_like_count", ++$user_like_count );
					if ( $post_users ) {
						update_post_meta( $post_id, "_user_liked", $post_users );
					}
				}
			} else { // user is anonymous
				$user_ip = cws_vc_shortcode_sl_get_ip();
				$post_users = cws_vc_shortcode_post_ip_likes( $user_ip, $post_id, $is_comment );
				// Update Post
				if ( $post_users ) {
					if ( $is_comment == 1 ) {
						update_comment_meta( $post_id, "_user_comment_IP", $post_users );
					} else { 
						update_post_meta( $post_id, "_user_IP", $post_users );
					}
				}
			}
			$like_count = ++$count;
			$response['status'] = "liked";
			$response['icon'] = cws_vc_shortcode_get_liked_icon();
		} else { // Unlike the post
			if ( is_user_logged_in() ) { // user is logged in
				$user_id = get_current_user_id();
				$post_users = cws_vc_shortcode_post_user_likes( $user_id, $post_id, $is_comment );
				// Update User
				if ( $is_comment == 1 ) {
					$user_like_count = get_user_option( "_comment_like_count", $user_id );
					$user_like_count =  ( isset( $user_like_count ) && is_numeric( $user_like_count ) ) ? $user_like_count : 0;
					if ( $user_like_count > 0 ) {
						update_user_option( $user_id, "_comment_like_count", --$user_like_count );
					}
				} else {
					$user_like_count = get_user_option( "_user_like_count", $user_id );
					$user_like_count =  ( isset( $user_like_count ) && is_numeric( $user_like_count ) ) ? $user_like_count : 0;
					if ( $user_like_count > 0 ) {
						update_user_option( $user_id, '_user_like_count', --$user_like_count );
					}
				}
				// Update Post
				if ( $post_users ) {	
					$uid_key = array_search( $user_id, $post_users );
					unset( $post_users[$uid_key] );
					if ( $is_comment == 1 ) {
						update_comment_meta( $post_id, "_user_comment_liked", $post_users );
					} else { 
						update_post_meta( $post_id, "_user_liked", $post_users );
					}
				}
			} else { // user is anonymous
				$user_ip = cws_vc_shortcode_sl_get_ip();
				$post_users = cws_vc_shortcode_post_ip_likes( $user_ip, $post_id, $is_comment );
				// Update Post
				if ( $post_users ) {
					$uip_key = array_search( $user_ip, $post_users );
					unset( $post_users[$uip_key] );
					if ( $is_comment == 1 ) {
						update_comment_meta( $post_id, "_user_comment_IP", $post_users );
					} else { 
						update_post_meta( $post_id, "_user_IP", $post_users );
					}
				}
			}
			$like_count = ( $count > 0 ) ? --$count : 0; // Prevent negative number
			$response['status'] = "unliked";
			$response['icon'] = cws_vc_shortcode_get_unliked_icon();
		}
		if ( $is_comment == 1 ) {
			update_comment_meta( $post_id, "_comment_like_count", $like_count );
			update_comment_meta( $post_id, "_comment_like_modified", date( 'Y-m-d H:i:s' ) );
		} else { 
			update_post_meta( $post_id, "_post_like_count", $like_count );
			update_post_meta( $post_id, "_post_like_modified", date( 'Y-m-d H:i:s' ) );
		}
		$response['count'] = get_like_count( $like_count );
		$response['testing'] = $is_comment;
		if ( $disabled == true ) {
			if ( $is_comment == 1 ) {
				wp_redirect( get_permalink( get_the_ID() ) );
				exit();
			} else {
				wp_redirect( get_permalink( $post_id ) );
				exit();
			}
		} else {
			wp_send_json( $response );
		}
	}
}

function cws_vc_shortcode_already_liked( $post_id, $is_comment ) {
	$post_users = NULL;
	$user_id = NULL;
	if ( is_user_logged_in() ) { // user is logged in
		$user_id = get_current_user_id();
		$post_meta_users = ( $is_comment == 1 ) ? get_comment_meta( $post_id, "_user_comment_liked" ) : get_post_meta( $post_id, "_user_liked" );
		if ( count( $post_meta_users ) != 0 ) {
			$post_users = $post_meta_users[0];
		}
	} else { // user is anonymous
		$user_id = cws_vc_shortcode_sl_get_ip();
		$post_meta_users = ( $is_comment == 1 ) ? get_comment_meta( $post_id, "_user_comment_IP" ) : get_post_meta( $post_id, "_user_IP" ); 
		if ( count( $post_meta_users ) != 0 ) { // meta exists, set up values
			$post_users = $post_meta_users[0];
		}
	}
	if ( is_array( $post_users ) && in_array( $user_id, $post_users ) ) {
		return true;
	} else {
		return false;
	}
}

function cws_vc_shortcode_get_simple_likes_button( $post_id, $is_comment = NULL ) {
	$is_comment = ( NULL == $is_comment ) ? 0 : 1;
	$output = '';
	$nonce = wp_create_nonce( 'simple-likes-nonce' ); // Security
	if ( $is_comment == 1 ) {
		$post_id_class = esc_attr( ' sl-comment-button-' . $post_id );
		$comment_class = esc_attr( ' sl-comment' );
		$like_count = get_comment_meta( $post_id, "_comment_like_count", true );
		$like_count = ( isset( $like_count ) && is_numeric( $like_count ) ) ? $like_count : 0;
	} else {
		$post_id_class = esc_attr( ' sl-button-' . $post_id );
		$comment_class = esc_attr( '' );
		$like_count = get_post_meta( $post_id, "_post_like_count", true );
		$like_count = ( isset( $like_count ) && is_numeric( $like_count ) ) ? $like_count : 0;
	}
	$count = get_like_count( $like_count );
	$icon_empty = cws_vc_shortcode_get_unliked_icon();
	$icon_full = cws_vc_shortcode_get_liked_icon();
	// Loader
	$loader = '<span class="sl-loader"></span>';
	// Liked/Unliked Variables
	if ( cws_vc_shortcode_already_liked( $post_id, $is_comment ) ) {
		$class = esc_attr( ' liked' );
		$title = esc_html__( 'Unlike', 'ingenious-shortcodes' );
		$icon = $icon_full;
	} else {
		$class = '';
		$title = esc_html__( 'Like', 'ingenious-shortcodes' );
		$icon = $icon_empty;
	}
	$output = '<span class="sl-wrapper"><a href="' . admin_url( 'admin-ajax.php?action=cws_vc_shortcode_process_simple_like' . '&post_id=' . $post_id . '&nonce=' . $nonce . '&is_comment=' . $is_comment . '&disabled=true' ) . '" class="sl-button' . $post_id_class . $class . $comment_class . '" data-nonce="' . $nonce . '" data-post-id="' . $post_id . '" data-iscomment="' . $is_comment . '" title="' . $title . '">' . $icon . $count . '</a>' . $loader . '</span>';
	return $output;
} 

function cws_vc_shortcode_post_user_likes( $user_id, $post_id, $is_comment ) {
	$post_users = '';
	$post_meta_users = ( $is_comment == 1 ) ? get_comment_meta( $post_id, "_user_comment_liked" ) : get_post_meta( $post_id, "_user_liked" );
	if ( count( $post_meta_users ) != 0 ) {
		$post_users = $post_meta_users[0];
	}
	if ( !is_array( $post_users ) ) {
		$post_users = array();
	}
	if ( !in_array( $user_id, $post_users ) ) {
		$post_users['user-' . $user_id] = $user_id;
	}
	return $post_users;
}

function cws_vc_shortcode_post_ip_likes( $user_ip, $post_id, $is_comment ) {
	$post_users = '';
	$post_meta_users = ( $is_comment == 1 ) ? get_comment_meta( $post_id, "_user_comment_IP" ) : get_post_meta( $post_id, "_user_IP" );
	// Retrieve post information
	if ( count( $post_meta_users ) != 0 ) {
		$post_users = $post_meta_users[0];
	}
	if ( !is_array( $post_users ) ) {
		$post_users = array();
	}
	if ( !in_array( $user_ip, $post_users ) ) {
		$post_users['ip-' . $user_ip] = $user_ip;
	}
	return $post_users;
}

function cws_vc_shortcode_sl_get_ip() {
	if ( isset( $_SERVER['HTTP_CLIENT_IP'] ) && ! empty( $_SERVER['HTTP_CLIENT_IP'] ) ) {
		$ip = $_SERVER['HTTP_CLIENT_IP'];
	} elseif ( isset( $_SERVER['HTTP_X_FORWARDED_FOR'] ) && ! empty( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ) {
		$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
	} else {
		$ip = ( isset( $_SERVER['REMOTE_ADDR'] ) ) ? $_SERVER['REMOTE_ADDR'] : '0.0.0.0';
	}
	$ip = filter_var( $ip, FILTER_VALIDATE_IP );
	$ip = ( $ip === false ) ? '0.0.0.0' : $ip;
	return $ip;
}

function cws_vc_shortcode_get_liked_icon() {
	/* If already using Font Awesome with your theme, replace svg with: <i class="fa fa-heart"></i> */
	$icon = '<span class="sl-icon unliked"></span>';
	return $icon;
}

function cws_vc_shortcode_get_unliked_icon() {
	/* If already using Font Awesome with your theme, replace svg with: <i class="fa fa-heart-o"></i> */
	$icon = '<span class="sl-icon liked"></span>';
	return $icon;
}

function cws_vc_shortcode_sl_format_count( $number ) {
	$precision = 2;
	if ( $number >= 1000 && $number < 1000000 ) {
		$formatted = number_format( $number/1000, $precision ).'K';
	} else if ( $number >= 1000000 && $number < 1000000000 ) {
		$formatted = number_format( $number/1000000, $precision ).'M';
	} else if ( $number >= 1000000000 ) {
		$formatted = number_format( $number/1000000000, $precision ).'B';
	} else {
		$formatted = $number; // Number is less than 1000
	}
	$formatted = str_replace( '.00', '', $formatted );
	return $formatted;
}

function get_like_count( $like_count ) {
	$like_text = esc_html__( '0', 'ingenious-shortcodes' );
	if ( is_numeric( $like_count ) && $like_count > 0 ) { 
		$number = cws_vc_shortcode_sl_format_count( $like_count );
	} else {
		$number = $like_text;
	}
	$count = '<span class="sl-count">'.$number.' '.esc_html__('پسند', 'ingenious-shortcodes').'</span>';
	return $count;
}
// User Profile List
add_action( 'show_user_profile', 'cws_vc_shortcode_show_user_likes' );
add_action( 'edit_user_profile', 'cws_vc_shortcode_show_user_likes' );
function cws_vc_shortcode_show_user_likes( $user ) { ?>        
	<table class="form-table">
		<tr>
			<th><label for="user_likes"><?php _e( 'You Like:', 'ingenious-shortcodes' ); ?></label></th>
			<td>
				<?php
				$types = get_post_types( array( 'public' => true ) );
				$args = array(
					'numberposts' => -1,
					'post_type' => $types,
					'meta_query' => array (
						array (
							'key' => '_user_liked',
							'value' => $user->ID,
							'compare' => 'LIKE'
							)
						) );		
				$sep = '';
				$like_query = new WP_Query( $args );
				if ( $like_query->have_posts() ) : ?>
					<p>
						<?php while ( $like_query->have_posts() ) : $like_query->the_post(); 
						echo sprintf('%s', $sep); ?><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
						<?php
						$sep = ' &middot; ';
						endwhile; 
						?>
					</p>
				<?php else : ?>
				<p><?php _e( 'You do not like anything yet.', 'ingenious-shortcodes' ); ?></p>
				<?php 
				endif; 
				wp_reset_postdata(); 
				?>
			</td>
		</tr>
	</table>
<?php }
/**
 * Processes like/unlike
 * @since    0.5
 */

function ingenious_msg_box ( $atts = array(), $content = "" ){
	extract( shortcode_atts( array(
		'type'					=> 'success',
		'title'					=> '',
		'text'					=> '',
		'is_closable'			=> '',
		'customize'				=> '',
		'with_icon'				=> '',
		'custom_icon'			=> '',
		'with_custom_icon'		=> '',
		'custom_fill_color'		=> INGENIOUS_THEME_COLOR,
		'el_class'				=> ''
	), $atts));
	$out = "";
	$type = esc_html( $type );
	$is_closable = (bool)$is_closable;
	$customize = (bool)$customize;
	$with_icon = (bool)$with_icon;
	$with_custom_icon = (bool)$with_custom_icon;
	$custom_icon = esc_html( $custom_icon );
	$el_class = esc_attr( $el_class );
	$content = !empty( $text ) ? $text : $content;
	$section_id = uniqid( "ingenious_msg_box_" );
	ob_start();
	if ( $customize ){
		echo !empty( $custom_fill_color ) ? "background-color: $custom_fill_color;" : "";
	}
	$section_styles = ob_get_clean();
	$icon_part_styles = '';	
	$classes = $type;
	$classes .= $is_closable ? " closable" : "";
	$classes .= $with_icon ? " with-icon" : "";
	$classes .= !empty($el_class) ? " $el_class" : "";
	$icon_class = "msg_icon";
	$icon_class .= $with_custom_icon && !empty( $custom_icon ) ? " {$custom_icon}" : "";
	if ( !empty( $title ) || !empty( $content ) ){
		$out .= "<div id='$section_id' class='ingenious_msg_box ingenious_module $classes' style='$section_styles'>";
			if ( $with_icon ) {
				$out .= "<div class='icon_part'" . ( !empty( $icon_part_styles ) ? " style='$icon_part_styles'" : "" ) . ">";
					$out .= "<i class='$icon_class'></i>";
					$out .= ingenious_shape('circle',true);
				$out .= "</div>";
			}
			$out .= "<div class='content_part'>";
				$out .= !empty( $title ) ? "<div class='title'>$title</div>" : "";
				$out .= !empty( $content ) ? "<p>$content</p>" : "";
			$out .= "</div>";
			$out .= $is_closable ? "<a class='close_button'><span class='cross'></span></a>" : "";
		$out .= "</div>";
	}
	return $out;
}
add_shortcode( 'cws_sc_msg_box', 'ingenious_msg_box' );

add_shortcode( 'cws_sc_portfolio_posts_grid', 'ingenious_portfolio_posts_grid' );

add_shortcode( 'cws_sc_staff_posts_grid', 'ingenious_staff_posts_grid' );

function ingenious_sc_vc_blog ( $atts = array(), $content = "" ){
	$post_type = "post";
	$out = '';
	$def_blog_layout = ingenious_get_option( 'def_blog_layout' );
	$def_blog_layout = isset( $def_blog_layout ) ? $def_blog_layout : "";
	$def_chars_count = ingenious_get_option( 'def_blog_chars_count' );
	$def_chars_count = isset( $def_chars_count ) && is_numeric( $def_chars_count ) ? $def_chars_count : '200';
	$defaults = array(
		'title'						=> '',
		'title_align'				=> 'left',
		'total_items_count'			=> '',
		'layout'					=> $def_blog_layout,
		'post_hide_meta_override'	=> false,
		'post_hide_meta'			=> '',
		'chars_count'				=> $def_chars_count,
		'display_style'				=> 'grid',
		'items_pp'					=> esc_html( get_option( 'posts_per_page' ) ),
		'links_enable'				=> true,
		'en_hover_color'			=> false,
		'hover_color'				=> '',
		'single_img'				=> '',
		'el_class'					=> '',
		'image_align'				=> '',
	);
	$proc_atts = shortcode_atts( $defaults, $atts );
	extract( $proc_atts );
	$out = "";
	$tax = isset( $atts[$post_type . '_tax'] ) ? $atts[$post_type . '_tax'] : '';
	$terms = isset( $atts["{$post_type}_{$tax}_terms"] ) ? $atts["{$post_type}_{$tax}_terms"] : "";
	$proc_atts = array_merge( $proc_atts, array(
		'post_hide_meta_override'				=> $post_hide_meta_override,
		'post_hide_meta'						=> $post_hide_meta,
		'tax'									=> $tax,
		'terms'									=> $terms
	));
	$out .= function_exists( "ingenious_sc_blog" ) ? ingenious_sc_blog( $proc_atts ) : "";
	return $out;
}
add_shortcode( 'cws_sc_vc_blog', 'ingenious_sc_vc_blog' );
add_shortcode( 'cws_sc_blog', 'ingenious_sc_blog' );

function ingenious_sc_icon ( $atts = array(), $content = "" ){
	extract( shortcode_atts( array(
		"icon_lib"			=> "",
		"url"				=> "",
		"new_tab"			=> "",
		"title"				=> "",
		"icon_shape"		=> "circle",
		'cws_svg_icon'		=> '',
		"size"				=> "medium",
		"aligning"			=> "",
		"add_hover"			=> false,
		"row_icon"			=> false,
		"shape_shadow"		=> false,
		"custom_shape_color"=> false,
		"custom_color"		=> false,
		"custom_title_color"=> false,
		"custom_hover_color"=> false,
		"fill_color"		=> '#fff',
		"stroke_color"		=> INGENIOUS_THEME_COLOR,
		"font_color"		=> INGENIOUS_THEME_COLOR,
		"title_color"		=> INGENIOUS_THEME_COLOR,
		"hover_font_color"	=> '#fff',
		"hover_fill_color"	=> INGENIOUS_THEME_COLOR,
		"hover_stroke_color"=> '#fff',
		"el_class"			=> ""
	), $atts));
	$out = "";
	$icon_lib 			= esc_attr( $icon_lib );
	$icon 				= ingenious_vc_sc_get_icon( $atts );
	$icon 				= esc_attr( $icon );
	$url  				= esc_url( $url );
	$new_tab			= (bool)$new_tab;
	$shape_shadow		= (bool)$shape_shadow;
	$title 				= esc_html( $title );
	$size				= esc_html( $size );
	$aligning			= esc_html( $aligning );
	$row_icon			= (bool)$row_icon;
	$icon_shape			= esc_html( $icon_shape );
	$add_hover			= (bool)$add_hover;
	$custom_shape_color	= (bool)$custom_shape_color;
	$custom_hover_color	= (bool)$custom_hover_color;
	$custom_color		= (bool)$custom_color;
	$custom_title_color	= (bool)$custom_title_color;
	$fill_color			= esc_html( $fill_color );
	$stroke_color		= esc_html( $stroke_color );
	$font_color			= esc_html( $font_color );
	$title_color		= esc_html( $title_color );
	$hover_font_color	= esc_html( $hover_font_color );
	$hover_fill_color	= esc_html( $hover_fill_color );
	$hover_stroke_color	= esc_html( $hover_stroke_color );
	$el_class			= esc_attr( $el_class );
	$icon_id = uniqid( "ingenious_icon_" );
	ob_start();	
	if ($custom_shape_color) {
		echo "#$icon_id .icon_shape svg{
			fill: $fill_color;
			stroke: $stroke_color;
		}";
	}
	if ($custom_color) {
		echo "#$icon_id{
			color: $font_color;
		}";
		echo "#$icon_id i.svg{
			stroke: $font_color;
			fill: $font_color;
		}";
	}
	if ($custom_title_color) {
		echo "#$icon_id + .icon_title{
			color: $title_color;
		}";
	}	
	if ($custom_hover_color) {
		echo "#$icon_id.hovered:hover{
			color: $hover_font_color;
		}";
		echo "#$icon_id:hover i.svg{
			stroke: $hover_font_color;
			fill: $hover_font_color;
		}";
		echo "#$icon_id.hovered:hover .icon_shape svg{
			fill: $hover_fill_color;
			stroke: $hover_stroke_color;
		}";
	}
	$styles = ob_get_clean();
	$styles = json_encode($styles);
	$cws_svg_icon = str_replace('``', '"', $cws_svg_icon);
	$svg = json_decode($cws_svg_icon);
	$al_class = !empty( $aligning ) ? "icon-align-{$aligning}" : "";
	$wrapper_tag = "div";
	$wrapper_classes = "ingenious_icon_wrapper render_styles";
	$wrapper_classes .= $row_icon ? " row_icon" : '';
	$wrapper_classes .= !empty( $styles ) ? " $al_class" : "";
	$tag = !empty( $url ) ? "a" : "div";
	$wrapper_tag_atts = $wrapper_tag;
	$wrapper_tag_atts .= " data-style='".esc_attr($styles)."' class='$wrapper_classes'";
	$classes = "ingenious_icon $icon $size $icon_shape";
	$classes .= $add_hover ? " hovered" : "";
	$classes .= empty( $styles ) ? " $al_class" : "";
	$classes .= !empty( $el_class ) ? " $el_class" : "";
	$classes .= $icon_lib == 'cws_svg' ? " cws_svg" : "";
	$tag_atts = $tag == 'a' ? "$tag href='$url'" : $tag;
	$tag_atts .= " id='$icon_id'";
	$tag_atts .= " class='$classes'";
	$tag_atts .= !empty( $url ) && $new_tab ? " target='_blank'" : "";
	$tag_atts .= !empty( $title ) ? " title='$title'" : "";
	$shape = ingenious_shape($icon_shape,$shape_shadow);
	$out .= "<$wrapper_tag_atts>";
	$out .= $aligning == 'left' ? "<span class='icon_title'>".esc_html($title)."</span>" : '';
	$out .= "<$tag_atts>" . ( $icon_lib == 'cws_svg' ? cwssvg_shortcode($svg) : "") . $shape . "</$tag>";
	$out .= $aligning == 'right' || $aligning == 'center' ? "<span class='icon_title'>".esc_html($title)."</span>" : '';
	$out .= "</$wrapper_tag>";
	return $out;
}
add_shortcode( 'cws_sc_icon', 'ingenious_sc_icon' );

function ingenious_sc_button ( $atts = array(), $content = "" ){
	$font_options = ingenious_get_option( 'body_font' );
	extract( shortcode_atts( array(
		"title"					=> "",
		"url"					=> "",
		"new_tab"				=> "",
		"size"					=> "regular",
		"ofs"					=> "",
		"aligning"				=> "",
		"icon"					=> "",
		"icon_pos"				=> "right",
		"alt"					=> "",
		"but_style"				=> "",
		"alt_hex"				=> "",
		"anim_style"			=> "def_anim",
		"customize_colors"		=> false,
		"custom_color"			=> INGENIOUS_THEME_COLOR,
		"custom_color_bg"		=> '#fff',
		"custom_color_border"	=> INGENIOUS_THEME_COLOR,
		"custom_hover_color"	=> INGENIOUS_THEME_COLOR,
		"custom_hover_color_bg"	=> '#fff',
		"custom_hover_color_border"	=> INGENIOUS_THEME_COLOR,
		"el_class"				=> ""
	), $atts));	
	$out = "";
	$title 					= esc_html( $title );
	$url  					= esc_url( $url );
	$new_tab				= (bool)$new_tab;
	$size 					= esc_html( $size );
	$ofs 					= (int)$ofs;
	$aligning				= esc_html( $aligning );
	$but_style				= esc_html( $but_style );
	$alt_hex				= (bool)$alt_hex;
	$icon					= esc_html( $icon );
	$alt					= (bool)$alt;
	$customize_colors		= (bool)$customize_colors;
	$custom_color			= esc_attr( $custom_color );
	$custom_color_bg		= esc_attr( $custom_color_bg );
	$custom_color_border	= esc_attr( $custom_color_border );
	$custom_hover_color		= esc_attr( $custom_hover_color );
	$custom_hover_color_bg	= esc_attr( $custom_hover_color_bg );
	$custom_hover_color_border	= esc_attr( $custom_hover_color_border );
	$el_class				= esc_attr( $el_class );
	$button_id 				= uniqid( "ingenious_button_" );
	/* styles */
	ob_start();
	if ( $ofs > 0 ){
		echo "#$button_id{";
			echo "padding-left: {$ofs}px;";
			echo "padding-right: {$ofs}px;";
			echo "min-width: 0px;";
		echo "}";
	}
	if ( $customize_colors ){
		echo "#$button_id{
			color: $custom_color;
			background-color: $custom_color_bg;
			border-color: $custom_color_border;
		}";
		echo "#$button_id > i{
			color: $custom_color;
		}";	
		echo "#$button_id.ingenious_button.swipe_left:before,
			#$button_id.ingenious_button.swipe_right:before,
			#$button_id.ingenious_button.swipe_top:before,
			#$button_id.ingenious_button.swipe_bot:before,	
			#$button_id.ingenious_button.smoosh:before,		
			#$button_id.ingenious_button.smoosh:after,	
			#$button_id.ingenious_button.collision:before,		
			#$button_id.ingenious_button.collision:after,		
			#$button_id.ingenious_button.pos_aware span{";		
			echo "background-color: $custom_color_bg;";		
		echo "}";	
		echo "#$button_id.ingenious_button.swipe_diagonal:before{";		
			echo "border-bottom-color: $custom_color_border;";		
		echo "}";
		echo "#$button_id.ingenious_button.close_diagonal:before,
			#$button_id.ingenious_button.close_diagonal:after{";		
			echo "border-bottom-color: $custom_color_border;";		
			echo "border-top-color: $custom_color_border;";		
		echo "}";
		echo "#$button_id.ingenious_button.slice:before{";		
			echo "border-left-color: $custom_color_border;";			
		echo "}";
		echo "#$button_id.ingenious_button.slice:after{";				
			echo "border-right-color: $custom_color_border;";		
		echo "}";
		echo "#$button_id.ingenious_button.shadow{";		
			echo "box-shadow: 0 0 40px 40px $custom_color_bg inset, 0 0 0 0 $custom_color_bg;";	
		echo "}";
		echo "#$button_id.ingenious_button.shadow_alt{";		
			echo "box-shadow: 0 0 10px 0 $custom_color_bg inset, 0 0 10px 4px $custom_color_bg;";
		echo "}";
		echo "#$button_id:not(.none_anim):hover{
			color: $custom_hover_color;
			background-color: $custom_hover_color_bg;
			border-color: $custom_hover_color_border;	
		}";	
		echo "#$button_id:hover > i{
			color: $custom_hover_color;
		}";
		echo "#$button_id.ingenious_button.shadow:hover{";		
			echo "box-shadow: 0 0 10px 0 $custom_hover_color_bg inset, 0 0 10px 4px $custom_hover_color_bg;";
		echo "}";
		echo "#$button_id.ingenious_button.shadow_alt:hover{";		
			echo "box-shadow: 0 0 40px 40px $custom_hover_color_bg inset, 0 0 10px 4px $custom_hover_color_bg;";
		echo "}";
	}
	$styles = ob_get_clean();
	$styles = json_encode($styles);

	/* \styles */

	$al_class = !empty( $aligning ) ? " align{$aligning}" : "";
	$wrapper_tag = "div";
	$wrapper_classes = "ingenious_button_wrapper render_styles";
	$wrapper_classes .= !empty( $styles ) ? $al_class : "";
	$wrapper_tag_atts = $wrapper_tag;
	$wrapper_tag_atts .= !empty( $wrapper_classes ) ? " data-style='".esc_attr($styles)."' class='$wrapper_classes'" : "";

	$tag = "a";
	$tag_atts = !empty( $url ) ? "$tag href='$url'" : $tag;
	$tag_atts .= " id='$button_id'";
	$classes = "ingenious_button $size";
	$classes .= (empty($title) && !empty($icon)) ? " only_icon" : "";
	$classes .= $but_style == 'hex_style' ? " hex_style" : "";
	$classes .= $alt ? " alt" : "";
	$classes .= $alt_hex ? " alt_hex" : "";
	$classes .= empty( $styles ) ? $al_class : "";
	$classes .= !empty( $anim_style ) ? " $anim_style" : "";
	$classes .= !empty( $el_class ) ? " $el_class" : "";
	$tag_atts .= " class='$classes'";
	$tag_atts .= !empty( $url ) && $new_tab ? " target='_blank'" : "";

	$out .= !empty( $styles ) ? "<$wrapper_tag_atts>" : "";
		$out .= "<$tag_atts>";
			if ( !empty( $icon ) && $icon_pos == 'left' ){
				$out .= "<i class='$icon'></i>&#x20;";
			}
			$out .= $title;
			if ( !empty( $icon ) && $icon_pos == 'right' ){
				$out .= "&#x20;<i class='$icon'></i>";
			}
			if ( $but_style == 'hex_style' ) {
				$out .= ingenious_figure_style();
			}		
		$out .= "</$tag>";
	$out .= !empty( $styles ) ? "</$wrapper_tag>" : "";
	return $out;
}
add_shortcode( 'cws_sc_button', 'ingenious_sc_button' );

function ingenious_sc_dropcap ( $atts = array(), $content = "" ){
	// return "<span class='dropcap'>$content</span>";
	extract( shortcode_atts( array(
		'dropcap_style' => '',
		'dropcap_border' => '',
		'dropcap_fill' => ''
	), $atts));

	$out = "<span class='dropcap $dropcap_style".(!empty($dropcap_border) ? ' dropcap_border' : '').(!empty($dropcap_fill) ? ' dropcap_fill' : '')."'>$content</span>";
	return $out;
}
add_shortcode( 'cws_sc_dropcap', 'ingenious_sc_dropcap' );

function ingenious_sc_mark ( $atts = array(), $content = "" ){
	extract( shortcode_atts( array(
		'font_color'	=> '#fff',
		'bg_color'		=> INGENIOUS_THEME_COLOR
	), $atts));
	return "<mark style='color: $font_color;background-color: $bg_color;'>$content</mark>";
}
add_shortcode( 'cws_sc_mark', 'ingenious_sc_mark' );

function ingenious_sc_embed ( $atts, $content ) {
	extract( shortcode_atts( array(
		'url' => '',
		'width' => '',
		'height' => ''
	), $atts));
	$url = esc_url( $url );
	return !empty( $url ) ? apply_filters( "the_content", "[embed" . ( !empty( $width ) && is_numeric( $width ) ? " width='$width'" : "" ) . ( !empty( $height ) && is_numeric( $height ) ? " height='$height'" : "" ) . "]" . $url . "[/embed]" ) : "";
}
add_shortcode( 'cws_sc_embed', 'ingenious_sc_embed' );

function ingenious_sc_banner ( $atts = array(), $content = "" ){
	extract( shortcode_atts( array(
		"title"				=> "",
		"offer"				=> "",
		"descr"				=> "",
		"banner_type"		=> "style_1",
		"half_overlay"		=> "left_overlay",
		"bg_overlay_color"	=> INGENIOUS_THEME_COLOR,
		"add_button"		=> false,
		"button_text"		=> "",
		"button_url"		=> "",
		"button_new_tab"	=> false,
		"button_alt"		=> false,
		"button_colors"				=> false,
		"button_font_color"			=> INGENIOUS_THEME_COLOR,
		"button_bg_color"			=> "#fff",
		"button_border_color"		=> INGENIOUS_THEME_COLOR,
		"button_hover_colors"		=> false,
		"button_hover_font_color"	=> INGENIOUS_THEME_COLOR,
		"button_hover_bg_color"		=> "#fff",
		"button_hover_border_color"	=> INGENIOUS_THEME_COLOR,
		"text_pos"			=> "a-left top",
		"bg_img"			=> "",
		"bg_color"			=> "transparent",
		"el_class"			=> ""
	), $atts));
	$out = "";
	$title				= $title;
	$offer 				= $offer;
	$descr				= $descr;
	$banner_type		= esc_html( $banner_type );
	$half_overlay		= esc_html( $half_overlay );
	$bg_overlay_color	= esc_html( $bg_overlay_color );
	$add_button			= (bool)$add_button;
	$button_text		= esc_html( $button_text );
	$button_url			= esc_html( $button_url );
	$button_new_tab		= (bool)$button_new_tab;
	$button_alt			= (bool)$button_alt;
	$button_colors		= (bool)$button_colors;
	$button_font_color	= esc_html( $button_font_color );
	$button_bg_color	= esc_html( $button_bg_color );
	$button_border_color= esc_html( $button_border_color );
	$button_hover_colors		= (bool)$button_hover_colors;
	$button_hover_font_color	= esc_html( $button_hover_font_color );
	$button_hover_bg_color	= esc_html( $button_hover_bg_color );
	$button_hover_border_color= esc_html( $button_hover_border_color );
	$bg_color			= esc_html( $bg_color );
	$text_pos			= esc_html( $text_pos );
	$bg_img				= esc_html( $bg_img );
	$el_class			= esc_attr( $el_class );
	$banner_id 			= uniqid( "banner_id_" );
	if ( empty( $title ) && empty( $offer ) ){
		return $out;
	}
	$classes = "";
	$classes .= !empty( $el_class ) ? " $el_class" : "";
	$classes .= " $banner_type";
	$classes .= " $half_overlay";
	$thumbnail  = wp_get_attachment_url( $bg_img );
	$button_atts = array(
		'title'				=> $button_text,
		'url'				=> $button_url,
		'new_tab'			=> $button_new_tab,
		'size'				=> 'small',
		'alt'				=> $button_alt,
		'customize_colors'	=> $button_colors,
		'custom_color'		=> $button_font_color,
		'custom_color_bg'	=> $button_bg_color,
		'custom_color_border'=> $button_border_color,
		'customize_hover_colors'=> $button_hover_colors,
		'custom_hover_color'		=> $button_hover_font_color,
		'custom_hover_color_bg'	=> $button_hover_bg_color,
		'custom_hover_color_border'=> $button_hover_border_color,
	);
	// $section_id = uniqid( 'ingenious_services_column_' );
	$button = $add_button ? ingenious_sc_button( $button_atts ) : "";
	/* section styles */
	ob_start();
	echo "#$banner_id .banner_wrapper:before{
		background: $bg_color;
	}";
	if ($banner_type == 'style_2' || $banner_type == 'style_3') {
		echo "#$banner_id .banner_wrapper:after{
			background: $bg_overlay_color;
		}";
		echo "#$banner_id.style_2:before,
			#$banner_id.style_3:before{
			background: $bg_overlay_color;
		}";
	}
	$styles = ob_get_clean();
	$styles = json_encode($styles);
	/* \section styles */
	$out .= "<div id='$banner_id' class='ingenious_banner $classes render_styles' data-style='".esc_attr($styles)."'>";
		$out .= "<div class='banner_wrapper' style='background:url($thumbnail)'>";
			$out .= "<div class='banner_table $text_pos'>";
				$out .= "<div class='banner_cell'>";
					$out .= !empty( $title ) ? "<h3 class='banner_title'>$title</h3>" : "";
					$out .= !empty( $offer ) ? "<div class='banner_offer'>$offer</div>" : "";
					$out .= !empty( $descr ) ? "<div class='banner_descr'>$descr</div>" : "";
					$out .= $add_button ? $button : '';
				$out .= "</div>";
			$out .= "</div>";
		$out .= "</div>";
	$out .= "</div>";
	return $out;
}
add_shortcode( 'cws_sc_banner', 'ingenious_sc_banner' );

function ingenious_sc_call_to_action ( $atts = array(), $content = "" ){
	extract( shortcode_atts( array(
		"type"				=> "style_1",
		"text_align"		=> "left",
		"offer"				=> "",
		"call_anim"			=> false,
		"offer_descr"		=> "",
		"customize_offer_color"	=> false,
		"font_offer_color"	=> "#fff",
		"half_overlay"		=> "left_overlay",
		"overlay_bg"		=> "color",
		"overlay_color"		=> INGENIOUS_THEME_COLOR,
		"overlay_gradient_from"	=> INGENIOUS_THEME_COLOR,
		"overlay_gradient_to"	=> INGENIOUS_THEME_COLOR,
		"overlay_gradient_angle"=> '180',
		"customize_color"	=> false,
		"font_color"		=> '#fff',
		"color_over_img"	=> false,
		"bg_color"			=> INGENIOUS_THEME_COLOR,
		"use_bg_img"		=> false,
		"bg_img"			=> "",
		"bg_size"			=> "auto",
		"bg_repeat"			=> "repeat",
		"bg_pos"			=> "left top",
		"paddings"			=> "",
		'add_button'		=> '',
		'button_text'		=> '',
		'button_url'		=> '',
		'button_new_tab'	=> '',
		'button_alt'		=> false,
		'button_size'		=> 'small',
		'button_colors'		=> false,
		'button_font_color'	=> INGENIOUS_THEME_COLOR,
		'button_bg_color'	=> '#fff',
		'button_border_color'	=> INGENIOUS_THEME_COLOR,
		'button_hover_font_color'	=> INGENIOUS_THEME_COLOR,
		'button_hover_bg_color'		=> '#fff',
		'button_hover_border_color'	=> INGENIOUS_THEME_COLOR,
		"el_class"			=> ""
	), $atts));
	$out = "";
	$type				= esc_html( $type );
	$offer				= esc_html( $offer );
	$call_anim			= (bool)$call_anim;
	$offer_descr		= esc_html( $offer_descr );
	$customize_offer_color 	= (bool)$customize_offer_color;
	$font_offer_color	= esc_html( $font_offer_color );
	$half_overlay		= esc_html( $half_overlay );
	$overlay_bg			= esc_html( $overlay_bg );
	$overlay_color		= esc_html( $overlay_color );
	$overlay_gradient_from	= esc_html( $overlay_gradient_from );
	$overlay_gradient_to	= esc_html( $overlay_gradient_to );
	$overlay_gradient_angle	= esc_html( $overlay_gradient_angle );
	$content			= apply_filters( 'the_content', $content );
	$color_over_img 	= (bool)$color_over_img;
	$customize_color	= (bool)$customize_color;
	$bg_color			= esc_html( $bg_color );
	$font_color			= esc_html( $font_color );
	$text_align			= esc_html( $text_align );
	$use_bg_img			= (bool)$use_bg_img;
	$bg_img				= esc_html( $bg_img );
	$bg_size			= esc_html( $bg_size );
	$bg_repeat			= esc_html( $bg_repeat );
	$bg_pos				= esc_html( $bg_pos );
	$paddings			= esc_html( $paddings );
 	$add_button 		= (bool)$add_button;
	$button_text		= esc_html( $button_text );
	$button_url			= esc_html( $button_url );
	$button_new_tab 	= (bool)$button_new_tab;
	$button_alt			= (bool)$button_alt;
	$button_size		= esc_html( $button_size );
	$button_colors		= (bool)$button_colors;
	$button_font_color	= esc_html( $button_font_color );
	$button_bg_color	= esc_html( $button_bg_color );
	$button_border_color= esc_html( $button_border_color );
	$button_hover_font_color	= esc_html( $button_hover_font_color );
	$button_hover_bg_color		= esc_html( $button_hover_bg_color );
	$button_hover_border_color	= esc_html( $button_hover_border_color );
	$el_class			= esc_attr( $el_class );
	$cta_id 			= uniqid( "cta_id_" );
	$classes = "ingenious_cta ingenious_module";
	$classes .= !empty( $type ) ? " $type" : "";
	$classes .= !empty( $el_class ) ? " $el_class" : "";
	$classes .= !empty( $text_align ) ? " a-".$text_align : "";
	$classes .= ( $type !== 'style_1' ) ? ' '.$half_overlay : "";
	$classes .= ( $type == 'style_2' && $add_button ) ? ' button_'.$button_size : "";
	$classes .= $call_anim ? ' cta_anim' : '';
	$thumbnail  = wp_get_attachment_url( $bg_img );
	$button_atts = array(
		'title'		=> $button_text,
		'url'		=> $button_url,
		'new_tab'	=> $button_new_tab,
		'alt'		=> $button_alt,
		'size'		=> $button_size,
		'customize_colors'	=> $button_colors,
		'custom_color'		=> $button_font_color,
		'custom_color_bg'	=> $button_bg_color,
		'custom_color_border'=> $button_border_color,
		'custom_hover_color'	=> $button_hover_font_color,
		'custom_hover_color_bg'	=> $button_hover_bg_color,
		'custom_hover_color_border'=> $button_hover_border_color,
	);

	/* section styles */
	ob_start();
	if ($color_over_img) {
		echo "#$cta_id .cta_wrapper:before{
			background: $bg_color;
		}";
	}
	if ($overlay_bg == 'color') {
		echo "#$cta_id .cta_overlay{
			background: $overlay_color;
		}";
	}
	if ($overlay_bg == 'gradient') {
		echo "#$cta_id .cta_overlay{
			background:linear-gradient(" . $overlay_gradient_angle . "deg, $overlay_gradient_from, $overlay_gradient_to);
		}";
	}
	$styles = ob_get_clean();
	$styles = json_encode($styles);
	/* \section styles */
	ob_start();
	if ( $use_bg_img && !empty( $bg_img ) ){
		$thumbnail  = wp_get_attachment_url( $bg_img );
		echo "background-image: url($thumbnail);"; 
		echo "background-size: $bg_size;"; 
		echo "background-repeat: $bg_repeat;"; 
		echo "background-position: $bg_pos;"; 
	}
	$img_layer_styles = ob_get_clean();
	$offer_color = !empty($customize_offer_color) ? "style='color:$font_offer_color'" : "";
	$button = $add_button ? ingenious_sc_button( $button_atts ) : "";
	$out .= "<div id='$cta_id' class='$classes render_styles' data-style='".esc_attr($styles)."'>";
		$out .= "<div class='cta_wrapper' " . (!empty($img_layer_styles) ? "style='$img_layer_styles'" : '') . ">";
			$out .= ($overlay_bg !== 'none') ? "<div class='cta_overlay'></div>" : "";
			$out .= "<div class='cta_content'>";
				$out .= "<div class='cta_description'>$content</div>";
				$out .= ($type == 'style_1') ? $button : ""; 
			$out .= "</div>";
			$out .= ($type == 'style_2') ? $button : "";
			if ($type == 'style_3') {
				$out .= "<div class='cta_offer_wrap' $offer_color>";
					$out .= !empty($offer) ? "<div class='cta_offer'>$offer</div>" : "";
					$out .= !empty($offer_descr) ? "<div class='cta_offer_descr'>$offer_descr</div>" : "";
					$out .= $button;
				$out .= "</div>";
			}
		$out .= "</div>";
	$out .= "</div>";
	return $out;
}
add_shortcode( 'cws_sc_call_to_action', 'ingenious_sc_call_to_action' );

function ingenious_sc_progress_bar ( $atts = array(), $content = "" ){
	extract( shortcode_atts( array(
		'title'				=> '',
		'progress'			=> '',
		'use_custom_color'	=> '',
		'custom_fill_color'	=> '',
		'custom_title_color'=> '',
		'el_class'			=> ''
	), $atts));
	$title 				= esc_html( $title );
	$progress 			= esc_html( $progress );
	$use_custom_color 	= (bool)$use_custom_color;
	$custom_fill_color 	= esc_attr( $custom_fill_color );
	$custom_title_color = esc_attr( $custom_title_color );
	$el_class			= esc_attr( $el_class );
	$out = "";
	if ( empty( $progress ) || !is_numeric( $progress ) ) return $out;
	$out .= "<div class='ingenious_pb ingenious_module" . ( !empty( $el_class ) ? " $el_class" : "" ) . "'>";
		$out .= !empty( $title ) ? "<p class='ingenious_pb_title' " . ( $use_custom_color && !empty( $custom_title_color ) ? "style='color: $custom_title_color;'" : "" ) . ">$title</p>" : "";
		$out .= "<span class='indicator'></span>";
		$out .= "<div class='ingenious_pb_bar'>";
			$out .= "<div class='ingenious_pb_progress' data-value='$progress' style='width:0%;" . ( $use_custom_color && !empty( $custom_fill_color ) ? "background-color: $custom_fill_color;" : "" ) . "'>";
			$out .= "</div>";
		$out .= "</div>";
	$out .= "</div>";
	return $out;
}
add_shortcode( 'cws_sc_progress_bar', 'ingenious_sc_progress_bar' );

function ingenious_sc_milestone ( $atts = array(), $content = "" ){
	extract( shortcode_atts( array(
		'add_icon'					=> false,
		'custom_icon_color'			=> false,
		'icon_color'				=> '#363636',
		'icon_lib'					=> '',
		'cws_svg_icon'				=> '',
		'shape'						=> 'circle',
		'shape_shadow'				=> true,
		'without_stroke'			=> false,
		'custom_shape_color'		=> false,
		'number'					=> '',
		'use_custom_number_color'	=> '',
		'custom_number_color'		=> INGENIOUS_THEME_COLOR,
		'fill_color'				=> '#fff',
		'stroke_color'				=> 'transparent',
		'title'						=> '',
		'speed'						=> '',
		'use_custom_title'			=> '',
		'custom_title_color'		=> INGENIOUS_THEME_COLOR,
		'el_class'					=> ''
	), $atts));
	$add_icon					= (bool)$add_icon;
	$custom_icon_color			= (bool)$custom_icon_color;
	$icon 						= ingenious_vc_sc_get_icon( $atts );
	$icon_color					= esc_html( $icon_color );
	$shape						= esc_html( $shape );
	$shape_shadow				= (bool)$shape_shadow;
	$without_stroke				= (bool)$without_stroke;
	$custom_shape_color			= (bool)$custom_shape_color;
	$number						= esc_html( $number );
	$use_custom_number_color 	= (bool)$use_custom_number_color;
	$custom_number_color 		= esc_attr( $custom_number_color );
	$title 						= esc_html( $title );
	$fill_color					= esc_html( $fill_color );
	$stroke_color				= esc_html( $stroke_color );
	$speed						= esc_html( $speed );
	$use_custom_title 			= (bool)$use_custom_title;
	$custom_title_color 		= esc_attr( $custom_title_color );
	$el_class					= esc_attr( $el_class );
	$out = "";
	$classes = '';
	$icon_out = '';
	$section_id = uniqid( 'ingenious_milestone_' );
	$cws_svg_icon = !empty($cws_svg_icon) ? $cws_svg_icon : '';
	$cws_svg_icon = str_replace('``', '"', $cws_svg_icon);
	$svg = json_decode($cws_svg_icon);
	if ( $icon_lib !== 'cws_svg') {
		$icon_out .= !empty( $icon ) ? "<div class='ingenious_milestone_icon'><i class='$icon'></i></div>" : "";
	} else {
		if (function_exists('cwssvg_shortcode')) {
			$icon_out .= !empty( $cws_svg_icon ) ? "<div class='ingenious_milestone_icon'>" . cwssvg_shortcode($svg) . "</div>" : "";
		}
	}
	if ( empty( $number ) || !is_numeric( $number ) ) return $out;
	wp_enqueue_script('odometer', INGENIOUS_THEME_URI . '/js/odometer.min.js', '', true);
	wp_enqueue_style('odometer', INGENIOUS_THEME_URI . '/css/odometer-theme-default.css', '', true);
	/* styles */
	ob_start();
	if ( $custom_shape_color ){
		echo "#$section_id .ingenious_milestone_shape svg{
				fill: $fill_color;
				stroke: $stroke_color;
			}";
	}
	if ( $custom_icon_color ){
		echo "#$section_id .ingenious_milestone_icon{
				color: $icon_color;
			}";
		echo "#$section_id .ingenious_milestone_icon svg{
				fill: $icon_color;
			}";
	}
	/* \styles */
	$styles = ob_get_clean();
	$styles = json_encode($styles);
	$number = "<div class='ingenious_milestone_number'" . ( !empty( $speed ) && is_numeric( $speed ) ? " data-speed='$speed'" : "" ) . " " . ( $use_custom_number_color && !empty( $custom_number_color ) ? "style=' color: $custom_number_color;'" : "" ) . ">$number</div>";
	$classes .= $without_stroke ? " without_stroke " : "";
	$out .= "<div id='$section_id' data-style='".esc_attr($styles)."' class='ingenious_milestone ingenious_module render_styles $shape $classes" . ( !empty( $el_class ) ? " $el_class" : "" ) . "'>";
		$out .= "<div class='ingenious_milestone_content'>";
			$out .= "<div class='ingenious_milestone_shape'>" . ingenious_shape($shape,$shape_shadow) . "</div>";
			if ($add_icon && !empty($icon_out)) {
				$out .= $icon_out;
			} else {
				$out .= $number;
			}
		$out .= "</div>";
		if ($add_icon && !empty($icon_out)) {
				$out .= $number;
			}	
		$out .= !empty( $title ) ? "<h6 class='ingenious_milestone_title' " . ($use_custom_title ? " style=' color: $custom_title_color;'" : "") . ">$title</h6>" : "";
	$out .= "</div>";
	return $out;
}
add_shortcode( 'cws_sc_milestone', 'ingenious_sc_milestone' );

function ingenious_sc_services ( $atts = array(), $content = "" ){
	extract( shortcode_atts( array(
		'title'						=> '',
		'icon_lib'					=> '',
		'cws_svg_icon'				=> '',
		'add_button'				=> '',
		'icon_space'				=> '',
		'icon_space_top'			=> '',
		'button_text'				=> '',
		'button_url'				=> '',
		'button_new_tab'			=> '',
		'button_size'				=> 'regular',
		'icon_shape'				=> 'circle',
		'icon_pos'					=> 'icon_center',
		'icon_size'					=> 'small',
		'button_icon'				=> '',
		'button_alt'				=> false,
		'button_customize_colors'	=> false,
		'shape_shadow'				=> true,
		'without_stroke'			=> false,
		'custom_icon_color'			=> false,
		'title_top_padding'			=> '',
		'custom_title_color'		=> false,
		'custom_shape_color'		=> false,
		'font_color'				=> '#000',
		'title_color'				=> '#000',
		'fill_color'				=> '#ffffff',
		'stroke_color'				=> INGENIOUS_THEME_COLOR,
		'buttom_custom_color'		=> '#fff',
		'button_custom_color_bg'	=> INGENIOUS_THEME_COLOR,
		'button_custom_color_border'=> INGENIOUS_THEME_COLOR,
		'button_custom_color_hover'			=> '#fff',
		'button_custom_color_bg_hover'		=> INGENIOUS_THEME_COLOR,
		'button_custom_color_border_hover'	=> INGENIOUS_THEME_COLOR,
		'el_class'					=> ''
	), $atts));
	$title 						= esc_html( $title );
	$icon_space 				= esc_html( $icon_space );
	$icon_space_top 			= esc_html( $icon_space_top );
	$icon_lib 					= esc_attr( $icon_lib );
	$icon 						= ingenious_vc_sc_get_icon( $atts );
	$icon 						= esc_attr( $icon );
	$desc 						= apply_filters( 'the_content', $content );
	$icon_pos 					= esc_html( $icon_pos );
	$icon_size 					= esc_html( $icon_size );
	$icon_shape 				= esc_html( $icon_shape );
	$add_button 				= (bool)$add_button;
	$shape_shadow 				= (bool)$shape_shadow;
	$without_stroke 			= (bool)$without_stroke;
	$custom_icon_color 			= (bool)$custom_icon_color;
	$title_top_padding 			= esc_attr( $title_top_padding );
	$custom_title_color 		= (bool)$custom_title_color;
	$custom_shape_color 		= (bool)$custom_shape_color;
	$font_color 				= esc_attr( $font_color );
	$title_color 				= esc_attr( $title_color );
	$fill_color 				= esc_attr( $fill_color );
	$stroke_color 				= esc_attr( $stroke_color );
	$el_class					= esc_attr( $el_class );
	$out = "";
	if ( function_exists( 'vc_icon_element_fonts_enqueue' ) ){
		vc_icon_element_fonts_enqueue( $icon_lib );		
	}
	$button_atts = array(
		'title'				=> $button_text,
		'icon'				=> $button_icon,
		'url'				=> $button_url,
		'new_tab'			=> $button_new_tab,
		'size'				=> $button_size,
		'alt'				=> $button_alt,
		'customize_colors'	=> $button_customize_colors,
		'custom_color'		=> $buttom_custom_color,
		'custom_color_bg'	=> $button_custom_color_bg,
		'custom_color_border'=> $button_custom_color_border,
		'custom_hover_color'		=> $button_custom_color_hover,
		'custom_hover_color_bg'		=> $button_custom_color_bg_hover,
		'custom_hover_color_border'	=> $button_custom_color_border_hover,
	);
	$section_id = uniqid( 'ingenious_services_column_' );
	$button = $add_button ? ingenious_sc_button( $button_atts ) : "";
	$title_part = $desc_part = "";
	$shape = ingenious_shape($icon_shape,$shape_shadow);
	$cws_svg_icon = !empty($cws_svg_icon) ? $cws_svg_icon : '';
	$cws_svg_icon = str_replace('``', '"', $cws_svg_icon);
	$svg = json_decode($cws_svg_icon);
	if ( $icon_lib !== 'cws_svg') {
		$title_part .= !empty( $icon ) ? "<div class='ingenious_services_icon'><div class='icon $icon'>" . $shape . "</div></div>" : "";
	} else {
		$icon_space = $icon_space != '' ? "padding:" . $icon_space . "px;" : "";
		$icon_space_top = $icon_space_top != '' ? "padding-top:" . $icon_space_top . "px;" : "";
		if (function_exists('cwssvg_shortcode')) {
			if (empty($button_url)){
				$title_part .= !empty( $cws_svg_icon ) ? "<div class='ingenious_services_icon' style='$icon_space $icon_space_top'><div class='icon'>" . cwssvg_shortcode($svg) . $shape ."</div></div>" : "";
			} else {
				$title_part .= !empty( $cws_svg_icon ) ? "<div class='ingenious_services_icon' style='$icon_space $icon_space_top'><div class='icon'><a href='".$button_url."'>" . cwssvg_shortcode($svg) . $shape ."</a></div></div>" : "";
			}
		}
	}
	$title_part .= !empty( $title ) ? "<h3 class='ingenious_services_title'>$title</h3>" : "";
	$desc_part .= !empty( $desc ) ? "<div class='ingenious_services_desc clearfix'>$desc</div>" : "";
	/* styles */
	ob_start();

	if (!empty($title_top_padding)){
		echo "#".esc_attr($section_id)." .ingenious_services_title{
			padding-top: ".esc_attr($title_top_padding)."px;
		}";
	}

	if ( $custom_icon_color ){
		echo "#$section_id .ingenious_services_icon .icon{
				color: $font_color;
			}
			#$section_id .ingenious_services_icon .icon > i > svg,
			#$section_id .ingenious_services_icon .icon > a > i > svg{
				fill: $font_color;
			}";
	}

	if ($icon_lib == 'cws_svg'){
		echo "#$section_id .ingenious_services_icon .icon > i > svg,
		#$section_id .ingenious_services_icon .icon > a > i > svg
		{
			width: ".esc_attr($svg->width)."px;
			height: ".esc_attr($svg->height)."px;
		}";		
	}

	if ( $custom_title_color ){
		echo "#$section_id .ingenious_services_title{
				color: $title_color;
			}";
	}
	if ( $custom_shape_color ) {
		echo "#$section_id .ingenious_services_icon .icon_shape > svg{
				fill: $fill_color;
				stroke: $stroke_color;
			}";	
	}
	/* \styles */
	$classes = '';
	$classes .= $icon_size . " " . $icon_pos . " " . $icon_shape;
	$classes .= $icon_lib == 'cws_svg' ? " cws_svg_icon " : "";
	$classes .= $without_stroke ? " without_stroke " : "";
	$styles = ob_get_clean();
	$styles = json_encode($styles);
	$out .= "<div id='$section_id' data-style='".esc_attr($styles)."' class='ingenious_services_column ingenious_module render_styles " . $classes . ( !empty( $button ) ? " ingenious_flex_column_sb" : "" ) . ( !empty( $el_class ) ? " $el_class" : "" ) . "'>";
		$out .= "<div class='ingenious_services_data'>";
			$out .= $title_part;
			$out .= $desc_part;
		$out .= "</div>";
		$out .= !empty( $button ) ? "<div class='ingenious_services_button'>$button</div>" : "";
	$out .= "</div>";
	return $out;
}
add_shortcode( 'cws_sc_services', 'ingenious_sc_services' );

function ingenious_sc_vc_testimonial ( $atts = array(), $content = "" ){
	$atts['thumbnail'] = isset( $atts['thumbnail'] ) && !empty( $atts['thumbnail'] ) ? $atts['thumbnail'] : "";
	return ingenious_testimonial_renderer( $atts, $content );
}
add_shortcode( 'cws_sc_vc_testimonial', 'ingenious_sc_vc_testimonial' );
function ingenious_sc_testimonial ( $atts = array(), $content = "" ){
	if ( !empty( $atts['thumbnail'] ) ){
		$thumbnail_data = json_decode( $atts['thumbnail'], true );
		$atts['thumbnail'] = ( isset( $thumbnail_data['@'] ) && isset( $thumbnail_data['@']['src'] ) ) ? $thumbnail_data['@']['src'] : "";
	}
	return function_exists( 'ingenious_testimonial_renderer' ) ? ingenious_testimonial_renderer( $atts, $content ) : '';
}
add_shortcode( 'cws_sc_testimonial', 'ingenious_sc_testimonial' );

function ingenious_sc_pricing_plan ( $atts = array(), $content = "" ){
	extract( shortcode_atts( array(
		'icon_lib'			=> '',
		'cws_svg_icon'		=> '',
		'icon_shape'		=> 'circle',
		'title'				=> '',
		'currency'			=> '',
		'price'				=> '29.00',
		'price_desc'		=> '',
		'add_button'		=> '',
		'button_text'		=> '',
		'button_url'		=> '',
		'button_new_tab'	=> '',
		'button_fw'			=> '',
		'highlighted'		=> '',
		'use_custom_color'	=> '',
		'custom_color'		=> INGENIOUS_THEME_COLOR,
		'el_class'			=> ''
 	), $atts));
 	$icon_lib 			= esc_attr( $icon_lib );
	$icon 				= ingenious_vc_sc_get_icon( $atts );
	$icon 				= esc_attr( $icon );
 	$icon_shape 		= esc_html( $icon_shape );
 	$title 				= esc_html( $title );
 	$currency 			= esc_html( $currency );
 	$price 				= esc_html( $price );
 	$price_desc 		= esc_html( $price_desc );
 	$add_button 		= (bool)$add_button;
 	$highlighted		= (bool)$highlighted;
 	$use_custom_color 	= (bool)$use_custom_color;
 	$custom_color 		= esc_attr( $custom_color );
 	$el_class			= esc_attr( $el_class );
 	$out = "";
 	$price_icon = '';
	$section_id = uniqid( 'ingenious_pricing_plan_' );
	if ( function_exists( 'vc_icon_element_fonts_enqueue' ) ){
		vc_icon_element_fonts_enqueue( $icon_lib );		
	}
	$shape = ingenious_shape($icon_shape, false);
	$cws_svg_icon = !empty($cws_svg_icon) ? $cws_svg_icon : '';
	$cws_svg_icon = str_replace('``', '"', $cws_svg_icon);
	$svg = json_decode($cws_svg_icon);
	if ( $icon_lib !== 'cws_svg') {
		$price_icon .= !empty( $icon ) ? "<div class='pricing_plan_icon'><div class='icon $icon'>" . $shape . "</div></div>" : "";
	} else if (function_exists('cwssvg_shortcode')) {
		$price_icon .= !empty( $cws_svg_icon ) ? "<div class='pricing_plan_icon'><div class='icon'>" . cwssvg_shortcode($svg) . $shape ."</div></div>" : "";
	}
 	ob_start();
 	if ( !empty( $price ) ){
		preg_match( "/(\.| |,)(\d+)$/", $price, $matches );	
 		echo "<div class='pricing_plan_price'>";
 			echo "<div class='pricing_plan_price_wrap'>";
	 			echo !empty( $currency ) ? "<span class='currency'>$currency</span>" : "";
	 			echo "<span class='main_price_part'>$price</span>";
	 			echo !empty( $price_desc ) ? "<span class='price_desc'>$price_desc</span>" : "";
	 		echo "</div>";	
 		echo "</div>";
 	}
 	echo !empty( $title ) ? "<h3 class='pricing_plan_title'>$title</h3>" : "";
	echo !empty( $price_icon ) ? $price_icon : '';
 	$plan = ob_get_clean();
	$button_atts = array(
		'title'		=> $button_text,
		'url'		=> $button_url,
		'new_tab'	=> $button_new_tab,
		'size'		=> 'regular',
		'alt'		=> true,
		'fw'		=> $button_fw
	);
	if ( $use_custom_color ){
		// $button_atts['customize_colors'] = true;
		// $button_atts['custom_color'] = $custom_color;
	}
	$button = $add_button ? ingenious_sc_button( $button_atts ) : "";
	$styles = '';
	/* styles */
	if ($use_custom_color) {
		$styles = "#$section_id .pricing_plan_content ul li:before,
		#$section_id .pricing_plan_price{
			color: $custom_color;
		}
		#$section_id .pricing_plan_button a{
			color: $custom_color;
			background-color: transparent;
			border-color: $custom_color;
		}
		#$section_id .pricing_plan_button a:hover{
			color: #ffffff;
			background-color: $custom_color;
			border-color: $custom_color;
		}
		#$section_id .pricing_plan_button a.alt{
			color: #ffffff;
			background-color: $custom_color;
			border-color: $custom_color;
		}
		#$section_id .pricing_plan_button a.alt:hover{
			color: $custom_color;
			background-color: transparent;
			border-color: $custom_color;
		}"
		;
	}
	
	$styles = json_encode($styles);
	/* \styles */
	$content = apply_filters( 'the_content', $content );
	$section_class = "ingenious_pricing_plan ingenious_module render_styles $icon_shape";
	$section_class .= !empty( $plan ) && !empty( $button ) ? " ingenious_flex_column_sb" : "";
	$section_class .= $highlighted ? " highlighted" : "";
	$section_class .= !empty( $el_class ) ? " $el_class" : "";
	$out .= "<div id='$section_id' data-style='".esc_attr($styles)."' class='$section_class'>";
		$out .= !empty( $plan ) ? "<div class='pricing_plan'>$plan</div>" : "";
		$out .= !empty( $content ) ? "<div class='pricing_plan_content'>$content</div>" : "";
		$out .= !empty( $button ) ? "<div class='pricing_plan_button'>$button</div>" : "";
	$out .= "</div>";
	return $out;
}
add_shortcode( 'cws_sc_pricing_plan', 'ingenious_sc_pricing_plan' );

function ingenious_sc_processes ( $atts = array(), $content = "" ){
	extract( shortcode_atts( array(
		"title"				=> "",
		"columns"			=> 'col_3',
		"processes_type"	=> 'horizontal',
	), $atts));
	$title 				= esc_html( $title );
	$columns 			= esc_html( $columns );
	$out = "";
	ob_start();
	if (!empty($title)) {
		echo "<h3>$title</h3>";
	}
	echo "<div class='cws_sc_processes_wrap $columns $processes_type'>" . do_shortcode( $content ) . "</div>";
	$out = ob_get_clean();
	return $out;
}
add_shortcode( 'cws_sc_processes', 'ingenious_sc_processes' );

function ingenious_sc_process ( $atts = array(), $content = "" ){
	extract( shortcode_atts( array(
		'title'						=> '',
		'icon_lib'					=> '',
		'cws_svg_icon'				=> '',
		'use_custom_color'			=> false,
		'custom_color'				=> '#363636',
		'active'					=> '',
		'use_custom_active_color'	=> false,
		'custom_active_color'		=> INGENIOUS_THEME_COLOR,
		'title'						=> '',
		'descr'						=> '',
	), $atts));
	$icon_lib 					= esc_attr( $icon_lib );
	$icon 						= ingenious_vc_sc_get_icon( $atts );
	$icon 						= esc_attr( $icon );
	$use_custom_color 			= (bool)$use_custom_color;
	$custom_color 				= esc_html( $custom_color );
	$active 					= (bool)$active;
	$use_custom_active_color 	= (bool)$use_custom_active_color;
	$custom_active_color 		= esc_html( $custom_active_color );
	$title 						= esc_html( $title );
	$descr 						= esc_html( $descr );

	$section_id = uniqid( 'ingenious_process_' );
	$cws_svg_icon = str_replace('``', '"', $cws_svg_icon);
	$svg = json_decode($cws_svg_icon);
	/* styles */
	ob_start();
	if ($use_custom_color && !empty($custom_color)) {
		echo "#{$section_id}.ingenious_process_column,
			#{$section_id} .process_icon,
			#{$section_id} .process_line_circle:before{
					color: $custom_color;
				}";
		echo "#{$section_id} .process_line,
			#{$section_id} .process_line_circle{
					background: $custom_color;
				}";
		echo "#{$section_id} .process_line_circle{
					border-color: $custom_color;
				}";
		echo "#{$section_id} .process_icon > i > svg{
					fill: $custom_color;
				}";
	}
	if ($active) {
		echo "#{$section_id} .process_icon,
			#{$section_id}.active .process_line_circle:before{
					color: " . INGENIOUS_THEME_COLOR . ";
				}";
		echo "#{$section_id}.active .process_line_active{
					background: " . INGENIOUS_THEME_COLOR . ";
				}";
		echo "#{$section_id}.active .process_line_circle{
					border-color: " . INGENIOUS_THEME_COLOR . ";
				}";
		echo "#{$section_id} .process_icon > i > svg{
					fill: " . INGENIOUS_THEME_COLOR . ";
				}";
	}
	if ($use_custom_active_color && !empty($custom_active_color)) {
		echo "#{$section_id} .process_icon,
			#{$section_id}.active .process_line_circle:before{
					color: $custom_active_color;
				}";
		echo "#{$section_id}.active .process_line_active{
					background: $custom_active_color;
				}";
		echo "#{$section_id}.active .process_line_circle{
					border-color: $custom_active_color;
				}";
		echo "#{$section_id} .process_icon > i > svg{
					fill: $custom_active_color;
				}";
	}
	/* \styles */
	$styles = ob_get_clean();
	$styles = json_encode($styles);
	$classes = $active ? 'active' : '';
	ob_start();
	echo "<div id='$section_id' class='ingenious_process_column ingenious_module render_styles $classes' data-style='" . esc_attr($styles) . "'>";
		echo "<div class='process_item'>";
			echo "<div class='process_icon'>";
				if ( $icon_lib !== 'cws_svg' ) {
					echo "<i class='fa $icon'></i>";
				} else{
					echo cwssvg_shortcode($svg);
				}	
			echo "</div>";
			echo "<span class='process_line'>";
				echo "<span class='process_line_active'></span>";
				echo "<span class='process_line_circle'></span>";
			echo "</span>";
		echo "</div>";
		echo "<h5 class='process_title'>$title</h5>";
		echo "<div class='process_descr'>$descr</div>";
	echo "</div>";
	$out = ob_get_clean();
	return $out;
}
add_shortcode( 'cws_sc_process', 'ingenious_sc_process' );

function ingenious_sc_divider ( $atts = array(), $content = "" ){
	extract( shortcode_atts( array(
		"type"				=> "thin",
		"mtop"				=> "",
		"mbottom"			=> "",
		"customize_colors"	=> false,
		"color"				=> INGENIOUS_THEME_COLOR,
		"el_class"			=> ""
 	), $atts));
 	$type 			= esc_attr( $type );
  	$mtop 			= esc_attr( $mtop );
  	$customize_colors = (bool)$customize_colors;
  	$mbottom 		= esc_attr( $mbottom );
  	$color 			= esc_attr( $color );
 	$el_class		= esc_attr( $el_class );
	$classes = "";
	$classes .= !empty( $type ) ? " $type" : "";
	$classes .= !empty( $el_class ) ? " $el_class" : "";
	$classes .= !empty( $customize_colors ) ? " render_styles" : "";
	$classes = trim( $classes );
	ob_start();
	if ( !empty($mtop) ){
		echo "margin-top: {$mtop}px; ";
	}
	if ( !empty($mbottom) ){
		echo "margin-bottom: {$mbottom}px; ";
	}
	$spacing_styles = ob_get_clean();
	ob_start();
	if ( $customize_colors ){
		if ( $type == 'thin_center' ){
			echo "hr:before{
				background-color: $color;
			}";
		} else {
			echo "hr{
				background-color: $color;
			}";
		}
	}
	$styles = ob_get_clean();
	$styles = json_encode($styles);
	$out = "";
	$out .= "<hr style='" . $spacing_styles . "'" . ( !empty( $classes ) ? " class='$classes'" : "" ) . (!empty($customize_colors) ? "data-style='".esc_attr($styles)."'" : "")." />";
	return $out;
}
add_shortcode( 'cws_sc_divider', 'ingenious_sc_divider' );

function ingenious_sc_spacing ( $atts = array(), $content = "" ){
	extract( shortcode_atts( array(
		'height' => '',
		'responsive_es' => '',
		'height_size_sm_desctop' => '',
		'height_tablet' => '',
		'height_mobile' => '',
	), $atts));
	$classes = '';
	
	$out = '';
	if (!empty($height) || $height == '0') {
		$out .= '<div class="cws_spacing custom_spacing'.esc_attr($classes).'">';
		$out .= '<div class="cws_spacing cws_spacing_default" style="height:'.(int)$height.'px;"></div>';
		if ($responsive_es == 'true') {
			$out .= !empty($height_size_sm_desctop || $height_size_sm_desctop == '0') ? ' <div class="cws_spacing cws_spacing_size_sm_desctop" style="height:'.(int)$height_size_sm_desctop.'px;"></div>' : '';
			$out .= !empty($height_tablet || $height_tablet == '0') ? ' <div class="cws_spacing cws_spacing_tablet" style="height:'.(int)$height_tablet.'px;"></div>' : '';
			$out .= !empty($height_mobile || $height_mobile == '0') ? ' <div class="cws_spacing cws_spacing_mobile" style="height:'.(int)$height_mobile.'px;"></div>' : '';
		}
		$out .= '</div>';
	} 
	return $out;
}
add_shortcode( 'cws_sc_spacing', 'ingenious_sc_spacing' );

function ingenious_sc_twitter ( $atts = array(), $content = "" ){
	extract( shortcode_atts( array(
		"icon"						=> "",
		"twitt_align"				=> "center",
		'number' 					=> 4,
		'visible_number' 			=> 2,
		"customize_colors"			=> false,
		"custom_font_color"			=> "",
		"el_class"					=> ""
 	), $atts));
 	$title 					= esc_attr( $icon );
 	$twitt_align 			= esc_attr( $twitt_align );
 	$title 					= esc_html( $title );
  	$number 				= esc_textarea( $number );
  	$visible_number 		= esc_textarea( $visible_number );
  	$customize_colors 		= (bool)$customize_colors;
  	$custom_font_color 	  	= esc_attr( $custom_font_color );
 	$el_class				= esc_attr( $el_class );
 	$number = empty( $number ) ? 4 : (int)$number;
 	$visible_number = empty( $visible_number ) ? 2 : (int)$visible_number;
	$classes = "cws_twitter ingenious_module";
	$classes .= !empty( $el_class ) ? " $el_class" : "";
	$classes = trim( $classes );
	$id = uniqid( "cws_twitter_" );
	$number = (int)$number;
	$visible_number = (int)$visible_number;
	$visible_number = $visible_number == 0 ? $number : $visible_number;
	$retrieved_tweets_number = 0;
	$is_plugin_installed = function_exists( 'getTweets' );
	$tweets = $is_plugin_installed ? getTweets( $number ) : array();
	$retrieved_tweets_number = count( $tweets );
	$is_carousel = $retrieved_tweets_number > $visible_number;
	if ( $is_carousel ){
		wp_enqueue_script( 'owl_carousel' );
	}
	$tweets_received = false;
	ob_start();
	if ( !empty( $tweets ) ){
		if ( isset( $tweets['error'] ) && !empty( $tweets['error'] ) ){
			echo do_shortcode( "[cws_sc_msg_box title='" . esc_html__( 'Twitter applyed with error', 'ingenious-shortcodes' ) . "' type='error']" . esc_html( $tweets['error'] ) . "[/cws_sc_msg_box]" );
		}
		else{
			if ( $is_carousel ){
				echo "<ul class='cws_tweets widget_carousel bullets_nav'>";
				$groups_count = ceil( $retrieved_tweets_number / $visible_number );
					for ( $i = 0; $i < $groups_count; $i++ ){
						echo "<li>";
							echo "<ul>";
								for( $j = $i * $visible_number; ( ( $j < ( $i + 1 ) * $visible_number ) && ( $j < $retrieved_tweets_number ) ); $j++ ){
									$tweet = $tweets[$j];
									$tweet_text = isset( $tweet['text'] ) ? $tweet['text'] : "";
									$tweet_entitties = isset( $tweet['entities'] ) ? $tweet['entities'] : array();
									$tweet_urls = isset( $tweet_entitties['urls'] ) && is_array( $tweet_entitties['urls'] ) ? $tweet_entitties['urls'] : array();
									foreach ( $tweet_urls as $tweet_url ) {
										$display_url = isset( $tweet_url['display_url'] ) ? $tweet_url['display_url'] : "";
										$received_url = isset( $tweet_url['url'] ) ? $tweet_url['url'] : "";
										$html_url = "<a href='$received_url'>$display_url</a>";
										$tweet_text = substr_replace( $tweet_text, $html_url, strpos( $tweet_text, $received_url ), strlen( $received_url ) );
									}
									$tweet_date = $tweet['created_at'];
									echo "<li class='tweet'>";
										echo "<div class='text'>" . $tweet_text . "</div>";
										echo "<div class='date'>";
											echo esc_html( date( "Y-m-d H:i:s", strtotime( $tweet_date ) ) );
										echo "</div>";	
									echo "</li>";						
								}
							echo "</ul>";
						echo "</li>";
					}
				echo "</ul>";
			}
			else{
				echo "<ul class='cws_tweets'>";
					foreach ( $tweets as $tweet ) {
						echo "<li class='tweet'>";
							$tweet_text = isset( $tweet['text'] ) ? $tweet['text'] : "";
							$tweet_entitties = isset( $tweet['entities'] ) ? $tweet['entities'] : array();
							$tweet_urls = isset( $tweet_entitties['urls'] ) && is_array( $tweet_entitties['urls'] ) ? $tweet_entitties['urls'] : array();
							foreach ( $tweet_urls as $tweet_url ) {
								$display_url = isset( $tweet_url['display_url'] ) ? $tweet_url['display_url'] : "";
								$received_url = isset( $tweet_url['url'] ) ? $tweet_url['url'] : "";
								$html_url = "<a href='$received_url'>$display_url</a>";
								$tweet_text = substr_replace( $tweet_text, $html_url, strpos( $tweet_text, $received_url ), strlen( $received_url ) );
							}
							$tweet_date = $tweet['created_at'];
							echo "<div class='text'>" . $tweet_text . "</div>";
							echo "<div class='date'>";
								echo esc_html( date( "Y-m-d H:i:s", strtotime( $tweet_date ) ) );
							echo "</div>";
						echo "</li>";
					}
				echo "</ul>";
			}
			$tweets_received = true;
		}
	}
	else{
		if ( !$is_plugin_installed ){
			echo do_shortcode( "[cws_sc_msg_box title='" . esc_html__( 'Plugin not installed', 'ingenious-shortcodes' ) . "' type='warn']" . esc_html__( 'Please install and activate required plugin ', 'ingenious-shortcodes' ) . "<a href='https://ru.wordpress.org/plugins/oauth-twitter-feed-for-developers/'>" . esc_html__( "oAuth Twitter Feed for Developers", 'ingenious-shortcodes' ) . "</a>[/cws_sc_msg_box]" );
		}
	}
	$twitter_response = ob_get_clean();

	ob_start();
	if ( $customize_colors && !empty( $custom_font_color ) ){
		echo "#{$id} .cws_twitter_icon i,
				#{$id} .cws_tweets .tweet a{
					color: $custom_font_color;
				}
				#{$id} .cws_twitter_icon i,
				#{$id} .owl-pagination .owl-page{
					border-color: $custom_font_color;
				}
				#{$id} .owl-pagination .owl-page.active{
					background-color: $custom_font_color;
				}";
	}
	$styles = ob_get_clean();

	ob_start();
	if ( $tweets_received ){
		echo !empty( $styles ) ? "<style type='text/css'>$styles</style>" : "";
		echo "<div id='$id' class='$classes' style='text-align:" . $twitt_align . "'>";
			if ( !empty( $icon ) ){
				echo "<div class='cws_twitter_icon'>";
					echo "<i class='$icon'></i>";
				echo "</div>";
			}
			echo $twitter_response;
		echo "</div>";
	}
	else{
		echo $twitter_response;
	}
	$out = ob_get_clean();
	return $out;
}
add_shortcode( 'cws_sc_twitter', 'ingenious_sc_twitter' );

function fix_shortcodes_autop($content){
  $array = array (
   '<p>[' => '[',
   ']</p>' => ']',
   ']<br />' => ']'
  );

  $content = strtr($content, $array);
  return $content;
 }
add_filter('the_content', 'fix_shortcodes_autop');

function ingenious_sc_benefits ( $atts = array(), $content = "" ){
	extract( shortcode_atts( array(
		'icon_lib'					=> '',
		'cws_svg_icon'				=> '',
		'icon_size'					=> 'regular',
		'custom_icon_color'			=> '',
		'icon_color'				=> INGENIOUS_THEME_COLOR,
		'benefit_img'				=> '',
		'add_sec_desc'				=> '',
		'sec_desc'					=> '',
		'custom_desc_bg'			=> '',
		'desc_bg_color'				=> '',
		'add_button'				=> '',
		'button_text'				=> '',
		'button_url'				=> '',
		'button_new_tab'			=> '',
		'button_customize_colors'	=> false,
		'buttom_font_color'			=> INGENIOUS_THEME_COLOR,
		'buttom_bg_color'			=> 'transparent',
		'buttom_border_color'		=> INGENIOUS_THEME_COLOR,
		'buttom_hover_font_color'	=> '#fff',
		'buttom_hover_bg_color'		=> INGENIOUS_THEME_COLOR,
		'buttom_hover_border_color'	=> INGENIOUS_THEME_COLOR,
		'el_class'					=> ''
	), $atts));

	$icon_lib 					= esc_attr( $icon_lib );
	$icon_size 					= esc_attr( $icon_size );
	$custom_icon_color 			= (bool)$custom_icon_color;
	$icon 						= ingenious_vc_sc_get_icon( $atts );
	$icon 						= esc_attr( $icon );
	$icon_color 				= esc_attr( $icon_color );
	$benefit_img 				= esc_attr( $benefit_img );
	$add_sec_desc 				= (bool)$add_sec_desc;
	$sec_desc 					= esc_attr( $sec_desc );
	$custom_desc_bg 			= (bool)$custom_desc_bg;
	$desc_bg_color 				= esc_attr( $desc_bg_color );
	$desc 						= apply_filters( 'the_content', $content );
	$add_button 				= (bool)$add_button;
	$el_class					= esc_attr( $el_class );
	$out = "";
	if ( function_exists( 'vc_icon_element_fonts_enqueue' ) ){
		vc_icon_element_fonts_enqueue( $icon_lib );		
	}
	$button_atts = array(
		'title'						=> $button_text,
		'url'						=> $button_url,
		'new_tab'					=> $button_new_tab,
		'customize_colors'			=> $button_customize_colors,
		'custom_color'				=> $buttom_font_color,
		'custom_color_bg'			=> $buttom_bg_color,
		'custom_color_border'		=> $buttom_border_color,
		'custom_hover_color'		=> $buttom_hover_font_color,
		'custom_hover_color_bg'		=> $buttom_hover_bg_color,
		'custom_hover_color_border'	=> $buttom_hover_border_color,
	);
	$section_id = uniqid( 'ingenious_benefits_' );
	$thumbnail  = wp_get_attachment_image($benefit_img, 'full' );

	/* styles */
	ob_start();
	if ( $custom_icon_color ){
		echo "#$section_id .benefits_icon .icon{
			background: $icon_color;
		}";
	}
	if ( $custom_desc_bg ){
		echo "
		#$section_id.sec_desc .benefits_media:hover .benefits_hover_content:before{
			background: $desc_bg_color;
		}";
	}	
	/* \styles */
	$styles = ob_get_clean();
	$styles = json_encode($styles);
	$button = $add_button ? ingenious_sc_button( $button_atts ) : "";
	$icon_part = "";
	$icon_class = 'benefits_icon';

	$cws_svg_icon = !empty($cws_svg_icon) ? $cws_svg_icon : '';
	$cws_svg_icon = str_replace('``', '"', $cws_svg_icon);
	$svg = json_decode($cws_svg_icon);
	if ( $icon_lib !== 'cws_svg') {
		$icon_part .= !empty( $icon ) ? "<div class='".esc_attr($icon_class)."'><div class='icon $icon'></div></div>" : "";
	} else if (function_exists('cwssvg_shortcode')) {
		$icon_part .= !empty( $cws_svg_icon ) ? "<div class='".esc_attr($icon_class)."'><div class='icon'>" . cwssvg_shortcode($svg) . "</div></div>" : "";
	}
	$classes = '';
	$classes .= $icon_lib == 'cws_svg' ? " cws_svg_icon " : "";
	$classes .= $add_sec_desc ? ' sec_desc' : '';
	$classes .= !empty( $el_class ) ? " $el_class" : "";
	$classes .= !empty( $benefit_img ) ? " cws_has_benefits_img" : "";
	$classes .= ' '.esc_attr($icon_size);

	$out .= "<div id='$section_id' data-style='".esc_attr($styles)."' class='ingenious_benefits ingenious_module render_styles $classes'>";
		if (!empty($benefit_img) || !empty($icon_part) ) {
			$out .= "<div class='benefits_media'>";
				$out .= $icon_part;
				$out .= "<div class='benefits_img'>$thumbnail</div>";
				$out .= "<div class='benefits_hover_content'>";	
					if ($add_sec_desc) $out .= "<span class='benefits_desc'>".$sec_desc."</span>";
				$out .= "</div>";
			$out .= "</div>";
		}
		$out .= "<div class='benefits_content_wrap'>";
			$out .= !empty( $desc ) ? "<div class='benefits_content'>$desc</div>" : "";
			$out .= !empty( $button ) ? "<div class='benefits_button'>$button</div>" : "";
		$out .= "</div>";
	$out .= "</div>";

	return $out;
}
add_shortcode( 'cws_sc_benefits', 'ingenious_sc_benefits' );

?>